package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.ContentEntryPicture
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class ContentEntryPictureDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: ContentEntryPictureDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : ContentEntryPictureDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend fun findByContentEntryUidAsync(entryUid: Long): ContentEntryPicture? {
    val _result = _dao.findByContentEntryUidAsync(entryUid)
    return _result
  }

  public override fun findByContentEntryUidLive(entryUid: Long): LiveData<ContentEntryPicture?> {
    val _result = _dao.findByContentEntryUidLive(entryUid)
    return _result
  }

  public override suspend fun updateAsync(ContentEntryPicture: ContentEntryPicture): Unit {
    _dao.updateAsync(ContentEntryPicture)
  }

  public override fun insert(entity: ContentEntryPicture): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: ContentEntryPicture): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<ContentEntryPicture>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ContentEntryPicture>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: ContentEntryPicture): Unit {
    _dao.update(entity)
  }
}
