package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class ContextXObjectStatementJoinDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContextXObjectStatementJoinDao,
) : ContextXObjectStatementJoinDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findByStatementAndObjectUid(statementUid: Long, objectUid: Long):
      ContextXObjectStatementJoin? = _dao.findByStatementAndObjectUid(statementUid, objectUid)

  public override fun insert(entity: ContextXObjectStatementJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.contextXObjectStatementJoinUid == 0L) {
      val _newPk = _pkManager.nextId(66)
      entity.contextXObjectStatementJoinUid = _newPk
    }
    entity.contextXObjectLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.contextXObjectStatementJoinUid
  }

  public override suspend fun insertAsync(entity: ContextXObjectStatementJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.contextXObjectStatementJoinUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(66)
      entity.contextXObjectStatementJoinUid = _newPk
    }
    entity.contextXObjectLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.contextXObjectStatementJoinUid
  }

  public override fun insertList(entityList: List<ContextXObjectStatementJoin>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.contextXObjectStatementJoinUid == 0L) {
        val _newPk = _pkManager.nextId(66)
        it.contextXObjectStatementJoinUid = _newPk
        _generatedPks += _newPk
      }
      it.contextXObjectLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ContextXObjectStatementJoin>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.contextXObjectLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: ContextXObjectStatementJoin): Unit {
    entity.contextXObjectLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
