package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import com.ustadmobile.door.attachments.storeAttachment
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.CoursePicture
import com.ustadmobile.lib.db.entities.asEntityWithAttachment
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List
import kotlinx.coroutines.runBlocking

public class CoursePictureDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: CoursePictureDao,
) : CoursePictureDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend fun findByClazzUidAsync(clazzUid: Long): CoursePicture? =
      _dao.findByClazzUidAsync(clazzUid)

  public override fun findByClazzUidLive(clazzUid: Long): LiveData<CoursePicture?> =
      _dao.findByClazzUidLive(clazzUid)

  public override suspend fun updateAsync(coursePicture: CoursePicture): Unit {
    _db.storeAttachment(coursePicture.asEntityWithAttachment())
    coursePicture.coursePictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.updateAsync(coursePicture)
  }

  public override fun insert(entity: CoursePicture): Long {
    runBlocking {
      _db.storeAttachment(entity.asEntityWithAttachment())
    }
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.coursePictureUid == 0L) {
      val _newPk = _pkManager.nextId(125)
      entity.coursePictureUid = _newPk
    }
    entity.coursePictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.coursePictureUid
  }

  public override suspend fun insertAsync(entity: CoursePicture): Long {
    _db.storeAttachment(entity.asEntityWithAttachment())
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.coursePictureUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(125)
      entity.coursePictureUid = _newPk
    }
    entity.coursePictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.coursePictureUid
  }

  public override fun insertList(entityList: List<CoursePicture>): Unit {
    runBlocking {
      entityList.forEach {
        _db.storeAttachment(it.asEntityWithAttachment())
      }
    }
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.coursePictureUid == 0L) {
        val _newPk = _pkManager.nextId(125)
        it.coursePictureUid = _newPk
        _generatedPks += _newPk
      }
      it.coursePictureLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<CoursePicture>): Unit {
    runBlocking {
      entityList.forEach {
        _db.storeAttachment(it.asEntityWithAttachment())
      }
    }
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.coursePictureLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: CoursePicture): Unit {
    runBlocking {
      _db.storeAttachment(entity.asEntityWithAttachment())
    }
    entity.coursePictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
