package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.StateContentEntity
import io.ktor.client.HttpClient
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class StateContentDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: StateContentDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : StateContentDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findAllStateContentWithStateUid(id: Long): List<StateContentEntity> {
    val _result = _dao.findAllStateContentWithStateUid(id)
    return _result
  }

  public override fun findStateContentByKeyAndStateUid(key: String, stateUid: Long):
      StateContentEntity? {
    val _result = _dao.findStateContentByKeyAndStateUid(key, stateUid)
    return _result
  }

  public override fun setInActiveStateContentByKeyAndUid(
    isActive: Boolean,
    stateUid: Long,
    updateTime: Long,
  ): Unit {
    _dao.setInActiveStateContentByKeyAndUid(isActive, stateUid, updateTime)
  }

  public override fun insert(entity: StateContentEntity): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: StateContentEntity): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<StateContentEntity>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<StateContentEntity>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: StateContentEntity): Unit {
    _dao.update(entity)
  }
}
