package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ClazzLog;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzLogDao_Impl extends ClazzLogDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzLog> __insertionAdapterOfClazzLog;

  private final EntityInsertionAdapter<ClazzLog> __insertionAdapterOfClazzLog_1;

  private final EntityDeletionOrUpdateAdapter<ClazzLog> __updateAdapterOfClazzLog;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatusByClazzLogUid;

  public ClazzLogDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzLog = new EntityInsertionAdapter<ClazzLog>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ClazzLog` (`clazzLogUid`,`clazzLogClazzUid`,`logDate`,`timeRecorded`,`clazzLogDone`,`cancellationNote`,`clazzLogCancelled`,`clazzLogNumPresent`,`clazzLogNumAbsent`,`clazzLogNumPartial`,`clazzLogScheduleUid`,`clazzLogStatusFlag`,`clazzLogMSQN`,`clazzLogLCSN`,`clazzLogLCB`,`clazzLogLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzLog value) {
        stmt.bindLong(1, value.getClazzLogUid());
        stmt.bindLong(2, value.getClazzLogClazzUid());
        stmt.bindLong(3, value.getLogDate());
        stmt.bindLong(4, value.getTimeRecorded());
        final int _tmp = value.getClazzLogDone() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        if (value.getCancellationNote() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCancellationNote());
        }
        final int _tmp_1 = value.getClazzLogCancelled() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getClazzLogNumPresent());
        stmt.bindLong(9, value.getClazzLogNumAbsent());
        stmt.bindLong(10, value.getClazzLogNumPartial());
        stmt.bindLong(11, value.getClazzLogScheduleUid());
        stmt.bindLong(12, value.getClazzLogStatusFlag());
        stmt.bindLong(13, value.getClazzLogMSQN());
        stmt.bindLong(14, value.getClazzLogLCSN());
        stmt.bindLong(15, value.getClazzLogLCB());
        stmt.bindLong(16, value.getClazzLogLastChangedTime());
      }
    };
    this.__insertionAdapterOfClazzLog_1 = new EntityInsertionAdapter<ClazzLog>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `ClazzLog` (`clazzLogUid`,`clazzLogClazzUid`,`logDate`,`timeRecorded`,`clazzLogDone`,`cancellationNote`,`clazzLogCancelled`,`clazzLogNumPresent`,`clazzLogNumAbsent`,`clazzLogNumPartial`,`clazzLogScheduleUid`,`clazzLogStatusFlag`,`clazzLogMSQN`,`clazzLogLCSN`,`clazzLogLCB`,`clazzLogLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzLog value) {
        stmt.bindLong(1, value.getClazzLogUid());
        stmt.bindLong(2, value.getClazzLogClazzUid());
        stmt.bindLong(3, value.getLogDate());
        stmt.bindLong(4, value.getTimeRecorded());
        final int _tmp = value.getClazzLogDone() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        if (value.getCancellationNote() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCancellationNote());
        }
        final int _tmp_1 = value.getClazzLogCancelled() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getClazzLogNumPresent());
        stmt.bindLong(9, value.getClazzLogNumAbsent());
        stmt.bindLong(10, value.getClazzLogNumPartial());
        stmt.bindLong(11, value.getClazzLogScheduleUid());
        stmt.bindLong(12, value.getClazzLogStatusFlag());
        stmt.bindLong(13, value.getClazzLogMSQN());
        stmt.bindLong(14, value.getClazzLogLCSN());
        stmt.bindLong(15, value.getClazzLogLCB());
        stmt.bindLong(16, value.getClazzLogLastChangedTime());
      }
    };
    this.__updateAdapterOfClazzLog = new EntityDeletionOrUpdateAdapter<ClazzLog>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ClazzLog` SET `clazzLogUid` = ?,`clazzLogClazzUid` = ?,`logDate` = ?,`timeRecorded` = ?,`clazzLogDone` = ?,`cancellationNote` = ?,`clazzLogCancelled` = ?,`clazzLogNumPresent` = ?,`clazzLogNumAbsent` = ?,`clazzLogNumPartial` = ?,`clazzLogScheduleUid` = ?,`clazzLogStatusFlag` = ?,`clazzLogMSQN` = ?,`clazzLogLCSN` = ?,`clazzLogLCB` = ?,`clazzLogLastChangedTime` = ? WHERE `clazzLogUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzLog value) {
        stmt.bindLong(1, value.getClazzLogUid());
        stmt.bindLong(2, value.getClazzLogClazzUid());
        stmt.bindLong(3, value.getLogDate());
        stmt.bindLong(4, value.getTimeRecorded());
        final int _tmp = value.getClazzLogDone() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        if (value.getCancellationNote() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCancellationNote());
        }
        final int _tmp_1 = value.getClazzLogCancelled() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getClazzLogNumPresent());
        stmt.bindLong(9, value.getClazzLogNumAbsent());
        stmt.bindLong(10, value.getClazzLogNumPartial());
        stmt.bindLong(11, value.getClazzLogScheduleUid());
        stmt.bindLong(12, value.getClazzLogStatusFlag());
        stmt.bindLong(13, value.getClazzLogMSQN());
        stmt.bindLong(14, value.getClazzLogLCSN());
        stmt.bindLong(15, value.getClazzLogLCB());
        stmt.bindLong(16, value.getClazzLogLastChangedTime());
        stmt.bindLong(17, value.getClazzLogUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ClazzLogReplicate(clPk, clDestination)\n"
                + "      SELECT DISTINCT ClazzLog.clazzLogUid AS clUid,\n"
                + "             ? AS clDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2 \n"
                + "                  \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "             JOIN ClazzLog\n"
                + "                  ON ClazzLog.clazzLogClazzUid = Clazz.clazzUid\n"
                + "       WHERE ClazzLog.clazzLogLastChangedTime != COALESCE(\n"
                + "             (SELECT clVersionId\n"
                + "                FROM ClazzLogReplicate\n"
                + "               WHERE clPk = ClazzLog.clazzLogUid\n"
                + "                 AND clDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(clPk, clDestination) DO UPDATE\n"
                + "             SET clPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ClazzLogReplicate(clPk, clDestination)\n"
                + "  SELECT DISTINCT ClazzLog.clazzLogUid AS clUid,\n"
                + "         UserSession.usClientNodeId AS clDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ClazzLog \n"
                + "              ON ChangeLog.chTableId = 14 \n"
                + "             AND ClazzLog.clazzLogUid = ChangeLog.chEntityPk\n"
                + "         JOIN Clazz \n"
                + "              ON Clazz.clazzUid = ClazzLog.clazzLogClazzUid \n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ClazzLog.clazzLogLastChangedTime != COALESCE(\n"
                + "         (SELECT clVersionId\n"
                + "            FROM ClazzLogReplicate\n"
                + "           WHERE clPk = ClazzLog.clazzLogUid\n"
                + "             AND clDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(clPk, clDestination) DO UPDATE\n"
                + "     SET clPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStatusByClazzLogUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ClazzLog \n"
                + "        SET clazzLogStatusFlag = ?,\n"
                + "        clazzLogLastChangedTime = ?\n"
                + "        WHERE clazzLogUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzLog entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfClazzLog.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzLog entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfClazzLog.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ClazzLog> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzLog.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public long replace(final ClazzLog entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfClazzLog_1.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ClazzLog> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzLog.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ClazzLog entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzLog.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ClazzLog clazzLog,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzLog.handle(clazzLog);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateStatusByClazzLogUid(final long clazzLogUid, final int newStatus,
      final long timeChanged) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatusByClazzLogUid.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, newStatus);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, timeChanged);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, clazzLogUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateStatusByClazzLogUid.release(_stmt);
    }
  }

  @Override
  public ClazzLog findByUid(final long uid) {
    final String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
      final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
      final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
      final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
      final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
      final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
      final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
      final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
      final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
      final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
      final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
      final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
      final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
      final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
      final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
      final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
      final ClazzLog _result;
      if(_cursor.moveToFirst()) {
        _result = new ClazzLog();
        final long _tmpClazzLogUid;
        _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
        _result.setClazzLogUid(_tmpClazzLogUid);
        final long _tmpClazzLogClazzUid;
        _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
        _result.setClazzLogClazzUid(_tmpClazzLogClazzUid);
        final long _tmpLogDate;
        _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
        _result.setLogDate(_tmpLogDate);
        final long _tmpTimeRecorded;
        _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
        _result.setTimeRecorded(_tmpTimeRecorded);
        final boolean _tmpClazzLogDone;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
        _tmpClazzLogDone = _tmp != 0;
        _result.setClazzLogDone(_tmpClazzLogDone);
        final String _tmpCancellationNote;
        if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
          _tmpCancellationNote = null;
        } else {
          _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
        }
        _result.setCancellationNote(_tmpCancellationNote);
        final boolean _tmpClazzLogCancelled;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
        _tmpClazzLogCancelled = _tmp_1 != 0;
        _result.setClazzLogCancelled(_tmpClazzLogCancelled);
        final int _tmpClazzLogNumPresent;
        _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
        _result.setClazzLogNumPresent(_tmpClazzLogNumPresent);
        final int _tmpClazzLogNumAbsent;
        _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
        _result.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
        final int _tmpClazzLogNumPartial;
        _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
        _result.setClazzLogNumPartial(_tmpClazzLogNumPartial);
        final long _tmpClazzLogScheduleUid;
        _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
        _result.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
        final int _tmpClazzLogStatusFlag;
        _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
        _result.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
        final long _tmpClazzLogMSQN;
        _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
        _result.setClazzLogMSQN(_tmpClazzLogMSQN);
        final long _tmpClazzLogLCSN;
        _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
        _result.setClazzLogLCSN(_tmpClazzLogLCSN);
        final int _tmpClazzLogLCB;
        _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
        _result.setClazzLogLCB(_tmpClazzLogLCB);
        final long _tmpClazzLogLastChangedTime;
        _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
        _result.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super ClazzLog> continuation) {
    final String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzLog>() {
      @Override
      public ClazzLog call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final ClazzLog _result;
          if(_cursor.moveToFirst()) {
            _result = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _result.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _result.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _result.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _result.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _result.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _result.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _result.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _result.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _result.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _result.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _result.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _result.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _result.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _result.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _result.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _result.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ClazzLog> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ClazzLog"}, false, new Callable<ClazzLog>() {
      @Override
      public ClazzLog call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final ClazzLog _result;
          if(_cursor.moveToFirst()) {
            _result = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _result.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _result.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _result.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _result.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _result.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _result.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _result.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _result.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _result.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _result.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _result.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _result.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _result.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _result.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _result.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _result.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public DataSource.Factory<Integer, ClazzLog> findByClazzUidAsFactory(final long clazzUid,
      final int excludeStatus) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE clazzLogClazzUid = ?\n"
            + "        AND clazzLog.clazzLogStatusFlag != ?\n"
            + "        ORDER BY ClazzLog.logDate DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeStatus);
    return new DataSource.Factory<Integer, ClazzLog>() {
      @Override
      public LimitOffsetDataSource<ClazzLog> create() {
        return new LimitOffsetDataSource<ClazzLog>(__db, _statement, false, true , "ClazzLog") {
          @Override
          protected List<ClazzLog> convertRows(Cursor cursor) {
            final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogUid");
            final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogClazzUid");
            final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(cursor, "logDate");
            final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(cursor, "timeRecorded");
            final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogDone");
            final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(cursor, "cancellationNote");
            final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogCancelled");
            final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogNumPresent");
            final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogNumAbsent");
            final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogNumPartial");
            final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogScheduleUid");
            final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogStatusFlag");
            final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogMSQN");
            final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogLCSN");
            final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogLCB");
            final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogLastChangedTime");
            final List<ClazzLog> _res = new ArrayList<ClazzLog>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ClazzLog _item;
              _item = new ClazzLog();
              final long _tmpClazzLogUid;
              _tmpClazzLogUid = cursor.getLong(_cursorIndexOfClazzLogUid);
              _item.setClazzLogUid(_tmpClazzLogUid);
              final long _tmpClazzLogClazzUid;
              _tmpClazzLogClazzUid = cursor.getLong(_cursorIndexOfClazzLogClazzUid);
              _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
              final long _tmpLogDate;
              _tmpLogDate = cursor.getLong(_cursorIndexOfLogDate);
              _item.setLogDate(_tmpLogDate);
              final long _tmpTimeRecorded;
              _tmpTimeRecorded = cursor.getLong(_cursorIndexOfTimeRecorded);
              _item.setTimeRecorded(_tmpTimeRecorded);
              final boolean _tmpClazzLogDone;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfClazzLogDone);
              _tmpClazzLogDone = _tmp != 0;
              _item.setClazzLogDone(_tmpClazzLogDone);
              final String _tmpCancellationNote;
              if (cursor.isNull(_cursorIndexOfCancellationNote)) {
                _tmpCancellationNote = null;
              } else {
                _tmpCancellationNote = cursor.getString(_cursorIndexOfCancellationNote);
              }
              _item.setCancellationNote(_tmpCancellationNote);
              final boolean _tmpClazzLogCancelled;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfClazzLogCancelled);
              _tmpClazzLogCancelled = _tmp_1 != 0;
              _item.setClazzLogCancelled(_tmpClazzLogCancelled);
              final int _tmpClazzLogNumPresent;
              _tmpClazzLogNumPresent = cursor.getInt(_cursorIndexOfClazzLogNumPresent);
              _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
              final int _tmpClazzLogNumAbsent;
              _tmpClazzLogNumAbsent = cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
              _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
              final int _tmpClazzLogNumPartial;
              _tmpClazzLogNumPartial = cursor.getInt(_cursorIndexOfClazzLogNumPartial);
              _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
              final long _tmpClazzLogScheduleUid;
              _tmpClazzLogScheduleUid = cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
              _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
              final int _tmpClazzLogStatusFlag;
              _tmpClazzLogStatusFlag = cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
              _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
              final long _tmpClazzLogMSQN;
              _tmpClazzLogMSQN = cursor.getLong(_cursorIndexOfClazzLogMSQN);
              _item.setClazzLogMSQN(_tmpClazzLogMSQN);
              final long _tmpClazzLogLCSN;
              _tmpClazzLogLCSN = cursor.getLong(_cursorIndexOfClazzLogLCSN);
              _item.setClazzLogLCSN(_tmpClazzLogLCSN);
              final int _tmpClazzLogLCB;
              _tmpClazzLogLCB = cursor.getInt(_cursorIndexOfClazzLogLCB);
              _item.setClazzLogLCB(_tmpClazzLogLCB);
              final long _tmpClazzLogLastChangedTime;
              _tmpClazzLogLastChangedTime = cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
              _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object findByClazzUidAsync(final long clazzUid, final int excludeStatus,
      final Continuation<? super List<? extends ClazzLog>> continuation) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE clazzLogClazzUid = ?\n"
            + "        AND clazzLog.clazzLogStatusFlag != ?\n"
            + "        ORDER BY ClazzLog.logDate ASC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeStatus);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzLog>>() {
      @Override
      public List<ClazzLog> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ClazzLog _item;
            _item = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _item.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _item.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _item.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _item.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _item.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _item.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _item.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _item.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _item.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByClazzUidWithinTimeRangeAsync(final long clazzUid, final long fromTime,
      final long toTime, final int excludeStatusFilter, final int limit,
      final Continuation<? super List<? extends ClazzLog>> continuation) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE \n"
            + "        ClazzLog.clazzLogClazzUid = ? \n"
            + "        AND ClazzLog.logDate BETWEEN ? AND ?\n"
            + "        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n"
            + "        ORDER BY ClazzLog.logDate DESC\n"
            + "        LIMIT ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, fromTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, toTime);
    _argIndex = 4;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 6;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzLog>>() {
      @Override
      public List<ClazzLog> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ClazzLog _item;
            _item = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _item.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _item.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _item.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _item.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _item.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _item.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _item.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _item.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _item.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public List<ClazzLog> findByClazzUidWithinTimeRange(final long clazzUid, final long fromTime,
      final long toTime, final int excludeStatusFilter, final int limit) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE \n"
            + "        ClazzLog.clazzLogClazzUid = ? \n"
            + "        AND ClazzLog.logDate BETWEEN ? AND ?\n"
            + "        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n"
            + "        ORDER BY ClazzLog.logDate DESC\n"
            + "        LIMIT ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, fromTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, toTime);
    _argIndex = 4;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 6;
    _statement.bindLong(_argIndex, limit);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
      final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
      final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
      final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
      final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
      final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
      final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
      final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
      final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
      final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
      final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
      final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
      final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
      final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
      final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
      final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
      final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ClazzLog _item;
        _item = new ClazzLog();
        final long _tmpClazzLogUid;
        _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
        _item.setClazzLogUid(_tmpClazzLogUid);
        final long _tmpClazzLogClazzUid;
        _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
        _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
        final long _tmpLogDate;
        _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
        _item.setLogDate(_tmpLogDate);
        final long _tmpTimeRecorded;
        _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
        _item.setTimeRecorded(_tmpTimeRecorded);
        final boolean _tmpClazzLogDone;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
        _tmpClazzLogDone = _tmp != 0;
        _item.setClazzLogDone(_tmpClazzLogDone);
        final String _tmpCancellationNote;
        if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
          _tmpCancellationNote = null;
        } else {
          _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
        }
        _item.setCancellationNote(_tmpCancellationNote);
        final boolean _tmpClazzLogCancelled;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
        _tmpClazzLogCancelled = _tmp_1 != 0;
        _item.setClazzLogCancelled(_tmpClazzLogCancelled);
        final int _tmpClazzLogNumPresent;
        _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
        _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
        final int _tmpClazzLogNumAbsent;
        _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
        _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
        final int _tmpClazzLogNumPartial;
        _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
        _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
        final long _tmpClazzLogScheduleUid;
        _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
        _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
        final int _tmpClazzLogStatusFlag;
        _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
        _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
        final long _tmpClazzLogMSQN;
        _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
        _item.setClazzLogMSQN(_tmpClazzLogMSQN);
        final long _tmpClazzLogLCSN;
        _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
        _item.setClazzLogLCSN(_tmpClazzLogLCSN);
        final int _tmpClazzLogLCB;
        _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
        _item.setClazzLogLCB(_tmpClazzLogLCB);
        final long _tmpClazzLogLastChangedTime;
        _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
        _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<List<ClazzLog>> findByClazzUidWithinTimeRangeLive(final long clazzUid,
      final long fromTime, final long toTime, final int statusFilter) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE \n"
            + "        ClazzLog.clazzLogClazzUid = ? \n"
            + "        AND ClazzLog.logDate BETWEEN ? AND ?\n"
            + "        AND (? = 0 OR ClazzLog.clazzLogStatusFlag = ?)\n"
            + "        ORDER BY ClazzLog.logDate\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, fromTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, toTime);
    _argIndex = 4;
    _statement.bindLong(_argIndex, statusFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, statusFilter);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ClazzLog"}, false, new Callable<List<ClazzLog>>() {
      @Override
      public List<ClazzLog> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ClazzLog _item;
            _item = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _item.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _item.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _item.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _item.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _item.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _item.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _item.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _item.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _item.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<Boolean> clazzHasScheduleLive(final long clazzUid,
      final int excludeStatusFilter) {
    final String _sql = "\n"
            + "        SELECT EXISTS(SELECT ClazzLog.clazzLogUid FROM ClazzLog WHERE clazzLogClazzUid = ? \n"
            + "        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0)))\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 3;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ClazzLog"}, false, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
