package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContainerETag;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContainerETagDao_Impl extends ContainerETagDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContainerETag> __insertionAdapterOfContainerETag;

  private final EntityDeletionOrUpdateAdapter<ContainerETag> __updateAdapterOfContainerETag;

  public ContainerETagDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContainerETag = new EntityInsertionAdapter<ContainerETag>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContainerETag` (`ceContainerUid`,`cetag`) VALUES (?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerETag value) {
        stmt.bindLong(1, value.getCeContainerUid());
        if (value.getCetag() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCetag());
        }
      }
    };
    this.__updateAdapterOfContainerETag = new EntityDeletionOrUpdateAdapter<ContainerETag>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContainerETag` SET `ceContainerUid` = ?,`cetag` = ? WHERE `ceContainerUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerETag value) {
        stmt.bindLong(1, value.getCeContainerUid());
        if (value.getCetag() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCetag());
        }
        stmt.bindLong(3, value.getCeContainerUid());
      }
    };
  }

  @Override
  public long insert(final ContainerETag entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContainerETag.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContainerETag entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContainerETag.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContainerETag> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContainerETag.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContainerETag> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerETag.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContainerETag entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerETag.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public String getEtagOfContainer(final long containerUid) {
    final String _sql = "SELECT cetag FROM ContainerETag WHERE ceContainerUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final String _result;
      if(_cursor.moveToFirst()) {
        if (_cursor.isNull(0)) {
          _result = null;
        } else {
          _result = _cursor.getString(0);
        }
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
