package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContainerEntry;
import com.ustadmobile.lib.db.entities.ContainerEntryFile;
import com.ustadmobile.lib.db.entities.ContainerEntryWithContainerEntryFile;
import com.ustadmobile.lib.db.entities.ContainerEntryWithMd5;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContainerEntryDao_Impl extends ContainerEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContainerEntry> __insertionAdapterOfContainerEntry;

  private final EntityDeletionOrUpdateAdapter<ContainerEntry> __deletionAdapterOfContainerEntry;

  private final EntityDeletionOrUpdateAdapter<ContainerEntry> __updateAdapterOfContainerEntry;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByContainerUid;

  private final SharedSQLiteStatement __preparedStmtOfDeleteContainerEntriesCreatedByJobs;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByContentEntryUid;

  private final SharedSQLiteStatement __preparedStmtOfInsertWithMd5SumsAsync;

  public ContainerEntryDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContainerEntry = new EntityInsertionAdapter<ContainerEntry>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContainerEntry` (`ceUid`,`ceContainerUid`,`cePath`,`ceCefUid`) VALUES (nullif(?, 0),?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerEntry value) {
        stmt.bindLong(1, value.getCeUid());
        stmt.bindLong(2, value.getCeContainerUid());
        if (value.getCePath() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCePath());
        }
        stmt.bindLong(4, value.getCeCefUid());
      }
    };
    this.__deletionAdapterOfContainerEntry = new EntityDeletionOrUpdateAdapter<ContainerEntry>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `ContainerEntry` WHERE `ceUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerEntry value) {
        stmt.bindLong(1, value.getCeUid());
      }
    };
    this.__updateAdapterOfContainerEntry = new EntityDeletionOrUpdateAdapter<ContainerEntry>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContainerEntry` SET `ceUid` = ?,`ceContainerUid` = ?,`cePath` = ?,`ceCefUid` = ? WHERE `ceUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerEntry value) {
        stmt.bindLong(1, value.getCeUid());
        stmt.bindLong(2, value.getCeContainerUid());
        if (value.getCePath() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCePath());
        }
        stmt.bindLong(4, value.getCeCefUid());
        stmt.bindLong(5, value.getCeUid());
      }
    };
    this.__preparedStmtOfDeleteByContainerUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM ContainerEntry WHERE ceContainerUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteContainerEntriesCreatedByJobs = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "            DELETE FROM ContainerEntry \n"
                + "             WHERE ceContainerUid \n"
                + "                IN (SELECT cjiContainerUid \n"
                + "                      FROM ContentJobItem\n"
                + "                      JOIN ContentJob \n"
                + "                           ON ContentJobItem.cjiJobUid = ContentJob.cjUid\n"
                + "                     WHERE ContentJob.cjUid = ?)";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteByContentEntryUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        DELETE FROM ContainerEntry\n"
                + "         WHERE ceContainerUid\n"
                + "            IN (SELECT containerUid\n"
                + "                  FROM Container\n"
                + "                 WHERE containerContentEntryUid = ?) \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfInsertWithMd5SumsAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        INSERT INTO ContainerEntry(ceContainerUid, cePath, ceCefUid) \n"
                + "        SELECT ? AS ceContainerUid, ? AS cePath, \n"
                + "               (SELECT COALESCE(\n"
                + "                      (SELECT cefUid \n"
                + "                         FROM ContainerEntryFile\n"
                + "                        WHERE cefMd5 = ?\n"
                + "                        LIMIT 1), 0))  \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContainerEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContainerEntry.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContainerEntry entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContainerEntry.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContainerEntry> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContainerEntry.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends ContainerEntry> containerEntryList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContainerEntry.insert(containerEntryList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void deleteList(final List<? extends ContainerEntry> entries) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfContainerEntry.handleMultiple(entries);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContainerEntry> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerEntry.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContainerEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerEntry.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteByContainerUid(final long containerUid) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByContainerUid.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, containerUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteByContainerUid.release(_stmt);
    }
  }

  @Override
  public Object deleteContainerEntriesCreatedByJobs(final long jobId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteContainerEntriesCreatedByJobs.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, jobId);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteContainerEntriesCreatedByJobs.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void deleteByContentEntryUid(final long contentEntryUid) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByContentEntryUid.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, contentEntryUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteByContentEntryUid.release(_stmt);
    }
  }

  @Override
  public Object insertWithMd5SumsAsync(final long containerUid, final String path, final String md5,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfInsertWithMd5SumsAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, containerUid);
        _argIndex = 2;
        if (path == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, path);
        }
        _argIndex = 3;
        if (md5 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, md5);
        }
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfInsertWithMd5SumsAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public List<ContainerEntryWithContainerEntryFile> findByContainer(final long containerUid) {
    final String _sql = "SELECT ContainerEntry.*, ContainerEntryFile.* FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCeUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceUid");
      final int _cursorIndexOfCeContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceContainerUid");
      final int _cursorIndexOfCePath = CursorUtil.getColumnIndexOrThrow(_cursor, "cePath");
      final int _cursorIndexOfCeCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCefUid");
      final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
      final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
      final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
      final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
      final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
      final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final List<ContainerEntryWithContainerEntryFile> _result = new ArrayList<ContainerEntryWithContainerEntryFile>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContainerEntryWithContainerEntryFile _item;
        final ContainerEntryFile _tmpContainerEntryFile;
        if (! (_cursor.isNull(_cursorIndexOfCefUid) && _cursor.isNull(_cursorIndexOfCefMd5) && _cursor.isNull(_cursorIndexOfCefPath) && _cursor.isNull(_cursorIndexOfCeTotalSize) && _cursor.isNull(_cursorIndexOfCeCompressedSize) && _cursor.isNull(_cursorIndexOfCompression) && _cursor.isNull(_cursorIndexOfLastModified))) {
          _tmpContainerEntryFile = new ContainerEntryFile();
          final long _tmpCefUid;
          _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
          _tmpContainerEntryFile.setCefUid(_tmpCefUid);
          final String _tmpCefMd5;
          if (_cursor.isNull(_cursorIndexOfCefMd5)) {
            _tmpCefMd5 = null;
          } else {
            _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
          }
          _tmpContainerEntryFile.setCefMd5(_tmpCefMd5);
          final String _tmpCefPath;
          if (_cursor.isNull(_cursorIndexOfCefPath)) {
            _tmpCefPath = null;
          } else {
            _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
          }
          _tmpContainerEntryFile.setCefPath(_tmpCefPath);
          final long _tmpCeTotalSize;
          _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
          _tmpContainerEntryFile.setCeTotalSize(_tmpCeTotalSize);
          final long _tmpCeCompressedSize;
          _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
          _tmpContainerEntryFile.setCeCompressedSize(_tmpCeCompressedSize);
          final int _tmpCompression;
          _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
          _tmpContainerEntryFile.setCompression(_tmpCompression);
          final long _tmpLastModified;
          _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
          _tmpContainerEntryFile.setLastModified(_tmpLastModified);
        }  else  {
          _tmpContainerEntryFile = null;
        }
        _item = new ContainerEntryWithContainerEntryFile();
        final long _tmpCeUid;
        _tmpCeUid = _cursor.getLong(_cursorIndexOfCeUid);
        _item.setCeUid(_tmpCeUid);
        final long _tmpCeContainerUid;
        _tmpCeContainerUid = _cursor.getLong(_cursorIndexOfCeContainerUid);
        _item.setCeContainerUid(_tmpCeContainerUid);
        final String _tmpCePath;
        if (_cursor.isNull(_cursorIndexOfCePath)) {
          _tmpCePath = null;
        } else {
          _tmpCePath = _cursor.getString(_cursorIndexOfCePath);
        }
        _item.setCePath(_tmpCePath);
        final long _tmpCeCefUid;
        _tmpCeCefUid = _cursor.getLong(_cursorIndexOfCeCefUid);
        _item.setCeCefUid(_tmpCeCefUid);
        _item.setContainerEntryFile(_tmpContainerEntryFile);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContainerEntryWithContainerEntryFile findByPathInContainer(final long containerUid,
      final String pathInContainer) {
    final String _sql = "SELECT ContainerEntry.*, ContainerEntryFile.* FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = ? AND ContainerEntry.cePath = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    _argIndex = 2;
    if (pathInContainer == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, pathInContainer);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCeUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceUid");
      final int _cursorIndexOfCeContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceContainerUid");
      final int _cursorIndexOfCePath = CursorUtil.getColumnIndexOrThrow(_cursor, "cePath");
      final int _cursorIndexOfCeCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCefUid");
      final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
      final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
      final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
      final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
      final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
      final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final ContainerEntryWithContainerEntryFile _result;
      if(_cursor.moveToFirst()) {
        final ContainerEntryFile _tmpContainerEntryFile;
        if (! (_cursor.isNull(_cursorIndexOfCefUid) && _cursor.isNull(_cursorIndexOfCefMd5) && _cursor.isNull(_cursorIndexOfCefPath) && _cursor.isNull(_cursorIndexOfCeTotalSize) && _cursor.isNull(_cursorIndexOfCeCompressedSize) && _cursor.isNull(_cursorIndexOfCompression) && _cursor.isNull(_cursorIndexOfLastModified))) {
          _tmpContainerEntryFile = new ContainerEntryFile();
          final long _tmpCefUid;
          _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
          _tmpContainerEntryFile.setCefUid(_tmpCefUid);
          final String _tmpCefMd5;
          if (_cursor.isNull(_cursorIndexOfCefMd5)) {
            _tmpCefMd5 = null;
          } else {
            _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
          }
          _tmpContainerEntryFile.setCefMd5(_tmpCefMd5);
          final String _tmpCefPath;
          if (_cursor.isNull(_cursorIndexOfCefPath)) {
            _tmpCefPath = null;
          } else {
            _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
          }
          _tmpContainerEntryFile.setCefPath(_tmpCefPath);
          final long _tmpCeTotalSize;
          _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
          _tmpContainerEntryFile.setCeTotalSize(_tmpCeTotalSize);
          final long _tmpCeCompressedSize;
          _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
          _tmpContainerEntryFile.setCeCompressedSize(_tmpCeCompressedSize);
          final int _tmpCompression;
          _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
          _tmpContainerEntryFile.setCompression(_tmpCompression);
          final long _tmpLastModified;
          _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
          _tmpContainerEntryFile.setLastModified(_tmpLastModified);
        }  else  {
          _tmpContainerEntryFile = null;
        }
        _result = new ContainerEntryWithContainerEntryFile();
        final long _tmpCeUid;
        _tmpCeUid = _cursor.getLong(_cursorIndexOfCeUid);
        _result.setCeUid(_tmpCeUid);
        final long _tmpCeContainerUid;
        _tmpCeContainerUid = _cursor.getLong(_cursorIndexOfCeContainerUid);
        _result.setCeContainerUid(_tmpCeContainerUid);
        final String _tmpCePath;
        if (_cursor.isNull(_cursorIndexOfCePath)) {
          _tmpCePath = null;
        } else {
          _tmpCePath = _cursor.getString(_cursorIndexOfCePath);
        }
        _result.setCePath(_tmpCePath);
        final long _tmpCeCefUid;
        _tmpCeCefUid = _cursor.getLong(_cursorIndexOfCeCefUid);
        _result.setCeCefUid(_tmpCeCefUid);
        _result.setContainerEntryFile(_tmpContainerEntryFile);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<ContainerEntryWithMd5> findByContainerWithMd5(final long containerUid) {
    final String _sql = "SELECT ContainerEntry.*, ContainerEntryFile.cefMd5 AS cefMd5 FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCeUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceUid");
      final int _cursorIndexOfCeContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceContainerUid");
      final int _cursorIndexOfCePath = CursorUtil.getColumnIndexOrThrow(_cursor, "cePath");
      final int _cursorIndexOfCeCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCefUid");
      final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
      final List<ContainerEntryWithMd5> _result = new ArrayList<ContainerEntryWithMd5>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContainerEntryWithMd5 _item;
        final String _tmpCefMd5;
        if (_cursor.isNull(_cursorIndexOfCefMd5)) {
          _tmpCefMd5 = null;
        } else {
          _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
        }
        _item = new ContainerEntryWithMd5(_tmpCefMd5);
        final long _tmpCeUid;
        _tmpCeUid = _cursor.getLong(_cursorIndexOfCeUid);
        _item.setCeUid(_tmpCeUid);
        final long _tmpCeContainerUid;
        _tmpCeContainerUid = _cursor.getLong(_cursorIndexOfCeContainerUid);
        _item.setCeContainerUid(_tmpCeContainerUid);
        final String _tmpCePath;
        if (_cursor.isNull(_cursorIndexOfCePath)) {
          _tmpCePath = null;
        } else {
          _tmpCePath = _cursor.getString(_cursorIndexOfCePath);
        }
        _item.setCePath(_tmpCePath);
        final long _tmpCeCefUid;
        _tmpCeCefUid = _cursor.getLong(_cursorIndexOfCeCefUid);
        _item.setCeCefUid(_tmpCeCefUid);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByContainerAsync(final long containerUid,
      final Continuation<? super List<ContainerEntryWithContainerEntryFile>> continuation) {
    final String _sql = "SELECT ContainerEntry.*, ContainerEntryFile.* FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, containerUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContainerEntryWithContainerEntryFile>>() {
      @Override
      public List<ContainerEntryWithContainerEntryFile> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCeUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceUid");
          final int _cursorIndexOfCeContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceContainerUid");
          final int _cursorIndexOfCePath = CursorUtil.getColumnIndexOrThrow(_cursor, "cePath");
          final int _cursorIndexOfCeCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCefUid");
          final int _cursorIndexOfCefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cefUid");
          final int _cursorIndexOfCefMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cefMd5");
          final int _cursorIndexOfCefPath = CursorUtil.getColumnIndexOrThrow(_cursor, "cefPath");
          final int _cursorIndexOfCeTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceTotalSize");
          final int _cursorIndexOfCeCompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "ceCompressedSize");
          final int _cursorIndexOfCompression = CursorUtil.getColumnIndexOrThrow(_cursor, "compression");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final List<ContainerEntryWithContainerEntryFile> _result = new ArrayList<ContainerEntryWithContainerEntryFile>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContainerEntryWithContainerEntryFile _item;
            final ContainerEntryFile _tmpContainerEntryFile;
            if (! (_cursor.isNull(_cursorIndexOfCefUid) && _cursor.isNull(_cursorIndexOfCefMd5) && _cursor.isNull(_cursorIndexOfCefPath) && _cursor.isNull(_cursorIndexOfCeTotalSize) && _cursor.isNull(_cursorIndexOfCeCompressedSize) && _cursor.isNull(_cursorIndexOfCompression) && _cursor.isNull(_cursorIndexOfLastModified))) {
              _tmpContainerEntryFile = new ContainerEntryFile();
              final long _tmpCefUid;
              _tmpCefUid = _cursor.getLong(_cursorIndexOfCefUid);
              _tmpContainerEntryFile.setCefUid(_tmpCefUid);
              final String _tmpCefMd5;
              if (_cursor.isNull(_cursorIndexOfCefMd5)) {
                _tmpCefMd5 = null;
              } else {
                _tmpCefMd5 = _cursor.getString(_cursorIndexOfCefMd5);
              }
              _tmpContainerEntryFile.setCefMd5(_tmpCefMd5);
              final String _tmpCefPath;
              if (_cursor.isNull(_cursorIndexOfCefPath)) {
                _tmpCefPath = null;
              } else {
                _tmpCefPath = _cursor.getString(_cursorIndexOfCefPath);
              }
              _tmpContainerEntryFile.setCefPath(_tmpCefPath);
              final long _tmpCeTotalSize;
              _tmpCeTotalSize = _cursor.getLong(_cursorIndexOfCeTotalSize);
              _tmpContainerEntryFile.setCeTotalSize(_tmpCeTotalSize);
              final long _tmpCeCompressedSize;
              _tmpCeCompressedSize = _cursor.getLong(_cursorIndexOfCeCompressedSize);
              _tmpContainerEntryFile.setCeCompressedSize(_tmpCeCompressedSize);
              final int _tmpCompression;
              _tmpCompression = _cursor.getInt(_cursorIndexOfCompression);
              _tmpContainerEntryFile.setCompression(_tmpCompression);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpContainerEntryFile.setLastModified(_tmpLastModified);
            }  else  {
              _tmpContainerEntryFile = null;
            }
            _item = new ContainerEntryWithContainerEntryFile();
            final long _tmpCeUid;
            _tmpCeUid = _cursor.getLong(_cursorIndexOfCeUid);
            _item.setCeUid(_tmpCeUid);
            final long _tmpCeContainerUid;
            _tmpCeContainerUid = _cursor.getLong(_cursorIndexOfCeContainerUid);
            _item.setCeContainerUid(_tmpCeContainerUid);
            final String _tmpCePath;
            if (_cursor.isNull(_cursorIndexOfCePath)) {
              _tmpCePath = null;
            } else {
              _tmpCePath = _cursor.getString(_cursorIndexOfCePath);
            }
            _item.setCePath(_tmpCePath);
            final long _tmpCeCefUid;
            _tmpCeCefUid = _cursor.getLong(_cursorIndexOfCeCefUid);
            _item.setCeCefUid(_tmpCeCefUid);
            _item.setContainerEntryFile(_tmpContainerEntryFile);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
