package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContextXObjectStatementJoinDao_Impl extends ContextXObjectStatementJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContextXObjectStatementJoin> __insertionAdapterOfContextXObjectStatementJoin;

  private final EntityDeletionOrUpdateAdapter<ContextXObjectStatementJoin> __updateAdapterOfContextXObjectStatementJoin;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ContextXObjectStatementJoinDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContextXObjectStatementJoin = new EntityInsertionAdapter<ContextXObjectStatementJoin>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContextXObjectStatementJoin` (`contextXObjectStatementJoinUid`,`contextActivityFlag`,`contextStatementUid`,`contextXObjectUid`,`verbMasterChangeSeqNum`,`verbLocalChangeSeqNum`,`verbLastChangedBy`,`contextXObjectLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContextXObjectStatementJoin value) {
        stmt.bindLong(1, value.getContextXObjectStatementJoinUid());
        stmt.bindLong(2, value.getContextActivityFlag());
        stmt.bindLong(3, value.getContextStatementUid());
        stmt.bindLong(4, value.getContextXObjectUid());
        stmt.bindLong(5, value.getVerbMasterChangeSeqNum());
        stmt.bindLong(6, value.getVerbLocalChangeSeqNum());
        stmt.bindLong(7, value.getVerbLastChangedBy());
        stmt.bindLong(8, value.getContextXObjectLct());
      }
    };
    this.__updateAdapterOfContextXObjectStatementJoin = new EntityDeletionOrUpdateAdapter<ContextXObjectStatementJoin>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContextXObjectStatementJoin` SET `contextXObjectStatementJoinUid` = ?,`contextActivityFlag` = ?,`contextStatementUid` = ?,`contextXObjectUid` = ?,`verbMasterChangeSeqNum` = ?,`verbLocalChangeSeqNum` = ?,`verbLastChangedBy` = ?,`contextXObjectLct` = ? WHERE `contextXObjectStatementJoinUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContextXObjectStatementJoin value) {
        stmt.bindLong(1, value.getContextXObjectStatementJoinUid());
        stmt.bindLong(2, value.getContextActivityFlag());
        stmt.bindLong(3, value.getContextStatementUid());
        stmt.bindLong(4, value.getContextXObjectUid());
        stmt.bindLong(5, value.getVerbMasterChangeSeqNum());
        stmt.bindLong(6, value.getVerbLocalChangeSeqNum());
        stmt.bindLong(7, value.getVerbLastChangedBy());
        stmt.bindLong(8, value.getContextXObjectLct());
        stmt.bindLong(9, value.getContextXObjectStatementJoinUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "    REPLACE INTO ContextXObjectStatementJoinReplicate(cxosjPk, cxosjDestination)\n"
                + "    SELECT DISTINCT ContextXObjectStatementJoin.contextXObjectStatementJoinUid AS cxosjPk,\n"
                + "         UserSession.usClientNodeId AS cxosjDestination\n"
                + "    FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             JOIN ScopedGrant\n"
                + "                  ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                     AND (ScopedGrant.sgPermissions & 549755813888) > 0\n"
                + "             JOIN StatementEntity\n"
                + "                  ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                AND ScopedGrant.sgEntityUid = -2)\n"
                + "             OR (ScopedGrant.sgTableId = 9\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n"
                + "             OR (ScopedGrant.sgTableId = 6\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n"
                + "             OR (ScopedGrant.sgTableId = 164\n"
                + "                AND ScopedGrant.sgEntityUid = (\n"
                + "                    SELECT clazzSchoolUid\n"
                + "                      FROM Clazz \n"
                + "                     WHERE clazzUid = StatementEntity.statementClazzUid))\n"
                + "            )         \n"
                + "        \n"
                + "             JOIN ContextXObjectStatementJoin\n"
                + "                  ON ContextXObjectStatementJoin.contextStatementUid = StatementEntity.statementUid\n"
                + "   WHERE UserSession.usClientNodeId = ?\n"
                + "     -- Temporary measure to prevent admin user getting clogged up\n"
                + "     -- Restrict to the last 30 days of data\n"
                + "     AND StatementEntity.timestamp > ( \n"
                + "   --notpsql\n"
                + "   strftime('%s', 'now') * 1000\n"
                + "   --endnotpsql\n"
                + "   /*psql\n"
                + "   ROUND(EXTRACT(epoch from NOW())*1000)\n"
                + "   */\n"
                + "   - (30 * CAST(86400000 AS BIGINT)))   \n"
                + "    --notpsql \n"
                + "     AND ContextXObjectStatementJoin.contextXObjectLct != COALESCE(\n"
                + "         (SELECT cxosjVersionId\n"
                + "            FROM ContextXObjectStatementJoinReplicate\n"
                + "           WHERE cxosjPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid\n"
                + "             AND cxosjDestination = UserSession.usClientNodeId), 0) \n"
                + "    --endnotpsql         \n"
                + "    /*psql ON CONFLICT(cxosjPk, cxosjDestination) DO UPDATE\n"
                + "     SET cxosjPending = (SELECT ContextXObjectStatementJoin.contextXObjectLct\n"
                + "                           FROM ContextXObjectStatementJoin\n"
                + "                          WHERE ContextXObjectStatementJoin.contextXObjectStatementJoinUid = EXCLUDED.cxosjPk ) \n"
                + "                                != ContextXObjectStatementJoinReplicate.cxosjVersionId             \n"
                + "    */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "    REPLACE INTO ContextXObjectStatementJoinReplicate(cxosjPk, cxosjDestination)\n"
                + "    SELECT DISTINCT ContextXObjectStatementJoin.contextXObjectStatementJoinUid AS cxosjUid,\n"
                + "         UserSession.usClientNodeId AS cxosjDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ContextXObjectStatementJoin\n"
                + "             ON ChangeLog.chTableId = 66\n"
                + "                AND ChangeLog.chEntityPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid\n"
                + "         JOIN StatementEntity\n"
                + "               ON ContextXObjectStatementJoin.contextStatementUid = StatementEntity.statementUid\n"
                + "         JOIN ScopedGrant\n"
                + "              ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                AND ScopedGrant.sgEntityUid = -2)\n"
                + "             OR (ScopedGrant.sgTableId = 9\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n"
                + "             OR (ScopedGrant.sgTableId = 6\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n"
                + "             OR (ScopedGrant.sgTableId = 164\n"
                + "                AND ScopedGrant.sgEntityUid = (\n"
                + "                    SELECT clazzSchoolUid\n"
                + "                      FROM Clazz\n"
                + "                     WHERE clazzUid = StatementEntity.statementClazzUid))\n"
                + "             )\n"
                + "        \n"
                + "                 AND (ScopedGrant.sgPermissions & 549755813888) > 0\n"
                + "         JOIN PersonGroupMember\n"
                + "              ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "         JOIN UserSession\n"
                + "              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "                 AND UserSession.usStatus = 1\n"
                + "    WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "   --notpsql       \n"
                + "     AND ContextXObjectStatementJoin.contextXObjectLct != COALESCE(\n"
                + "         (SELECT cxosjVersionId\n"
                + "            FROM ContextXObjectStatementJoinReplicate\n"
                + "           WHERE cxosjPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid\n"
                + "             AND cxosjDestination = UserSession.usClientNodeId), 0)\n"
                + "    --endnotpsql\n"
                + "    /*psql ON CONFLICT(cxosjPk, cxosjDestination) DO UPDATE\n"
                + "     SET cxosjPending = (SELECT ContextXObjectStatementJoin.contextXObjectLct\n"
                + "                           FROM ContextXObjectStatementJoin\n"
                + "                          WHERE ContextXObjectStatementJoin.contextXObjectStatementJoinUid = EXCLUDED.cxosjPk ) \n"
                + "                                != ContextXObjectStatementJoinReplicate.cxosjVersionId             \n"
                + "    */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContextXObjectStatementJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContextXObjectStatementJoin.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContextXObjectStatementJoin entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContextXObjectStatementJoin.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContextXObjectStatementJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContextXObjectStatementJoin.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContextXObjectStatementJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContextXObjectStatementJoin.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContextXObjectStatementJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContextXObjectStatementJoin.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public ContextXObjectStatementJoin findByStatementAndObjectUid(final long statementUid,
      final long objectUid) {
    final String _sql = "SELECT * FROM ContextXObjectStatementJoin where contextStatementUid = ? and contextXObjectUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, statementUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, objectUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContextXObjectStatementJoinUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextXObjectStatementJoinUid");
      final int _cursorIndexOfContextActivityFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contextActivityFlag");
      final int _cursorIndexOfContextStatementUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementUid");
      final int _cursorIndexOfContextXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextXObjectUid");
      final int _cursorIndexOfVerbMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "verbMasterChangeSeqNum");
      final int _cursorIndexOfVerbLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLocalChangeSeqNum");
      final int _cursorIndexOfVerbLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLastChangedBy");
      final int _cursorIndexOfContextXObjectLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contextXObjectLct");
      final ContextXObjectStatementJoin _result;
      if(_cursor.moveToFirst()) {
        _result = new ContextXObjectStatementJoin();
        final long _tmpContextXObjectStatementJoinUid;
        _tmpContextXObjectStatementJoinUid = _cursor.getLong(_cursorIndexOfContextXObjectStatementJoinUid);
        _result.setContextXObjectStatementJoinUid(_tmpContextXObjectStatementJoinUid);
        final int _tmpContextActivityFlag;
        _tmpContextActivityFlag = _cursor.getInt(_cursorIndexOfContextActivityFlag);
        _result.setContextActivityFlag(_tmpContextActivityFlag);
        final long _tmpContextStatementUid;
        _tmpContextStatementUid = _cursor.getLong(_cursorIndexOfContextStatementUid);
        _result.setContextStatementUid(_tmpContextStatementUid);
        final long _tmpContextXObjectUid;
        _tmpContextXObjectUid = _cursor.getLong(_cursorIndexOfContextXObjectUid);
        _result.setContextXObjectUid(_tmpContextXObjectUid);
        final long _tmpVerbMasterChangeSeqNum;
        _tmpVerbMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfVerbMasterChangeSeqNum);
        _result.setVerbMasterChangeSeqNum(_tmpVerbMasterChangeSeqNum);
        final long _tmpVerbLocalChangeSeqNum;
        _tmpVerbLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfVerbLocalChangeSeqNum);
        _result.setVerbLocalChangeSeqNum(_tmpVerbLocalChangeSeqNum);
        final int _tmpVerbLastChangedBy;
        _tmpVerbLastChangedBy = _cursor.getInt(_cursorIndexOfVerbLastChangedBy);
        _result.setVerbLastChangedBy(_tmpVerbLastChangedBy);
        final long _tmpContextXObjectLct;
        _tmpContextXObjectLct = _cursor.getLong(_cursorIndexOfContextXObjectLct);
        _result.setContextXObjectLct(_tmpContextXObjectLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
