package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.AssignmentProgressSummary;
import com.ustadmobile.lib.db.entities.ClazzAssignment;
import com.ustadmobile.lib.db.entities.ClazzAssignmentWithMetrics;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import com.ustadmobile.lib.db.entities.ContentEntryStatementScoreProgress;
import com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer;
import com.ustadmobile.lib.db.entities.CourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseBlock;
import com.ustadmobile.lib.db.entities.CourseBlockWithCompleteEntity;
import com.ustadmobile.lib.db.entities.CourseBlockWithEntityDb;
import com.ustadmobile.lib.db.entities.CourseDiscussion;
import com.ustadmobile.lib.db.entities.Language;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseBlockDao_Impl extends CourseBlockDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseBlock> __insertionAdapterOfCourseBlock;

  private final EntityInsertionAdapter<CourseBlock> __insertionAdapterOfCourseBlock_1;

  private final EntityDeletionOrUpdateAdapter<CourseBlock> __updateAdapterOfCourseBlock;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public CourseBlockDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseBlock = new EntityInsertionAdapter<CourseBlock>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `CourseBlock` (`cbUid`,`cbType`,`cbIndentLevel`,`cbModuleParentBlockUid`,`cbTitle`,`cbDescription`,`cbCompletionCriteria`,`cbHideUntilDate`,`cbDeadlineDate`,`cbLateSubmissionPenalty`,`cbGracePeriodDate`,`cbMaxPoints`,`cbMinPoints`,`cbIndex`,`cbClazzUid`,`cbActive`,`cbHidden`,`cbEntityUid`,`cbLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseBlock value) {
        stmt.bindLong(1, value.getCbUid());
        stmt.bindLong(2, value.getCbType());
        stmt.bindLong(3, value.getCbIndentLevel());
        stmt.bindLong(4, value.getCbModuleParentBlockUid());
        if (value.getCbTitle() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCbTitle());
        }
        if (value.getCbDescription() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCbDescription());
        }
        stmt.bindLong(7, value.getCbCompletionCriteria());
        stmt.bindLong(8, value.getCbHideUntilDate());
        stmt.bindLong(9, value.getCbDeadlineDate());
        stmt.bindLong(10, value.getCbLateSubmissionPenalty());
        stmt.bindLong(11, value.getCbGracePeriodDate());
        stmt.bindLong(12, value.getCbMaxPoints());
        stmt.bindLong(13, value.getCbMinPoints());
        stmt.bindLong(14, value.getCbIndex());
        stmt.bindLong(15, value.getCbClazzUid());
        final int _tmp = value.getCbActive() ? 1 : 0;
        stmt.bindLong(16, _tmp);
        final int _tmp_1 = value.getCbHidden() ? 1 : 0;
        stmt.bindLong(17, _tmp_1);
        stmt.bindLong(18, value.getCbEntityUid());
        stmt.bindLong(19, value.getCbLct());
      }
    };
    this.__insertionAdapterOfCourseBlock_1 = new EntityInsertionAdapter<CourseBlock>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `CourseBlock` (`cbUid`,`cbType`,`cbIndentLevel`,`cbModuleParentBlockUid`,`cbTitle`,`cbDescription`,`cbCompletionCriteria`,`cbHideUntilDate`,`cbDeadlineDate`,`cbLateSubmissionPenalty`,`cbGracePeriodDate`,`cbMaxPoints`,`cbMinPoints`,`cbIndex`,`cbClazzUid`,`cbActive`,`cbHidden`,`cbEntityUid`,`cbLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseBlock value) {
        stmt.bindLong(1, value.getCbUid());
        stmt.bindLong(2, value.getCbType());
        stmt.bindLong(3, value.getCbIndentLevel());
        stmt.bindLong(4, value.getCbModuleParentBlockUid());
        if (value.getCbTitle() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCbTitle());
        }
        if (value.getCbDescription() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCbDescription());
        }
        stmt.bindLong(7, value.getCbCompletionCriteria());
        stmt.bindLong(8, value.getCbHideUntilDate());
        stmt.bindLong(9, value.getCbDeadlineDate());
        stmt.bindLong(10, value.getCbLateSubmissionPenalty());
        stmt.bindLong(11, value.getCbGracePeriodDate());
        stmt.bindLong(12, value.getCbMaxPoints());
        stmt.bindLong(13, value.getCbMinPoints());
        stmt.bindLong(14, value.getCbIndex());
        stmt.bindLong(15, value.getCbClazzUid());
        final int _tmp = value.getCbActive() ? 1 : 0;
        stmt.bindLong(16, _tmp);
        final int _tmp_1 = value.getCbHidden() ? 1 : 0;
        stmt.bindLong(17, _tmp_1);
        stmt.bindLong(18, value.getCbEntityUid());
        stmt.bindLong(19, value.getCbLct());
      }
    };
    this.__updateAdapterOfCourseBlock = new EntityDeletionOrUpdateAdapter<CourseBlock>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `CourseBlock` SET `cbUid` = ?,`cbType` = ?,`cbIndentLevel` = ?,`cbModuleParentBlockUid` = ?,`cbTitle` = ?,`cbDescription` = ?,`cbCompletionCriteria` = ?,`cbHideUntilDate` = ?,`cbDeadlineDate` = ?,`cbLateSubmissionPenalty` = ?,`cbGracePeriodDate` = ?,`cbMaxPoints` = ?,`cbMinPoints` = ?,`cbIndex` = ?,`cbClazzUid` = ?,`cbActive` = ?,`cbHidden` = ?,`cbEntityUid` = ?,`cbLct` = ? WHERE `cbUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseBlock value) {
        stmt.bindLong(1, value.getCbUid());
        stmt.bindLong(2, value.getCbType());
        stmt.bindLong(3, value.getCbIndentLevel());
        stmt.bindLong(4, value.getCbModuleParentBlockUid());
        if (value.getCbTitle() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCbTitle());
        }
        if (value.getCbDescription() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCbDescription());
        }
        stmt.bindLong(7, value.getCbCompletionCriteria());
        stmt.bindLong(8, value.getCbHideUntilDate());
        stmt.bindLong(9, value.getCbDeadlineDate());
        stmt.bindLong(10, value.getCbLateSubmissionPenalty());
        stmt.bindLong(11, value.getCbGracePeriodDate());
        stmt.bindLong(12, value.getCbMaxPoints());
        stmt.bindLong(13, value.getCbMinPoints());
        stmt.bindLong(14, value.getCbIndex());
        stmt.bindLong(15, value.getCbClazzUid());
        final int _tmp = value.getCbActive() ? 1 : 0;
        stmt.bindLong(16, _tmp);
        final int _tmp_1 = value.getCbHidden() ? 1 : 0;
        stmt.bindLong(17, _tmp_1);
        stmt.bindLong(18, value.getCbEntityUid());
        stmt.bindLong(19, value.getCbLct());
        stmt.bindLong(20, value.getCbUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "    REPLACE INTO CourseBlockReplicate(cbPk, cbDestination)\n"
                + "      SELECT DISTINCT CourseBlock.cbUid AS cbPk,\n"
                + "             ? AS cbDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "               JOIN CourseBlock\n"
                + "                    ON CourseBlock.cbClazzUid = Clazz.clazzUid                \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND CourseBlock.cbLct != COALESCE(\n"
                + "             (SELECT cbVersionId\n"
                + "                FROM CourseBlockReplicate\n"
                + "               WHERE cbPk = CourseBlock.cbUid\n"
                + "                 AND cbDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(cbPk, cbDestination) DO UPDATE\n"
                + "             SET cbPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO CourseBlockReplicate(cbPk, cbDestination)\n"
                + "  SELECT DISTINCT CourseBlock.cbUid AS cbPk,\n"
                + "         UserSession.usClientNodeId AS cbDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN CourseBlock\n"
                + "             ON ChangeLog.chTableId = 124\n"
                + "                AND ChangeLog.chEntityPk = CourseBlock.cbUid\n"
                + "             JOIN Clazz\n"
                + "                    ON  Clazz.clazzUid = CourseBlock.cbClazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "          \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND CourseBlock.cbLct != COALESCE(\n"
                + "         (SELECT cbVersionId\n"
                + "            FROM CourseBlockReplicate\n"
                + "           WHERE cbPk = CourseBlock.cbUid\n"
                + "             AND cbDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(cbPk, cbDestination) DO UPDATE\n"
                + "     SET cbPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CourseBlock \n"
                + "           SET cbActive = ?, \n"
                + "               cbLct = ?\n"
                + "         WHERE cbUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseBlock entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfCourseBlock.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseBlock entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfCourseBlock.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends CourseBlock> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseBlock.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends CourseBlock> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseBlock.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replaceListAsync(final List<? extends CourseBlock> list,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseBlock_1.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends CourseBlock> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseBlock.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CourseBlock entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseBlock.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends CourseBlock> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfCourseBlock.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAsync(final CourseBlock entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfCourseBlock.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cbUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super CourseBlock> continuation) {
    final String _sql = "SELECT * FROM CourseBlock WHERE cbUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseBlock>() {
      @Override
      public CourseBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final CourseBlock _result;
          if(_cursor.moveToFirst()) {
            _result = new CourseBlock();
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            _result.setCbUid(_tmpCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            _result.setCbType(_tmpCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            _result.setCbIndentLevel(_tmpCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            _result.setCbModuleParentBlockUid(_tmpCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            _result.setCbTitle(_tmpCbTitle);
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            _result.setCbDescription(_tmpCbDescription);
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            _result.setCbCompletionCriteria(_tmpCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            _result.setCbHideUntilDate(_tmpCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            _result.setCbDeadlineDate(_tmpCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            _result.setCbLateSubmissionPenalty(_tmpCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            _result.setCbGracePeriodDate(_tmpCbGracePeriodDate);
            final int _tmpCbMaxPoints;
            _tmpCbMaxPoints = _cursor.getInt(_cursorIndexOfCbMaxPoints);
            _result.setCbMaxPoints(_tmpCbMaxPoints);
            final int _tmpCbMinPoints;
            _tmpCbMinPoints = _cursor.getInt(_cursorIndexOfCbMinPoints);
            _result.setCbMinPoints(_tmpCbMinPoints);
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            _result.setCbIndex(_tmpCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            _result.setCbClazzUid(_tmpCbClazzUid);
            final boolean _tmpCbActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp != 0;
            _result.setCbActive(_tmpCbActive);
            final boolean _tmpCbHidden;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_1 != 0;
            _result.setCbHidden(_tmpCbHidden);
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            _result.setCbEntityUid(_tmpCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            _result.setCbLct(_tmpCbLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllCourseBlockByClazzUidAsync(final long clazzUid,
      final Continuation<? super List<? extends CourseBlockWithEntityDb>> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseBlock \n"
            + "               LEFT JOIN ClazzAssignment as assignment\n"
            + "               ON assignment.caUid = CourseBlock.cbEntityUid\n"
            + "               AND CourseBlock.cbType = 103\n"
            + "               LEFT JOIN CourseDiscussion as courseDiscussion\n"
            + "               ON CourseDiscussion.courseDiscussionUid = CourseBlock.cbEntityUid\n"
            + "               AND CourseBlock.cbType = 105\n"
            + "               LEFT JOIN ContentEntry as entry\n"
            + "               ON entry.contentEntryUid = CourseBlock.cbEntityUid\n"
            + "               AND CourseBlock.cbType = 104\n"
            + "               \n"
            + "               LEFT JOIN Language\n"
            + "               ON Language.langUid = entry.primaryLanguageUid\n"
            + "                AND CourseBlock.cbType = 104\n"
            + "               \n"
            + "         WHERE cbClazzUid = ?\n"
            + "           AND cbActive\n"
            + "      ORDER BY cbIndex\n"
            + "          ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseBlockWithEntityDb>>() {
      @Override
      public List<CourseBlockWithEntityDb> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final int _cursorIndexOfCourseDiscussionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionUid");
          final int _cursorIndexOfCourseDiscussionTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionTitle");
          final int _cursorIndexOfCourseDiscussionDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionDesc");
          final int _cursorIndexOfCourseDiscussionClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionClazzUid");
          final int _cursorIndexOfCourseDiscussionActive = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionActive");
          final int _cursorIndexOfCourseDiscussionLct = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionLct");
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final List<CourseBlockWithEntityDb> _result = new ArrayList<CourseBlockWithEntityDb>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final CourseBlockWithEntityDb _item;
            final ClazzAssignment _tmpAssignment;
            if (! (_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
              _tmpAssignment = new ClazzAssignment();
              final long _tmpCaUid;
              _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
              _tmpAssignment.setCaUid(_tmpCaUid);
              final String _tmpCaTitle;
              if (_cursor.isNull(_cursorIndexOfCaTitle)) {
                _tmpCaTitle = null;
              } else {
                _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
              }
              _tmpAssignment.setCaTitle(_tmpCaTitle);
              final String _tmpCaDescription;
              if (_cursor.isNull(_cursorIndexOfCaDescription)) {
                _tmpCaDescription = null;
              } else {
                _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
              }
              _tmpAssignment.setCaDescription(_tmpCaDescription);
              final long _tmpCaGroupUid;
              _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
              _tmpAssignment.setCaGroupUid(_tmpCaGroupUid);
              final boolean _tmpCaActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCaActive);
              _tmpCaActive = _tmp != 0;
              _tmpAssignment.setCaActive(_tmpCaActive);
              final boolean _tmpCaClassCommentEnabled;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
              _tmpCaClassCommentEnabled = _tmp_1 != 0;
              _tmpAssignment.setCaClassCommentEnabled(_tmpCaClassCommentEnabled);
              final boolean _tmpCaPrivateCommentsEnabled;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
              _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
              _tmpAssignment.setCaPrivateCommentsEnabled(_tmpCaPrivateCommentsEnabled);
              final int _tmpCaCompletionCriteria;
              _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
              _tmpAssignment.setCaCompletionCriteria(_tmpCaCompletionCriteria);
              final boolean _tmpCaRequireFileSubmission;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
              _tmpCaRequireFileSubmission = _tmp_3 != 0;
              _tmpAssignment.setCaRequireFileSubmission(_tmpCaRequireFileSubmission);
              final int _tmpCaFileType;
              _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
              _tmpAssignment.setCaFileType(_tmpCaFileType);
              final int _tmpCaSizeLimit;
              _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
              _tmpAssignment.setCaSizeLimit(_tmpCaSizeLimit);
              final int _tmpCaNumberOfFiles;
              _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
              _tmpAssignment.setCaNumberOfFiles(_tmpCaNumberOfFiles);
              final int _tmpCaSubmissionPolicy;
              _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
              _tmpAssignment.setCaSubmissionPolicy(_tmpCaSubmissionPolicy);
              final int _tmpCaMarkingType;
              _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
              _tmpAssignment.setCaMarkingType(_tmpCaMarkingType);
              final boolean _tmpCaRequireTextSubmission;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
              _tmpCaRequireTextSubmission = _tmp_4 != 0;
              _tmpAssignment.setCaRequireTextSubmission(_tmpCaRequireTextSubmission);
              final int _tmpCaTextLimitType;
              _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
              _tmpAssignment.setCaTextLimitType(_tmpCaTextLimitType);
              final int _tmpCaTextLimit;
              _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
              _tmpAssignment.setCaTextLimit(_tmpCaTextLimit);
              final long _tmpCaXObjectUid;
              _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
              _tmpAssignment.setCaXObjectUid(_tmpCaXObjectUid);
              final long _tmpCaClazzUid;
              _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
              _tmpAssignment.setCaClazzUid(_tmpCaClazzUid);
              final long _tmpCaLocalChangeSeqNum;
              _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
              _tmpAssignment.setCaLocalChangeSeqNum(_tmpCaLocalChangeSeqNum);
              final long _tmpCaMasterChangeSeqNum;
              _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
              _tmpAssignment.setCaMasterChangeSeqNum(_tmpCaMasterChangeSeqNum);
              final int _tmpCaLastChangedBy;
              _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
              _tmpAssignment.setCaLastChangedBy(_tmpCaLastChangedBy);
              final long _tmpCaLct;
              _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
              _tmpAssignment.setCaLct(_tmpCaLct);
            }  else  {
              _tmpAssignment = null;
            }
            final CourseDiscussion _tmpCourseDiscussion;
            if (! (_cursor.isNull(_cursorIndexOfCourseDiscussionUid) && _cursor.isNull(_cursorIndexOfCourseDiscussionTitle) && _cursor.isNull(_cursorIndexOfCourseDiscussionDesc) && _cursor.isNull(_cursorIndexOfCourseDiscussionClazzUid) && _cursor.isNull(_cursorIndexOfCourseDiscussionActive) && _cursor.isNull(_cursorIndexOfCourseDiscussionLct))) {
              _tmpCourseDiscussion = new CourseDiscussion();
              final long _tmpCourseDiscussionUid;
              _tmpCourseDiscussionUid = _cursor.getLong(_cursorIndexOfCourseDiscussionUid);
              _tmpCourseDiscussion.setCourseDiscussionUid(_tmpCourseDiscussionUid);
              final String _tmpCourseDiscussionTitle;
              if (_cursor.isNull(_cursorIndexOfCourseDiscussionTitle)) {
                _tmpCourseDiscussionTitle = null;
              } else {
                _tmpCourseDiscussionTitle = _cursor.getString(_cursorIndexOfCourseDiscussionTitle);
              }
              _tmpCourseDiscussion.setCourseDiscussionTitle(_tmpCourseDiscussionTitle);
              final String _tmpCourseDiscussionDesc;
              if (_cursor.isNull(_cursorIndexOfCourseDiscussionDesc)) {
                _tmpCourseDiscussionDesc = null;
              } else {
                _tmpCourseDiscussionDesc = _cursor.getString(_cursorIndexOfCourseDiscussionDesc);
              }
              _tmpCourseDiscussion.setCourseDiscussionDesc(_tmpCourseDiscussionDesc);
              final long _tmpCourseDiscussionClazzUid;
              _tmpCourseDiscussionClazzUid = _cursor.getLong(_cursorIndexOfCourseDiscussionClazzUid);
              _tmpCourseDiscussion.setCourseDiscussionClazzUid(_tmpCourseDiscussionClazzUid);
              final boolean _tmpCourseDiscussionActive;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfCourseDiscussionActive);
              _tmpCourseDiscussionActive = _tmp_5 != 0;
              _tmpCourseDiscussion.setCourseDiscussionActive(_tmpCourseDiscussionActive);
              final long _tmpCourseDiscussionLct;
              _tmpCourseDiscussionLct = _cursor.getLong(_cursorIndexOfCourseDiscussionLct);
              _tmpCourseDiscussion.setCourseDiscussionLct(_tmpCourseDiscussionLct);
            }  else  {
              _tmpCourseDiscussion = null;
            }
            final ContentEntry _tmpEntry;
            if (! (_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
              _tmpEntry = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
              _tmpEntry.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (_cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
              }
              _tmpEntry.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (_cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
              }
              _tmpEntry.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (_cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
              }
              _tmpEntry.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (_cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
              }
              _tmpEntry.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (_cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
              }
              _tmpEntry.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
              _tmpEntry.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (_cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
              }
              _tmpEntry.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _tmpEntry.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
              }
              _tmpEntry.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _tmpEntry.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpEntry.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _tmpEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _tmpEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
              _tmpEntry.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_6;
              _tmp_6 = _cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_6 != 0;
              _tmpEntry.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_7;
              _tmp_7 = _cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_7 != 0;
              _tmpEntry.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_8;
              _tmp_8 = _cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_8 != 0;
              _tmpEntry.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
              _tmpEntry.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
              _tmpEntry.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
              _tmpEntry.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
              _tmpEntry.setContentOwner(_tmpContentOwner);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _tmpEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _tmpEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _tmpEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
              _tmpEntry.setContentEntryLct(_tmpContentEntryLct);
            }  else  {
              _tmpEntry = null;
            }
            final Language _tmpLanguage;
            if (! (_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp_9;
              _tmp_9 = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp_9 != 0;
              _tmpLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpLanguage.setLangLct(_tmpLangLct);
            }  else  {
              _tmpLanguage = null;
            }
            _item = new CourseBlockWithEntityDb();
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            _item.setCbUid(_tmpCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            _item.setCbType(_tmpCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            _item.setCbIndentLevel(_tmpCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            _item.setCbModuleParentBlockUid(_tmpCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            _item.setCbTitle(_tmpCbTitle);
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            _item.setCbDescription(_tmpCbDescription);
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            _item.setCbCompletionCriteria(_tmpCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            _item.setCbHideUntilDate(_tmpCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            _item.setCbDeadlineDate(_tmpCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            _item.setCbLateSubmissionPenalty(_tmpCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            _item.setCbGracePeriodDate(_tmpCbGracePeriodDate);
            final int _tmpCbMaxPoints;
            _tmpCbMaxPoints = _cursor.getInt(_cursorIndexOfCbMaxPoints);
            _item.setCbMaxPoints(_tmpCbMaxPoints);
            final int _tmpCbMinPoints;
            _tmpCbMinPoints = _cursor.getInt(_cursorIndexOfCbMinPoints);
            _item.setCbMinPoints(_tmpCbMinPoints);
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            _item.setCbIndex(_tmpCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            _item.setCbClazzUid(_tmpCbClazzUid);
            final boolean _tmpCbActive;
            final int _tmp_10;
            _tmp_10 = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp_10 != 0;
            _item.setCbActive(_tmpCbActive);
            final boolean _tmpCbHidden;
            final int _tmp_11;
            _tmp_11 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_11 != 0;
            _item.setCbHidden(_tmpCbHidden);
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            _item.setCbEntityUid(_tmpCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            _item.setCbLct(_tmpCbLct);
            _item.setAssignment(_tmpAssignment);
            _item.setCourseDiscussion(_tmpCourseDiscussion);
            _item.setEntry(_tmpEntry);
            _item.setLanguage(_tmpLanguage);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, CourseBlockWithCompleteEntity> findAllCourseBlockByClazzUidLive(
      final long clazzUid, final long personUid, final List<Long> collapseList,
      final long currentTime) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("         WITH CtePermissionCheck (hasPermission) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            AS (SELECT EXISTS( ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               SELECT PrsGrpMbr.groupMemberPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM Clazz");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            JOIN ScopedGrant");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 ON ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ((ScopedGrant.sgTableId = -2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ScopedGrant.sgEntityUid = -2)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            OR (ScopedGrant.sgTableId = 6");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            OR (ScopedGrant.sgTableId = 164");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AND (ScopedGrant.sgPermissions & ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          549755813888");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                       ) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("             JOIN PersonGroupMember AS PrsGrpMbr");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE Clazz.clazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND PrsGrpMbr.groupMemberPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(")), ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SubmitterList (submitterId, assignmentUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ClazzAssignment.caUid AS assignmentUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM ClazzEnrolment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       JOIN Person ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       JOIN ClazzAssignment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ON ClazzAssignment.caClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       JOIN CourseBlock");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       AND CourseBlock.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE ClazzAssignment.caGroupUid = 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND clazzEnrolmentClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND clazzEnrolmentActive");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND clazzEnrolmentRole = 1000");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate");
    _stringBuilder.append("\n");
    _stringBuilder.append("              GROUP BY submitterId, assignmentUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("            UNION                 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ClazzAssignment.caUid AS assignmentUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM CourseGroupMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    JOIN ClazzAssignment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON ClazzAssignment.caClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                AND ClazzAssignment.caGroupUid != 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                AND CourseGroupMember.cgmGroupNumber != 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("           GROUP BY submitterId, assignmentUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("            )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT CourseBlock.*, ClazzAssignment.*, ContentEntry.*, CourseDiscussion.*, ContentEntryParentChildJoin.*, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               Container.*, CourseAssignmentMark.*, (CourseBlock.cbUid NOT IN (");
    final int _inputSize = collapseList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")) AS expanded,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                COALESCE(StatementEntity.extensionProgress,0) AS progress, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                COALESCE(StatementEntity.resultCompletion,'FALSE') AS contentComplete,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                COALESCE(StatementEntity.resultSuccess, 0) AS success,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                COALESCE((CASE WHEN StatementEntity.resultCompletion ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                THEN 1 ELSE 0 END),0) AS totalCompletedContent,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                0 AS assignmentContentWeight,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                1 as totalContent, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                0 as penalty,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                (SELECT hasPermission FROM CtePermissionCheck) AS hasMetricsPermission,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("             ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 (SELECT COUNT(*) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    FROM SubmitterList ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   WHERE SubmitterList.assignmentUid = ClazzAssignment.caUid) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AS totalStudents, ");
    _stringBuilder.append("\n");
    _stringBuilder.append(" ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               0 AS notSubmittedStudents,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (CASE WHEN (SELECT hasPermission ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          FROM CtePermissionCheck)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     THEN (SELECT COUNT(DISTINCT CourseAssignmentSubmission.casSubmitterUid) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                             FROM CourseAssignmentSubmission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   LEFT JOIN CourseAssignmentMark");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   AND CourseAssignmentMark.camAssignmentUid = CourseAssignmentSubmission.casAssignmentUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            WHERE CourseAssignmentMark.camUid IS NULL");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              AND CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              AND CourseAssignmentSubmission.casSubmitterUid IN ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                    (SELECT submitterId ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                      FROM SubmitterList");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                     WHERE SubmitterList.assignmentUid = ClazzAssignment.caUid))  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      ELSE 0 END) AS submittedStudents,         ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                (CASE WHEN (SELECT hasPermission ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           FROM CtePermissionCheck)       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   THEN (SELECT COUNT(DISTINCT CourseAssignmentMark.camSubmitterUid) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           FROM CourseAssignmentMark");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                             JOIN CourseAssignmentSubmission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                             ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                             AND CourseAssignmentSubmission.casAssignmentUid = CourseAssignmentMark.camAssignmentUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                             ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          WHERE CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND CourseAssignmentMark.camSubmitterUid IN (SELECT submitterId ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                            FROM SubmitterList");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                           WHERE SubmitterList.assignmentUid = ClazzAssignment.caUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ELSE 0 END) AS markedStudents,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   COALESCE((CASE WHEN CourseAssignmentMark.camUid IS NOT NULL ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          THEN 2 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          WHEN CourseAssignmentSubmission.casUid IS NOT NULL ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          THEN 1 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          ELSE 0 END), ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                               0) AS fileSubmissionStatus");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM CourseBlock ");
    _stringBuilder.append("\n");
    _stringBuilder.append("          ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN CourseBlock AS parentBlock");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ON CourseBlock.cbModuleParentBlockUid = parentBlock.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND CourseBlock.cbTYpe != 100");
    _stringBuilder.append("\n");
    _stringBuilder.append("          ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN ClazzAssignment");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ON ClazzAssignment.caUid = CourseBlock.cbEntityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND CourseBlock.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN ContentEntry");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ON ContentEntry.contentEntryUid = CourseBlock.cbEntityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND NOT ceInactive");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND CourseBlock.cbType = 104");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN CourseDiscussion ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      ON CourseDiscussion.courseDiscussionUid = CourseBlock.cbEntityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     AND CourseBlock.cbType = 105");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN ContentEntryParentChildJoin ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN Container ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON Container.containerUid = ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        (SELECT containerUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           FROM Container ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ORDER BY cntLastModified DESC LIMIT 1)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              LEFT JOIN StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("\t\t\t\t     ON StatementEntity.statementUid = ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                (SELECT statementUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("\t\t\t\t\t\t\t       FROM StatementEntity ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("\t\t\t\t\t\t\t        AND contentEntryRoot ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                               ORDER BY resultScoreScaled DESC, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                        extensionProgress DESC, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                        resultSuccess DESC ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                  LIMIT 1) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN CourseAssignmentSubmission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ON casUid = (SELECT casUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                     FROM CourseAssignmentSubmission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    WHERE casAssignmentUid = ClazzAssignment.caUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      AND casSubmitterUid = (SELECT (CASE WHEN ref.caGroupUid = 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          THEN ");
    _stringBuilder.append("?");
    _stringBuilder.append(" ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          WHEN CourseGroupMember.cgmUid IS NULL ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          THEN 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          ELSE CourseGroupMember.cgmGroupNumber ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          END) as submitterUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                               FROM ClazzAssignment AS ref");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                    LEFT JOIN CourseGroupMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                     ON cgmSetUid = ClazzAssignment.caGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                     AND cgmPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                              WHERE ref.caUid = ClazzAssignment.caUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                 ORDER BY casTimestamp DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    LIMIT 1)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                          ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN CourseAssignmentMark");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      ON camUid = (SELECT camUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                     FROM CourseAssignmentMark");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    WHERE camAssignmentUid = ClazzAssignment.caUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      AND camSubmitterUid = (SELECT (CASE WHEN ref.caGroupUid = 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          THEN ");
    _stringBuilder.append("?");
    _stringBuilder.append(" ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          WHEN CourseGroupMember.cgmUid IS NULL ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          THEN 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          ELSE CourseGroupMember.cgmGroupNumber ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                          END) as submitterUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                               FROM ClazzAssignment AS ref");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                    LEFT JOIN CourseGroupMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                     ON cgmSetUid = ClazzAssignment.caGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                                     AND cgmPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                              WHERE ref.caUid = ClazzAssignment.caUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                 ORDER BY camLct DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    LIMIT 1)       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE CourseBlock.cbClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND CourseBlock.cbActive");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND NOT CourseBlock.cbHidden");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" > CourseBlock.cbHideUntilDate");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" > COALESCE(parentBlock.cbHideUntilDate,0)");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND CourseBlock.cbModuleParentBlockUid NOT IN (");
    final int _inputSize_1 = collapseList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize_1);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CourseBlock.cbIndex");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 13 + _inputSize + _inputSize_1;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 6;
    for (long _item : collapseList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    _argIndex = 6 + _inputSize;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 7 + _inputSize;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 8 + _inputSize;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 9 + _inputSize;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 10 + _inputSize;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 11 + _inputSize;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 12 + _inputSize;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 13 + _inputSize;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 14 + _inputSize;
    for (long _item_1 : collapseList) {
      _statement.bindLong(_argIndex, _item_1);
      _argIndex ++;
    }
    return new DataSource.Factory<Integer, CourseBlockWithCompleteEntity>() {
      @Override
      public LimitOffsetDataSource<CourseBlockWithCompleteEntity> create() {
        return new LimitOffsetDataSource<CourseBlockWithCompleteEntity>(__db, _statement, false, true , "Clazz", "ScopedGrant", "PersonGroupMember", "ClazzEnrolment", "Person", "ClazzAssignment", "CourseBlock", "CourseGroupMember", "CourseAssignmentSubmission", "CourseAssignmentMark", "ContentEntry", "CourseDiscussion", "ContentEntryParentChildJoin", "Container", "StatementEntity") {
          @Override
          protected List<CourseBlockWithCompleteEntity> convertRows(Cursor cursor) {
            final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbUid");
            final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(cursor, "cbType");
            final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(cursor, "cbIndentLevel");
            final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbModuleParentBlockUid");
            final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(cursor, "cbTitle");
            final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(cursor, "cbDescription");
            final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "cbCompletionCriteria");
            final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(cursor, "cbHideUntilDate");
            final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(cursor, "cbDeadlineDate");
            final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "cbLateSubmissionPenalty");
            final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(cursor, "cbGracePeriodDate");
            final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(cursor, "cbMaxPoints");
            final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(cursor, "cbMinPoints");
            final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(cursor, "cbIndex");
            final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbClazzUid");
            final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(cursor, "cbActive");
            final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(cursor, "cbHidden");
            final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbEntityUid");
            final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(cursor, "cbLct");
            final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(cursor, "caUid");
            final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(cursor, "caTitle");
            final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(cursor, "caDescription");
            final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "caGroupUid");
            final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(cursor, "caActive");
            final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(cursor, "caClassCommentEnabled");
            final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(cursor, "caPrivateCommentsEnabled");
            final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "caCompletionCriteria");
            final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(cursor, "caRequireFileSubmission");
            final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(cursor, "caFileType");
            final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(cursor, "caSizeLimit");
            final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(cursor, "caNumberOfFiles");
            final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(cursor, "caSubmissionPolicy");
            final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(cursor, "caMarkingType");
            final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(cursor, "caRequireTextSubmission");
            final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(cursor, "caTextLimitType");
            final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(cursor, "caTextLimit");
            final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(cursor, "caXObjectUid");
            final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "caClazzUid");
            final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "caLocalChangeSeqNum");
            final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "caMasterChangeSeqNum");
            final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "caLastChangedBy");
            final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(cursor, "caLct");
            final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
            final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
            final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
            final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
            final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
            final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
            final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
            final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
            final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
            final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
            final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
            final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
            final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
            final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
            final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
            final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
            final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
            final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
            final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
            final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
            final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
            final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
            final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
            final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
            final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
            final int _cursorIndexOfCourseDiscussionUid = CursorUtil.getColumnIndexOrThrow(cursor, "courseDiscussionUid");
            final int _cursorIndexOfCourseDiscussionTitle = CursorUtil.getColumnIndexOrThrow(cursor, "courseDiscussionTitle");
            final int _cursorIndexOfCourseDiscussionDesc = CursorUtil.getColumnIndexOrThrow(cursor, "courseDiscussionDesc");
            final int _cursorIndexOfCourseDiscussionClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "courseDiscussionClazzUid");
            final int _cursorIndexOfCourseDiscussionActive = CursorUtil.getColumnIndexOrThrow(cursor, "courseDiscussionActive");
            final int _cursorIndexOfCourseDiscussionLct = CursorUtil.getColumnIndexOrThrow(cursor, "courseDiscussionLct");
            final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
            final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
            final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
            final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
            final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
            final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
            final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
            final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
            final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerUid");
            final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntLocalCsn");
            final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntMasterCsn");
            final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModBy");
            final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(cursor, "cntLct");
            final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
            final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerContentEntryUid");
            final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModified");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(cursor, "mimeType");
            final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(cursor, "remarks");
            final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(cursor, "mobileOptimized");
            final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(cursor, "cntNumEntries");
            final int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow(cursor, "camUid");
            final int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "camAssignmentUid");
            final int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "camSubmitterUid");
            final int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow(cursor, "camMark");
            final int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "camPenalty");
            final int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow(cursor, "camLct");
            final int _cursorIndexOfExpanded = CursorUtil.getColumnIndexOrThrow(cursor, "expanded");
            final int _cursorIndexOfResultMax = CursorUtil.getColumnIndexOrThrow(cursor, "resultMax");
            final int _cursorIndexOfResultScore = CursorUtil.getColumnIndexOrThrow(cursor, "resultScore");
            final int _cursorIndexOfResultScaled = CursorUtil.getColumnIndexOrThrow(cursor, "resultScaled");
            final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(cursor, "progress");
            final int _cursorIndexOfContentComplete = CursorUtil.getColumnIndexOrThrow(cursor, "contentComplete");
            final int _cursorIndexOfSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "success");
            final int _cursorIndexOfTotalCompletedContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalCompletedContent");
            final int _cursorIndexOfAssignmentContentWeight = CursorUtil.getColumnIndexOrThrow(cursor, "assignmentContentWeight");
            final int _cursorIndexOfTotalContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalContent");
            final int _cursorIndexOfPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "penalty");
            final int _cursorIndexOfHasMetricsPermission = CursorUtil.getColumnIndexOrThrow(cursor, "hasMetricsPermission");
            final int _cursorIndexOfTotalStudents = CursorUtil.getColumnIndexOrThrow(cursor, "totalStudents");
            final int _cursorIndexOfNotSubmittedStudents = CursorUtil.getColumnIndexOrThrow(cursor, "notSubmittedStudents");
            final int _cursorIndexOfSubmittedStudents = CursorUtil.getColumnIndexOrThrow(cursor, "submittedStudents");
            final int _cursorIndexOfMarkedStudents = CursorUtil.getColumnIndexOrThrow(cursor, "markedStudents");
            final int _cursorIndexOfFileSubmissionStatus = CursorUtil.getColumnIndexOrThrow(cursor, "fileSubmissionStatus");
            final List<CourseBlockWithCompleteEntity> _res = new ArrayList<CourseBlockWithCompleteEntity>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CourseBlockWithCompleteEntity _item_2;
              final ClazzAssignmentWithMetrics _tmpAssignment;
              if (! (cursor.isNull(_cursorIndexOfCaUid) && cursor.isNull(_cursorIndexOfCaTitle) && cursor.isNull(_cursorIndexOfCaDescription) && cursor.isNull(_cursorIndexOfCaGroupUid) && cursor.isNull(_cursorIndexOfCaActive) && cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && cursor.isNull(_cursorIndexOfCaCompletionCriteria) && cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && cursor.isNull(_cursorIndexOfCaFileType) && cursor.isNull(_cursorIndexOfCaSizeLimit) && cursor.isNull(_cursorIndexOfCaNumberOfFiles) && cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && cursor.isNull(_cursorIndexOfCaMarkingType) && cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && cursor.isNull(_cursorIndexOfCaTextLimitType) && cursor.isNull(_cursorIndexOfCaTextLimit) && cursor.isNull(_cursorIndexOfCaXObjectUid) && cursor.isNull(_cursorIndexOfCaClazzUid) && cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCaLastChangedBy) && cursor.isNull(_cursorIndexOfCaLct) && cursor.isNull(_cursorIndexOfFileSubmissionStatus) && cursor.isNull(_cursorIndexOfCamUid) && cursor.isNull(_cursorIndexOfCamAssignmentUid) && cursor.isNull(_cursorIndexOfCamSubmitterUid) && cursor.isNull(_cursorIndexOfCamMark) && cursor.isNull(_cursorIndexOfCamPenalty) && cursor.isNull(_cursorIndexOfCamLct) && cursor.isNull(_cursorIndexOfHasMetricsPermission) && cursor.isNull(_cursorIndexOfTotalStudents) && cursor.isNull(_cursorIndexOfNotSubmittedStudents) && cursor.isNull(_cursorIndexOfSubmittedStudents) && cursor.isNull(_cursorIndexOfMarkedStudents))) {
                final CourseAssignmentMark _tmpMark;
                if (! (cursor.isNull(_cursorIndexOfCamUid) && cursor.isNull(_cursorIndexOfCamAssignmentUid) && cursor.isNull(_cursorIndexOfCamSubmitterUid) && cursor.isNull(_cursorIndexOfCamMark) && cursor.isNull(_cursorIndexOfCamPenalty) && cursor.isNull(_cursorIndexOfCamLct))) {
                  _tmpMark = new CourseAssignmentMark();
                  final long _tmpCamUid;
                  _tmpCamUid = cursor.getLong(_cursorIndexOfCamUid);
                  _tmpMark.setCamUid(_tmpCamUid);
                  final long _tmpCamAssignmentUid;
                  _tmpCamAssignmentUid = cursor.getLong(_cursorIndexOfCamAssignmentUid);
                  _tmpMark.setCamAssignmentUid(_tmpCamAssignmentUid);
                  final long _tmpCamSubmitterUid;
                  _tmpCamSubmitterUid = cursor.getLong(_cursorIndexOfCamSubmitterUid);
                  _tmpMark.setCamSubmitterUid(_tmpCamSubmitterUid);
                  final float _tmpCamMark;
                  _tmpCamMark = cursor.getFloat(_cursorIndexOfCamMark);
                  _tmpMark.setCamMark(_tmpCamMark);
                  final int _tmpCamPenalty;
                  _tmpCamPenalty = cursor.getInt(_cursorIndexOfCamPenalty);
                  _tmpMark.setCamPenalty(_tmpCamPenalty);
                  final long _tmpCamLct;
                  _tmpCamLct = cursor.getLong(_cursorIndexOfCamLct);
                  _tmpMark.setCamLct(_tmpCamLct);
                }  else  {
                  _tmpMark = null;
                }
                final AssignmentProgressSummary _tmpProgressSummary;
                if (! (cursor.isNull(_cursorIndexOfHasMetricsPermission) && cursor.isNull(_cursorIndexOfTotalStudents) && cursor.isNull(_cursorIndexOfNotSubmittedStudents) && cursor.isNull(_cursorIndexOfSubmittedStudents) && cursor.isNull(_cursorIndexOfMarkedStudents))) {
                  _tmpProgressSummary = new AssignmentProgressSummary();
                  final boolean _tmpHasMetricsPermission;
                  final int _tmp;
                  _tmp = cursor.getInt(_cursorIndexOfHasMetricsPermission);
                  _tmpHasMetricsPermission = _tmp != 0;
                  _tmpProgressSummary.setHasMetricsPermission(_tmpHasMetricsPermission);
                  final int _tmpTotalStudents;
                  _tmpTotalStudents = cursor.getInt(_cursorIndexOfTotalStudents);
                  _tmpProgressSummary.setTotalStudents(_tmpTotalStudents);
                  final int _tmpNotSubmittedStudents;
                  _tmpNotSubmittedStudents = cursor.getInt(_cursorIndexOfNotSubmittedStudents);
                  _tmpProgressSummary.setNotSubmittedStudents(_tmpNotSubmittedStudents);
                  final int _tmpSubmittedStudents;
                  _tmpSubmittedStudents = cursor.getInt(_cursorIndexOfSubmittedStudents);
                  _tmpProgressSummary.setSubmittedStudents(_tmpSubmittedStudents);
                  final int _tmpMarkedStudents;
                  _tmpMarkedStudents = cursor.getInt(_cursorIndexOfMarkedStudents);
                  _tmpProgressSummary.setMarkedStudents(_tmpMarkedStudents);
                }  else  {
                  _tmpProgressSummary = null;
                }
                _tmpAssignment = new ClazzAssignmentWithMetrics();
                final long _tmpCaUid;
                _tmpCaUid = cursor.getLong(_cursorIndexOfCaUid);
                _tmpAssignment.setCaUid(_tmpCaUid);
                final String _tmpCaTitle;
                if (cursor.isNull(_cursorIndexOfCaTitle)) {
                  _tmpCaTitle = null;
                } else {
                  _tmpCaTitle = cursor.getString(_cursorIndexOfCaTitle);
                }
                _tmpAssignment.setCaTitle(_tmpCaTitle);
                final String _tmpCaDescription;
                if (cursor.isNull(_cursorIndexOfCaDescription)) {
                  _tmpCaDescription = null;
                } else {
                  _tmpCaDescription = cursor.getString(_cursorIndexOfCaDescription);
                }
                _tmpAssignment.setCaDescription(_tmpCaDescription);
                final long _tmpCaGroupUid;
                _tmpCaGroupUid = cursor.getLong(_cursorIndexOfCaGroupUid);
                _tmpAssignment.setCaGroupUid(_tmpCaGroupUid);
                final boolean _tmpCaActive;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfCaActive);
                _tmpCaActive = _tmp_1 != 0;
                _tmpAssignment.setCaActive(_tmpCaActive);
                final boolean _tmpCaClassCommentEnabled;
                final int _tmp_2;
                _tmp_2 = cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                _tmpCaClassCommentEnabled = _tmp_2 != 0;
                _tmpAssignment.setCaClassCommentEnabled(_tmpCaClassCommentEnabled);
                final boolean _tmpCaPrivateCommentsEnabled;
                final int _tmp_3;
                _tmp_3 = cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                _tmpCaPrivateCommentsEnabled = _tmp_3 != 0;
                _tmpAssignment.setCaPrivateCommentsEnabled(_tmpCaPrivateCommentsEnabled);
                final int _tmpCaCompletionCriteria;
                _tmpCaCompletionCriteria = cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                _tmpAssignment.setCaCompletionCriteria(_tmpCaCompletionCriteria);
                final boolean _tmpCaRequireFileSubmission;
                final int _tmp_4;
                _tmp_4 = cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                _tmpCaRequireFileSubmission = _tmp_4 != 0;
                _tmpAssignment.setCaRequireFileSubmission(_tmpCaRequireFileSubmission);
                final int _tmpCaFileType;
                _tmpCaFileType = cursor.getInt(_cursorIndexOfCaFileType);
                _tmpAssignment.setCaFileType(_tmpCaFileType);
                final int _tmpCaSizeLimit;
                _tmpCaSizeLimit = cursor.getInt(_cursorIndexOfCaSizeLimit);
                _tmpAssignment.setCaSizeLimit(_tmpCaSizeLimit);
                final int _tmpCaNumberOfFiles;
                _tmpCaNumberOfFiles = cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                _tmpAssignment.setCaNumberOfFiles(_tmpCaNumberOfFiles);
                final int _tmpCaSubmissionPolicy;
                _tmpCaSubmissionPolicy = cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                _tmpAssignment.setCaSubmissionPolicy(_tmpCaSubmissionPolicy);
                final int _tmpCaMarkingType;
                _tmpCaMarkingType = cursor.getInt(_cursorIndexOfCaMarkingType);
                _tmpAssignment.setCaMarkingType(_tmpCaMarkingType);
                final boolean _tmpCaRequireTextSubmission;
                final int _tmp_5;
                _tmp_5 = cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                _tmpCaRequireTextSubmission = _tmp_5 != 0;
                _tmpAssignment.setCaRequireTextSubmission(_tmpCaRequireTextSubmission);
                final int _tmpCaTextLimitType;
                _tmpCaTextLimitType = cursor.getInt(_cursorIndexOfCaTextLimitType);
                _tmpAssignment.setCaTextLimitType(_tmpCaTextLimitType);
                final int _tmpCaTextLimit;
                _tmpCaTextLimit = cursor.getInt(_cursorIndexOfCaTextLimit);
                _tmpAssignment.setCaTextLimit(_tmpCaTextLimit);
                final long _tmpCaXObjectUid;
                _tmpCaXObjectUid = cursor.getLong(_cursorIndexOfCaXObjectUid);
                _tmpAssignment.setCaXObjectUid(_tmpCaXObjectUid);
                final long _tmpCaClazzUid;
                _tmpCaClazzUid = cursor.getLong(_cursorIndexOfCaClazzUid);
                _tmpAssignment.setCaClazzUid(_tmpCaClazzUid);
                final long _tmpCaLocalChangeSeqNum;
                _tmpCaLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                _tmpAssignment.setCaLocalChangeSeqNum(_tmpCaLocalChangeSeqNum);
                final long _tmpCaMasterChangeSeqNum;
                _tmpCaMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                _tmpAssignment.setCaMasterChangeSeqNum(_tmpCaMasterChangeSeqNum);
                final int _tmpCaLastChangedBy;
                _tmpCaLastChangedBy = cursor.getInt(_cursorIndexOfCaLastChangedBy);
                _tmpAssignment.setCaLastChangedBy(_tmpCaLastChangedBy);
                final long _tmpCaLct;
                _tmpCaLct = cursor.getLong(_cursorIndexOfCaLct);
                _tmpAssignment.setCaLct(_tmpCaLct);
                final int _tmpFileSubmissionStatus;
                _tmpFileSubmissionStatus = cursor.getInt(_cursorIndexOfFileSubmissionStatus);
                _tmpAssignment.setFileSubmissionStatus(_tmpFileSubmissionStatus);
                _tmpAssignment.setMark(_tmpMark);
                _tmpAssignment.setProgressSummary(_tmpProgressSummary);
              }  else  {
                _tmpAssignment = null;
              }
              final ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer _tmpEntry;
              if (! (cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct) && cursor.isNull(_cursorIndexOfAssignmentContentWeight) && cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct) && cursor.isNull(_cursorIndexOfContainerUid) && cursor.isNull(_cursorIndexOfCntLocalCsn) && cursor.isNull(_cursorIndexOfCntMasterCsn) && cursor.isNull(_cursorIndexOfCntLastModBy) && cursor.isNull(_cursorIndexOfCntLct) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfContainerContentEntryUid) && cursor.isNull(_cursorIndexOfCntLastModified) && cursor.isNull(_cursorIndexOfMimeType) && cursor.isNull(_cursorIndexOfRemarks) && cursor.isNull(_cursorIndexOfMobileOptimized) && cursor.isNull(_cursorIndexOfCntNumEntries) && cursor.isNull(_cursorIndexOfResultMax) && cursor.isNull(_cursorIndexOfResultScore) && cursor.isNull(_cursorIndexOfResultScaled) && cursor.isNull(_cursorIndexOfProgress) && cursor.isNull(_cursorIndexOfContentComplete) && cursor.isNull(_cursorIndexOfSuccess) && cursor.isNull(_cursorIndexOfTotalCompletedContent) && cursor.isNull(_cursorIndexOfTotalContent) && cursor.isNull(_cursorIndexOfPenalty))) {
                final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
                if (! (cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct))) {
                  final long _tmpCepcjParentContentEntryUid;
                  _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                  final long _tmpCepcjChildContentEntryUid;
                  _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                  final int _tmpChildIndex;
                  _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                  _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
                  final long _tmpCepcjUid;
                  _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                  _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                  final long _tmpCepcjLocalChangeSeqNum;
                  _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                  _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                  final long _tmpCepcjMasterChangeSeqNum;
                  _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                  _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                  final int _tmpCepcjLastChangedBy;
                  _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                  _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                  final long _tmpCepcjLct;
                  _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                  _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
                }  else  {
                  _tmpContentEntryParentChildJoin = null;
                }
                final Container _tmpMostRecentContainer;
                if (! (cursor.isNull(_cursorIndexOfContainerUid) && cursor.isNull(_cursorIndexOfCntLocalCsn) && cursor.isNull(_cursorIndexOfCntMasterCsn) && cursor.isNull(_cursorIndexOfCntLastModBy) && cursor.isNull(_cursorIndexOfCntLct) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfContainerContentEntryUid) && cursor.isNull(_cursorIndexOfCntLastModified) && cursor.isNull(_cursorIndexOfMimeType) && cursor.isNull(_cursorIndexOfRemarks) && cursor.isNull(_cursorIndexOfMobileOptimized) && cursor.isNull(_cursorIndexOfCntNumEntries))) {
                  _tmpMostRecentContainer = new Container();
                  final long _tmpContainerUid;
                  _tmpContainerUid = cursor.getLong(_cursorIndexOfContainerUid);
                  _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
                  final long _tmpCntLocalCsn;
                  _tmpCntLocalCsn = cursor.getLong(_cursorIndexOfCntLocalCsn);
                  _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
                  final long _tmpCntMasterCsn;
                  _tmpCntMasterCsn = cursor.getLong(_cursorIndexOfCntMasterCsn);
                  _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
                  final int _tmpCntLastModBy;
                  _tmpCntLastModBy = cursor.getInt(_cursorIndexOfCntLastModBy);
                  _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
                  final long _tmpCntLct;
                  _tmpCntLct = cursor.getLong(_cursorIndexOfCntLct);
                  _tmpMostRecentContainer.setCntLct(_tmpCntLct);
                  final long _tmpFileSize;
                  _tmpFileSize = cursor.getLong(_cursorIndexOfFileSize);
                  _tmpMostRecentContainer.setFileSize(_tmpFileSize);
                  final long _tmpContainerContentEntryUid;
                  _tmpContainerContentEntryUid = cursor.getLong(_cursorIndexOfContainerContentEntryUid);
                  _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
                  final long _tmpCntLastModified;
                  _tmpCntLastModified = cursor.getLong(_cursorIndexOfCntLastModified);
                  _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
                  final String _tmpMimeType;
                  if (cursor.isNull(_cursorIndexOfMimeType)) {
                    _tmpMimeType = null;
                  } else {
                    _tmpMimeType = cursor.getString(_cursorIndexOfMimeType);
                  }
                  _tmpMostRecentContainer.setMimeType(_tmpMimeType);
                  final String _tmpRemarks;
                  if (cursor.isNull(_cursorIndexOfRemarks)) {
                    _tmpRemarks = null;
                  } else {
                    _tmpRemarks = cursor.getString(_cursorIndexOfRemarks);
                  }
                  _tmpMostRecentContainer.setRemarks(_tmpRemarks);
                  final boolean _tmpMobileOptimized;
                  final int _tmp_6;
                  _tmp_6 = cursor.getInt(_cursorIndexOfMobileOptimized);
                  _tmpMobileOptimized = _tmp_6 != 0;
                  _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
                  final int _tmpCntNumEntries;
                  _tmpCntNumEntries = cursor.getInt(_cursorIndexOfCntNumEntries);
                  _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
                }  else  {
                  _tmpMostRecentContainer = null;
                }
                final ContentEntryStatementScoreProgress _tmpScoreProgress;
                if (! (cursor.isNull(_cursorIndexOfResultMax) && cursor.isNull(_cursorIndexOfResultScore) && cursor.isNull(_cursorIndexOfResultScaled) && cursor.isNull(_cursorIndexOfProgress) && cursor.isNull(_cursorIndexOfContentComplete) && cursor.isNull(_cursorIndexOfSuccess) && cursor.isNull(_cursorIndexOfTotalCompletedContent) && cursor.isNull(_cursorIndexOfTotalContent) && cursor.isNull(_cursorIndexOfPenalty))) {
                  _tmpScoreProgress = new ContentEntryStatementScoreProgress();
                  final int _tmpResultMax;
                  _tmpResultMax = cursor.getInt(_cursorIndexOfResultMax);
                  _tmpScoreProgress.setResultMax(_tmpResultMax);
                  final int _tmpResultScore;
                  _tmpResultScore = cursor.getInt(_cursorIndexOfResultScore);
                  _tmpScoreProgress.setResultScore(_tmpResultScore);
                  final float _tmpResultScaled;
                  _tmpResultScaled = cursor.getFloat(_cursorIndexOfResultScaled);
                  _tmpScoreProgress.setResultScaled(_tmpResultScaled);
                  final int _tmpProgress;
                  _tmpProgress = cursor.getInt(_cursorIndexOfProgress);
                  _tmpScoreProgress.setProgress(_tmpProgress);
                  final boolean _tmpContentComplete;
                  final int _tmp_7;
                  _tmp_7 = cursor.getInt(_cursorIndexOfContentComplete);
                  _tmpContentComplete = _tmp_7 != 0;
                  _tmpScoreProgress.setContentComplete(_tmpContentComplete);
                  final byte _tmpSuccess;
                  _tmpSuccess = (byte) cursor.getShort(_cursorIndexOfSuccess);
                  _tmpScoreProgress.setSuccess(_tmpSuccess);
                  final int _tmpTotalCompletedContent;
                  _tmpTotalCompletedContent = cursor.getInt(_cursorIndexOfTotalCompletedContent);
                  _tmpScoreProgress.setTotalCompletedContent(_tmpTotalCompletedContent);
                  final int _tmpTotalContent;
                  _tmpTotalContent = cursor.getInt(_cursorIndexOfTotalContent);
                  _tmpScoreProgress.setTotalContent(_tmpTotalContent);
                  final int _tmpPenalty;
                  _tmpPenalty = cursor.getInt(_cursorIndexOfPenalty);
                  _tmpScoreProgress.setPenalty(_tmpPenalty);
                }  else  {
                  _tmpScoreProgress = null;
                }
                _tmpEntry = new ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer();
                final long _tmpContentEntryUid;
                _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
                _tmpEntry.setContentEntryUid(_tmpContentEntryUid);
                final String _tmpTitle;
                if (cursor.isNull(_cursorIndexOfTitle)) {
                  _tmpTitle = null;
                } else {
                  _tmpTitle = cursor.getString(_cursorIndexOfTitle);
                }
                _tmpEntry.setTitle(_tmpTitle);
                final String _tmpDescription;
                if (cursor.isNull(_cursorIndexOfDescription)) {
                  _tmpDescription = null;
                } else {
                  _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                }
                _tmpEntry.setDescription(_tmpDescription);
                final String _tmpEntryId;
                if (cursor.isNull(_cursorIndexOfEntryId)) {
                  _tmpEntryId = null;
                } else {
                  _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
                }
                _tmpEntry.setEntryId(_tmpEntryId);
                final String _tmpAuthor;
                if (cursor.isNull(_cursorIndexOfAuthor)) {
                  _tmpAuthor = null;
                } else {
                  _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
                }
                _tmpEntry.setAuthor(_tmpAuthor);
                final String _tmpPublisher;
                if (cursor.isNull(_cursorIndexOfPublisher)) {
                  _tmpPublisher = null;
                } else {
                  _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
                }
                _tmpEntry.setPublisher(_tmpPublisher);
                final int _tmpLicenseType;
                _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
                _tmpEntry.setLicenseType(_tmpLicenseType);
                final String _tmpLicenseName;
                if (cursor.isNull(_cursorIndexOfLicenseName)) {
                  _tmpLicenseName = null;
                } else {
                  _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
                }
                _tmpEntry.setLicenseName(_tmpLicenseName);
                final String _tmpLicenseUrl;
                if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
                  _tmpLicenseUrl = null;
                } else {
                  _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
                }
                _tmpEntry.setLicenseUrl(_tmpLicenseUrl);
                final String _tmpSourceUrl;
                if (cursor.isNull(_cursorIndexOfSourceUrl)) {
                  _tmpSourceUrl = null;
                } else {
                  _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
                }
                _tmpEntry.setSourceUrl(_tmpSourceUrl);
                final String _tmpThumbnailUrl;
                if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                  _tmpThumbnailUrl = null;
                } else {
                  _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
                }
                _tmpEntry.setThumbnailUrl(_tmpThumbnailUrl);
                final long _tmpLastModified;
                _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
                _tmpEntry.setLastModified(_tmpLastModified);
                final long _tmpPrimaryLanguageUid;
                _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                _tmpEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                final long _tmpLanguageVariantUid;
                _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
                _tmpEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                final int _tmpContentFlags;
                _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
                _tmpEntry.setContentFlags(_tmpContentFlags);
                final boolean _tmpLeaf;
                final int _tmp_8;
                _tmp_8 = cursor.getInt(_cursorIndexOfLeaf);
                _tmpLeaf = _tmp_8 != 0;
                _tmpEntry.setLeaf(_tmpLeaf);
                final boolean _tmpPublik;
                final int _tmp_9;
                _tmp_9 = cursor.getInt(_cursorIndexOfPublik);
                _tmpPublik = _tmp_9 != 0;
                _tmpEntry.setPublik(_tmpPublik);
                final boolean _tmpCeInactive;
                final int _tmp_10;
                _tmp_10 = cursor.getInt(_cursorIndexOfCeInactive);
                _tmpCeInactive = _tmp_10 != 0;
                _tmpEntry.setCeInactive(_tmpCeInactive);
                final int _tmpCompletionCriteria;
                _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
                _tmpEntry.setCompletionCriteria(_tmpCompletionCriteria);
                final int _tmpMinScore;
                _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
                _tmpEntry.setMinScore(_tmpMinScore);
                final int _tmpContentTypeFlag;
                _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
                _tmpEntry.setContentTypeFlag(_tmpContentTypeFlag);
                final long _tmpContentOwner;
                _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
                _tmpEntry.setContentOwner(_tmpContentOwner);
                final long _tmpContentEntryLocalChangeSeqNum;
                _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                _tmpEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                final long _tmpContentEntryMasterChangeSeqNum;
                _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                _tmpEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                final int _tmpContentEntryLastChangedBy;
                _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                _tmpEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                final long _tmpContentEntryLct;
                _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
                _tmpEntry.setContentEntryLct(_tmpContentEntryLct);
                final int _tmpAssignmentContentWeight;
                _tmpAssignmentContentWeight = cursor.getInt(_cursorIndexOfAssignmentContentWeight);
                _tmpEntry.setAssignmentContentWeight(_tmpAssignmentContentWeight);
                _tmpEntry.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
                _tmpEntry.setMostRecentContainer(_tmpMostRecentContainer);
                _tmpEntry.setScoreProgress(_tmpScoreProgress);
              }  else  {
                _tmpEntry = null;
              }
              final CourseDiscussion _tmpCourseDiscussion;
              if (! (cursor.isNull(_cursorIndexOfCourseDiscussionUid) && cursor.isNull(_cursorIndexOfCourseDiscussionTitle) && cursor.isNull(_cursorIndexOfCourseDiscussionDesc) && cursor.isNull(_cursorIndexOfCourseDiscussionClazzUid) && cursor.isNull(_cursorIndexOfCourseDiscussionActive) && cursor.isNull(_cursorIndexOfCourseDiscussionLct))) {
                _tmpCourseDiscussion = new CourseDiscussion();
                final long _tmpCourseDiscussionUid;
                _tmpCourseDiscussionUid = cursor.getLong(_cursorIndexOfCourseDiscussionUid);
                _tmpCourseDiscussion.setCourseDiscussionUid(_tmpCourseDiscussionUid);
                final String _tmpCourseDiscussionTitle;
                if (cursor.isNull(_cursorIndexOfCourseDiscussionTitle)) {
                  _tmpCourseDiscussionTitle = null;
                } else {
                  _tmpCourseDiscussionTitle = cursor.getString(_cursorIndexOfCourseDiscussionTitle);
                }
                _tmpCourseDiscussion.setCourseDiscussionTitle(_tmpCourseDiscussionTitle);
                final String _tmpCourseDiscussionDesc;
                if (cursor.isNull(_cursorIndexOfCourseDiscussionDesc)) {
                  _tmpCourseDiscussionDesc = null;
                } else {
                  _tmpCourseDiscussionDesc = cursor.getString(_cursorIndexOfCourseDiscussionDesc);
                }
                _tmpCourseDiscussion.setCourseDiscussionDesc(_tmpCourseDiscussionDesc);
                final long _tmpCourseDiscussionClazzUid;
                _tmpCourseDiscussionClazzUid = cursor.getLong(_cursorIndexOfCourseDiscussionClazzUid);
                _tmpCourseDiscussion.setCourseDiscussionClazzUid(_tmpCourseDiscussionClazzUid);
                final boolean _tmpCourseDiscussionActive;
                final int _tmp_11;
                _tmp_11 = cursor.getInt(_cursorIndexOfCourseDiscussionActive);
                _tmpCourseDiscussionActive = _tmp_11 != 0;
                _tmpCourseDiscussion.setCourseDiscussionActive(_tmpCourseDiscussionActive);
                final long _tmpCourseDiscussionLct;
                _tmpCourseDiscussionLct = cursor.getLong(_cursorIndexOfCourseDiscussionLct);
                _tmpCourseDiscussion.setCourseDiscussionLct(_tmpCourseDiscussionLct);
              }  else  {
                _tmpCourseDiscussion = null;
              }
              _item_2 = new CourseBlockWithCompleteEntity();
              final long _tmpCbUid;
              _tmpCbUid = cursor.getLong(_cursorIndexOfCbUid);
              _item_2.setCbUid(_tmpCbUid);
              final int _tmpCbType;
              _tmpCbType = cursor.getInt(_cursorIndexOfCbType);
              _item_2.setCbType(_tmpCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = cursor.getInt(_cursorIndexOfCbIndentLevel);
              _item_2.setCbIndentLevel(_tmpCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              _item_2.setCbModuleParentBlockUid(_tmpCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = cursor.getString(_cursorIndexOfCbTitle);
              }
              _item_2.setCbTitle(_tmpCbTitle);
              final String _tmpCbDescription;
              if (cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = cursor.getString(_cursorIndexOfCbDescription);
              }
              _item_2.setCbDescription(_tmpCbDescription);
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              _item_2.setCbCompletionCriteria(_tmpCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = cursor.getLong(_cursorIndexOfCbHideUntilDate);
              _item_2.setCbHideUntilDate(_tmpCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = cursor.getLong(_cursorIndexOfCbDeadlineDate);
              _item_2.setCbDeadlineDate(_tmpCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              _item_2.setCbLateSubmissionPenalty(_tmpCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              _item_2.setCbGracePeriodDate(_tmpCbGracePeriodDate);
              final int _tmpCbMaxPoints;
              _tmpCbMaxPoints = cursor.getInt(_cursorIndexOfCbMaxPoints);
              _item_2.setCbMaxPoints(_tmpCbMaxPoints);
              final int _tmpCbMinPoints;
              _tmpCbMinPoints = cursor.getInt(_cursorIndexOfCbMinPoints);
              _item_2.setCbMinPoints(_tmpCbMinPoints);
              final int _tmpCbIndex;
              _tmpCbIndex = cursor.getInt(_cursorIndexOfCbIndex);
              _item_2.setCbIndex(_tmpCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = cursor.getLong(_cursorIndexOfCbClazzUid);
              _item_2.setCbClazzUid(_tmpCbClazzUid);
              final boolean _tmpCbActive;
              final int _tmp_12;
              _tmp_12 = cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp_12 != 0;
              _item_2.setCbActive(_tmpCbActive);
              final boolean _tmpCbHidden;
              final int _tmp_13;
              _tmp_13 = cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_13 != 0;
              _item_2.setCbHidden(_tmpCbHidden);
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = cursor.getLong(_cursorIndexOfCbEntityUid);
              _item_2.setCbEntityUid(_tmpCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = cursor.getLong(_cursorIndexOfCbLct);
              _item_2.setCbLct(_tmpCbLct);
              final boolean _tmpExpanded;
              final int _tmp_14;
              _tmp_14 = cursor.getInt(_cursorIndexOfExpanded);
              _tmpExpanded = _tmp_14 != 0;
              _item_2.setExpanded(_tmpExpanded);
              _item_2.setAssignment(_tmpAssignment);
              _item_2.setEntry(_tmpEntry);
              _item_2.setCourseDiscussion(_tmpCourseDiscussion);
              _res.add(_item_2);
            }
            return _res;
          }
        };
      }
    };
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
