package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseDiscussion;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseDiscussionDao_Impl extends CourseDiscussionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseDiscussion> __insertionAdapterOfCourseDiscussion;

  private final EntityInsertionAdapter<CourseDiscussion> __insertionAdapterOfCourseDiscussion_1;

  private final EntityDeletionOrUpdateAdapter<CourseDiscussion> __updateAdapterOfCourseDiscussion;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public CourseDiscussionDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseDiscussion = new EntityInsertionAdapter<CourseDiscussion>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `CourseDiscussion` (`courseDiscussionUid`,`courseDiscussionTitle`,`courseDiscussionDesc`,`courseDiscussionClazzUid`,`courseDiscussionActive`,`courseDiscussionLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseDiscussion value) {
        stmt.bindLong(1, value.getCourseDiscussionUid());
        if (value.getCourseDiscussionTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCourseDiscussionTitle());
        }
        if (value.getCourseDiscussionDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCourseDiscussionDesc());
        }
        stmt.bindLong(4, value.getCourseDiscussionClazzUid());
        final int _tmp = value.getCourseDiscussionActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getCourseDiscussionLct());
      }
    };
    this.__insertionAdapterOfCourseDiscussion_1 = new EntityInsertionAdapter<CourseDiscussion>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `CourseDiscussion` (`courseDiscussionUid`,`courseDiscussionTitle`,`courseDiscussionDesc`,`courseDiscussionClazzUid`,`courseDiscussionActive`,`courseDiscussionLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseDiscussion value) {
        stmt.bindLong(1, value.getCourseDiscussionUid());
        if (value.getCourseDiscussionTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCourseDiscussionTitle());
        }
        if (value.getCourseDiscussionDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCourseDiscussionDesc());
        }
        stmt.bindLong(4, value.getCourseDiscussionClazzUid());
        final int _tmp = value.getCourseDiscussionActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getCourseDiscussionLct());
      }
    };
    this.__updateAdapterOfCourseDiscussion = new EntityDeletionOrUpdateAdapter<CourseDiscussion>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `CourseDiscussion` SET `courseDiscussionUid` = ?,`courseDiscussionTitle` = ?,`courseDiscussionDesc` = ?,`courseDiscussionClazzUid` = ?,`courseDiscussionActive` = ?,`courseDiscussionLct` = ? WHERE `courseDiscussionUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseDiscussion value) {
        stmt.bindLong(1, value.getCourseDiscussionUid());
        if (value.getCourseDiscussionTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCourseDiscussionTitle());
        }
        if (value.getCourseDiscussionDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCourseDiscussionDesc());
        }
        stmt.bindLong(4, value.getCourseDiscussionClazzUid());
        final int _tmp = value.getCourseDiscussionActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getCourseDiscussionLct());
        stmt.bindLong(7, value.getCourseDiscussionUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CourseDiscussionReplicate(courseDiscussionPk, courseDiscussionDestination)\n"
                + "      SELECT DISTINCT CourseDiscussion.courseDiscussionUid AS courseDiscussionPk,\n"
                + "             ? AS courseDiscussionDestination\n"
                + "             \n"
                + "       FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2 \n"
                + "                  \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "                  \n"
                + "             JOIN CourseDiscussion \n"
                + "                  ON CourseDiscussion.courseDiscussionClazzUid = Clazz.clazzUid\n"
                + "                  \n"
                + "       WHERE CourseDiscussion.courseDiscussionLct != COALESCE(\n"
                + "             (SELECT courseDiscussionVersionId\n"
                + "                FROM courseDiscussionReplicate\n"
                + "               WHERE courseDiscussionPk = CourseDiscussion.courseDiscussionUid\n"
                + "                 AND courseDiscussionDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(courseDiscussionPk, courseDiscussionDestination) DO UPDATE\n"
                + "             SET courseDiscussionPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO CourseDiscussionReplicate(courseDiscussionPk, courseDiscussionDestination)\n"
                + "          SELECT DISTINCT CourseDiscussion.courseDiscussionUid AS courseDiscussionUid,\n"
                + "                 UserSession.usClientNodeId AS courseDiscussionDestination\n"
                + "            FROM ChangeLog\n"
                + "                 JOIN CourseDiscussion\n"
                + "                     ON ChangeLog.chTableId = 130\n"
                + "                        AND ChangeLog.chEntityPk = CourseDiscussion.courseDiscussionUid\n"
                + "                 JOIN Clazz\n"
                + "                      ON Clazz.clazzUid = CourseDiscussion.courseDiscussionClazzUid\n"
                + "                 \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2\n"
                + "                 \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "                 \n"
                + "           WHERE UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "             AND CourseDiscussion.courseDiscussionLct != COALESCE(\n"
                + "                 (SELECT courseDiscussionVersionId\n"
                + "                    FROM courseDiscussionReplicate\n"
                + "                   WHERE courseDiscussionPk = CourseDiscussion.courseDiscussionUid\n"
                + "                     AND courseDiscussionDestination = UserSession.usClientNodeId), 0)\n"
                + "         /*psql ON CONFLICT(courseDiscussionPk, courseDiscussionDestination) DO UPDATE\n"
                + "             SET courseDiscussionPending = true\n"
                + "          */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CourseDiscussion \n"
                + "           SET courseDiscussionActive = ?, \n"
                + "               courseDiscussionLct = ?\n"
                + "         WHERE courseDiscussionUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseDiscussion entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfCourseDiscussion.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseDiscussion entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfCourseDiscussion.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends CourseDiscussion> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseDiscussion.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends CourseDiscussion> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseDiscussion.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replaceListAsync(final List<? extends CourseDiscussion> list,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseDiscussion_1.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends CourseDiscussion> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseDiscussion.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CourseDiscussion entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseDiscussion.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends CourseDiscussion> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfCourseDiscussion.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cbUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<CourseDiscussion> getCourseDiscussionByUid(final long courseDiscussionUid) {
    final String _sql = "\n"
            + "        SELECT CourseDiscussion.* \n"
            + "          FROM CourseDiscussion\n"
            + "         WHERE CourseDiscussion.courseDiscussionUid = ? \n"
            + "           AND CAST(CourseDiscussion.courseDiscussionActive AS INTEGER) = 1 \n"
            + "         \n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, courseDiscussionUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"CourseDiscussion"}, false, new Callable<CourseDiscussion>() {
      @Override
      public CourseDiscussion call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCourseDiscussionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionUid");
          final int _cursorIndexOfCourseDiscussionTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionTitle");
          final int _cursorIndexOfCourseDiscussionDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionDesc");
          final int _cursorIndexOfCourseDiscussionClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionClazzUid");
          final int _cursorIndexOfCourseDiscussionActive = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionActive");
          final int _cursorIndexOfCourseDiscussionLct = CursorUtil.getColumnIndexOrThrow(_cursor, "courseDiscussionLct");
          final CourseDiscussion _result;
          if(_cursor.moveToFirst()) {
            _result = new CourseDiscussion();
            final long _tmpCourseDiscussionUid;
            _tmpCourseDiscussionUid = _cursor.getLong(_cursorIndexOfCourseDiscussionUid);
            _result.setCourseDiscussionUid(_tmpCourseDiscussionUid);
            final String _tmpCourseDiscussionTitle;
            if (_cursor.isNull(_cursorIndexOfCourseDiscussionTitle)) {
              _tmpCourseDiscussionTitle = null;
            } else {
              _tmpCourseDiscussionTitle = _cursor.getString(_cursorIndexOfCourseDiscussionTitle);
            }
            _result.setCourseDiscussionTitle(_tmpCourseDiscussionTitle);
            final String _tmpCourseDiscussionDesc;
            if (_cursor.isNull(_cursorIndexOfCourseDiscussionDesc)) {
              _tmpCourseDiscussionDesc = null;
            } else {
              _tmpCourseDiscussionDesc = _cursor.getString(_cursorIndexOfCourseDiscussionDesc);
            }
            _result.setCourseDiscussionDesc(_tmpCourseDiscussionDesc);
            final long _tmpCourseDiscussionClazzUid;
            _tmpCourseDiscussionClazzUid = _cursor.getLong(_cursorIndexOfCourseDiscussionClazzUid);
            _result.setCourseDiscussionClazzUid(_tmpCourseDiscussionClazzUid);
            final boolean _tmpCourseDiscussionActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCourseDiscussionActive);
            _tmpCourseDiscussionActive = _tmp != 0;
            _result.setCourseDiscussionActive(_tmpCourseDiscussionActive);
            final long _tmpCourseDiscussionLct;
            _tmpCourseDiscussionLct = _cursor.getLong(_cursorIndexOfCourseDiscussionLct);
            _result.setCourseDiscussionLct(_tmpCourseDiscussionLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
