package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CoursePicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CoursePictureDao_Impl extends CoursePictureDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CoursePicture> __insertionAdapterOfCoursePicture;

  private final EntityDeletionOrUpdateAdapter<CoursePicture> __updateAdapterOfCoursePicture;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public CoursePictureDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCoursePicture = new EntityInsertionAdapter<CoursePicture>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `CoursePicture` (`coursePictureUid`,`coursePictureClazzUid`,`coursePictureMasterCsn`,`coursePictureLocalCsn`,`coursePictureLastChangedBy`,`coursePictureLct`,`coursePictureUri`,`coursePictureMd5`,`coursePictureFileSize`,`coursePictureTimestamp`,`coursePictureMimeType`,`coursePictureActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CoursePicture value) {
        stmt.bindLong(1, value.getCoursePictureUid());
        stmt.bindLong(2, value.getCoursePictureClazzUid());
        stmt.bindLong(3, value.getCoursePictureMasterCsn());
        stmt.bindLong(4, value.getCoursePictureLocalCsn());
        stmt.bindLong(5, value.getCoursePictureLastChangedBy());
        stmt.bindLong(6, value.getCoursePictureLct());
        if (value.getCoursePictureUri() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getCoursePictureUri());
        }
        if (value.getCoursePictureMd5() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getCoursePictureMd5());
        }
        stmt.bindLong(9, value.getCoursePictureFileSize());
        stmt.bindLong(10, value.getCoursePictureTimestamp());
        if (value.getCoursePictureMimeType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getCoursePictureMimeType());
        }
        final int _tmp = value.getCoursePictureActive() ? 1 : 0;
        stmt.bindLong(12, _tmp);
      }
    };
    this.__updateAdapterOfCoursePicture = new EntityDeletionOrUpdateAdapter<CoursePicture>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `CoursePicture` SET `coursePictureUid` = ?,`coursePictureClazzUid` = ?,`coursePictureMasterCsn` = ?,`coursePictureLocalCsn` = ?,`coursePictureLastChangedBy` = ?,`coursePictureLct` = ?,`coursePictureUri` = ?,`coursePictureMd5` = ?,`coursePictureFileSize` = ?,`coursePictureTimestamp` = ?,`coursePictureMimeType` = ?,`coursePictureActive` = ? WHERE `coursePictureUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CoursePicture value) {
        stmt.bindLong(1, value.getCoursePictureUid());
        stmt.bindLong(2, value.getCoursePictureClazzUid());
        stmt.bindLong(3, value.getCoursePictureMasterCsn());
        stmt.bindLong(4, value.getCoursePictureLocalCsn());
        stmt.bindLong(5, value.getCoursePictureLastChangedBy());
        stmt.bindLong(6, value.getCoursePictureLct());
        if (value.getCoursePictureUri() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getCoursePictureUri());
        }
        if (value.getCoursePictureMd5() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getCoursePictureMd5());
        }
        stmt.bindLong(9, value.getCoursePictureFileSize());
        stmt.bindLong(10, value.getCoursePictureTimestamp());
        if (value.getCoursePictureMimeType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getCoursePictureMimeType());
        }
        final int _tmp = value.getCoursePictureActive() ? 1 : 0;
        stmt.bindLong(12, _tmp);
        stmt.bindLong(13, value.getCoursePictureUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)\n"
                + "      SELECT DISTINCT CoursePicture.coursePictureUid AS cpPk,\n"
                + "             ? AS cpDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "                 \n"
                + "              \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "                 \n"
                + "             JOIN CoursePicture\n"
                + "                  ON CoursePicture.coursePictureClazzUid = Clazz.clazzUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND CoursePicture.coursePictureLct != COALESCE(\n"
                + "             (SELECT cpVersionId\n"
                + "                FROM CoursePictureReplicate\n"
                + "               WHERE cpPk = CoursePicture.coursePictureUid\n"
                + "                 AND cpDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE\n"
                + "             SET cpPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)\n"
                + "  SELECT DISTINCT CoursePicture.coursePictureUid AS cpUid,\n"
                + "         UserSession.usClientNodeId AS cpDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN CoursePicture\n"
                + "              ON ChangeLog.chTableId = 125\n"
                + "                 AND ChangeLog.chEntityPk = CoursePicture.coursePictureUid\n"
                + "        JOIN Clazz \n"
                + "            ON CoursePicture.coursePictureClazzUid = Clazz.clazzUid\n"
                + "  \n"
                + "        \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2 \n"
                + "                    \n"
                + "           \n"
                + "        \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "        \n"
                + " \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND CoursePicture.coursePictureLct != COALESCE(\n"
                + "         (SELECT cpVersionId\n"
                + "            FROM CoursePictureReplicate\n"
                + "           WHERE cpPk = CoursePicture.coursePictureUid\n"
                + "             AND cpDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE\n"
                + "     SET cpPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CoursePicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfCoursePicture.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CoursePicture entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfCoursePicture.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends CoursePicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCoursePicture.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends CoursePicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCoursePicture.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CoursePicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCoursePicture.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final CoursePicture coursePicture,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfCoursePicture.handle(coursePicture);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByClazzUidAsync(final long clazzUid,
      final Continuation<? super CoursePicture> continuation) {
    final String _sql = "SELECT * FROM CoursePicture \n"
            + "        WHERE coursePictureClazzUid = ?\n"
            + "        AND CAST(coursePictureActive AS INTEGER) = 1\n"
            + "        ORDER BY coursePictureTimestamp DESC LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CoursePicture>() {
      @Override
      public CoursePicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUid");
          final int _cursorIndexOfCoursePictureClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureClazzUid");
          final int _cursorIndexOfCoursePictureMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureMasterCsn");
          final int _cursorIndexOfCoursePictureLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLocalCsn");
          final int _cursorIndexOfCoursePictureLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLastChangedBy");
          final int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLct");
          final int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUri");
          final int _cursorIndexOfCoursePictureMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureMd5");
          final int _cursorIndexOfCoursePictureFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureFileSize");
          final int _cursorIndexOfCoursePictureTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureTimestamp");
          final int _cursorIndexOfCoursePictureMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureMimeType");
          final int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureActive");
          final CoursePicture _result;
          if(_cursor.moveToFirst()) {
            _result = new CoursePicture();
            final long _tmpCoursePictureUid;
            _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
            _result.setCoursePictureUid(_tmpCoursePictureUid);
            final long _tmpCoursePictureClazzUid;
            _tmpCoursePictureClazzUid = _cursor.getLong(_cursorIndexOfCoursePictureClazzUid);
            _result.setCoursePictureClazzUid(_tmpCoursePictureClazzUid);
            final long _tmpCoursePictureMasterCsn;
            _tmpCoursePictureMasterCsn = _cursor.getLong(_cursorIndexOfCoursePictureMasterCsn);
            _result.setCoursePictureMasterCsn(_tmpCoursePictureMasterCsn);
            final long _tmpCoursePictureLocalCsn;
            _tmpCoursePictureLocalCsn = _cursor.getLong(_cursorIndexOfCoursePictureLocalCsn);
            _result.setCoursePictureLocalCsn(_tmpCoursePictureLocalCsn);
            final int _tmpCoursePictureLastChangedBy;
            _tmpCoursePictureLastChangedBy = _cursor.getInt(_cursorIndexOfCoursePictureLastChangedBy);
            _result.setCoursePictureLastChangedBy(_tmpCoursePictureLastChangedBy);
            final long _tmpCoursePictureLct;
            _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
            _result.setCoursePictureLct(_tmpCoursePictureLct);
            final String _tmpCoursePictureUri;
            if (_cursor.isNull(_cursorIndexOfCoursePictureUri)) {
              _tmpCoursePictureUri = null;
            } else {
              _tmpCoursePictureUri = _cursor.getString(_cursorIndexOfCoursePictureUri);
            }
            _result.setCoursePictureUri(_tmpCoursePictureUri);
            final String _tmpCoursePictureMd5;
            if (_cursor.isNull(_cursorIndexOfCoursePictureMd5)) {
              _tmpCoursePictureMd5 = null;
            } else {
              _tmpCoursePictureMd5 = _cursor.getString(_cursorIndexOfCoursePictureMd5);
            }
            _result.setCoursePictureMd5(_tmpCoursePictureMd5);
            final int _tmpCoursePictureFileSize;
            _tmpCoursePictureFileSize = _cursor.getInt(_cursorIndexOfCoursePictureFileSize);
            _result.setCoursePictureFileSize(_tmpCoursePictureFileSize);
            final long _tmpCoursePictureTimestamp;
            _tmpCoursePictureTimestamp = _cursor.getLong(_cursorIndexOfCoursePictureTimestamp);
            _result.setCoursePictureTimestamp(_tmpCoursePictureTimestamp);
            final String _tmpCoursePictureMimeType;
            if (_cursor.isNull(_cursorIndexOfCoursePictureMimeType)) {
              _tmpCoursePictureMimeType = null;
            } else {
              _tmpCoursePictureMimeType = _cursor.getString(_cursorIndexOfCoursePictureMimeType);
            }
            _result.setCoursePictureMimeType(_tmpCoursePictureMimeType);
            final boolean _tmpCoursePictureActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCoursePictureActive);
            _tmpCoursePictureActive = _tmp != 0;
            _result.setCoursePictureActive(_tmpCoursePictureActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<CoursePicture> findByClazzUidLive(final long clazzUid) {
    final String _sql = "SELECT * FROM CoursePicture where coursePictureClazzUid = ? ORDER BY  coursePictureTimestamp DESC LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"CoursePicture"}, false, new Callable<CoursePicture>() {
      @Override
      public CoursePicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUid");
          final int _cursorIndexOfCoursePictureClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureClazzUid");
          final int _cursorIndexOfCoursePictureMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureMasterCsn");
          final int _cursorIndexOfCoursePictureLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLocalCsn");
          final int _cursorIndexOfCoursePictureLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLastChangedBy");
          final int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLct");
          final int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUri");
          final int _cursorIndexOfCoursePictureMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureMd5");
          final int _cursorIndexOfCoursePictureFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureFileSize");
          final int _cursorIndexOfCoursePictureTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureTimestamp");
          final int _cursorIndexOfCoursePictureMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureMimeType");
          final int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureActive");
          final CoursePicture _result;
          if(_cursor.moveToFirst()) {
            _result = new CoursePicture();
            final long _tmpCoursePictureUid;
            _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
            _result.setCoursePictureUid(_tmpCoursePictureUid);
            final long _tmpCoursePictureClazzUid;
            _tmpCoursePictureClazzUid = _cursor.getLong(_cursorIndexOfCoursePictureClazzUid);
            _result.setCoursePictureClazzUid(_tmpCoursePictureClazzUid);
            final long _tmpCoursePictureMasterCsn;
            _tmpCoursePictureMasterCsn = _cursor.getLong(_cursorIndexOfCoursePictureMasterCsn);
            _result.setCoursePictureMasterCsn(_tmpCoursePictureMasterCsn);
            final long _tmpCoursePictureLocalCsn;
            _tmpCoursePictureLocalCsn = _cursor.getLong(_cursorIndexOfCoursePictureLocalCsn);
            _result.setCoursePictureLocalCsn(_tmpCoursePictureLocalCsn);
            final int _tmpCoursePictureLastChangedBy;
            _tmpCoursePictureLastChangedBy = _cursor.getInt(_cursorIndexOfCoursePictureLastChangedBy);
            _result.setCoursePictureLastChangedBy(_tmpCoursePictureLastChangedBy);
            final long _tmpCoursePictureLct;
            _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
            _result.setCoursePictureLct(_tmpCoursePictureLct);
            final String _tmpCoursePictureUri;
            if (_cursor.isNull(_cursorIndexOfCoursePictureUri)) {
              _tmpCoursePictureUri = null;
            } else {
              _tmpCoursePictureUri = _cursor.getString(_cursorIndexOfCoursePictureUri);
            }
            _result.setCoursePictureUri(_tmpCoursePictureUri);
            final String _tmpCoursePictureMd5;
            if (_cursor.isNull(_cursorIndexOfCoursePictureMd5)) {
              _tmpCoursePictureMd5 = null;
            } else {
              _tmpCoursePictureMd5 = _cursor.getString(_cursorIndexOfCoursePictureMd5);
            }
            _result.setCoursePictureMd5(_tmpCoursePictureMd5);
            final int _tmpCoursePictureFileSize;
            _tmpCoursePictureFileSize = _cursor.getInt(_cursorIndexOfCoursePictureFileSize);
            _result.setCoursePictureFileSize(_tmpCoursePictureFileSize);
            final long _tmpCoursePictureTimestamp;
            _tmpCoursePictureTimestamp = _cursor.getLong(_cursorIndexOfCoursePictureTimestamp);
            _result.setCoursePictureTimestamp(_tmpCoursePictureTimestamp);
            final String _tmpCoursePictureMimeType;
            if (_cursor.isNull(_cursorIndexOfCoursePictureMimeType)) {
              _tmpCoursePictureMimeType = null;
            } else {
              _tmpCoursePictureMimeType = _cursor.getString(_cursorIndexOfCoursePictureMimeType);
            }
            _result.setCoursePictureMimeType(_tmpCoursePictureMimeType);
            final boolean _tmpCoursePictureActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCoursePictureActive);
            _tmpCoursePictureActive = _tmp != 0;
            _result.setCoursePictureActive(_tmpCoursePictureActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
