package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.DiscussionTopic;
import com.ustadmobile.lib.db.entities.DiscussionTopicListDetail;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class DiscussionTopicDao_Impl extends DiscussionTopicDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<DiscussionTopic> __insertionAdapterOfDiscussionTopic;

  private final EntityInsertionAdapter<DiscussionTopic> __insertionAdapterOfDiscussionTopic_1;

  private final EntityDeletionOrUpdateAdapter<DiscussionTopic> __updateAdapterOfDiscussionTopic;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public DiscussionTopicDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfDiscussionTopic = new EntityInsertionAdapter<DiscussionTopic>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `DiscussionTopic` (`discussionTopicUid`,`discussionTopicTitle`,`discussionTopicDesc`,`discussionTopicStartDate`,`discussionTopicCourseDiscussionUid`,`discussionTopicVisible`,`discussionTopicArchive`,`discussionTopicIndex`,`discussionTopicClazzUid`,`discussionTopicLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, DiscussionTopic value) {
        stmt.bindLong(1, value.getDiscussionTopicUid());
        if (value.getDiscussionTopicTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getDiscussionTopicTitle());
        }
        if (value.getDiscussionTopicDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDiscussionTopicDesc());
        }
        stmt.bindLong(4, value.getDiscussionTopicStartDate());
        stmt.bindLong(5, value.getDiscussionTopicCourseDiscussionUid());
        final int _tmp = value.getDiscussionTopicVisible() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        final int _tmp_1 = value.getDiscussionTopicArchive() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getDiscussionTopicIndex());
        stmt.bindLong(9, value.getDiscussionTopicClazzUid());
        stmt.bindLong(10, value.getDiscussionTopicLct());
      }
    };
    this.__insertionAdapterOfDiscussionTopic_1 = new EntityInsertionAdapter<DiscussionTopic>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `DiscussionTopic` (`discussionTopicUid`,`discussionTopicTitle`,`discussionTopicDesc`,`discussionTopicStartDate`,`discussionTopicCourseDiscussionUid`,`discussionTopicVisible`,`discussionTopicArchive`,`discussionTopicIndex`,`discussionTopicClazzUid`,`discussionTopicLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, DiscussionTopic value) {
        stmt.bindLong(1, value.getDiscussionTopicUid());
        if (value.getDiscussionTopicTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getDiscussionTopicTitle());
        }
        if (value.getDiscussionTopicDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDiscussionTopicDesc());
        }
        stmt.bindLong(4, value.getDiscussionTopicStartDate());
        stmt.bindLong(5, value.getDiscussionTopicCourseDiscussionUid());
        final int _tmp = value.getDiscussionTopicVisible() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        final int _tmp_1 = value.getDiscussionTopicArchive() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getDiscussionTopicIndex());
        stmt.bindLong(9, value.getDiscussionTopicClazzUid());
        stmt.bindLong(10, value.getDiscussionTopicLct());
      }
    };
    this.__updateAdapterOfDiscussionTopic = new EntityDeletionOrUpdateAdapter<DiscussionTopic>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `DiscussionTopic` SET `discussionTopicUid` = ?,`discussionTopicTitle` = ?,`discussionTopicDesc` = ?,`discussionTopicStartDate` = ?,`discussionTopicCourseDiscussionUid` = ?,`discussionTopicVisible` = ?,`discussionTopicArchive` = ?,`discussionTopicIndex` = ?,`discussionTopicClazzUid` = ?,`discussionTopicLct` = ? WHERE `discussionTopicUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, DiscussionTopic value) {
        stmt.bindLong(1, value.getDiscussionTopicUid());
        if (value.getDiscussionTopicTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getDiscussionTopicTitle());
        }
        if (value.getDiscussionTopicDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDiscussionTopicDesc());
        }
        stmt.bindLong(4, value.getDiscussionTopicStartDate());
        stmt.bindLong(5, value.getDiscussionTopicCourseDiscussionUid());
        final int _tmp = value.getDiscussionTopicVisible() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        final int _tmp_1 = value.getDiscussionTopicArchive() ? 1 : 0;
        stmt.bindLong(7, _tmp_1);
        stmt.bindLong(8, value.getDiscussionTopicIndex());
        stmt.bindLong(9, value.getDiscussionTopicClazzUid());
        stmt.bindLong(10, value.getDiscussionTopicLct());
        stmt.bindLong(11, value.getDiscussionTopicUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO DiscussionTopicReplicate(discussionTopicPk, discussionTopicDestination)\n"
                + "      SELECT DISTINCT DiscussionTopic.discussionTopicUid AS discussionTopicPk,\n"
                + "             ? AS discussionTopicDestination\n"
                + "             \n"
                + "       FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2 \n"
                + "                  \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "                  \n"
                + "             JOIN DiscussionTopic \n"
                + "                  ON DiscussionTopic.discussionTopicClazzUid = Clazz.clazzUid\n"
                + "                  \n"
                + "       WHERE DiscussionTopic.discussionTopicLct != COALESCE(\n"
                + "             (SELECT discussionTopicVersionId\n"
                + "                FROM discussionTopicReplicate\n"
                + "               WHERE discussionTopicPk = DiscussionTopic.discussionTopicUid\n"
                + "                 AND discussionTopicDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(discussionTopicPk, discussionTopicDestination) DO UPDATE\n"
                + "             SET discussionTopicPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO DiscussionTopicReplicate(discussionTopicPk, discussionTopicDestination)\n"
                + "          SELECT DISTINCT DiscussionTopic.discussionTopicUid AS discussionTopicUid,\n"
                + "                 UserSession.usClientNodeId AS discussionTopicDestination\n"
                + "            FROM ChangeLog\n"
                + "                 JOIN DiscussionTopic\n"
                + "                     ON ChangeLog.chTableId = 131\n"
                + "                        AND ChangeLog.chEntityPk = DiscussionTopic.discussionTopicUid\n"
                + "                        \n"
                + "                        \n"
                + "                 JOIN Clazz\n"
                + "                      ON Clazz.clazzUid = DiscussionTopic.discussionTopicClazzUid\n"
                + "                 \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2\n"
                + "                 \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "             \n"
                + "                 \n"
                + "           WHERE UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "             AND DiscussionTopic.discussionTopicLct != COALESCE(\n"
                + "                 (SELECT discussionTopicVersionId\n"
                + "                    FROM discussionTopicReplicate\n"
                + "                   WHERE discussionTopicPk = DiscussionTopic.discussionTopicUid\n"
                + "                     AND DiscussionTopicDestination = UserSession.usClientNodeId), 0)\n"
                + "         /*psql ON CONFLICT(discussionTopicPk, discussionTopicDestination) DO UPDATE\n"
                + "             SET discussionTopicPending = true\n"
                + "          */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE DiscussionTopic \n"
                + "           SET discussionTopicVisible = ?, \n"
                + "               discussionTopicLct = ?\n"
                + "         WHERE discussionTopicUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final DiscussionTopic entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfDiscussionTopic.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final DiscussionTopic entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfDiscussionTopic.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends DiscussionTopic> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfDiscussionTopic.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends DiscussionTopic> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfDiscussionTopic.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replaceListAsync(final List<? extends DiscussionTopic> list,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfDiscussionTopic_1.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends DiscussionTopic> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfDiscussionTopic.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final DiscussionTopic entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfDiscussionTopic.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends DiscussionTopic> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfDiscussionTopic.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateActiveByUid(final long uid, final boolean active, final long changeTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, uid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, DiscussionTopicListDetail> getListOfTopicsByDiscussion(
      final long discussionUid) {
    final String _sql = "\n"
            + "        SELECT DiscussionTopic.*,\n"
            + "                ( \n"
            + "                    SELECT COUNT(*) \n"
            + "                      FROM DiscussionPost \n"
            + "                     WHERE DiscussionPost.discussionPostDiscussionTopicUid = DiscussionTopic.discussionTopicUid\n"
            + "                ) as numPosts,\n"
            + "                (\n"
            + "                    0\n"
            + "                )as lastActiveTimestamp\n"
            + "          FROM DiscussionTopic     \n"
            + "         WHERE DiscussionTopic.discussionTopicCourseDiscussionUid = ? \n"
            + "           AND CAST(DiscussionTopic.discussionTopicVisible AS INTEGER) = 1\n"
            + "           AND CAST(DiscussionTopic.discussionTopicArchive AS INTEGER) = 0\n"
            + "      ORDER BY DiscussionTopic.discussionTopicIndex\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, discussionUid);
    return new DataSource.Factory<Integer, DiscussionTopicListDetail>() {
      @Override
      public LimitOffsetDataSource<DiscussionTopicListDetail> create() {
        return new LimitOffsetDataSource<DiscussionTopicListDetail>(__db, _statement, false, true , "DiscussionPost", "DiscussionTopic") {
          @Override
          protected List<DiscussionTopicListDetail> convertRows(Cursor cursor) {
            final int _cursorIndexOfDiscussionTopicUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicUid");
            final int _cursorIndexOfDiscussionTopicTitle = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicTitle");
            final int _cursorIndexOfDiscussionTopicDesc = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicDesc");
            final int _cursorIndexOfDiscussionTopicStartDate = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicStartDate");
            final int _cursorIndexOfDiscussionTopicCourseDiscussionUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicCourseDiscussionUid");
            final int _cursorIndexOfDiscussionTopicVisible = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicVisible");
            final int _cursorIndexOfDiscussionTopicArchive = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicArchive");
            final int _cursorIndexOfDiscussionTopicIndex = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicIndex");
            final int _cursorIndexOfDiscussionTopicClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicClazzUid");
            final int _cursorIndexOfDiscussionTopicLct = CursorUtil.getColumnIndexOrThrow(cursor, "discussionTopicLct");
            final int _cursorIndexOfNumPosts = CursorUtil.getColumnIndexOrThrow(cursor, "numPosts");
            final int _cursorIndexOfLastActiveTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "lastActiveTimestamp");
            final List<DiscussionTopicListDetail> _res = new ArrayList<DiscussionTopicListDetail>(cursor.getCount());
            while(cursor.moveToNext()) {
              final DiscussionTopicListDetail _item;
              _item = new DiscussionTopicListDetail();
              final long _tmpDiscussionTopicUid;
              _tmpDiscussionTopicUid = cursor.getLong(_cursorIndexOfDiscussionTopicUid);
              _item.setDiscussionTopicUid(_tmpDiscussionTopicUid);
              final String _tmpDiscussionTopicTitle;
              if (cursor.isNull(_cursorIndexOfDiscussionTopicTitle)) {
                _tmpDiscussionTopicTitle = null;
              } else {
                _tmpDiscussionTopicTitle = cursor.getString(_cursorIndexOfDiscussionTopicTitle);
              }
              _item.setDiscussionTopicTitle(_tmpDiscussionTopicTitle);
              final String _tmpDiscussionTopicDesc;
              if (cursor.isNull(_cursorIndexOfDiscussionTopicDesc)) {
                _tmpDiscussionTopicDesc = null;
              } else {
                _tmpDiscussionTopicDesc = cursor.getString(_cursorIndexOfDiscussionTopicDesc);
              }
              _item.setDiscussionTopicDesc(_tmpDiscussionTopicDesc);
              final long _tmpDiscussionTopicStartDate;
              _tmpDiscussionTopicStartDate = cursor.getLong(_cursorIndexOfDiscussionTopicStartDate);
              _item.setDiscussionTopicStartDate(_tmpDiscussionTopicStartDate);
              final long _tmpDiscussionTopicCourseDiscussionUid;
              _tmpDiscussionTopicCourseDiscussionUid = cursor.getLong(_cursorIndexOfDiscussionTopicCourseDiscussionUid);
              _item.setDiscussionTopicCourseDiscussionUid(_tmpDiscussionTopicCourseDiscussionUid);
              final boolean _tmpDiscussionTopicVisible;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfDiscussionTopicVisible);
              _tmpDiscussionTopicVisible = _tmp != 0;
              _item.setDiscussionTopicVisible(_tmpDiscussionTopicVisible);
              final boolean _tmpDiscussionTopicArchive;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfDiscussionTopicArchive);
              _tmpDiscussionTopicArchive = _tmp_1 != 0;
              _item.setDiscussionTopicArchive(_tmpDiscussionTopicArchive);
              final int _tmpDiscussionTopicIndex;
              _tmpDiscussionTopicIndex = cursor.getInt(_cursorIndexOfDiscussionTopicIndex);
              _item.setDiscussionTopicIndex(_tmpDiscussionTopicIndex);
              final long _tmpDiscussionTopicClazzUid;
              _tmpDiscussionTopicClazzUid = cursor.getLong(_cursorIndexOfDiscussionTopicClazzUid);
              _item.setDiscussionTopicClazzUid(_tmpDiscussionTopicClazzUid);
              final long _tmpDiscussionTopicLct;
              _tmpDiscussionTopicLct = cursor.getLong(_cursorIndexOfDiscussionTopicLct);
              _item.setDiscussionTopicLct(_tmpDiscussionTopicLct);
              final int _tmpNumPosts;
              _tmpNumPosts = cursor.getInt(_cursorIndexOfNumPosts);
              _item.setNumPosts(_tmpNumPosts);
              final long _tmpLastActiveTimestamp;
              _tmpLastActiveTimestamp = cursor.getLong(_cursorIndexOfLastActiveTimestamp);
              _item.setLastActiveTimestamp(_tmpLastActiveTimestamp);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object getTopicsByClazz(final long clazzUid,
      final Continuation<? super List<? extends DiscussionTopic>> continuation) {
    final String _sql = "\n"
            + "        SELECT DiscussionTopic.*\n"
            + "          FROM DiscussionTopic\n"
            + "         WHERE DiscussionTopic.discussionTopicCourseDiscussionUid IN \n"
            + "                (SELECT CourseDiscussion.courseDiscussionUid \n"
            + "                   FROM CourseDiscussion\n"
            + "                  WHERE CourseDiscussion.courseDiscussionClazzUid = ? ) \n"
            + "          AND CAST(DiscussionTopic.discussionTopicVisible AS INTEGER) = 1\n"
            + "          AND CAST(DiscussionTopic.discussionTopicArchive AS INTEGER)  = 0\n"
            + "                        \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<DiscussionTopic>>() {
      @Override
      public List<DiscussionTopic> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDiscussionTopicUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicUid");
          final int _cursorIndexOfDiscussionTopicTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicTitle");
          final int _cursorIndexOfDiscussionTopicDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicDesc");
          final int _cursorIndexOfDiscussionTopicStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicStartDate");
          final int _cursorIndexOfDiscussionTopicCourseDiscussionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicCourseDiscussionUid");
          final int _cursorIndexOfDiscussionTopicVisible = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicVisible");
          final int _cursorIndexOfDiscussionTopicArchive = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicArchive");
          final int _cursorIndexOfDiscussionTopicIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicIndex");
          final int _cursorIndexOfDiscussionTopicClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicClazzUid");
          final int _cursorIndexOfDiscussionTopicLct = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicLct");
          final List<DiscussionTopic> _result = new ArrayList<DiscussionTopic>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final DiscussionTopic _item;
            _item = new DiscussionTopic();
            final long _tmpDiscussionTopicUid;
            _tmpDiscussionTopicUid = _cursor.getLong(_cursorIndexOfDiscussionTopicUid);
            _item.setDiscussionTopicUid(_tmpDiscussionTopicUid);
            final String _tmpDiscussionTopicTitle;
            if (_cursor.isNull(_cursorIndexOfDiscussionTopicTitle)) {
              _tmpDiscussionTopicTitle = null;
            } else {
              _tmpDiscussionTopicTitle = _cursor.getString(_cursorIndexOfDiscussionTopicTitle);
            }
            _item.setDiscussionTopicTitle(_tmpDiscussionTopicTitle);
            final String _tmpDiscussionTopicDesc;
            if (_cursor.isNull(_cursorIndexOfDiscussionTopicDesc)) {
              _tmpDiscussionTopicDesc = null;
            } else {
              _tmpDiscussionTopicDesc = _cursor.getString(_cursorIndexOfDiscussionTopicDesc);
            }
            _item.setDiscussionTopicDesc(_tmpDiscussionTopicDesc);
            final long _tmpDiscussionTopicStartDate;
            _tmpDiscussionTopicStartDate = _cursor.getLong(_cursorIndexOfDiscussionTopicStartDate);
            _item.setDiscussionTopicStartDate(_tmpDiscussionTopicStartDate);
            final long _tmpDiscussionTopicCourseDiscussionUid;
            _tmpDiscussionTopicCourseDiscussionUid = _cursor.getLong(_cursorIndexOfDiscussionTopicCourseDiscussionUid);
            _item.setDiscussionTopicCourseDiscussionUid(_tmpDiscussionTopicCourseDiscussionUid);
            final boolean _tmpDiscussionTopicVisible;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDiscussionTopicVisible);
            _tmpDiscussionTopicVisible = _tmp != 0;
            _item.setDiscussionTopicVisible(_tmpDiscussionTopicVisible);
            final boolean _tmpDiscussionTopicArchive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionTopicArchive);
            _tmpDiscussionTopicArchive = _tmp_1 != 0;
            _item.setDiscussionTopicArchive(_tmpDiscussionTopicArchive);
            final int _tmpDiscussionTopicIndex;
            _tmpDiscussionTopicIndex = _cursor.getInt(_cursorIndexOfDiscussionTopicIndex);
            _item.setDiscussionTopicIndex(_tmpDiscussionTopicIndex);
            final long _tmpDiscussionTopicClazzUid;
            _tmpDiscussionTopicClazzUid = _cursor.getLong(_cursorIndexOfDiscussionTopicClazzUid);
            _item.setDiscussionTopicClazzUid(_tmpDiscussionTopicClazzUid);
            final long _tmpDiscussionTopicLct;
            _tmpDiscussionTopicLct = _cursor.getLong(_cursorIndexOfDiscussionTopicLct);
            _item.setDiscussionTopicLct(_tmpDiscussionTopicLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<DiscussionTopic> getDiscussionTopicByUid(final long discussionTopicUid) {
    final String _sql = "\n"
            + "        SELECT DiscussionTopic.*\n"
            + "          FROM DiscussionTopic\n"
            + "         WHERE DiscussionTopic.discussionTopicUid = ?\n"
            + "         \n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, discussionTopicUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"DiscussionTopic"}, false, new Callable<DiscussionTopic>() {
      @Override
      public DiscussionTopic call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDiscussionTopicUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicUid");
          final int _cursorIndexOfDiscussionTopicTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicTitle");
          final int _cursorIndexOfDiscussionTopicDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicDesc");
          final int _cursorIndexOfDiscussionTopicStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicStartDate");
          final int _cursorIndexOfDiscussionTopicCourseDiscussionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicCourseDiscussionUid");
          final int _cursorIndexOfDiscussionTopicVisible = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicVisible");
          final int _cursorIndexOfDiscussionTopicArchive = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicArchive");
          final int _cursorIndexOfDiscussionTopicIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicIndex");
          final int _cursorIndexOfDiscussionTopicClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicClazzUid");
          final int _cursorIndexOfDiscussionTopicLct = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionTopicLct");
          final DiscussionTopic _result;
          if(_cursor.moveToFirst()) {
            _result = new DiscussionTopic();
            final long _tmpDiscussionTopicUid;
            _tmpDiscussionTopicUid = _cursor.getLong(_cursorIndexOfDiscussionTopicUid);
            _result.setDiscussionTopicUid(_tmpDiscussionTopicUid);
            final String _tmpDiscussionTopicTitle;
            if (_cursor.isNull(_cursorIndexOfDiscussionTopicTitle)) {
              _tmpDiscussionTopicTitle = null;
            } else {
              _tmpDiscussionTopicTitle = _cursor.getString(_cursorIndexOfDiscussionTopicTitle);
            }
            _result.setDiscussionTopicTitle(_tmpDiscussionTopicTitle);
            final String _tmpDiscussionTopicDesc;
            if (_cursor.isNull(_cursorIndexOfDiscussionTopicDesc)) {
              _tmpDiscussionTopicDesc = null;
            } else {
              _tmpDiscussionTopicDesc = _cursor.getString(_cursorIndexOfDiscussionTopicDesc);
            }
            _result.setDiscussionTopicDesc(_tmpDiscussionTopicDesc);
            final long _tmpDiscussionTopicStartDate;
            _tmpDiscussionTopicStartDate = _cursor.getLong(_cursorIndexOfDiscussionTopicStartDate);
            _result.setDiscussionTopicStartDate(_tmpDiscussionTopicStartDate);
            final long _tmpDiscussionTopicCourseDiscussionUid;
            _tmpDiscussionTopicCourseDiscussionUid = _cursor.getLong(_cursorIndexOfDiscussionTopicCourseDiscussionUid);
            _result.setDiscussionTopicCourseDiscussionUid(_tmpDiscussionTopicCourseDiscussionUid);
            final boolean _tmpDiscussionTopicVisible;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDiscussionTopicVisible);
            _tmpDiscussionTopicVisible = _tmp != 0;
            _result.setDiscussionTopicVisible(_tmpDiscussionTopicVisible);
            final boolean _tmpDiscussionTopicArchive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionTopicArchive);
            _tmpDiscussionTopicArchive = _tmp_1 != 0;
            _result.setDiscussionTopicArchive(_tmpDiscussionTopicArchive);
            final int _tmpDiscussionTopicIndex;
            _tmpDiscussionTopicIndex = _cursor.getInt(_cursorIndexOfDiscussionTopicIndex);
            _result.setDiscussionTopicIndex(_tmpDiscussionTopicIndex);
            final long _tmpDiscussionTopicClazzUid;
            _tmpDiscussionTopicClazzUid = _cursor.getLong(_cursorIndexOfDiscussionTopicClazzUid);
            _result.setDiscussionTopicClazzUid(_tmpDiscussionTopicClazzUid);
            final long _tmpDiscussionTopicLct;
            _tmpDiscussionTopicLct = _cursor.getLong(_cursorIndexOfDiscussionTopicLct);
            _result.setDiscussionTopicLct(_tmpDiscussionTopicLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
