package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.HolidayCalendar;
import com.ustadmobile.lib.db.entities.HolidayCalendarWithNumEntries;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class HolidayCalendarDao_Impl extends HolidayCalendarDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<HolidayCalendar> __insertionAdapterOfHolidayCalendar;

  private final EntityInsertionAdapter<HolidayCalendar> __insertionAdapterOfHolidayCalendar_1;

  private final EntityDeletionOrUpdateAdapter<HolidayCalendar> __updateAdapterOfHolidayCalendar;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public HolidayCalendarDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfHolidayCalendar = new EntityInsertionAdapter<HolidayCalendar>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `HolidayCalendar` (`umCalendarUid`,`umCalendarName`,`umCalendarCategory`,`umCalendarActive`,`umCalendarMasterChangeSeqNum`,`umCalendarLocalChangeSeqNum`,`umCalendarLastChangedBy`,`umCalendarLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, HolidayCalendar value) {
        stmt.bindLong(1, value.getUmCalendarUid());
        if (value.getUmCalendarName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUmCalendarName());
        }
        stmt.bindLong(3, value.getUmCalendarCategory());
        final int _tmp = value.getUmCalendarActive() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getUmCalendarMasterChangeSeqNum());
        stmt.bindLong(6, value.getUmCalendarLocalChangeSeqNum());
        stmt.bindLong(7, value.getUmCalendarLastChangedBy());
        stmt.bindLong(8, value.getUmCalendarLct());
      }
    };
    this.__insertionAdapterOfHolidayCalendar_1 = new EntityInsertionAdapter<HolidayCalendar>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `HolidayCalendar` (`umCalendarUid`,`umCalendarName`,`umCalendarCategory`,`umCalendarActive`,`umCalendarMasterChangeSeqNum`,`umCalendarLocalChangeSeqNum`,`umCalendarLastChangedBy`,`umCalendarLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, HolidayCalendar value) {
        stmt.bindLong(1, value.getUmCalendarUid());
        if (value.getUmCalendarName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUmCalendarName());
        }
        stmt.bindLong(3, value.getUmCalendarCategory());
        final int _tmp = value.getUmCalendarActive() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getUmCalendarMasterChangeSeqNum());
        stmt.bindLong(6, value.getUmCalendarLocalChangeSeqNum());
        stmt.bindLong(7, value.getUmCalendarLastChangedBy());
        stmt.bindLong(8, value.getUmCalendarLct());
      }
    };
    this.__updateAdapterOfHolidayCalendar = new EntityDeletionOrUpdateAdapter<HolidayCalendar>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `HolidayCalendar` SET `umCalendarUid` = ?,`umCalendarName` = ?,`umCalendarCategory` = ?,`umCalendarActive` = ?,`umCalendarMasterChangeSeqNum` = ?,`umCalendarLocalChangeSeqNum` = ?,`umCalendarLastChangedBy` = ?,`umCalendarLct` = ? WHERE `umCalendarUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, HolidayCalendar value) {
        stmt.bindLong(1, value.getUmCalendarUid());
        if (value.getUmCalendarName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getUmCalendarName());
        }
        stmt.bindLong(3, value.getUmCalendarCategory());
        final int _tmp = value.getUmCalendarActive() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getUmCalendarMasterChangeSeqNum());
        stmt.bindLong(6, value.getUmCalendarLocalChangeSeqNum());
        stmt.bindLong(7, value.getUmCalendarLastChangedBy());
        stmt.bindLong(8, value.getUmCalendarLct());
        stmt.bindLong(9, value.getUmCalendarUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO HolidayCalendarReplicate(hcPk, hcDestination)\n"
                + "      SELECT DISTINCT HolidayCalendar.umCalendarUid AS hcPk,\n"
                + "             ? AS hcDestination\n"
                + "        FROM HolidayCalendar\n"
                + "             JOIN UserSession\n"
                + "                  ON UserSession.usClientNodeId = ?\n"
                + "        --notpsql \n"
                + "       WHERE HolidayCalendar.umCalendarLct != COALESCE(\n"
                + "             (SELECT hcVersionId\n"
                + "                FROM HolidayCalendarReplicate\n"
                + "               WHERE hcPk = HolidayCalendar.umCalendarUid\n"
                + "                 AND hcDestination = UserSession.usClientNodeId), 0) \n"
                + "         --endnotpsql        \n"
                + "      /*psql ON CONFLICT(hcPk, hcDestination) DO UPDATE\n"
                + "             SET hcPending = (SELECT HolidayCalendar.umCalendarLct\n"
                + "                                FROM HolidayCalendar\n"
                + "                               WHERE HolidayCalendar.umCalendarUid = EXCLUDED.hcPk ) \n"
                + "                                     != HolidayCalendarReplicate.hcPk\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO HolidayCalendarReplicate(hcPk, hcDestination)\n"
                + "  SELECT DISTINCT HolidayCalendar.umCalendarUid AS hcUid,\n"
                + "         UserSession.usClientNodeId AS hcDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN HolidayCalendar\n"
                + "             ON ChangeLog.chTableId = 28\n"
                + "                AND ChangeLog.chEntityPk = HolidayCalendar.umCalendarUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     --notpsql \n"
                + "      AND HolidayCalendar.umCalendarLct != COALESCE(\n"
                + "             (SELECT hcVersionId\n"
                + "                FROM HolidayCalendarReplicate\n"
                + "               WHERE hcPk = HolidayCalendar.umCalendarUid\n"
                + "                 AND hcDestination = UserSession.usClientNodeId), 0) \n"
                + "         --endnotpsql    \n"
                + "   /*psql ON CONFLICT(hcPk, hcDestination) DO UPDATE\n"
                + "             SET hcPending = (SELECT HolidayCalendar.umCalendarLct\n"
                + "                                FROM HolidayCalendar\n"
                + "                               WHERE HolidayCalendar.umCalendarUid = EXCLUDED.hcPk ) \n"
                + "                                     != HolidayCalendarReplicate.hcPk     \n"
                + "        */                                           \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final HolidayCalendar entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfHolidayCalendar.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final HolidayCalendar entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfHolidayCalendar.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends HolidayCalendar> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfHolidayCalendar.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void replaceList(final List<? extends HolidayCalendar> list) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfHolidayCalendar_1.insert(list);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends HolidayCalendar> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfHolidayCalendar.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final HolidayCalendar entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfHolidayCalendar.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final HolidayCalendar entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfHolidayCalendar.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, HolidayCalendarWithNumEntries> findAllHolidaysWithEntriesCount(
      ) {
    final String _sql = "SELECT HolidayCalendar.* ,\n"
            + "            (SELECT COUNT(*) FROM Holiday \n"
            + "               WHERE holHolidayCalendarUid = HolidayCalendar.umCalendarUid \n"
            + "               AND CAST(holActive AS INTEGER) = 1) AS numEntries \n"
            + "             FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND \n"
            + "             umCalendarCategory = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new DataSource.Factory<Integer, HolidayCalendarWithNumEntries>() {
      @Override
      public LimitOffsetDataSource<HolidayCalendarWithNumEntries> create() {
        return new LimitOffsetDataSource<HolidayCalendarWithNumEntries>(__db, _statement, false, true , "Holiday", "HolidayCalendar") {
          @Override
          protected List<HolidayCalendarWithNumEntries> convertRows(Cursor cursor) {
            final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarUid");
            final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarName");
            final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarCategory");
            final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarActive");
            final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarMasterChangeSeqNum");
            final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarLocalChangeSeqNum");
            final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarLastChangedBy");
            final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarLct");
            final int _cursorIndexOfNumEntries = CursorUtil.getColumnIndexOrThrow(cursor, "numEntries");
            final List<HolidayCalendarWithNumEntries> _res = new ArrayList<HolidayCalendarWithNumEntries>(cursor.getCount());
            while(cursor.moveToNext()) {
              final HolidayCalendarWithNumEntries _item;
              _item = new HolidayCalendarWithNumEntries();
              final long _tmpUmCalendarUid;
              _tmpUmCalendarUid = cursor.getLong(_cursorIndexOfUmCalendarUid);
              _item.setUmCalendarUid(_tmpUmCalendarUid);
              final String _tmpUmCalendarName;
              if (cursor.isNull(_cursorIndexOfUmCalendarName)) {
                _tmpUmCalendarName = null;
              } else {
                _tmpUmCalendarName = cursor.getString(_cursorIndexOfUmCalendarName);
              }
              _item.setUmCalendarName(_tmpUmCalendarName);
              final int _tmpUmCalendarCategory;
              _tmpUmCalendarCategory = cursor.getInt(_cursorIndexOfUmCalendarCategory);
              _item.setUmCalendarCategory(_tmpUmCalendarCategory);
              final boolean _tmpUmCalendarActive;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfUmCalendarActive);
              _tmpUmCalendarActive = _tmp != 0;
              _item.setUmCalendarActive(_tmpUmCalendarActive);
              final long _tmpUmCalendarMasterChangeSeqNum;
              _tmpUmCalendarMasterChangeSeqNum = cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
              _item.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
              final long _tmpUmCalendarLocalChangeSeqNum;
              _tmpUmCalendarLocalChangeSeqNum = cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
              _item.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
              final int _tmpUmCalendarLastChangedBy;
              _tmpUmCalendarLastChangedBy = cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
              _item.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
              final long _tmpUmCalendarLct;
              _tmpUmCalendarLct = cursor.getLong(_cursorIndexOfUmCalendarLct);
              _item.setUmCalendarLct(_tmpUmCalendarLct);
              final int _tmpNumEntries;
              _tmpNumEntries = cursor.getInt(_cursorIndexOfNumEntries);
              _item.setNumEntries(_tmpNumEntries);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public LiveData<List<HolidayCalendar>> findAllHolidaysLiveData() {
    final String _sql = "SELECT * FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND umCalendarCategory = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[]{"HolidayCalendar"}, false, new Callable<List<HolidayCalendar>>() {
      @Override
      public List<HolidayCalendar> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final List<HolidayCalendar> _result = new ArrayList<HolidayCalendar>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final HolidayCalendar _item;
            _item = new HolidayCalendar();
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _item.setUmCalendarUid(_tmpUmCalendarUid);
            final String _tmpUmCalendarName;
            if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
              _tmpUmCalendarName = null;
            } else {
              _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
            }
            _item.setUmCalendarName(_tmpUmCalendarName);
            final int _tmpUmCalendarCategory;
            _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
            _item.setUmCalendarCategory(_tmpUmCalendarCategory);
            final boolean _tmpUmCalendarActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
            _tmpUmCalendarActive = _tmp != 0;
            _item.setUmCalendarActive(_tmpUmCalendarActive);
            final long _tmpUmCalendarMasterChangeSeqNum;
            _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
            _item.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
            final long _tmpUmCalendarLocalChangeSeqNum;
            _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
            _item.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
            final int _tmpUmCalendarLastChangedBy;
            _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
            _item.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
            final long _tmpUmCalendarLct;
            _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
            _item.setUmCalendarLct(_tmpUmCalendarLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<HolidayCalendar> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = ? AND CAST(umCalendarActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"HolidayCalendar"}, false, new Callable<HolidayCalendar>() {
      @Override
      public HolidayCalendar call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final HolidayCalendar _result;
          if(_cursor.moveToFirst()) {
            _result = new HolidayCalendar();
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _result.setUmCalendarUid(_tmpUmCalendarUid);
            final String _tmpUmCalendarName;
            if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
              _tmpUmCalendarName = null;
            } else {
              _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
            }
            _result.setUmCalendarName(_tmpUmCalendarName);
            final int _tmpUmCalendarCategory;
            _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
            _result.setUmCalendarCategory(_tmpUmCalendarCategory);
            final boolean _tmpUmCalendarActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
            _tmpUmCalendarActive = _tmp != 0;
            _result.setUmCalendarActive(_tmpUmCalendarActive);
            final long _tmpUmCalendarMasterChangeSeqNum;
            _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
            _result.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
            final long _tmpUmCalendarLocalChangeSeqNum;
            _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
            _result.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
            final int _tmpUmCalendarLastChangedBy;
            _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
            _result.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
            final long _tmpUmCalendarLct;
            _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
            _result.setUmCalendarLct(_tmpUmCalendarLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByUid(final long uid,
      final Continuation<? super HolidayCalendar> continuation) {
    final String _sql = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<HolidayCalendar>() {
      @Override
      public HolidayCalendar call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final HolidayCalendar _result;
          if(_cursor.moveToFirst()) {
            _result = new HolidayCalendar();
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _result.setUmCalendarUid(_tmpUmCalendarUid);
            final String _tmpUmCalendarName;
            if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
              _tmpUmCalendarName = null;
            } else {
              _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
            }
            _result.setUmCalendarName(_tmpUmCalendarName);
            final int _tmpUmCalendarCategory;
            _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
            _result.setUmCalendarCategory(_tmpUmCalendarCategory);
            final boolean _tmpUmCalendarActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
            _tmpUmCalendarActive = _tmp != 0;
            _result.setUmCalendarActive(_tmpUmCalendarActive);
            final long _tmpUmCalendarMasterChangeSeqNum;
            _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
            _result.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
            final long _tmpUmCalendarLocalChangeSeqNum;
            _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
            _result.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
            final int _tmpUmCalendarLastChangedBy;
            _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
            _result.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
            final long _tmpUmCalendarLct;
            _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
            _result.setUmCalendarLct(_tmpUmCalendarLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super HolidayCalendar> continuation) {
    final String _sql = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<HolidayCalendar>() {
      @Override
      public HolidayCalendar call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final HolidayCalendar _result;
          if(_cursor.moveToFirst()) {
            _result = new HolidayCalendar();
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _result.setUmCalendarUid(_tmpUmCalendarUid);
            final String _tmpUmCalendarName;
            if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
              _tmpUmCalendarName = null;
            } else {
              _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
            }
            _result.setUmCalendarName(_tmpUmCalendarName);
            final int _tmpUmCalendarCategory;
            _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
            _result.setUmCalendarCategory(_tmpUmCalendarCategory);
            final boolean _tmpUmCalendarActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
            _tmpUmCalendarActive = _tmp != 0;
            _result.setUmCalendarActive(_tmpUmCalendarActive);
            final long _tmpUmCalendarMasterChangeSeqNum;
            _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
            _result.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
            final long _tmpUmCalendarLocalChangeSeqNum;
            _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
            _result.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
            final int _tmpUmCalendarLastChangedBy;
            _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
            _result.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
            final long _tmpUmCalendarLct;
            _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
            _result.setUmCalendarLct(_tmpUmCalendarLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
