package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Holiday;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class HolidayDao_Impl extends HolidayDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Holiday> __insertionAdapterOfHoliday;

  private final EntityDeletionOrUpdateAdapter<Holiday> __updateAdapterOfHoliday;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public HolidayDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfHoliday = new EntityInsertionAdapter<Holiday>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Holiday` (`holUid`,`holMasterCsn`,`holLocalCsn`,`holLastModBy`,`holLct`,`holActive`,`holHolidayCalendarUid`,`holStartTime`,`holEndTime`,`holName`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Holiday value) {
        stmt.bindLong(1, value.getHolUid());
        stmt.bindLong(2, value.getHolMasterCsn());
        stmt.bindLong(3, value.getHolLocalCsn());
        stmt.bindLong(4, value.getHolLastModBy());
        stmt.bindLong(5, value.getHolLct());
        final int _tmp = value.getHolActive() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        stmt.bindLong(7, value.getHolHolidayCalendarUid());
        stmt.bindLong(8, value.getHolStartTime());
        stmt.bindLong(9, value.getHolEndTime());
        if (value.getHolName() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getHolName());
        }
      }
    };
    this.__updateAdapterOfHoliday = new EntityDeletionOrUpdateAdapter<Holiday>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Holiday` SET `holUid` = ?,`holMasterCsn` = ?,`holLocalCsn` = ?,`holLastModBy` = ?,`holLct` = ?,`holActive` = ?,`holHolidayCalendarUid` = ?,`holStartTime` = ?,`holEndTime` = ?,`holName` = ? WHERE `holUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Holiday value) {
        stmt.bindLong(1, value.getHolUid());
        stmt.bindLong(2, value.getHolMasterCsn());
        stmt.bindLong(3, value.getHolLocalCsn());
        stmt.bindLong(4, value.getHolLastModBy());
        stmt.bindLong(5, value.getHolLct());
        final int _tmp = value.getHolActive() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        stmt.bindLong(7, value.getHolHolidayCalendarUid());
        stmt.bindLong(8, value.getHolStartTime());
        stmt.bindLong(9, value.getHolEndTime());
        if (value.getHolName() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getHolName());
        }
        stmt.bindLong(11, value.getHolUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO HolidayReplicate(holidayPk, holidayDestination)\n"
                + "      SELECT DISTINCT Holiday.holUid AS holidayPk,\n"
                + "             ? AS holidayDestination\n"
                + "        FROM Holiday\n"
                + "       WHERE Holiday.holLct != COALESCE(\n"
                + "             (SELECT holidayVersionId\n"
                + "                FROM HolidayReplicate\n"
                + "               WHERE holidayPk = Holiday.holUid\n"
                + "                 AND holidayDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(holidayPk, holidayDestination) DO UPDATE\n"
                + "             SET holidayPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO HolidayReplicate(holidayPk, holidayDestination)\n"
                + "  SELECT DISTINCT Holiday.holUid AS holidayUid,\n"
                + "         UserSession.usClientNodeId AS holidayDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN Holiday\n"
                + "             ON ChangeLog.chTableId = 99\n"
                + "                AND ChangeLog.chEntityPk = Holiday.holUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND Holiday.holLct != COALESCE(\n"
                + "         (SELECT holidayVersionId\n"
                + "            FROM HolidayReplicate\n"
                + "           WHERE holidayPk = Holiday.holUid\n"
                + "             AND holidayDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(holidayPk, holidayDestination) DO UPDATE\n"
                + "     SET holidayPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Holiday \n"
                + "           SET holActive = ?, \n"
                + "               holLct = ?\n"
                + "         WHERE holUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Holiday entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfHoliday.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Holiday entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfHoliday.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Holiday> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfHoliday.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends Holiday> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfHoliday.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAsync(final Holiday entity, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfHoliday.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends Holiday> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfHoliday.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Holiday entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfHoliday.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends Holiday> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfHoliday.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateActiveByUid(final long holidayUid, final boolean active,
      final long changeTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
    int _argIndex = 1;
    final int _tmp = active ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changeTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, holidayUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateActiveByUid.release(_stmt);
    }
  }

  @Override
  public List<Holiday> findByHolidayCalendaUid(final long holidayCalendarUid) {
    final String _sql = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, holidayCalendarUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfHolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holUid");
      final int _cursorIndexOfHolMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holMasterCsn");
      final int _cursorIndexOfHolLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holLocalCsn");
      final int _cursorIndexOfHolLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "holLastModBy");
      final int _cursorIndexOfHolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "holLct");
      final int _cursorIndexOfHolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "holActive");
      final int _cursorIndexOfHolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holHolidayCalendarUid");
      final int _cursorIndexOfHolStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holStartTime");
      final int _cursorIndexOfHolEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holEndTime");
      final int _cursorIndexOfHolName = CursorUtil.getColumnIndexOrThrow(_cursor, "holName");
      final List<Holiday> _result = new ArrayList<Holiday>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Holiday _item;
        _item = new Holiday();
        final long _tmpHolUid;
        _tmpHolUid = _cursor.getLong(_cursorIndexOfHolUid);
        _item.setHolUid(_tmpHolUid);
        final long _tmpHolMasterCsn;
        _tmpHolMasterCsn = _cursor.getLong(_cursorIndexOfHolMasterCsn);
        _item.setHolMasterCsn(_tmpHolMasterCsn);
        final long _tmpHolLocalCsn;
        _tmpHolLocalCsn = _cursor.getLong(_cursorIndexOfHolLocalCsn);
        _item.setHolLocalCsn(_tmpHolLocalCsn);
        final int _tmpHolLastModBy;
        _tmpHolLastModBy = _cursor.getInt(_cursorIndexOfHolLastModBy);
        _item.setHolLastModBy(_tmpHolLastModBy);
        final long _tmpHolLct;
        _tmpHolLct = _cursor.getLong(_cursorIndexOfHolLct);
        _item.setHolLct(_tmpHolLct);
        final boolean _tmpHolActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfHolActive);
        _tmpHolActive = _tmp != 0;
        _item.setHolActive(_tmpHolActive);
        final long _tmpHolHolidayCalendarUid;
        _tmpHolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfHolHolidayCalendarUid);
        _item.setHolHolidayCalendarUid(_tmpHolHolidayCalendarUid);
        final long _tmpHolStartTime;
        _tmpHolStartTime = _cursor.getLong(_cursorIndexOfHolStartTime);
        _item.setHolStartTime(_tmpHolStartTime);
        final long _tmpHolEndTime;
        _tmpHolEndTime = _cursor.getLong(_cursorIndexOfHolEndTime);
        _item.setHolEndTime(_tmpHolEndTime);
        final String _tmpHolName;
        if (_cursor.isNull(_cursorIndexOfHolName)) {
          _tmpHolName = null;
        } else {
          _tmpHolName = _cursor.getString(_cursorIndexOfHolName);
        }
        _item.setHolName(_tmpHolName);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByHolidayCalendaUidAsync(final long holidayCalendarUid,
      final Continuation<? super List<Holiday>> continuation) {
    final String _sql = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, holidayCalendarUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Holiday>>() {
      @Override
      public List<Holiday> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfHolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holUid");
          final int _cursorIndexOfHolMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holMasterCsn");
          final int _cursorIndexOfHolLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holLocalCsn");
          final int _cursorIndexOfHolLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "holLastModBy");
          final int _cursorIndexOfHolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "holLct");
          final int _cursorIndexOfHolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "holActive");
          final int _cursorIndexOfHolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holHolidayCalendarUid");
          final int _cursorIndexOfHolStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holStartTime");
          final int _cursorIndexOfHolEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holEndTime");
          final int _cursorIndexOfHolName = CursorUtil.getColumnIndexOrThrow(_cursor, "holName");
          final List<Holiday> _result = new ArrayList<Holiday>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Holiday _item;
            _item = new Holiday();
            final long _tmpHolUid;
            _tmpHolUid = _cursor.getLong(_cursorIndexOfHolUid);
            _item.setHolUid(_tmpHolUid);
            final long _tmpHolMasterCsn;
            _tmpHolMasterCsn = _cursor.getLong(_cursorIndexOfHolMasterCsn);
            _item.setHolMasterCsn(_tmpHolMasterCsn);
            final long _tmpHolLocalCsn;
            _tmpHolLocalCsn = _cursor.getLong(_cursorIndexOfHolLocalCsn);
            _item.setHolLocalCsn(_tmpHolLocalCsn);
            final int _tmpHolLastModBy;
            _tmpHolLastModBy = _cursor.getInt(_cursorIndexOfHolLastModBy);
            _item.setHolLastModBy(_tmpHolLastModBy);
            final long _tmpHolLct;
            _tmpHolLct = _cursor.getLong(_cursorIndexOfHolLct);
            _item.setHolLct(_tmpHolLct);
            final boolean _tmpHolActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfHolActive);
            _tmpHolActive = _tmp != 0;
            _item.setHolActive(_tmpHolActive);
            final long _tmpHolHolidayCalendarUid;
            _tmpHolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfHolHolidayCalendarUid);
            _item.setHolHolidayCalendarUid(_tmpHolHolidayCalendarUid);
            final long _tmpHolStartTime;
            _tmpHolStartTime = _cursor.getLong(_cursorIndexOfHolStartTime);
            _item.setHolStartTime(_tmpHolStartTime);
            final long _tmpHolEndTime;
            _tmpHolEndTime = _cursor.getLong(_cursorIndexOfHolEndTime);
            _item.setHolEndTime(_tmpHolEndTime);
            final String _tmpHolName;
            if (_cursor.isNull(_cursorIndexOfHolName)) {
              _tmpHolName = null;
            } else {
              _tmpHolName = _cursor.getString(_cursorIndexOfHolName);
            }
            _item.setHolName(_tmpHolName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
