package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntryStatementScoreProgress;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonWithAttemptsSummary;
import com.ustadmobile.lib.db.entities.PersonWithSessionsDisplay;
import com.ustadmobile.lib.db.entities.StatementEntity;
import com.ustadmobile.lib.db.entities.StatementEntityWithDisplayDetails;
import com.ustadmobile.lib.db.entities.StatementReportData;
import com.ustadmobile.lib.db.entities.StatementWithSessionDetailDisplay;
import com.ustadmobile.lib.db.entities.VerbEntity;
import com.ustadmobile.lib.db.entities.XLangMapEntry;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class StatementDao_Impl extends StatementDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StatementEntity> __insertionAdapterOfStatementEntity;

  private final EntityDeletionOrUpdateAdapter<StatementEntity> __updateAdapterOfStatementEntity;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateProgress;

  public StatementDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStatementEntity = new EntityInsertionAdapter<StatementEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `StatementEntity` (`statementUid`,`statementId`,`statementPersonUid`,`statementVerbUid`,`xObjectUid`,`subStatementActorUid`,`substatementVerbUid`,`subStatementObjectUid`,`agentUid`,`instructorUid`,`authorityUid`,`teamUid`,`resultCompletion`,`resultSuccess`,`resultScoreScaled`,`resultScoreRaw`,`resultScoreMin`,`resultScoreMax`,`resultDuration`,`resultResponse`,`timestamp`,`stored`,`contextRegistration`,`contextPlatform`,`contextStatementId`,`fullStatement`,`statementMasterChangeSeqNum`,`statementLocalChangeSeqNum`,`statementLastChangedBy`,`statementLct`,`extensionProgress`,`contentEntryRoot`,`statementContentEntryUid`,`statementLearnerGroupUid`,`statementClazzUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, StatementEntity value) {
        stmt.bindLong(1, value.getStatementUid());
        if (value.getStatementId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getStatementId());
        }
        stmt.bindLong(3, value.getStatementPersonUid());
        stmt.bindLong(4, value.getStatementVerbUid());
        stmt.bindLong(5, value.getXObjectUid());
        stmt.bindLong(6, value.getSubStatementActorUid());
        stmt.bindLong(7, value.getSubstatementVerbUid());
        stmt.bindLong(8, value.getSubStatementObjectUid());
        stmt.bindLong(9, value.getAgentUid());
        stmt.bindLong(10, value.getInstructorUid());
        stmt.bindLong(11, value.getAuthorityUid());
        stmt.bindLong(12, value.getTeamUid());
        final int _tmp = value.getResultCompletion() ? 1 : 0;
        stmt.bindLong(13, _tmp);
        stmt.bindLong(14, value.getResultSuccess());
        stmt.bindDouble(15, value.getResultScoreScaled());
        stmt.bindLong(16, value.getResultScoreRaw());
        stmt.bindLong(17, value.getResultScoreMin());
        stmt.bindLong(18, value.getResultScoreMax());
        stmt.bindLong(19, value.getResultDuration());
        if (value.getResultResponse() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindString(20, value.getResultResponse());
        }
        stmt.bindLong(21, value.getTimestamp());
        stmt.bindLong(22, value.getStored());
        if (value.getContextRegistration() == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindString(23, value.getContextRegistration());
        }
        if (value.getContextPlatform() == null) {
          stmt.bindNull(24);
        } else {
          stmt.bindString(24, value.getContextPlatform());
        }
        if (value.getContextStatementId() == null) {
          stmt.bindNull(25);
        } else {
          stmt.bindString(25, value.getContextStatementId());
        }
        if (value.getFullStatement() == null) {
          stmt.bindNull(26);
        } else {
          stmt.bindString(26, value.getFullStatement());
        }
        stmt.bindLong(27, value.getStatementMasterChangeSeqNum());
        stmt.bindLong(28, value.getStatementLocalChangeSeqNum());
        stmt.bindLong(29, value.getStatementLastChangedBy());
        stmt.bindLong(30, value.getStatementLct());
        stmt.bindLong(31, value.getExtensionProgress());
        final int _tmp_1 = value.getContentEntryRoot() ? 1 : 0;
        stmt.bindLong(32, _tmp_1);
        stmt.bindLong(33, value.getStatementContentEntryUid());
        stmt.bindLong(34, value.getStatementLearnerGroupUid());
        stmt.bindLong(35, value.getStatementClazzUid());
      }
    };
    this.__updateAdapterOfStatementEntity = new EntityDeletionOrUpdateAdapter<StatementEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `StatementEntity` SET `statementUid` = ?,`statementId` = ?,`statementPersonUid` = ?,`statementVerbUid` = ?,`xObjectUid` = ?,`subStatementActorUid` = ?,`substatementVerbUid` = ?,`subStatementObjectUid` = ?,`agentUid` = ?,`instructorUid` = ?,`authorityUid` = ?,`teamUid` = ?,`resultCompletion` = ?,`resultSuccess` = ?,`resultScoreScaled` = ?,`resultScoreRaw` = ?,`resultScoreMin` = ?,`resultScoreMax` = ?,`resultDuration` = ?,`resultResponse` = ?,`timestamp` = ?,`stored` = ?,`contextRegistration` = ?,`contextPlatform` = ?,`contextStatementId` = ?,`fullStatement` = ?,`statementMasterChangeSeqNum` = ?,`statementLocalChangeSeqNum` = ?,`statementLastChangedBy` = ?,`statementLct` = ?,`extensionProgress` = ?,`contentEntryRoot` = ?,`statementContentEntryUid` = ?,`statementLearnerGroupUid` = ?,`statementClazzUid` = ? WHERE `statementUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, StatementEntity value) {
        stmt.bindLong(1, value.getStatementUid());
        if (value.getStatementId() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getStatementId());
        }
        stmt.bindLong(3, value.getStatementPersonUid());
        stmt.bindLong(4, value.getStatementVerbUid());
        stmt.bindLong(5, value.getXObjectUid());
        stmt.bindLong(6, value.getSubStatementActorUid());
        stmt.bindLong(7, value.getSubstatementVerbUid());
        stmt.bindLong(8, value.getSubStatementObjectUid());
        stmt.bindLong(9, value.getAgentUid());
        stmt.bindLong(10, value.getInstructorUid());
        stmt.bindLong(11, value.getAuthorityUid());
        stmt.bindLong(12, value.getTeamUid());
        final int _tmp = value.getResultCompletion() ? 1 : 0;
        stmt.bindLong(13, _tmp);
        stmt.bindLong(14, value.getResultSuccess());
        stmt.bindDouble(15, value.getResultScoreScaled());
        stmt.bindLong(16, value.getResultScoreRaw());
        stmt.bindLong(17, value.getResultScoreMin());
        stmt.bindLong(18, value.getResultScoreMax());
        stmt.bindLong(19, value.getResultDuration());
        if (value.getResultResponse() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindString(20, value.getResultResponse());
        }
        stmt.bindLong(21, value.getTimestamp());
        stmt.bindLong(22, value.getStored());
        if (value.getContextRegistration() == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindString(23, value.getContextRegistration());
        }
        if (value.getContextPlatform() == null) {
          stmt.bindNull(24);
        } else {
          stmt.bindString(24, value.getContextPlatform());
        }
        if (value.getContextStatementId() == null) {
          stmt.bindNull(25);
        } else {
          stmt.bindString(25, value.getContextStatementId());
        }
        if (value.getFullStatement() == null) {
          stmt.bindNull(26);
        } else {
          stmt.bindString(26, value.getFullStatement());
        }
        stmt.bindLong(27, value.getStatementMasterChangeSeqNum());
        stmt.bindLong(28, value.getStatementLocalChangeSeqNum());
        stmt.bindLong(29, value.getStatementLastChangedBy());
        stmt.bindLong(30, value.getStatementLct());
        stmt.bindLong(31, value.getExtensionProgress());
        final int _tmp_1 = value.getContentEntryRoot() ? 1 : 0;
        stmt.bindLong(32, _tmp_1);
        stmt.bindLong(33, value.getStatementContentEntryUid());
        stmt.bindLong(34, value.getStatementLearnerGroupUid());
        stmt.bindLong(35, value.getStatementClazzUid());
        stmt.bindLong(36, value.getStatementUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO StatementEntityReplicate(sePk, seDestination)\n"
                + "      SELECT DISTINCT StatementEntity.statementUid AS sePk,\n"
                + "             ? AS seDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             JOIN ScopedGrant\n"
                + "                  ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                     AND (ScopedGrant.sgPermissions & 549755813888) > 0\n"
                + "             JOIN StatementEntity\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                AND ScopedGrant.sgEntityUid = -2)\n"
                + "             OR (ScopedGrant.sgTableId = 9\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n"
                + "             OR (ScopedGrant.sgTableId = 6\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n"
                + "             OR (ScopedGrant.sgTableId = 164\n"
                + "                AND ScopedGrant.sgEntityUid = (\n"
                + "                    SELECT clazzSchoolUid\n"
                + "                      FROM Clazz \n"
                + "                     WHERE clazzUid = StatementEntity.statementClazzUid))\n"
                + "            )         \n"
                + "        \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         -- Temporary measure to prevent admin user getting clogged up\n"
                + "         -- Restrict to the last 30 days of data\n"
                + "         AND StatementEntity.timestamp > ( \n"
                + "       --notpsql\n"
                + "       strftime('%s', 'now') * 1000\n"
                + "       --endnotpsql\n"
                + "       /*psql\n"
                + "       ROUND(EXTRACT(epoch from NOW())*1000)\n"
                + "       */\n"
                + "       - (30 * CAST(86400000 AS BIGINT)))\n"
                + "       --notpsql\n"
                + "         AND StatementEntity.statementLct != COALESCE(\n"
                + "             (SELECT seVersionId\n"
                + "                FROM StatementEntityReplicate\n"
                + "               WHERE sePk = StatementEntity.statementUid\n"
                + "                 AND seDestination = UserSession.usClientNodeId), 0)\n"
                + "       --endnotpsql           \n"
                + "      /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n"
                + "             SET sePending = (SELECT StatementEntity.statementLct\n"
                + "            FROM StatementEntity\n"
                + "           WHERE StatementEntity.statementUid = EXCLUDED.sePk ) \n"
                + "                 != StatementEntityReplicate.seVersionId\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO StatementEntityReplicate(sePk, seDestination)\n"
                + "  SELECT DISTINCT StatementEntity.statementUid AS seUid,\n"
                + "         UserSession.usClientNodeId AS seDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN StatementEntity\n"
                + "               ON ChangeLog.chTableId = 60\n"
                + "                  AND ChangeLog.chEntityPk = StatementEntity.statementUid\n"
                + "         JOIN ScopedGrant\n"
                + "              ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                AND ScopedGrant.sgEntityUid = -2)\n"
                + "             OR (ScopedGrant.sgTableId = 9\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n"
                + "             OR (ScopedGrant.sgTableId = 6\n"
                + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n"
                + "             OR (ScopedGrant.sgTableId = 164\n"
                + "                AND ScopedGrant.sgEntityUid = (\n"
                + "                    SELECT clazzSchoolUid\n"
                + "                      FROM Clazz\n"
                + "                     WHERE clazzUid = StatementEntity.statementClazzUid))\n"
                + "             )\n"
                + "        \n"
                + "                 AND (ScopedGrant.sgPermissions & 549755813888) > 0\n"
                + "         JOIN PersonGroupMember\n"
                + "              ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "         JOIN UserSession\n"
                + "              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "                 AND UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId\n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND StatementEntity.statementLct != COALESCE(\n"
                + "         (SELECT seVersionId\n"
                + "            FROM StatementEntityReplicate\n"
                + "           WHERE sePk = StatementEntity.statementUid\n"
                + "             AND seDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n"
                + "     SET sePending = true\n"
                + "  */\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateProgress = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE StatementEntity \n"
                + "           SET extensionProgress = ?,\n"
                + "               statementLct = ? \n"
                + "            WHERE statementUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final StatementEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfStatementEntity.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final StatementEntity entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfStatementEntity.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends StatementEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfStatementEntity.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends StatementEntity> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStatementEntity.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends StatementEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfStatementEntity.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final StatementEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfStatementEntity.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateProgress(final long uid, final int progress, final long updateTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateProgress.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, progress);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, updateTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, uid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateProgress.release(_stmt);
    }
  }

  @Override
  public LiveData<StatementEntity> getOneStatement() {
    final String _sql = "SELECT * From StatementEntity LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[]{"StatementEntity"}, false, new Callable<StatementEntity>() {
      @Override
      public StatementEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementUid");
          final int _cursorIndexOfStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "statementId");
          final int _cursorIndexOfStatementPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectUid");
          final int _cursorIndexOfSubStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementActorUid");
          final int _cursorIndexOfSubstatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "substatementVerbUid");
          final int _cursorIndexOfSubStatementObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementObjectUid");
          final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
          final int _cursorIndexOfInstructorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "instructorUid");
          final int _cursorIndexOfAuthorityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistration = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistration");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementId");
          final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "fullStatement");
          final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementMasterChangeSeqNum");
          final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLocalChangeSeqNum");
          final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLastChangedBy");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfContentEntryRoot = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryRoot");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final StatementEntity _result;
          if(_cursor.moveToFirst()) {
            _result = new StatementEntity();
            final long _tmpStatementUid;
            _tmpStatementUid = _cursor.getLong(_cursorIndexOfStatementUid);
            _result.setStatementUid(_tmpStatementUid);
            final String _tmpStatementId;
            if (_cursor.isNull(_cursorIndexOfStatementId)) {
              _tmpStatementId = null;
            } else {
              _tmpStatementId = _cursor.getString(_cursorIndexOfStatementId);
            }
            _result.setStatementId(_tmpStatementId);
            final long _tmpStatementPersonUid;
            _tmpStatementPersonUid = _cursor.getLong(_cursorIndexOfStatementPersonUid);
            _result.setStatementPersonUid(_tmpStatementPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            _result.setStatementVerbUid(_tmpStatementVerbUid);
            final long _tmpXObjectUid;
            _tmpXObjectUid = _cursor.getLong(_cursorIndexOfXObjectUid);
            _result.setXObjectUid(_tmpXObjectUid);
            final long _tmpSubStatementActorUid;
            _tmpSubStatementActorUid = _cursor.getLong(_cursorIndexOfSubStatementActorUid);
            _result.setSubStatementActorUid(_tmpSubStatementActorUid);
            final long _tmpSubstatementVerbUid;
            _tmpSubstatementVerbUid = _cursor.getLong(_cursorIndexOfSubstatementVerbUid);
            _result.setSubstatementVerbUid(_tmpSubstatementVerbUid);
            final long _tmpSubStatementObjectUid;
            _tmpSubStatementObjectUid = _cursor.getLong(_cursorIndexOfSubStatementObjectUid);
            _result.setSubStatementObjectUid(_tmpSubStatementObjectUid);
            final long _tmpAgentUid;
            _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
            _result.setAgentUid(_tmpAgentUid);
            final long _tmpInstructorUid;
            _tmpInstructorUid = _cursor.getLong(_cursorIndexOfInstructorUid);
            _result.setInstructorUid(_tmpInstructorUid);
            final long _tmpAuthorityUid;
            _tmpAuthorityUid = _cursor.getLong(_cursorIndexOfAuthorityUid);
            _result.setAuthorityUid(_tmpAuthorityUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            _result.setTeamUid(_tmpTeamUid);
            final boolean _tmpResultCompletion;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            _tmpResultCompletion = _tmp != 0;
            _result.setResultCompletion(_tmpResultCompletion);
            final byte _tmpResultSuccess;
            _tmpResultSuccess = (byte) _cursor.getShort(_cursorIndexOfResultSuccess);
            _result.setResultSuccess(_tmpResultSuccess);
            final float _tmpResultScoreScaled;
            _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            _result.setResultScoreScaled(_tmpResultScoreScaled);
            final long _tmpResultScoreRaw;
            _tmpResultScoreRaw = _cursor.getLong(_cursorIndexOfResultScoreRaw);
            _result.setResultScoreRaw(_tmpResultScoreRaw);
            final long _tmpResultScoreMin;
            _tmpResultScoreMin = _cursor.getLong(_cursorIndexOfResultScoreMin);
            _result.setResultScoreMin(_tmpResultScoreMin);
            final long _tmpResultScoreMax;
            _tmpResultScoreMax = _cursor.getLong(_cursorIndexOfResultScoreMax);
            _result.setResultScoreMax(_tmpResultScoreMax);
            final long _tmpResultDuration;
            _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            _result.setResultDuration(_tmpResultDuration);
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            _result.setResultResponse(_tmpResultResponse);
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            _result.setTimestamp(_tmpTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            _result.setStored(_tmpStored);
            final String _tmpContextRegistration;
            if (_cursor.isNull(_cursorIndexOfContextRegistration)) {
              _tmpContextRegistration = null;
            } else {
              _tmpContextRegistration = _cursor.getString(_cursorIndexOfContextRegistration);
            }
            _result.setContextRegistration(_tmpContextRegistration);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            _result.setContextPlatform(_tmpContextPlatform);
            final String _tmpContextStatementId;
            if (_cursor.isNull(_cursorIndexOfContextStatementId)) {
              _tmpContextStatementId = null;
            } else {
              _tmpContextStatementId = _cursor.getString(_cursorIndexOfContextStatementId);
            }
            _result.setContextStatementId(_tmpContextStatementId);
            final String _tmpFullStatement;
            if (_cursor.isNull(_cursorIndexOfFullStatement)) {
              _tmpFullStatement = null;
            } else {
              _tmpFullStatement = _cursor.getString(_cursorIndexOfFullStatement);
            }
            _result.setFullStatement(_tmpFullStatement);
            final long _tmpStatementMasterChangeSeqNum;
            _tmpStatementMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
            _result.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
            final long _tmpStatementLocalChangeSeqNum;
            _tmpStatementLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
            _result.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
            final int _tmpStatementLastChangedBy;
            _tmpStatementLastChangedBy = _cursor.getInt(_cursorIndexOfStatementLastChangedBy);
            _result.setStatementLastChangedBy(_tmpStatementLastChangedBy);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            _result.setStatementLct(_tmpStatementLct);
            final int _tmpExtensionProgress;
            _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            _result.setExtensionProgress(_tmpExtensionProgress);
            final boolean _tmpContentEntryRoot;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfContentEntryRoot);
            _tmpContentEntryRoot = _tmp_1 != 0;
            _result.setContentEntryRoot(_tmpContentEntryRoot);
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            _result.setStatementContentEntryUid(_tmpStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            _result.setStatementLearnerGroupUid(_tmpStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            _result.setStatementClazzUid(_tmpStatementClazzUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public StatementEntity findByStatementId(final String id) {
    final String _sql = "SELECT * FROM StatementEntity WHERE statementId = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfStatementUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementUid");
      final int _cursorIndexOfStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "statementId");
      final int _cursorIndexOfStatementPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementPersonUid");
      final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
      final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectUid");
      final int _cursorIndexOfSubStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementActorUid");
      final int _cursorIndexOfSubstatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "substatementVerbUid");
      final int _cursorIndexOfSubStatementObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementObjectUid");
      final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
      final int _cursorIndexOfInstructorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "instructorUid");
      final int _cursorIndexOfAuthorityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityUid");
      final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
      final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
      final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
      final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
      final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
      final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
      final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
      final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
      final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
      final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
      final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
      final int _cursorIndexOfContextRegistration = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistration");
      final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
      final int _cursorIndexOfContextStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementId");
      final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "fullStatement");
      final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementMasterChangeSeqNum");
      final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLocalChangeSeqNum");
      final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLastChangedBy");
      final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
      final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
      final int _cursorIndexOfContentEntryRoot = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryRoot");
      final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
      final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
      final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
      final StatementEntity _result;
      if(_cursor.moveToFirst()) {
        _result = new StatementEntity();
        final long _tmpStatementUid;
        _tmpStatementUid = _cursor.getLong(_cursorIndexOfStatementUid);
        _result.setStatementUid(_tmpStatementUid);
        final String _tmpStatementId;
        if (_cursor.isNull(_cursorIndexOfStatementId)) {
          _tmpStatementId = null;
        } else {
          _tmpStatementId = _cursor.getString(_cursorIndexOfStatementId);
        }
        _result.setStatementId(_tmpStatementId);
        final long _tmpStatementPersonUid;
        _tmpStatementPersonUid = _cursor.getLong(_cursorIndexOfStatementPersonUid);
        _result.setStatementPersonUid(_tmpStatementPersonUid);
        final long _tmpStatementVerbUid;
        _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
        _result.setStatementVerbUid(_tmpStatementVerbUid);
        final long _tmpXObjectUid;
        _tmpXObjectUid = _cursor.getLong(_cursorIndexOfXObjectUid);
        _result.setXObjectUid(_tmpXObjectUid);
        final long _tmpSubStatementActorUid;
        _tmpSubStatementActorUid = _cursor.getLong(_cursorIndexOfSubStatementActorUid);
        _result.setSubStatementActorUid(_tmpSubStatementActorUid);
        final long _tmpSubstatementVerbUid;
        _tmpSubstatementVerbUid = _cursor.getLong(_cursorIndexOfSubstatementVerbUid);
        _result.setSubstatementVerbUid(_tmpSubstatementVerbUid);
        final long _tmpSubStatementObjectUid;
        _tmpSubStatementObjectUid = _cursor.getLong(_cursorIndexOfSubStatementObjectUid);
        _result.setSubStatementObjectUid(_tmpSubStatementObjectUid);
        final long _tmpAgentUid;
        _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
        _result.setAgentUid(_tmpAgentUid);
        final long _tmpInstructorUid;
        _tmpInstructorUid = _cursor.getLong(_cursorIndexOfInstructorUid);
        _result.setInstructorUid(_tmpInstructorUid);
        final long _tmpAuthorityUid;
        _tmpAuthorityUid = _cursor.getLong(_cursorIndexOfAuthorityUid);
        _result.setAuthorityUid(_tmpAuthorityUid);
        final long _tmpTeamUid;
        _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
        _result.setTeamUid(_tmpTeamUid);
        final boolean _tmpResultCompletion;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
        _tmpResultCompletion = _tmp != 0;
        _result.setResultCompletion(_tmpResultCompletion);
        final byte _tmpResultSuccess;
        _tmpResultSuccess = (byte) _cursor.getShort(_cursorIndexOfResultSuccess);
        _result.setResultSuccess(_tmpResultSuccess);
        final float _tmpResultScoreScaled;
        _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
        _result.setResultScoreScaled(_tmpResultScoreScaled);
        final long _tmpResultScoreRaw;
        _tmpResultScoreRaw = _cursor.getLong(_cursorIndexOfResultScoreRaw);
        _result.setResultScoreRaw(_tmpResultScoreRaw);
        final long _tmpResultScoreMin;
        _tmpResultScoreMin = _cursor.getLong(_cursorIndexOfResultScoreMin);
        _result.setResultScoreMin(_tmpResultScoreMin);
        final long _tmpResultScoreMax;
        _tmpResultScoreMax = _cursor.getLong(_cursorIndexOfResultScoreMax);
        _result.setResultScoreMax(_tmpResultScoreMax);
        final long _tmpResultDuration;
        _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
        _result.setResultDuration(_tmpResultDuration);
        final String _tmpResultResponse;
        if (_cursor.isNull(_cursorIndexOfResultResponse)) {
          _tmpResultResponse = null;
        } else {
          _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
        }
        _result.setResultResponse(_tmpResultResponse);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _result.setTimestamp(_tmpTimestamp);
        final long _tmpStored;
        _tmpStored = _cursor.getLong(_cursorIndexOfStored);
        _result.setStored(_tmpStored);
        final String _tmpContextRegistration;
        if (_cursor.isNull(_cursorIndexOfContextRegistration)) {
          _tmpContextRegistration = null;
        } else {
          _tmpContextRegistration = _cursor.getString(_cursorIndexOfContextRegistration);
        }
        _result.setContextRegistration(_tmpContextRegistration);
        final String _tmpContextPlatform;
        if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
          _tmpContextPlatform = null;
        } else {
          _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
        }
        _result.setContextPlatform(_tmpContextPlatform);
        final String _tmpContextStatementId;
        if (_cursor.isNull(_cursorIndexOfContextStatementId)) {
          _tmpContextStatementId = null;
        } else {
          _tmpContextStatementId = _cursor.getString(_cursorIndexOfContextStatementId);
        }
        _result.setContextStatementId(_tmpContextStatementId);
        final String _tmpFullStatement;
        if (_cursor.isNull(_cursorIndexOfFullStatement)) {
          _tmpFullStatement = null;
        } else {
          _tmpFullStatement = _cursor.getString(_cursorIndexOfFullStatement);
        }
        _result.setFullStatement(_tmpFullStatement);
        final long _tmpStatementMasterChangeSeqNum;
        _tmpStatementMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
        _result.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
        final long _tmpStatementLocalChangeSeqNum;
        _tmpStatementLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
        _result.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
        final int _tmpStatementLastChangedBy;
        _tmpStatementLastChangedBy = _cursor.getInt(_cursorIndexOfStatementLastChangedBy);
        _result.setStatementLastChangedBy(_tmpStatementLastChangedBy);
        final long _tmpStatementLct;
        _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
        _result.setStatementLct(_tmpStatementLct);
        final int _tmpExtensionProgress;
        _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
        _result.setExtensionProgress(_tmpExtensionProgress);
        final boolean _tmpContentEntryRoot;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfContentEntryRoot);
        _tmpContentEntryRoot = _tmp_1 != 0;
        _result.setContentEntryRoot(_tmpContentEntryRoot);
        final long _tmpStatementContentEntryUid;
        _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
        _result.setStatementContentEntryUid(_tmpStatementContentEntryUid);
        final long _tmpStatementLearnerGroupUid;
        _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
        _result.setStatementLearnerGroupUid(_tmpStatementLearnerGroupUid);
        final long _tmpStatementClazzUid;
        _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
        _result.setStatementClazzUid(_tmpStatementClazzUid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<StatementEntity> findByStatementIdList(final List<String> id) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM StatementEntity WHERE statementId IN (");
    final int _inputSize = id.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : id) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfStatementUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementUid");
      final int _cursorIndexOfStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "statementId");
      final int _cursorIndexOfStatementPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementPersonUid");
      final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
      final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectUid");
      final int _cursorIndexOfSubStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementActorUid");
      final int _cursorIndexOfSubstatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "substatementVerbUid");
      final int _cursorIndexOfSubStatementObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementObjectUid");
      final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
      final int _cursorIndexOfInstructorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "instructorUid");
      final int _cursorIndexOfAuthorityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityUid");
      final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
      final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
      final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
      final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
      final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
      final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
      final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
      final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
      final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
      final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
      final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
      final int _cursorIndexOfContextRegistration = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistration");
      final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
      final int _cursorIndexOfContextStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementId");
      final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "fullStatement");
      final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementMasterChangeSeqNum");
      final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLocalChangeSeqNum");
      final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLastChangedBy");
      final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
      final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
      final int _cursorIndexOfContentEntryRoot = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryRoot");
      final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
      final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
      final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
      final List<StatementEntity> _result = new ArrayList<StatementEntity>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final StatementEntity _item_1;
        _item_1 = new StatementEntity();
        final long _tmpStatementUid;
        _tmpStatementUid = _cursor.getLong(_cursorIndexOfStatementUid);
        _item_1.setStatementUid(_tmpStatementUid);
        final String _tmpStatementId;
        if (_cursor.isNull(_cursorIndexOfStatementId)) {
          _tmpStatementId = null;
        } else {
          _tmpStatementId = _cursor.getString(_cursorIndexOfStatementId);
        }
        _item_1.setStatementId(_tmpStatementId);
        final long _tmpStatementPersonUid;
        _tmpStatementPersonUid = _cursor.getLong(_cursorIndexOfStatementPersonUid);
        _item_1.setStatementPersonUid(_tmpStatementPersonUid);
        final long _tmpStatementVerbUid;
        _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
        _item_1.setStatementVerbUid(_tmpStatementVerbUid);
        final long _tmpXObjectUid;
        _tmpXObjectUid = _cursor.getLong(_cursorIndexOfXObjectUid);
        _item_1.setXObjectUid(_tmpXObjectUid);
        final long _tmpSubStatementActorUid;
        _tmpSubStatementActorUid = _cursor.getLong(_cursorIndexOfSubStatementActorUid);
        _item_1.setSubStatementActorUid(_tmpSubStatementActorUid);
        final long _tmpSubstatementVerbUid;
        _tmpSubstatementVerbUid = _cursor.getLong(_cursorIndexOfSubstatementVerbUid);
        _item_1.setSubstatementVerbUid(_tmpSubstatementVerbUid);
        final long _tmpSubStatementObjectUid;
        _tmpSubStatementObjectUid = _cursor.getLong(_cursorIndexOfSubStatementObjectUid);
        _item_1.setSubStatementObjectUid(_tmpSubStatementObjectUid);
        final long _tmpAgentUid;
        _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
        _item_1.setAgentUid(_tmpAgentUid);
        final long _tmpInstructorUid;
        _tmpInstructorUid = _cursor.getLong(_cursorIndexOfInstructorUid);
        _item_1.setInstructorUid(_tmpInstructorUid);
        final long _tmpAuthorityUid;
        _tmpAuthorityUid = _cursor.getLong(_cursorIndexOfAuthorityUid);
        _item_1.setAuthorityUid(_tmpAuthorityUid);
        final long _tmpTeamUid;
        _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
        _item_1.setTeamUid(_tmpTeamUid);
        final boolean _tmpResultCompletion;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
        _tmpResultCompletion = _tmp != 0;
        _item_1.setResultCompletion(_tmpResultCompletion);
        final byte _tmpResultSuccess;
        _tmpResultSuccess = (byte) _cursor.getShort(_cursorIndexOfResultSuccess);
        _item_1.setResultSuccess(_tmpResultSuccess);
        final float _tmpResultScoreScaled;
        _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
        _item_1.setResultScoreScaled(_tmpResultScoreScaled);
        final long _tmpResultScoreRaw;
        _tmpResultScoreRaw = _cursor.getLong(_cursorIndexOfResultScoreRaw);
        _item_1.setResultScoreRaw(_tmpResultScoreRaw);
        final long _tmpResultScoreMin;
        _tmpResultScoreMin = _cursor.getLong(_cursorIndexOfResultScoreMin);
        _item_1.setResultScoreMin(_tmpResultScoreMin);
        final long _tmpResultScoreMax;
        _tmpResultScoreMax = _cursor.getLong(_cursorIndexOfResultScoreMax);
        _item_1.setResultScoreMax(_tmpResultScoreMax);
        final long _tmpResultDuration;
        _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
        _item_1.setResultDuration(_tmpResultDuration);
        final String _tmpResultResponse;
        if (_cursor.isNull(_cursorIndexOfResultResponse)) {
          _tmpResultResponse = null;
        } else {
          _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
        }
        _item_1.setResultResponse(_tmpResultResponse);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _item_1.setTimestamp(_tmpTimestamp);
        final long _tmpStored;
        _tmpStored = _cursor.getLong(_cursorIndexOfStored);
        _item_1.setStored(_tmpStored);
        final String _tmpContextRegistration;
        if (_cursor.isNull(_cursorIndexOfContextRegistration)) {
          _tmpContextRegistration = null;
        } else {
          _tmpContextRegistration = _cursor.getString(_cursorIndexOfContextRegistration);
        }
        _item_1.setContextRegistration(_tmpContextRegistration);
        final String _tmpContextPlatform;
        if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
          _tmpContextPlatform = null;
        } else {
          _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
        }
        _item_1.setContextPlatform(_tmpContextPlatform);
        final String _tmpContextStatementId;
        if (_cursor.isNull(_cursorIndexOfContextStatementId)) {
          _tmpContextStatementId = null;
        } else {
          _tmpContextStatementId = _cursor.getString(_cursorIndexOfContextStatementId);
        }
        _item_1.setContextStatementId(_tmpContextStatementId);
        final String _tmpFullStatement;
        if (_cursor.isNull(_cursorIndexOfFullStatement)) {
          _tmpFullStatement = null;
        } else {
          _tmpFullStatement = _cursor.getString(_cursorIndexOfFullStatement);
        }
        _item_1.setFullStatement(_tmpFullStatement);
        final long _tmpStatementMasterChangeSeqNum;
        _tmpStatementMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
        _item_1.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
        final long _tmpStatementLocalChangeSeqNum;
        _tmpStatementLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
        _item_1.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
        final int _tmpStatementLastChangedBy;
        _tmpStatementLastChangedBy = _cursor.getInt(_cursorIndexOfStatementLastChangedBy);
        _item_1.setStatementLastChangedBy(_tmpStatementLastChangedBy);
        final long _tmpStatementLct;
        _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
        _item_1.setStatementLct(_tmpStatementLct);
        final int _tmpExtensionProgress;
        _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
        _item_1.setExtensionProgress(_tmpExtensionProgress);
        final boolean _tmpContentEntryRoot;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfContentEntryRoot);
        _tmpContentEntryRoot = _tmp_1 != 0;
        _item_1.setContentEntryRoot(_tmpContentEntryRoot);
        final long _tmpStatementContentEntryUid;
        _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
        _item_1.setStatementContentEntryUid(_tmpStatementContentEntryUid);
        final long _tmpStatementLearnerGroupUid;
        _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
        _item_1.setStatementLearnerGroupUid(_tmpStatementLearnerGroupUid);
        final long _tmpStatementClazzUid;
        _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
        _item_1.setStatementClazzUid(_tmpStatementClazzUid);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Person getPerson() {
    final String _sql = "SELECT * FROM PERSON LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final Person _result;
      if(_cursor.moveToFirst()) {
        _result = new Person();
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        _result.setPersonUid(_tmpPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        _result.setUsername(_tmpUsername);
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        _result.setFirstNames(_tmpFirstNames);
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        _result.setLastName(_tmpLastName);
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        _result.setEmailAddr(_tmpEmailAddr);
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        _result.setPhoneNum(_tmpPhoneNum);
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        _result.setGender(_tmpGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        _result.setActive(_tmpActive);
        final boolean _tmpAdmin;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_1 != 0;
        _result.setAdmin(_tmpAdmin);
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        _result.setPersonNotes(_tmpPersonNotes);
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        _result.setFatherName(_tmpFatherName);
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        _result.setFatherNumber(_tmpFatherNumber);
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        _result.setMotherName(_tmpMotherName);
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _result.setMotherNum(_tmpMotherNum);
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        _result.setDateOfBirth(_tmpDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        _result.setPersonAddress(_tmpPersonAddress);
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        _result.setPersonOrgId(_tmpPersonOrgId);
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        _result.setPersonGroupUid(_tmpPersonGroupUid);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        _result.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        _result.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        _result.setPersonLastChangedBy(_tmpPersonLastChangedBy);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        _result.setPersonLct(_tmpPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        _result.setPersonCountry(_tmpPersonCountry);
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        _result.setPersonType(_tmpPersonType);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public XLangMapEntry getXLangMap() {
    final String _sql = "SELECT * FROM XLangMapEntry LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfVerbLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLangMapUid");
      final int _cursorIndexOfObjectLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectLangMapUid");
      final int _cursorIndexOfLanguageLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageLangMapUid");
      final int _cursorIndexOfLanguageVariantLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantLangMapUid");
      final int _cursorIndexOfValueLangMap = CursorUtil.getColumnIndexOrThrow(_cursor, "valueLangMap");
      final int _cursorIndexOfStatementLangMapMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapMasterCsn");
      final int _cursorIndexOfStatementLangMapLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLocalCsn");
      final int _cursorIndexOfStatementLangMapLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLcb");
      final int _cursorIndexOfStatementLangMapLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLct");
      final int _cursorIndexOfStatementLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapUid");
      final XLangMapEntry _result;
      if(_cursor.moveToFirst()) {
        final long _tmpVerbLangMapUid;
        _tmpVerbLangMapUid = _cursor.getLong(_cursorIndexOfVerbLangMapUid);
        final long _tmpObjectLangMapUid;
        _tmpObjectLangMapUid = _cursor.getLong(_cursorIndexOfObjectLangMapUid);
        final long _tmpLanguageLangMapUid;
        _tmpLanguageLangMapUid = _cursor.getLong(_cursorIndexOfLanguageLangMapUid);
        final long _tmpLanguageVariantLangMapUid;
        _tmpLanguageVariantLangMapUid = _cursor.getLong(_cursorIndexOfLanguageVariantLangMapUid);
        final String _tmpValueLangMap;
        if (_cursor.isNull(_cursorIndexOfValueLangMap)) {
          _tmpValueLangMap = null;
        } else {
          _tmpValueLangMap = _cursor.getString(_cursorIndexOfValueLangMap);
        }
        final int _tmpStatementLangMapMasterCsn;
        _tmpStatementLangMapMasterCsn = _cursor.getInt(_cursorIndexOfStatementLangMapMasterCsn);
        final int _tmpStatementLangMapLocalCsn;
        _tmpStatementLangMapLocalCsn = _cursor.getInt(_cursorIndexOfStatementLangMapLocalCsn);
        final int _tmpStatementLangMapLcb;
        _tmpStatementLangMapLcb = _cursor.getInt(_cursorIndexOfStatementLangMapLcb);
        final long _tmpStatementLangMapLct;
        _tmpStatementLangMapLct = _cursor.getLong(_cursorIndexOfStatementLangMapLct);
        _result = new XLangMapEntry(_tmpVerbLangMapUid,_tmpObjectLangMapUid,_tmpLanguageLangMapUid,_tmpLanguageVariantLangMapUid,_tmpValueLangMap,_tmpStatementLangMapMasterCsn,_tmpStatementLangMapLocalCsn,_tmpStatementLangMapLcb,_tmpStatementLangMapLct);
        final long _tmpStatementLangMapUid;
        _tmpStatementLangMapUid = _cursor.getLong(_cursorIndexOfStatementLangMapUid);
        _result.setStatementLangMapUid(_tmpStatementLangMapUid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public DataSource.Factory<Integer, PersonWithAttemptsSummary> findPersonsWithContentEntryAttempts(
      final long contentEntryUid, final long accountPersonUid, final String searchText,
      final int sortOrder) {
    final String _sql = "\n"
            + "        SELECT ResultSource.personUid, ResultSource.firstNames, ResultSource.lastName,\n"
            + "            COUNT(DISTINCT(ResultSource.contextRegistration)) AS attempts, \n"
            + "            MIN(ResultSource.timestamp) AS startDate, \n"
            + "            MAX(ResultSource.timestamp) AS endDate, \n"
            + "            SUM(ResultSource.resultDuration) AS duration, \n"
            + "            MAX(CASE WHEN ResultSource.contentEntryRoot \n"
            + "                THEN resultScoreRaw\n"
            + "                ELSE 0 END) AS resultScore, \n"
            + "            MAX(CASE WHEN ResultSource.contentEntryRoot \n"
            + "                THEN resultScoreMax\n"
            + "                ELSE 0 END) AS resultMax,   \n"
            + "            MAX(CASE WHEN ResultSource.contentEntryRoot \n"
            + "                THEN resultScoreScaled\n"
            + "                ELSE 0 END) AS resultScaled, \n"
            + "            MAX(ResultSource.extensionProgress) AS progress,\n"
            + "            0 AS penalty,\n"
            + "            0 as resultWeight,\n"
            + "            'FALSE' AS contentComplete,\n"
            + "            0 AS success,\n"
            + "            \n"
            + "            CASE WHEN ResultSource.resultCompletion \n"
            + "                THEN 1 ELSE 0 END AS totalCompletedContent,\n"
            + "                \n"
            + "            1 as totalContent, \n"
            + "            \n"
            + "            0 as fileSubmissionStatus, \n"
            + "         \n"
            + "            '' AS latestPrivateComment\n"
            + "        \n"
            + "         FROM (SELECT Person.personUid, Person.firstNames, Person.lastName, \n"
            + "            StatementEntity.contextRegistration, StatementEntity.timestamp, \n"
            + "            StatementEntity.resultDuration, StatementEntity.resultScoreRaw, \n"
            + "            StatementEntity.resultScoreMax, StatementEntity.resultScoreScaled,\n"
            + "            StatementEntity.contentEntryRoot, StatementEntity.extensionProgress, \n"
            + "            StatementEntity.resultCompletion\n"
            + "            FROM PersonGroupMember\n"
            + "            \n"
            + "            JOIN ScopedGrant\n"
            + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "                    AND (ScopedGrant.sgPermissions & 549755813888 \n"
            + "                                                    ) > 0\n"
            + "            JOIN Person \n"
            + "                 ON \n"
            + "                ((ScopedGrant.sgTableId = -2\n"
            + "                    AND ScopedGrant.sgEntityUid = -2)\n"
            + "                 OR (ScopedGrant.sgTableId = 9\n"
            + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
            + "                 OR (ScopedGrant.sgTableId = 6       \n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
            + "                          FROM ClazzEnrolment\n"
            + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
            + "                 OR (ScopedGrant.sgTableId = 164\n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT schoolMemberPersonUid\n"
            + "                          FROM SchoolMember\n"
            + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
            + "                           AND schoolMemberActive))\n"
            + "                           )    \n"
            + "        \n"
            + "        \n"
            + "             LEFT JOIN StatementEntity \n"
            + "                ON StatementEntity.statementPersonUid = Person.personUid \n"
            + "                    WHERE PersonGroupMember.groupMemberPersonUid = ? \n"
            + "                        AND PersonGroupMember.groupMemberActive  \n"
            + "                        AND statementContentEntryUid = ?\n"
            + "                        AND Person.firstNames || ' ' || Person.lastName LIKE ?              \n"
            + "                   GROUP BY StatementEntity.statementUid \n"
            + "                   ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC) AS ResultSource \n"
            + "         GROUP BY ResultSource.personUid \n"
            + "         ORDER BY CASE(?) \n"
            + "                WHEN 1 THEN ResultSource.firstNames\n"
            + "                WHEN 3 THEN ResultSource.lastName\n"
            + "                ELSE ''\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 2 THEN ResultSource.firstNames\n"
            + "                WHEN 4 THEN ResultSource.lastName\n"
            + "                ELSE ''\n"
            + "            END DESC,\n"
            + "            CASE(?)\n"
            + "                WHEN 5 THEN endDate \n"
            + "                ELSE 0\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 6 then endDate\n"
            + "                ELSE 0\n"
            + "            END DESC\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 5;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 6;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 7;
    _statement.bindLong(_argIndex, sortOrder);
    return new DataSource.Factory<Integer, PersonWithAttemptsSummary>() {
      @Override
      public LimitOffsetDataSource<PersonWithAttemptsSummary> create() {
        return new LimitOffsetDataSource<PersonWithAttemptsSummary>(__db, _statement, false, true , "PersonGroupMember", "ScopedGrant", "Person", "ClazzEnrolment", "SchoolMember", "StatementEntity") {
          @Override
          protected List<PersonWithAttemptsSummary> convertRows(Cursor cursor) {
            final int _cursorIndexOfPersonUid = 0;
            final int _cursorIndexOfFirstNames = 1;
            final int _cursorIndexOfLastName = 2;
            final int _cursorIndexOfAttempts = 3;
            final int _cursorIndexOfStartDate = 4;
            final int _cursorIndexOfEndDate = 5;
            final int _cursorIndexOfDuration = 6;
            final int _cursorIndexOfResultScore = 7;
            final int _cursorIndexOfResultMax = 8;
            final int _cursorIndexOfResultScaled = 9;
            final int _cursorIndexOfProgress = 10;
            final int _cursorIndexOfPenalty = 11;
            final int _cursorIndexOfResultWeight = 12;
            final int _cursorIndexOfContentComplete = 13;
            final int _cursorIndexOfSuccess = 14;
            final int _cursorIndexOfTotalCompletedContent = 15;
            final int _cursorIndexOfTotalContent = 16;
            final int _cursorIndexOfFileSubmissionStatus = 17;
            final int _cursorIndexOfLatestPrivateComment = 18;
            final List<PersonWithAttemptsSummary> _res = new ArrayList<PersonWithAttemptsSummary>(cursor.getCount());
            while(cursor.moveToNext()) {
              final PersonWithAttemptsSummary _item;
              final ContentEntryStatementScoreProgress _tmpScoreProgress;
              if (! (cursor.isNull(_cursorIndexOfResultScore) && cursor.isNull(_cursorIndexOfResultMax) && cursor.isNull(_cursorIndexOfResultScaled) && cursor.isNull(_cursorIndexOfProgress) && cursor.isNull(_cursorIndexOfPenalty) && cursor.isNull(_cursorIndexOfResultWeight) && cursor.isNull(_cursorIndexOfContentComplete) && cursor.isNull(_cursorIndexOfSuccess) && cursor.isNull(_cursorIndexOfTotalCompletedContent) && cursor.isNull(_cursorIndexOfTotalContent))) {
                _tmpScoreProgress = new ContentEntryStatementScoreProgress();
                final int _tmpResultScore;
                _tmpResultScore = cursor.getInt(_cursorIndexOfResultScore);
                _tmpScoreProgress.setResultScore(_tmpResultScore);
                final int _tmpResultMax;
                _tmpResultMax = cursor.getInt(_cursorIndexOfResultMax);
                _tmpScoreProgress.setResultMax(_tmpResultMax);
                final float _tmpResultScaled;
                _tmpResultScaled = cursor.getFloat(_cursorIndexOfResultScaled);
                _tmpScoreProgress.setResultScaled(_tmpResultScaled);
                final int _tmpProgress;
                _tmpProgress = cursor.getInt(_cursorIndexOfProgress);
                _tmpScoreProgress.setProgress(_tmpProgress);
                final int _tmpPenalty;
                _tmpPenalty = cursor.getInt(_cursorIndexOfPenalty);
                _tmpScoreProgress.setPenalty(_tmpPenalty);
                final int _tmpResultWeight;
                _tmpResultWeight = cursor.getInt(_cursorIndexOfResultWeight);
                _tmpScoreProgress.setResultWeight(_tmpResultWeight);
                final boolean _tmpContentComplete;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfContentComplete);
                _tmpContentComplete = _tmp != 0;
                _tmpScoreProgress.setContentComplete(_tmpContentComplete);
                final byte _tmpSuccess;
                _tmpSuccess = (byte) cursor.getShort(_cursorIndexOfSuccess);
                _tmpScoreProgress.setSuccess(_tmpSuccess);
                final int _tmpTotalCompletedContent;
                _tmpTotalCompletedContent = cursor.getInt(_cursorIndexOfTotalCompletedContent);
                _tmpScoreProgress.setTotalCompletedContent(_tmpTotalCompletedContent);
                final int _tmpTotalContent;
                _tmpTotalContent = cursor.getInt(_cursorIndexOfTotalContent);
                _tmpScoreProgress.setTotalContent(_tmpTotalContent);
              }  else  {
                _tmpScoreProgress = null;
              }
              _item = new PersonWithAttemptsSummary();
              final long _tmpPersonUid;
              _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
              _item.setPersonUid(_tmpPersonUid);
              final String _tmpFirstNames;
              if (cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
              }
              _item.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = cursor.getString(_cursorIndexOfLastName);
              }
              _item.setLastName(_tmpLastName);
              final int _tmpAttempts;
              _tmpAttempts = cursor.getInt(_cursorIndexOfAttempts);
              _item.setAttempts(_tmpAttempts);
              final long _tmpStartDate;
              _tmpStartDate = cursor.getLong(_cursorIndexOfStartDate);
              _item.setStartDate(_tmpStartDate);
              final long _tmpEndDate;
              _tmpEndDate = cursor.getLong(_cursorIndexOfEndDate);
              _item.setEndDate(_tmpEndDate);
              final long _tmpDuration;
              _tmpDuration = cursor.getLong(_cursorIndexOfDuration);
              _item.setDuration(_tmpDuration);
              final int _tmpFileSubmissionStatus;
              _tmpFileSubmissionStatus = cursor.getInt(_cursorIndexOfFileSubmissionStatus);
              _item.setFileSubmissionStatus(_tmpFileSubmissionStatus);
              final String _tmpLatestPrivateComment;
              if (cursor.isNull(_cursorIndexOfLatestPrivateComment)) {
                _tmpLatestPrivateComment = null;
              } else {
                _tmpLatestPrivateComment = cursor.getString(_cursorIndexOfLatestPrivateComment);
              }
              _item.setLatestPrivateComment(_tmpLatestPrivateComment);
              _item.setScoreProgress(_tmpScoreProgress);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object getBestScoreForContentForPerson(final long contentEntryUid,
      final long accountPersonUid,
      final Continuation<? super ContentEntryStatementScoreProgress> continuation) {
    final String _sql = "\n"
            + "        SELECT \n"
            + "                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n"
            + "                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n"
            + "                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n"
            + "                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n"
            + "                COALESCE(StatementEntity.resultCompletion,'FALSE') AS contentComplete,\n"
            + "                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n"
            + "                0 as resultWeight,\n"
            + "                \n"
            + "                COALESCE((CASE WHEN resultCompletion \n"
            + "                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n"
            + "                \n"
            + "                1 as totalContent, \n"
            + "                0 as penalty\n"
            + "                \n"
            + "        FROM ContentEntry\n"
            + "            LEFT JOIN StatementEntity\n"
            + "\t\t\t\t\t\t\tON StatementEntity.statementUid = \n"
            + "                                (SELECT statementUid \n"
            + "\t\t\t\t\t\t\t       FROM StatementEntity \n"
            + "                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = ?\n"
            + "\t\t\t\t\t\t\t        AND contentEntryRoot \n"
            + "                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)\n"
            + "                               \n"
            + "       WHERE contentEntryUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryStatementScoreProgress>() {
      @Override
      public ContentEntryStatementScoreProgress call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfResultMax = 0;
          final int _cursorIndexOfResultScore = 1;
          final int _cursorIndexOfResultScaled = 2;
          final int _cursorIndexOfProgress = 3;
          final int _cursorIndexOfContentComplete = 4;
          final int _cursorIndexOfSuccess = 5;
          final int _cursorIndexOfResultWeight = 6;
          final int _cursorIndexOfTotalCompletedContent = 7;
          final int _cursorIndexOfTotalContent = 8;
          final int _cursorIndexOfPenalty = 9;
          final ContentEntryStatementScoreProgress _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntryStatementScoreProgress();
            final int _tmpResultMax;
            _tmpResultMax = _cursor.getInt(_cursorIndexOfResultMax);
            _result.setResultMax(_tmpResultMax);
            final int _tmpResultScore;
            _tmpResultScore = _cursor.getInt(_cursorIndexOfResultScore);
            _result.setResultScore(_tmpResultScore);
            final float _tmpResultScaled;
            _tmpResultScaled = _cursor.getFloat(_cursorIndexOfResultScaled);
            _result.setResultScaled(_tmpResultScaled);
            final int _tmpProgress;
            _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
            _result.setProgress(_tmpProgress);
            final boolean _tmpContentComplete;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfContentComplete);
            _tmpContentComplete = _tmp != 0;
            _result.setContentComplete(_tmpContentComplete);
            final byte _tmpSuccess;
            _tmpSuccess = (byte) _cursor.getShort(_cursorIndexOfSuccess);
            _result.setSuccess(_tmpSuccess);
            final int _tmpResultWeight;
            _tmpResultWeight = _cursor.getInt(_cursorIndexOfResultWeight);
            _result.setResultWeight(_tmpResultWeight);
            final int _tmpTotalCompletedContent;
            _tmpTotalCompletedContent = _cursor.getInt(_cursorIndexOfTotalCompletedContent);
            _result.setTotalCompletedContent(_tmpTotalCompletedContent);
            final int _tmpTotalContent;
            _tmpTotalContent = _cursor.getInt(_cursorIndexOfTotalContent);
            _result.setTotalContent(_tmpTotalContent);
            final int _tmpPenalty;
            _tmpPenalty = _cursor.getInt(_cursorIndexOfPenalty);
            _result.setPenalty(_tmpPenalty);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findNextStudentNotMarkedForAssignment(final long assignmentUid,
      final long currentStudentUid, final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "         SELECT COALESCE((\n"
            + "                SELECT DISTINCT(statementpersonUid)\n"
            + "                  FROM ClazzAssignment \n"
            + "                      JOIN ClazzEnrolment\n"
            + "                       ON ClazzEnrolment.clazzEnrolmentClazzUid = ClazzAssignment.caClazzUid\n"
            + "                       \n"
            + "                       JOIN CourseBlock\n"
            + "                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n"
            + "                       AND CourseBlock.cbType = 103\n"
            + "                       \n"
            + "          \t           JOIN StatementEntity AS SubmissionStatement\n"
            + "          \t           ON SubmissionStatement.statementUid = (SELECT statementUid \n"
            + "                                   FROM StatementEntity\n"
            + "                                  WHERE StatementEntity.statementContentEntryUid = 0\n"
            + "                                    AND xObjectUid = ClazzAssignment.caXObjectUid\n"
            + "                                    AND StatementEntity.statementPersonUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                                    AND StatementEntity.timestamp \n"
            + "                                        BETWEEN CourseBlock.cbHideUntilDate\n"
            + "                                        AND CourseBlock.cbGracePeriodDate\n"
            + "                               ORDER BY timestamp DESC LIMIT 1)\n"
            + "                               \n"
            + "          \t           LEFT JOIN XObjectEntity\n"
            + "                       ON XObjectEntity.objectStatementRefUid = SubmissionStatement.statementUid  \n"
            + "               \n"
            + "                 WHERE ClazzAssignment.caUid = ?\n"
            + "                   AND XObjectEntity.xobjectUid IS NULL\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentPersonUid != ?\n"
            + "            LIMIT 1),0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, currentStudentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findSubmittedStatementFromStudent(final long studentUid,
      final long assignmentObjectUid, final Continuation<? super StatementEntity> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM StatementEntity\n"
            + "         WHERE statementPersonUid = ?\n"
            + "           AND statementVerbUid = 10008\n"
            + "           AND xObjectUid = ?    \n"
            + "      ORDER BY timestamp                \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, studentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentObjectUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<StatementEntity>() {
      @Override
      public StatementEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementUid");
          final int _cursorIndexOfStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "statementId");
          final int _cursorIndexOfStatementPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectUid");
          final int _cursorIndexOfSubStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementActorUid");
          final int _cursorIndexOfSubstatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "substatementVerbUid");
          final int _cursorIndexOfSubStatementObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementObjectUid");
          final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
          final int _cursorIndexOfInstructorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "instructorUid");
          final int _cursorIndexOfAuthorityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistration = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistration");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementId");
          final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "fullStatement");
          final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementMasterChangeSeqNum");
          final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLocalChangeSeqNum");
          final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLastChangedBy");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfContentEntryRoot = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryRoot");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final StatementEntity _result;
          if(_cursor.moveToFirst()) {
            _result = new StatementEntity();
            final long _tmpStatementUid;
            _tmpStatementUid = _cursor.getLong(_cursorIndexOfStatementUid);
            _result.setStatementUid(_tmpStatementUid);
            final String _tmpStatementId;
            if (_cursor.isNull(_cursorIndexOfStatementId)) {
              _tmpStatementId = null;
            } else {
              _tmpStatementId = _cursor.getString(_cursorIndexOfStatementId);
            }
            _result.setStatementId(_tmpStatementId);
            final long _tmpStatementPersonUid;
            _tmpStatementPersonUid = _cursor.getLong(_cursorIndexOfStatementPersonUid);
            _result.setStatementPersonUid(_tmpStatementPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            _result.setStatementVerbUid(_tmpStatementVerbUid);
            final long _tmpXObjectUid;
            _tmpXObjectUid = _cursor.getLong(_cursorIndexOfXObjectUid);
            _result.setXObjectUid(_tmpXObjectUid);
            final long _tmpSubStatementActorUid;
            _tmpSubStatementActorUid = _cursor.getLong(_cursorIndexOfSubStatementActorUid);
            _result.setSubStatementActorUid(_tmpSubStatementActorUid);
            final long _tmpSubstatementVerbUid;
            _tmpSubstatementVerbUid = _cursor.getLong(_cursorIndexOfSubstatementVerbUid);
            _result.setSubstatementVerbUid(_tmpSubstatementVerbUid);
            final long _tmpSubStatementObjectUid;
            _tmpSubStatementObjectUid = _cursor.getLong(_cursorIndexOfSubStatementObjectUid);
            _result.setSubStatementObjectUid(_tmpSubStatementObjectUid);
            final long _tmpAgentUid;
            _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
            _result.setAgentUid(_tmpAgentUid);
            final long _tmpInstructorUid;
            _tmpInstructorUid = _cursor.getLong(_cursorIndexOfInstructorUid);
            _result.setInstructorUid(_tmpInstructorUid);
            final long _tmpAuthorityUid;
            _tmpAuthorityUid = _cursor.getLong(_cursorIndexOfAuthorityUid);
            _result.setAuthorityUid(_tmpAuthorityUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            _result.setTeamUid(_tmpTeamUid);
            final boolean _tmpResultCompletion;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            _tmpResultCompletion = _tmp != 0;
            _result.setResultCompletion(_tmpResultCompletion);
            final byte _tmpResultSuccess;
            _tmpResultSuccess = (byte) _cursor.getShort(_cursorIndexOfResultSuccess);
            _result.setResultSuccess(_tmpResultSuccess);
            final float _tmpResultScoreScaled;
            _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            _result.setResultScoreScaled(_tmpResultScoreScaled);
            final long _tmpResultScoreRaw;
            _tmpResultScoreRaw = _cursor.getLong(_cursorIndexOfResultScoreRaw);
            _result.setResultScoreRaw(_tmpResultScoreRaw);
            final long _tmpResultScoreMin;
            _tmpResultScoreMin = _cursor.getLong(_cursorIndexOfResultScoreMin);
            _result.setResultScoreMin(_tmpResultScoreMin);
            final long _tmpResultScoreMax;
            _tmpResultScoreMax = _cursor.getLong(_cursorIndexOfResultScoreMax);
            _result.setResultScoreMax(_tmpResultScoreMax);
            final long _tmpResultDuration;
            _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            _result.setResultDuration(_tmpResultDuration);
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            _result.setResultResponse(_tmpResultResponse);
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            _result.setTimestamp(_tmpTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            _result.setStored(_tmpStored);
            final String _tmpContextRegistration;
            if (_cursor.isNull(_cursorIndexOfContextRegistration)) {
              _tmpContextRegistration = null;
            } else {
              _tmpContextRegistration = _cursor.getString(_cursorIndexOfContextRegistration);
            }
            _result.setContextRegistration(_tmpContextRegistration);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            _result.setContextPlatform(_tmpContextPlatform);
            final String _tmpContextStatementId;
            if (_cursor.isNull(_cursorIndexOfContextStatementId)) {
              _tmpContextStatementId = null;
            } else {
              _tmpContextStatementId = _cursor.getString(_cursorIndexOfContextStatementId);
            }
            _result.setContextStatementId(_tmpContextStatementId);
            final String _tmpFullStatement;
            if (_cursor.isNull(_cursorIndexOfFullStatement)) {
              _tmpFullStatement = null;
            } else {
              _tmpFullStatement = _cursor.getString(_cursorIndexOfFullStatement);
            }
            _result.setFullStatement(_tmpFullStatement);
            final long _tmpStatementMasterChangeSeqNum;
            _tmpStatementMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
            _result.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
            final long _tmpStatementLocalChangeSeqNum;
            _tmpStatementLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
            _result.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
            final int _tmpStatementLastChangedBy;
            _tmpStatementLastChangedBy = _cursor.getInt(_cursorIndexOfStatementLastChangedBy);
            _result.setStatementLastChangedBy(_tmpStatementLastChangedBy);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            _result.setStatementLct(_tmpStatementLct);
            final int _tmpExtensionProgress;
            _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            _result.setExtensionProgress(_tmpExtensionProgress);
            final boolean _tmpContentEntryRoot;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfContentEntryRoot);
            _tmpContentEntryRoot = _tmp_1 != 0;
            _result.setContentEntryRoot(_tmpContentEntryRoot);
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            _result.setStatementContentEntryUid(_tmpStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            _result.setStatementLearnerGroupUid(_tmpStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            _result.setStatementClazzUid(_tmpStatementClazzUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public StatementEntity findScoreStatementForStudent(final long studentUid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM StatementEntity\n"
            + "         WHERE statementPersonUid = ?\n"
            + "           AND statementVerbUid = 10009\n"
            + "      ORDER BY timestamp                \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, studentUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfStatementUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementUid");
      final int _cursorIndexOfStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "statementId");
      final int _cursorIndexOfStatementPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementPersonUid");
      final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
      final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectUid");
      final int _cursorIndexOfSubStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementActorUid");
      final int _cursorIndexOfSubstatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "substatementVerbUid");
      final int _cursorIndexOfSubStatementObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "subStatementObjectUid");
      final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "agentUid");
      final int _cursorIndexOfInstructorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "instructorUid");
      final int _cursorIndexOfAuthorityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityUid");
      final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
      final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
      final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
      final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
      final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
      final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
      final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
      final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
      final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
      final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
      final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
      final int _cursorIndexOfContextRegistration = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistration");
      final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
      final int _cursorIndexOfContextStatementId = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementId");
      final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "fullStatement");
      final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementMasterChangeSeqNum");
      final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLocalChangeSeqNum");
      final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLastChangedBy");
      final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
      final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
      final int _cursorIndexOfContentEntryRoot = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryRoot");
      final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
      final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
      final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
      final StatementEntity _result;
      if(_cursor.moveToFirst()) {
        _result = new StatementEntity();
        final long _tmpStatementUid;
        _tmpStatementUid = _cursor.getLong(_cursorIndexOfStatementUid);
        _result.setStatementUid(_tmpStatementUid);
        final String _tmpStatementId;
        if (_cursor.isNull(_cursorIndexOfStatementId)) {
          _tmpStatementId = null;
        } else {
          _tmpStatementId = _cursor.getString(_cursorIndexOfStatementId);
        }
        _result.setStatementId(_tmpStatementId);
        final long _tmpStatementPersonUid;
        _tmpStatementPersonUid = _cursor.getLong(_cursorIndexOfStatementPersonUid);
        _result.setStatementPersonUid(_tmpStatementPersonUid);
        final long _tmpStatementVerbUid;
        _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
        _result.setStatementVerbUid(_tmpStatementVerbUid);
        final long _tmpXObjectUid;
        _tmpXObjectUid = _cursor.getLong(_cursorIndexOfXObjectUid);
        _result.setXObjectUid(_tmpXObjectUid);
        final long _tmpSubStatementActorUid;
        _tmpSubStatementActorUid = _cursor.getLong(_cursorIndexOfSubStatementActorUid);
        _result.setSubStatementActorUid(_tmpSubStatementActorUid);
        final long _tmpSubstatementVerbUid;
        _tmpSubstatementVerbUid = _cursor.getLong(_cursorIndexOfSubstatementVerbUid);
        _result.setSubstatementVerbUid(_tmpSubstatementVerbUid);
        final long _tmpSubStatementObjectUid;
        _tmpSubStatementObjectUid = _cursor.getLong(_cursorIndexOfSubStatementObjectUid);
        _result.setSubStatementObjectUid(_tmpSubStatementObjectUid);
        final long _tmpAgentUid;
        _tmpAgentUid = _cursor.getLong(_cursorIndexOfAgentUid);
        _result.setAgentUid(_tmpAgentUid);
        final long _tmpInstructorUid;
        _tmpInstructorUid = _cursor.getLong(_cursorIndexOfInstructorUid);
        _result.setInstructorUid(_tmpInstructorUid);
        final long _tmpAuthorityUid;
        _tmpAuthorityUid = _cursor.getLong(_cursorIndexOfAuthorityUid);
        _result.setAuthorityUid(_tmpAuthorityUid);
        final long _tmpTeamUid;
        _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
        _result.setTeamUid(_tmpTeamUid);
        final boolean _tmpResultCompletion;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
        _tmpResultCompletion = _tmp != 0;
        _result.setResultCompletion(_tmpResultCompletion);
        final byte _tmpResultSuccess;
        _tmpResultSuccess = (byte) _cursor.getShort(_cursorIndexOfResultSuccess);
        _result.setResultSuccess(_tmpResultSuccess);
        final float _tmpResultScoreScaled;
        _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
        _result.setResultScoreScaled(_tmpResultScoreScaled);
        final long _tmpResultScoreRaw;
        _tmpResultScoreRaw = _cursor.getLong(_cursorIndexOfResultScoreRaw);
        _result.setResultScoreRaw(_tmpResultScoreRaw);
        final long _tmpResultScoreMin;
        _tmpResultScoreMin = _cursor.getLong(_cursorIndexOfResultScoreMin);
        _result.setResultScoreMin(_tmpResultScoreMin);
        final long _tmpResultScoreMax;
        _tmpResultScoreMax = _cursor.getLong(_cursorIndexOfResultScoreMax);
        _result.setResultScoreMax(_tmpResultScoreMax);
        final long _tmpResultDuration;
        _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
        _result.setResultDuration(_tmpResultDuration);
        final String _tmpResultResponse;
        if (_cursor.isNull(_cursorIndexOfResultResponse)) {
          _tmpResultResponse = null;
        } else {
          _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
        }
        _result.setResultResponse(_tmpResultResponse);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _result.setTimestamp(_tmpTimestamp);
        final long _tmpStored;
        _tmpStored = _cursor.getLong(_cursorIndexOfStored);
        _result.setStored(_tmpStored);
        final String _tmpContextRegistration;
        if (_cursor.isNull(_cursorIndexOfContextRegistration)) {
          _tmpContextRegistration = null;
        } else {
          _tmpContextRegistration = _cursor.getString(_cursorIndexOfContextRegistration);
        }
        _result.setContextRegistration(_tmpContextRegistration);
        final String _tmpContextPlatform;
        if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
          _tmpContextPlatform = null;
        } else {
          _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
        }
        _result.setContextPlatform(_tmpContextPlatform);
        final String _tmpContextStatementId;
        if (_cursor.isNull(_cursorIndexOfContextStatementId)) {
          _tmpContextStatementId = null;
        } else {
          _tmpContextStatementId = _cursor.getString(_cursorIndexOfContextStatementId);
        }
        _result.setContextStatementId(_tmpContextStatementId);
        final String _tmpFullStatement;
        if (_cursor.isNull(_cursorIndexOfFullStatement)) {
          _tmpFullStatement = null;
        } else {
          _tmpFullStatement = _cursor.getString(_cursorIndexOfFullStatement);
        }
        _result.setFullStatement(_tmpFullStatement);
        final long _tmpStatementMasterChangeSeqNum;
        _tmpStatementMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
        _result.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
        final long _tmpStatementLocalChangeSeqNum;
        _tmpStatementLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
        _result.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
        final int _tmpStatementLastChangedBy;
        _tmpStatementLastChangedBy = _cursor.getInt(_cursorIndexOfStatementLastChangedBy);
        _result.setStatementLastChangedBy(_tmpStatementLastChangedBy);
        final long _tmpStatementLct;
        _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
        _result.setStatementLct(_tmpStatementLct);
        final int _tmpExtensionProgress;
        _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
        _result.setExtensionProgress(_tmpExtensionProgress);
        final boolean _tmpContentEntryRoot;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfContentEntryRoot);
        _tmpContentEntryRoot = _tmp_1 != 0;
        _result.setContentEntryRoot(_tmpContentEntryRoot);
        final long _tmpStatementContentEntryUid;
        _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
        _result.setStatementContentEntryUid(_tmpStatementContentEntryUid);
        final long _tmpStatementLearnerGroupUid;
        _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
        _result.setStatementLearnerGroupUid(_tmpStatementLearnerGroupUid);
        final long _tmpStatementClazzUid;
        _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
        _result.setStatementClazzUid(_tmpStatementClazzUid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public DataSource.Factory<Integer, PersonWithSessionsDisplay> findSessionsForPerson(
      final long contentEntryUid, final long accountPersonUid, final long personUid) {
    final String _sql = "\n"
            + "        SELECT MIN(timestamp) AS startDate, \n"
            + "            MAX(CASE \n"
            + "                    WHEN StatementEntity.resultSuccess > 0 \n"
            + "                    AND StatementEntity.contentEntryRoot \n"
            + "                    THEN StatementEntity.resultSuccess \n"
            + "                    ELSE 0 END) AS resultSuccess, \n"
            + "            SUM(CASE \n"
            + "                     WHEN CAST(resultCompletion AS INTEGER) > 0 \n"
            + "                     AND StatementEntity.contentEntryRoot \n"
            + "                     THEN 1 \n"
            + "                     ELSE 0 END) AS resultComplete, \n"
            + "            SUM(resultDuration) AS duration, contextRegistration, \n"
            + "            MAX(CASE WHEN contentEntryRoot \n"
            + "                     THEN resultScoreRaw ELSE 0 END) AS resultScore, \n"
            + "            MAX(CASE WHEN contentEntryRoot \n"
            + "                     THEN resultScoreMax ELSE 0 END) AS resultMax,\n"
            + "            MAX(CASE WHEN contentEntryRoot \n"
            + "                     THEN resultScoreScaled ELSE 0 END) AS resultScoreScaled,\n"
            + "                       \n"
            + "            SUM(CASE WHEN resultCompletion AND StatementEntity.contentEntryRoot \n"
            + "                THEN 1 ELSE 0 END) AS totalCompletedContent,\n"
            + "                \n"
            + "             1 as totalContent          \n"
            + "                       \n"
            + "        FROM StatementEntity \n"
            + "             JOIN ScopedGrant \n"
            + "                 ON \n"
            + "            ((ScopedGrant.sgTableId = -2\n"
            + "                AND ScopedGrant.sgEntityUid = -2)\n"
            + "             OR (ScopedGrant.sgTableId = 9\n"
            + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n"
            + "             OR (ScopedGrant.sgTableId = 6\n"
            + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n"
            + "             OR (ScopedGrant.sgTableId = 164\n"
            + "                AND ScopedGrant.sgEntityUid = (\n"
            + "                    SELECT clazzSchoolUid\n"
            + "                      FROM Clazz\n"
            + "                     WHERE clazzUid = StatementEntity.statementClazzUid))\n"
            + "             )\n"
            + "        \n"
            + "                 AND (ScopedGrant.sgPermissions & 549755813888) > 0\n"
            + "             JOIN PersonGroupMember \n"
            + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid  \n"
            + "                AND PersonGroupMember.groupMemberPersonUid = ?\n"
            + "        WHERE statementContentEntryUid = ?   \n"
            + "          AND statementPersonUid = ? \n"
            + "        GROUP BY StatementEntity.contextRegistration \n"
            + "        ORDER BY startDate DESC, resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    return new DataSource.Factory<Integer, PersonWithSessionsDisplay>() {
      @Override
      public LimitOffsetDataSource<PersonWithSessionsDisplay> create() {
        return new LimitOffsetDataSource<PersonWithSessionsDisplay>(__db, _statement, false, true , "StatementEntity", "ScopedGrant", "Clazz", "PersonGroupMember") {
          @Override
          protected List<PersonWithSessionsDisplay> convertRows(Cursor cursor) {
            final int _cursorIndexOfStartDate = 0;
            final int _cursorIndexOfResultSuccess = 1;
            final int _cursorIndexOfResultComplete = 2;
            final int _cursorIndexOfDuration = 3;
            final int _cursorIndexOfContextRegistration = 4;
            final int _cursorIndexOfResultScore = 5;
            final int _cursorIndexOfResultMax = 6;
            final int _cursorIndexOfResultScoreScaled = 7;
            final List<PersonWithSessionsDisplay> _res = new ArrayList<PersonWithSessionsDisplay>(cursor.getCount());
            while(cursor.moveToNext()) {
              final PersonWithSessionsDisplay _item;
              _item = new PersonWithSessionsDisplay();
              final long _tmpStartDate;
              _tmpStartDate = cursor.getLong(_cursorIndexOfStartDate);
              _item.setStartDate(_tmpStartDate);
              final byte _tmpResultSuccess;
              _tmpResultSuccess = (byte) cursor.getShort(_cursorIndexOfResultSuccess);
              _item.setResultSuccess(_tmpResultSuccess);
              final boolean _tmpResultComplete;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfResultComplete);
              _tmpResultComplete = _tmp != 0;
              _item.setResultComplete(_tmpResultComplete);
              final long _tmpDuration;
              _tmpDuration = cursor.getLong(_cursorIndexOfDuration);
              _item.setDuration(_tmpDuration);
              final String _tmpContextRegistration;
              if (cursor.isNull(_cursorIndexOfContextRegistration)) {
                _tmpContextRegistration = null;
              } else {
                _tmpContextRegistration = cursor.getString(_cursorIndexOfContextRegistration);
              }
              _item.setContextRegistration(_tmpContextRegistration);
              final int _tmpResultScore;
              _tmpResultScore = cursor.getInt(_cursorIndexOfResultScore);
              _item.setResultScore(_tmpResultScore);
              final int _tmpResultMax;
              _tmpResultMax = cursor.getInt(_cursorIndexOfResultMax);
              _item.setResultMax(_tmpResultMax);
              final float _tmpResultScoreScaled;
              _tmpResultScoreScaled = cursor.getFloat(_cursorIndexOfResultScoreScaled);
              _item.setResultScoreScaled(_tmpResultScoreScaled);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, StatementWithSessionDetailDisplay> findSessionDetailForPerson(
      final long contentEntryUid, final long accountPersonUid, final long personUid,
      final String contextRegistration) {
    final String _sql = "\n"
            + "        SELECT StatementEntity.*, VerbEntity.*, \n"
            + "            verbLangMap.valueLangMap AS verbDisplay, \n"
            + "            xobjectMap.valueLangMap AS objectDisplay \n"
            + "        FROM StatementEntity\n"
            + "                 JOIN ScopedGrant \n"
            + "                    ON \n"
            + "            ((ScopedGrant.sgTableId = -2\n"
            + "                AND ScopedGrant.sgEntityUid = -2)\n"
            + "             OR (ScopedGrant.sgTableId = 9\n"
            + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n"
            + "             OR (ScopedGrant.sgTableId = 6\n"
            + "                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n"
            + "             OR (ScopedGrant.sgTableId = 164\n"
            + "                AND ScopedGrant.sgEntityUid = (\n"
            + "                    SELECT clazzSchoolUid\n"
            + "                      FROM Clazz\n"
            + "                     WHERE clazzUid = StatementEntity.statementClazzUid))\n"
            + "             )\n"
            + "        \n"
            + "                    AND (ScopedGrant.sgPermissions & 549755813888) > 0\n"
            + "                 JOIN PersonGroupMember \n"
            + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid  \n"
            + "                AND PersonGroupMember.groupMemberPersonUid = ?\n"
            + "                LEFT JOIN VerbEntity \n"
            + "                    ON VerbEntity.verbUid = StatementEntity.statementVerbUid \n"
            + "                LEFT JOIN XLangMapEntry verbLangMap \n"
            + "                    ON verbLangMap.verbLangMapUid = VerbEntity.verbUid\n"
            + "                LEFT JOIN XLangMapEntry xobjectMap \n"
            + "                    ON xobjectMap.objectLangMapUid = StatementEntity.xObjectUid\n"
            + "         WHERE statementContentEntryUid = ? \n"
            + "            AND statementPersonUid = ? \n"
            + "            AND contextRegistration = ? \n"
            + "         ORDER BY StatementEntity.timestamp DESC\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 4;
    if (contextRegistration == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, contextRegistration);
    }
    return new DataSource.Factory<Integer, StatementWithSessionDetailDisplay>() {
      @Override
      public LimitOffsetDataSource<StatementWithSessionDetailDisplay> create() {
        return new LimitOffsetDataSource<StatementWithSessionDetailDisplay>(__db, _statement, false, true , "StatementEntity", "ScopedGrant", "Clazz", "PersonGroupMember", "VerbEntity", "XLangMapEntry") {
          @Override
          protected List<StatementWithSessionDetailDisplay> convertRows(Cursor cursor) {
            final int _cursorIndexOfStatementUid = CursorUtil.getColumnIndexOrThrow(cursor, "statementUid");
            final int _cursorIndexOfStatementId = CursorUtil.getColumnIndexOrThrow(cursor, "statementId");
            final int _cursorIndexOfStatementPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "statementPersonUid");
            final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(cursor, "statementVerbUid");
            final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(cursor, "xObjectUid");
            final int _cursorIndexOfSubStatementActorUid = CursorUtil.getColumnIndexOrThrow(cursor, "subStatementActorUid");
            final int _cursorIndexOfSubstatementVerbUid = CursorUtil.getColumnIndexOrThrow(cursor, "substatementVerbUid");
            final int _cursorIndexOfSubStatementObjectUid = CursorUtil.getColumnIndexOrThrow(cursor, "subStatementObjectUid");
            final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndexOrThrow(cursor, "agentUid");
            final int _cursorIndexOfInstructorUid = CursorUtil.getColumnIndexOrThrow(cursor, "instructorUid");
            final int _cursorIndexOfAuthorityUid = CursorUtil.getColumnIndexOrThrow(cursor, "authorityUid");
            final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(cursor, "teamUid");
            final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(cursor, "resultCompletion");
            final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "resultSuccess");
            final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(cursor, "resultScoreScaled");
            final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(cursor, "resultScoreRaw");
            final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(cursor, "resultScoreMin");
            final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(cursor, "resultScoreMax");
            final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(cursor, "resultDuration");
            final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(cursor, "resultResponse");
            final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "timestamp");
            final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(cursor, "stored");
            final int _cursorIndexOfContextRegistration = CursorUtil.getColumnIndexOrThrow(cursor, "contextRegistration");
            final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(cursor, "contextPlatform");
            final int _cursorIndexOfContextStatementId = CursorUtil.getColumnIndexOrThrow(cursor, "contextStatementId");
            final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow(cursor, "fullStatement");
            final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "statementMasterChangeSeqNum");
            final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "statementLocalChangeSeqNum");
            final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "statementLastChangedBy");
            final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(cursor, "statementLct");
            final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(cursor, "extensionProgress");
            final int _cursorIndexOfContentEntryRoot = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryRoot");
            final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "statementContentEntryUid");
            final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "statementLearnerGroupUid");
            final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "statementClazzUid");
            final int _cursorIndexOfVerbUid = CursorUtil.getColumnIndexOrThrow(cursor, "verbUid");
            final int _cursorIndexOfUrlId = CursorUtil.getColumnIndexOrThrow(cursor, "urlId");
            final int _cursorIndexOfVerbInActive = CursorUtil.getColumnIndexOrThrow(cursor, "verbInActive");
            final int _cursorIndexOfVerbMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "verbMasterChangeSeqNum");
            final int _cursorIndexOfVerbLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "verbLocalChangeSeqNum");
            final int _cursorIndexOfVerbLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "verbLastChangedBy");
            final int _cursorIndexOfVerbLct = CursorUtil.getColumnIndexOrThrow(cursor, "verbLct");
            final int _cursorIndexOfVerbDisplay = CursorUtil.getColumnIndexOrThrow(cursor, "verbDisplay");
            final int _cursorIndexOfObjectDisplay = CursorUtil.getColumnIndexOrThrow(cursor, "objectDisplay");
            final List<StatementWithSessionDetailDisplay> _res = new ArrayList<StatementWithSessionDetailDisplay>(cursor.getCount());
            while(cursor.moveToNext()) {
              final StatementWithSessionDetailDisplay _item;
              final VerbEntity _tmpVerb;
              if (! (cursor.isNull(_cursorIndexOfVerbUid) && cursor.isNull(_cursorIndexOfUrlId) && cursor.isNull(_cursorIndexOfVerbInActive) && cursor.isNull(_cursorIndexOfVerbMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfVerbLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfVerbLastChangedBy) && cursor.isNull(_cursorIndexOfVerbLct))) {
                _tmpVerb = new VerbEntity();
                final long _tmpVerbUid;
                _tmpVerbUid = cursor.getLong(_cursorIndexOfVerbUid);
                _tmpVerb.setVerbUid(_tmpVerbUid);
                final String _tmpUrlId;
                if (cursor.isNull(_cursorIndexOfUrlId)) {
                  _tmpUrlId = null;
                } else {
                  _tmpUrlId = cursor.getString(_cursorIndexOfUrlId);
                }
                _tmpVerb.setUrlId(_tmpUrlId);
                final boolean _tmpVerbInActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfVerbInActive);
                _tmpVerbInActive = _tmp != 0;
                _tmpVerb.setVerbInActive(_tmpVerbInActive);
                final long _tmpVerbMasterChangeSeqNum;
                _tmpVerbMasterChangeSeqNum = cursor.getLong(_cursorIndexOfVerbMasterChangeSeqNum);
                _tmpVerb.setVerbMasterChangeSeqNum(_tmpVerbMasterChangeSeqNum);
                final long _tmpVerbLocalChangeSeqNum;
                _tmpVerbLocalChangeSeqNum = cursor.getLong(_cursorIndexOfVerbLocalChangeSeqNum);
                _tmpVerb.setVerbLocalChangeSeqNum(_tmpVerbLocalChangeSeqNum);
                final int _tmpVerbLastChangedBy;
                _tmpVerbLastChangedBy = cursor.getInt(_cursorIndexOfVerbLastChangedBy);
                _tmpVerb.setVerbLastChangedBy(_tmpVerbLastChangedBy);
                final long _tmpVerbLct;
                _tmpVerbLct = cursor.getLong(_cursorIndexOfVerbLct);
                _tmpVerb.setVerbLct(_tmpVerbLct);
              }  else  {
                _tmpVerb = null;
              }
              _item = new StatementWithSessionDetailDisplay();
              final long _tmpStatementUid;
              _tmpStatementUid = cursor.getLong(_cursorIndexOfStatementUid);
              _item.setStatementUid(_tmpStatementUid);
              final String _tmpStatementId;
              if (cursor.isNull(_cursorIndexOfStatementId)) {
                _tmpStatementId = null;
              } else {
                _tmpStatementId = cursor.getString(_cursorIndexOfStatementId);
              }
              _item.setStatementId(_tmpStatementId);
              final long _tmpStatementPersonUid;
              _tmpStatementPersonUid = cursor.getLong(_cursorIndexOfStatementPersonUid);
              _item.setStatementPersonUid(_tmpStatementPersonUid);
              final long _tmpStatementVerbUid;
              _tmpStatementVerbUid = cursor.getLong(_cursorIndexOfStatementVerbUid);
              _item.setStatementVerbUid(_tmpStatementVerbUid);
              final long _tmpXObjectUid;
              _tmpXObjectUid = cursor.getLong(_cursorIndexOfXObjectUid);
              _item.setXObjectUid(_tmpXObjectUid);
              final long _tmpSubStatementActorUid;
              _tmpSubStatementActorUid = cursor.getLong(_cursorIndexOfSubStatementActorUid);
              _item.setSubStatementActorUid(_tmpSubStatementActorUid);
              final long _tmpSubstatementVerbUid;
              _tmpSubstatementVerbUid = cursor.getLong(_cursorIndexOfSubstatementVerbUid);
              _item.setSubstatementVerbUid(_tmpSubstatementVerbUid);
              final long _tmpSubStatementObjectUid;
              _tmpSubStatementObjectUid = cursor.getLong(_cursorIndexOfSubStatementObjectUid);
              _item.setSubStatementObjectUid(_tmpSubStatementObjectUid);
              final long _tmpAgentUid;
              _tmpAgentUid = cursor.getLong(_cursorIndexOfAgentUid);
              _item.setAgentUid(_tmpAgentUid);
              final long _tmpInstructorUid;
              _tmpInstructorUid = cursor.getLong(_cursorIndexOfInstructorUid);
              _item.setInstructorUid(_tmpInstructorUid);
              final long _tmpAuthorityUid;
              _tmpAuthorityUid = cursor.getLong(_cursorIndexOfAuthorityUid);
              _item.setAuthorityUid(_tmpAuthorityUid);
              final long _tmpTeamUid;
              _tmpTeamUid = cursor.getLong(_cursorIndexOfTeamUid);
              _item.setTeamUid(_tmpTeamUid);
              final boolean _tmpResultCompletion;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfResultCompletion);
              _tmpResultCompletion = _tmp_1 != 0;
              _item.setResultCompletion(_tmpResultCompletion);
              final byte _tmpResultSuccess;
              _tmpResultSuccess = (byte) cursor.getShort(_cursorIndexOfResultSuccess);
              _item.setResultSuccess(_tmpResultSuccess);
              final float _tmpResultScoreScaled;
              _tmpResultScoreScaled = cursor.getFloat(_cursorIndexOfResultScoreScaled);
              _item.setResultScoreScaled(_tmpResultScoreScaled);
              final long _tmpResultScoreRaw;
              _tmpResultScoreRaw = cursor.getLong(_cursorIndexOfResultScoreRaw);
              _item.setResultScoreRaw(_tmpResultScoreRaw);
              final long _tmpResultScoreMin;
              _tmpResultScoreMin = cursor.getLong(_cursorIndexOfResultScoreMin);
              _item.setResultScoreMin(_tmpResultScoreMin);
              final long _tmpResultScoreMax;
              _tmpResultScoreMax = cursor.getLong(_cursorIndexOfResultScoreMax);
              _item.setResultScoreMax(_tmpResultScoreMax);
              final long _tmpResultDuration;
              _tmpResultDuration = cursor.getLong(_cursorIndexOfResultDuration);
              _item.setResultDuration(_tmpResultDuration);
              final String _tmpResultResponse;
              if (cursor.isNull(_cursorIndexOfResultResponse)) {
                _tmpResultResponse = null;
              } else {
                _tmpResultResponse = cursor.getString(_cursorIndexOfResultResponse);
              }
              _item.setResultResponse(_tmpResultResponse);
              final long _tmpTimestamp;
              _tmpTimestamp = cursor.getLong(_cursorIndexOfTimestamp);
              _item.setTimestamp(_tmpTimestamp);
              final long _tmpStored;
              _tmpStored = cursor.getLong(_cursorIndexOfStored);
              _item.setStored(_tmpStored);
              final String _tmpContextRegistration;
              if (cursor.isNull(_cursorIndexOfContextRegistration)) {
                _tmpContextRegistration = null;
              } else {
                _tmpContextRegistration = cursor.getString(_cursorIndexOfContextRegistration);
              }
              _item.setContextRegistration(_tmpContextRegistration);
              final String _tmpContextPlatform;
              if (cursor.isNull(_cursorIndexOfContextPlatform)) {
                _tmpContextPlatform = null;
              } else {
                _tmpContextPlatform = cursor.getString(_cursorIndexOfContextPlatform);
              }
              _item.setContextPlatform(_tmpContextPlatform);
              final String _tmpContextStatementId;
              if (cursor.isNull(_cursorIndexOfContextStatementId)) {
                _tmpContextStatementId = null;
              } else {
                _tmpContextStatementId = cursor.getString(_cursorIndexOfContextStatementId);
              }
              _item.setContextStatementId(_tmpContextStatementId);
              final String _tmpFullStatement;
              if (cursor.isNull(_cursorIndexOfFullStatement)) {
                _tmpFullStatement = null;
              } else {
                _tmpFullStatement = cursor.getString(_cursorIndexOfFullStatement);
              }
              _item.setFullStatement(_tmpFullStatement);
              final long _tmpStatementMasterChangeSeqNum;
              _tmpStatementMasterChangeSeqNum = cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
              _item.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
              final long _tmpStatementLocalChangeSeqNum;
              _tmpStatementLocalChangeSeqNum = cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
              _item.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
              final int _tmpStatementLastChangedBy;
              _tmpStatementLastChangedBy = cursor.getInt(_cursorIndexOfStatementLastChangedBy);
              _item.setStatementLastChangedBy(_tmpStatementLastChangedBy);
              final long _tmpStatementLct;
              _tmpStatementLct = cursor.getLong(_cursorIndexOfStatementLct);
              _item.setStatementLct(_tmpStatementLct);
              final int _tmpExtensionProgress;
              _tmpExtensionProgress = cursor.getInt(_cursorIndexOfExtensionProgress);
              _item.setExtensionProgress(_tmpExtensionProgress);
              final boolean _tmpContentEntryRoot;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfContentEntryRoot);
              _tmpContentEntryRoot = _tmp_2 != 0;
              _item.setContentEntryRoot(_tmpContentEntryRoot);
              final long _tmpStatementContentEntryUid;
              _tmpStatementContentEntryUid = cursor.getLong(_cursorIndexOfStatementContentEntryUid);
              _item.setStatementContentEntryUid(_tmpStatementContentEntryUid);
              final long _tmpStatementLearnerGroupUid;
              _tmpStatementLearnerGroupUid = cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
              _item.setStatementLearnerGroupUid(_tmpStatementLearnerGroupUid);
              final long _tmpStatementClazzUid;
              _tmpStatementClazzUid = cursor.getLong(_cursorIndexOfStatementClazzUid);
              _item.setStatementClazzUid(_tmpStatementClazzUid);
              final String _tmpVerbDisplay;
              if (cursor.isNull(_cursorIndexOfVerbDisplay)) {
                _tmpVerbDisplay = null;
              } else {
                _tmpVerbDisplay = cursor.getString(_cursorIndexOfVerbDisplay);
              }
              _item.setVerbDisplay(_tmpVerbDisplay);
              final String _tmpObjectDisplay;
              if (cursor.isNull(_cursorIndexOfObjectDisplay)) {
                _tmpObjectDisplay = null;
              } else {
                _tmpObjectDisplay = cursor.getString(_cursorIndexOfObjectDisplay);
              }
              _item.setObjectDisplay(_tmpObjectDisplay);
              _item.setVerb(_tmpVerb);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object calculateScoreForSession(final String contextRegistration,
      final Continuation<? super ContentEntryStatementScoreProgress> continuation) {
    final String _sql = "\n"
            + "        SELECT SUM(resultScoreRaw) AS resultScore, \n"
            + "               SUM(resultScoreMax) AS resultMax,\n"
            + "               MAX(extensionProgress) AS progress,\n"
            + "               0 as resultWeight,\n"
            + "               0 as penalty,\n"
            + "               0 as success,\n"
            + "               'FALSE' as contentComplete,\n"
            + "               0 AS resultScaled, \n"
            + "               COALESCE((CASE WHEN resultCompletion \n"
            + "               THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n"
            + "                \n"
            + "                1 as totalContent\n"
            + "               \n"
            + "         FROM (SELECT * \n"
            + "                 FROM StatementEntity \n"
            + "                WHERE contextRegistration = ?\n"
            + "                  AND NOT contentEntryRoot\n"
            + "                  AND statementVerbUid = 10007 \n"
            + "             GROUP BY xObjectUid) AS SessionStatements\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (contextRegistration == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, contextRegistration);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryStatementScoreProgress>() {
      @Override
      public ContentEntryStatementScoreProgress call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfResultScore = 0;
          final int _cursorIndexOfResultMax = 1;
          final int _cursorIndexOfProgress = 2;
          final int _cursorIndexOfResultWeight = 3;
          final int _cursorIndexOfPenalty = 4;
          final int _cursorIndexOfSuccess = 5;
          final int _cursorIndexOfContentComplete = 6;
          final int _cursorIndexOfResultScaled = 7;
          final int _cursorIndexOfTotalCompletedContent = 8;
          final int _cursorIndexOfTotalContent = 9;
          final ContentEntryStatementScoreProgress _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntryStatementScoreProgress();
            final int _tmpResultScore;
            _tmpResultScore = _cursor.getInt(_cursorIndexOfResultScore);
            _result.setResultScore(_tmpResultScore);
            final int _tmpResultMax;
            _tmpResultMax = _cursor.getInt(_cursorIndexOfResultMax);
            _result.setResultMax(_tmpResultMax);
            final int _tmpProgress;
            _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
            _result.setProgress(_tmpProgress);
            final int _tmpResultWeight;
            _tmpResultWeight = _cursor.getInt(_cursorIndexOfResultWeight);
            _result.setResultWeight(_tmpResultWeight);
            final int _tmpPenalty;
            _tmpPenalty = _cursor.getInt(_cursorIndexOfPenalty);
            _result.setPenalty(_tmpPenalty);
            final byte _tmpSuccess;
            _tmpSuccess = (byte) _cursor.getShort(_cursorIndexOfSuccess);
            _result.setSuccess(_tmpSuccess);
            final boolean _tmpContentComplete;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfContentComplete);
            _tmpContentComplete = _tmp != 0;
            _result.setContentComplete(_tmpContentComplete);
            final float _tmpResultScaled;
            _tmpResultScaled = _cursor.getFloat(_cursorIndexOfResultScaled);
            _result.setResultScaled(_tmpResultScaled);
            final int _tmpTotalCompletedContent;
            _tmpTotalCompletedContent = _cursor.getInt(_cursorIndexOfTotalCompletedContent);
            _result.setTotalCompletedContent(_tmpTotalCompletedContent);
            final int _tmpTotalContent;
            _tmpTotalContent = _cursor.getInt(_cursorIndexOfTotalContent);
            _result.setTotalContent(_tmpTotalContent);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findCompletedScoreForSession(final String contextRegistration,
      final Continuation<? super ContentEntryStatementScoreProgress> continuation) {
    final String _sql = "\n"
            + "        SELECT resultScoreRaw AS resultScore, \n"
            + "               resultScoreMax AS resultMax,\n"
            + "               extensionProgress AS progress,\n"
            + "               0 AS penalty,\n"
            + "               0 as resultWeight,\n"
            + "               resultSuccess AS success,\n"
            + "               resultCompletion AS contentComplete, \n"
            + "               resultScoreScaled AS resultScaled,\n"
            + "                1 AS totalCompletedContent,\n"
            + "                1 as totalContent\n"
            + "               \n"
            + "          FROM StatementEntity\n"
            + "         WHERE resultCompletion\n"
            + "          AND contextRegistration = ?\n"
            + "          AND contentEntryRoot\n"
            + "     ORDER BY resultScoreScaled DESC, \n"
            + "              extensionProgress DESC, \n"
            + "              resultSuccess DESC \n"
            + "              LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (contextRegistration == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, contextRegistration);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryStatementScoreProgress>() {
      @Override
      public ContentEntryStatementScoreProgress call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfResultScore = 0;
          final int _cursorIndexOfResultMax = 1;
          final int _cursorIndexOfProgress = 2;
          final int _cursorIndexOfPenalty = 3;
          final int _cursorIndexOfResultWeight = 4;
          final int _cursorIndexOfSuccess = 5;
          final int _cursorIndexOfContentComplete = 6;
          final int _cursorIndexOfResultScaled = 7;
          final int _cursorIndexOfTotalCompletedContent = 8;
          final int _cursorIndexOfTotalContent = 9;
          final ContentEntryStatementScoreProgress _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntryStatementScoreProgress();
            final int _tmpResultScore;
            _tmpResultScore = _cursor.getInt(_cursorIndexOfResultScore);
            _result.setResultScore(_tmpResultScore);
            final int _tmpResultMax;
            _tmpResultMax = _cursor.getInt(_cursorIndexOfResultMax);
            _result.setResultMax(_tmpResultMax);
            final int _tmpProgress;
            _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
            _result.setProgress(_tmpProgress);
            final int _tmpPenalty;
            _tmpPenalty = _cursor.getInt(_cursorIndexOfPenalty);
            _result.setPenalty(_tmpPenalty);
            final int _tmpResultWeight;
            _tmpResultWeight = _cursor.getInt(_cursorIndexOfResultWeight);
            _result.setResultWeight(_tmpResultWeight);
            final byte _tmpSuccess;
            _tmpSuccess = (byte) _cursor.getShort(_cursorIndexOfSuccess);
            _result.setSuccess(_tmpSuccess);
            final boolean _tmpContentComplete;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfContentComplete);
            _tmpContentComplete = _tmp != 0;
            _result.setContentComplete(_tmpContentComplete);
            final float _tmpResultScaled;
            _tmpResultScaled = _cursor.getFloat(_cursorIndexOfResultScaled);
            _result.setResultScaled(_tmpResultScaled);
            final int _tmpTotalCompletedContent;
            _tmpTotalCompletedContent = _cursor.getInt(_cursorIndexOfTotalCompletedContent);
            _result.setTotalCompletedContent(_tmpTotalCompletedContent);
            final int _tmpTotalContent;
            _tmpTotalContent = _cursor.getInt(_cursorIndexOfTotalContent);
            _result.setTotalContent(_tmpTotalContent);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findLatestRegistrationStatement(final long accountPersonUid, final long entryUid,
      final Continuation<? super String> continuation) {
    final String _sql = "\n"
            + "        SELECT contextRegistration \n"
            + "          FROM StatementEntity\n"
            + "         WHERE statementPersonUid = ?\n"
            + "           AND statementContentEntryUid = ?\n"
            + "           AND NOT EXISTS (SELECT statementUid FROM StatementEntity\n"
            + "                            WHERE statementPersonUid = ?\n"
            + "                             AND statementContentEntryUid = ?\n"
            + "                             AND (statementVerbUid = 10001 \n"
            + "                                    OR statementVerbUid = 10004))\n"
            + "      ORDER BY timestamp DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, entryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if(_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getResults(final SupportSQLiteQuery query,
      final Continuation<? super List<StatementReportData>> continuation) {
    final SupportSQLiteQuery _internalQuery = query;
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementReportData>>() {
      @Override
      public List<StatementReportData> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _internalQuery, false, null);
        try {
          final int _cursorIndexOfYAxis = CursorUtil.getColumnIndex(_cursor, "yAxis");
          final int _cursorIndexOfXAxis = CursorUtil.getColumnIndex(_cursor, "xAxis");
          final int _cursorIndexOfSubgroup = CursorUtil.getColumnIndex(_cursor, "subgroup");
          final List<StatementReportData> _result = new ArrayList<StatementReportData>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final StatementReportData _item;
            final float _tmpYAxis;
            if (_cursorIndexOfYAxis == -1) {
              _tmpYAxis = 0;
            } else {
              _tmpYAxis = _cursor.getFloat(_cursorIndexOfYAxis);
            }
            final String _tmpXAxis;
            if (_cursorIndexOfXAxis == -1) {
              _tmpXAxis = null;
            } else {
              if (_cursor.isNull(_cursorIndexOfXAxis)) {
                _tmpXAxis = null;
              } else {
                _tmpXAxis = _cursor.getString(_cursorIndexOfXAxis);
              }
            }
            final String _tmpSubgroup;
            if (_cursorIndexOfSubgroup == -1) {
              _tmpSubgroup = null;
            } else {
              if (_cursor.isNull(_cursorIndexOfSubgroup)) {
                _tmpSubgroup = null;
              } else {
                _tmpSubgroup = _cursor.getString(_cursorIndexOfSubgroup);
              }
            }
            _item = new StatementReportData(_tmpYAxis,_tmpXAxis,_tmpSubgroup);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, StatementEntityWithDisplayDetails> getListResults(
      final SupportSQLiteQuery query) {
    final SupportSQLiteQuery _internalQuery = query;
    return new DataSource.Factory<Integer, StatementEntityWithDisplayDetails>() {
      @Override
      public LimitOffsetDataSource<StatementEntityWithDisplayDetails> create() {
        return new LimitOffsetDataSource<StatementEntityWithDisplayDetails>(__db, _internalQuery, false, true , "StatementEntity", "Person", "XLangMapEntry") {
          @Override
          protected List<StatementEntityWithDisplayDetails> convertRows(Cursor cursor) {
            final int _cursorIndexOfStatementUid = CursorUtil.getColumnIndex(cursor, "statementUid");
            final int _cursorIndexOfStatementId = CursorUtil.getColumnIndex(cursor, "statementId");
            final int _cursorIndexOfStatementPersonUid = CursorUtil.getColumnIndex(cursor, "statementPersonUid");
            final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndex(cursor, "statementVerbUid");
            final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndex(cursor, "xObjectUid");
            final int _cursorIndexOfSubStatementActorUid = CursorUtil.getColumnIndex(cursor, "subStatementActorUid");
            final int _cursorIndexOfSubstatementVerbUid = CursorUtil.getColumnIndex(cursor, "substatementVerbUid");
            final int _cursorIndexOfSubStatementObjectUid = CursorUtil.getColumnIndex(cursor, "subStatementObjectUid");
            final int _cursorIndexOfAgentUid = CursorUtil.getColumnIndex(cursor, "agentUid");
            final int _cursorIndexOfInstructorUid = CursorUtil.getColumnIndex(cursor, "instructorUid");
            final int _cursorIndexOfAuthorityUid = CursorUtil.getColumnIndex(cursor, "authorityUid");
            final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndex(cursor, "teamUid");
            final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndex(cursor, "resultCompletion");
            final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndex(cursor, "resultSuccess");
            final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndex(cursor, "resultScoreScaled");
            final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndex(cursor, "resultScoreRaw");
            final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndex(cursor, "resultScoreMin");
            final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndex(cursor, "resultScoreMax");
            final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndex(cursor, "resultDuration");
            final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndex(cursor, "resultResponse");
            final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndex(cursor, "timestamp");
            final int _cursorIndexOfStored = CursorUtil.getColumnIndex(cursor, "stored");
            final int _cursorIndexOfContextRegistration = CursorUtil.getColumnIndex(cursor, "contextRegistration");
            final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndex(cursor, "contextPlatform");
            final int _cursorIndexOfContextStatementId = CursorUtil.getColumnIndex(cursor, "contextStatementId");
            final int _cursorIndexOfFullStatement = CursorUtil.getColumnIndex(cursor, "fullStatement");
            final int _cursorIndexOfStatementMasterChangeSeqNum = CursorUtil.getColumnIndex(cursor, "statementMasterChangeSeqNum");
            final int _cursorIndexOfStatementLocalChangeSeqNum = CursorUtil.getColumnIndex(cursor, "statementLocalChangeSeqNum");
            final int _cursorIndexOfStatementLastChangedBy = CursorUtil.getColumnIndex(cursor, "statementLastChangedBy");
            final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndex(cursor, "statementLct");
            final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndex(cursor, "extensionProgress");
            final int _cursorIndexOfContentEntryRoot = CursorUtil.getColumnIndex(cursor, "contentEntryRoot");
            final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndex(cursor, "statementContentEntryUid");
            final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndex(cursor, "statementLearnerGroupUid");
            final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndex(cursor, "statementClazzUid");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndex(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndex(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndex(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndex(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndex(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndex(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndex(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndex(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndex(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndex(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndex(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndex(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndex(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndex(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndex(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndex(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndex(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndex(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndex(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndex(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndex(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndex(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndex(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndex(cursor, "personType");
            final int _cursorIndexOfVerbLangMapUid = CursorUtil.getColumnIndex(cursor, "verbLangMapUid");
            final int _cursorIndexOfObjectLangMapUid = CursorUtil.getColumnIndex(cursor, "objectLangMapUid");
            final int _cursorIndexOfLanguageLangMapUid = CursorUtil.getColumnIndex(cursor, "languageLangMapUid");
            final int _cursorIndexOfLanguageVariantLangMapUid = CursorUtil.getColumnIndex(cursor, "languageVariantLangMapUid");
            final int _cursorIndexOfValueLangMap = CursorUtil.getColumnIndex(cursor, "valueLangMap");
            final int _cursorIndexOfStatementLangMapMasterCsn = CursorUtil.getColumnIndex(cursor, "statementLangMapMasterCsn");
            final int _cursorIndexOfStatementLangMapLocalCsn = CursorUtil.getColumnIndex(cursor, "statementLangMapLocalCsn");
            final int _cursorIndexOfStatementLangMapLcb = CursorUtil.getColumnIndex(cursor, "statementLangMapLcb");
            final int _cursorIndexOfStatementLangMapLct = CursorUtil.getColumnIndex(cursor, "statementLangMapLct");
            final int _cursorIndexOfStatementLangMapUid = CursorUtil.getColumnIndex(cursor, "statementLangMapUid");
            final List<StatementEntityWithDisplayDetails> _res = new ArrayList<StatementEntityWithDisplayDetails>(cursor.getCount());
            while(cursor.moveToNext()) {
              final StatementEntityWithDisplayDetails _item;
              final Person _tmpPerson;
              if (! (( _cursorIndexOfPersonUid == -1 || cursor.isNull(_cursorIndexOfPersonUid)) && ( _cursorIndexOfUsername == -1 || cursor.isNull(_cursorIndexOfUsername)) && ( _cursorIndexOfFirstNames == -1 || cursor.isNull(_cursorIndexOfFirstNames)) && ( _cursorIndexOfLastName == -1 || cursor.isNull(_cursorIndexOfLastName)) && ( _cursorIndexOfEmailAddr == -1 || cursor.isNull(_cursorIndexOfEmailAddr)) && ( _cursorIndexOfPhoneNum == -1 || cursor.isNull(_cursorIndexOfPhoneNum)) && ( _cursorIndexOfGender == -1 || cursor.isNull(_cursorIndexOfGender)) && ( _cursorIndexOfActive == -1 || cursor.isNull(_cursorIndexOfActive)) && ( _cursorIndexOfAdmin == -1 || cursor.isNull(_cursorIndexOfAdmin)) && ( _cursorIndexOfPersonNotes == -1 || cursor.isNull(_cursorIndexOfPersonNotes)) && ( _cursorIndexOfFatherName == -1 || cursor.isNull(_cursorIndexOfFatherName)) && ( _cursorIndexOfFatherNumber == -1 || cursor.isNull(_cursorIndexOfFatherNumber)) && ( _cursorIndexOfMotherName == -1 || cursor.isNull(_cursorIndexOfMotherName)) && ( _cursorIndexOfMotherNum == -1 || cursor.isNull(_cursorIndexOfMotherNum)) && ( _cursorIndexOfDateOfBirth == -1 || cursor.isNull(_cursorIndexOfDateOfBirth)) && ( _cursorIndexOfPersonAddress == -1 || cursor.isNull(_cursorIndexOfPersonAddress)) && ( _cursorIndexOfPersonOrgId == -1 || cursor.isNull(_cursorIndexOfPersonOrgId)) && ( _cursorIndexOfPersonGroupUid == -1 || cursor.isNull(_cursorIndexOfPersonGroupUid)) && ( _cursorIndexOfPersonMasterChangeSeqNum == -1 || cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum)) && ( _cursorIndexOfPersonLocalChangeSeqNum == -1 || cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum)) && ( _cursorIndexOfPersonLastChangedBy == -1 || cursor.isNull(_cursorIndexOfPersonLastChangedBy)) && ( _cursorIndexOfPersonLct == -1 || cursor.isNull(_cursorIndexOfPersonLct)) && ( _cursorIndexOfPersonCountry == -1 || cursor.isNull(_cursorIndexOfPersonCountry)) && ( _cursorIndexOfPersonType == -1 || cursor.isNull(_cursorIndexOfPersonType)))) {
                _tmpPerson = new Person();
                if (_cursorIndexOfPersonUid != -1) {
                  final long _tmpPersonUid;
                  _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                  _tmpPerson.setPersonUid(_tmpPersonUid);
                }
                if (_cursorIndexOfUsername != -1) {
                  final String _tmpUsername;
                  if (cursor.isNull(_cursorIndexOfUsername)) {
                    _tmpUsername = null;
                  } else {
                    _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                  }
                  _tmpPerson.setUsername(_tmpUsername);
                }
                if (_cursorIndexOfFirstNames != -1) {
                  final String _tmpFirstNames;
                  if (cursor.isNull(_cursorIndexOfFirstNames)) {
                    _tmpFirstNames = null;
                  } else {
                    _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                  }
                  _tmpPerson.setFirstNames(_tmpFirstNames);
                }
                if (_cursorIndexOfLastName != -1) {
                  final String _tmpLastName;
                  if (cursor.isNull(_cursorIndexOfLastName)) {
                    _tmpLastName = null;
                  } else {
                    _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                  }
                  _tmpPerson.setLastName(_tmpLastName);
                }
                if (_cursorIndexOfEmailAddr != -1) {
                  final String _tmpEmailAddr;
                  if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                    _tmpEmailAddr = null;
                  } else {
                    _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                  }
                  _tmpPerson.setEmailAddr(_tmpEmailAddr);
                }
                if (_cursorIndexOfPhoneNum != -1) {
                  final String _tmpPhoneNum;
                  if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                    _tmpPhoneNum = null;
                  } else {
                    _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                  }
                  _tmpPerson.setPhoneNum(_tmpPhoneNum);
                }
                if (_cursorIndexOfGender != -1) {
                  final int _tmpGender;
                  _tmpGender = cursor.getInt(_cursorIndexOfGender);
                  _tmpPerson.setGender(_tmpGender);
                }
                if (_cursorIndexOfActive != -1) {
                  final boolean _tmpActive;
                  final int _tmp;
                  _tmp = cursor.getInt(_cursorIndexOfActive);
                  _tmpActive = _tmp != 0;
                  _tmpPerson.setActive(_tmpActive);
                }
                if (_cursorIndexOfAdmin != -1) {
                  final boolean _tmpAdmin;
                  final int _tmp_1;
                  _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                  _tmpAdmin = _tmp_1 != 0;
                  _tmpPerson.setAdmin(_tmpAdmin);
                }
                if (_cursorIndexOfPersonNotes != -1) {
                  final String _tmpPersonNotes;
                  if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                    _tmpPersonNotes = null;
                  } else {
                    _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                  }
                  _tmpPerson.setPersonNotes(_tmpPersonNotes);
                }
                if (_cursorIndexOfFatherName != -1) {
                  final String _tmpFatherName;
                  if (cursor.isNull(_cursorIndexOfFatherName)) {
                    _tmpFatherName = null;
                  } else {
                    _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                  }
                  _tmpPerson.setFatherName(_tmpFatherName);
                }
                if (_cursorIndexOfFatherNumber != -1) {
                  final String _tmpFatherNumber;
                  if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                    _tmpFatherNumber = null;
                  } else {
                    _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                  }
                  _tmpPerson.setFatherNumber(_tmpFatherNumber);
                }
                if (_cursorIndexOfMotherName != -1) {
                  final String _tmpMotherName;
                  if (cursor.isNull(_cursorIndexOfMotherName)) {
                    _tmpMotherName = null;
                  } else {
                    _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                  }
                  _tmpPerson.setMotherName(_tmpMotherName);
                }
                if (_cursorIndexOfMotherNum != -1) {
                  final String _tmpMotherNum;
                  if (cursor.isNull(_cursorIndexOfMotherNum)) {
                    _tmpMotherNum = null;
                  } else {
                    _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                  }
                  _tmpPerson.setMotherNum(_tmpMotherNum);
                }
                if (_cursorIndexOfDateOfBirth != -1) {
                  final long _tmpDateOfBirth;
                  _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                  _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
                }
                if (_cursorIndexOfPersonAddress != -1) {
                  final String _tmpPersonAddress;
                  if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                    _tmpPersonAddress = null;
                  } else {
                    _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                  }
                  _tmpPerson.setPersonAddress(_tmpPersonAddress);
                }
                if (_cursorIndexOfPersonOrgId != -1) {
                  final String _tmpPersonOrgId;
                  if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                    _tmpPersonOrgId = null;
                  } else {
                    _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                  }
                  _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
                }
                if (_cursorIndexOfPersonGroupUid != -1) {
                  final long _tmpPersonGroupUid;
                  _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                  _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
                }
                if (_cursorIndexOfPersonMasterChangeSeqNum != -1) {
                  final long _tmpPersonMasterChangeSeqNum;
                  _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                  _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                }
                if (_cursorIndexOfPersonLocalChangeSeqNum != -1) {
                  final long _tmpPersonLocalChangeSeqNum;
                  _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                  _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                }
                if (_cursorIndexOfPersonLastChangedBy != -1) {
                  final int _tmpPersonLastChangedBy;
                  _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                  _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                }
                if (_cursorIndexOfPersonLct != -1) {
                  final long _tmpPersonLct;
                  _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                  _tmpPerson.setPersonLct(_tmpPersonLct);
                }
                if (_cursorIndexOfPersonCountry != -1) {
                  final String _tmpPersonCountry;
                  if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                    _tmpPersonCountry = null;
                  } else {
                    _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                  }
                  _tmpPerson.setPersonCountry(_tmpPersonCountry);
                }
                if (_cursorIndexOfPersonType != -1) {
                  final int _tmpPersonType;
                  _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                  _tmpPerson.setPersonType(_tmpPersonType);
                }
              }  else  {
                _tmpPerson = null;
              }
              final XLangMapEntry _tmpXlangMapEntry;
              if (! (( _cursorIndexOfVerbLangMapUid == -1 || cursor.isNull(_cursorIndexOfVerbLangMapUid)) && ( _cursorIndexOfObjectLangMapUid == -1 || cursor.isNull(_cursorIndexOfObjectLangMapUid)) && ( _cursorIndexOfLanguageLangMapUid == -1 || cursor.isNull(_cursorIndexOfLanguageLangMapUid)) && ( _cursorIndexOfLanguageVariantLangMapUid == -1 || cursor.isNull(_cursorIndexOfLanguageVariantLangMapUid)) && ( _cursorIndexOfValueLangMap == -1 || cursor.isNull(_cursorIndexOfValueLangMap)) && ( _cursorIndexOfStatementLangMapMasterCsn == -1 || cursor.isNull(_cursorIndexOfStatementLangMapMasterCsn)) && ( _cursorIndexOfStatementLangMapLocalCsn == -1 || cursor.isNull(_cursorIndexOfStatementLangMapLocalCsn)) && ( _cursorIndexOfStatementLangMapLcb == -1 || cursor.isNull(_cursorIndexOfStatementLangMapLcb)) && ( _cursorIndexOfStatementLangMapLct == -1 || cursor.isNull(_cursorIndexOfStatementLangMapLct)) && ( _cursorIndexOfStatementLangMapUid == -1 || cursor.isNull(_cursorIndexOfStatementLangMapUid)))) {
                final long _tmpVerbLangMapUid;
                if (_cursorIndexOfVerbLangMapUid == -1) {
                  _tmpVerbLangMapUid = 0;
                } else {
                  _tmpVerbLangMapUid = cursor.getLong(_cursorIndexOfVerbLangMapUid);
                }
                final long _tmpObjectLangMapUid;
                if (_cursorIndexOfObjectLangMapUid == -1) {
                  _tmpObjectLangMapUid = 0;
                } else {
                  _tmpObjectLangMapUid = cursor.getLong(_cursorIndexOfObjectLangMapUid);
                }
                final long _tmpLanguageLangMapUid;
                if (_cursorIndexOfLanguageLangMapUid == -1) {
                  _tmpLanguageLangMapUid = 0;
                } else {
                  _tmpLanguageLangMapUid = cursor.getLong(_cursorIndexOfLanguageLangMapUid);
                }
                final long _tmpLanguageVariantLangMapUid;
                if (_cursorIndexOfLanguageVariantLangMapUid == -1) {
                  _tmpLanguageVariantLangMapUid = 0;
                } else {
                  _tmpLanguageVariantLangMapUid = cursor.getLong(_cursorIndexOfLanguageVariantLangMapUid);
                }
                final String _tmpValueLangMap;
                if (_cursorIndexOfValueLangMap == -1) {
                  _tmpValueLangMap = null;
                } else {
                  if (cursor.isNull(_cursorIndexOfValueLangMap)) {
                    _tmpValueLangMap = null;
                  } else {
                    _tmpValueLangMap = cursor.getString(_cursorIndexOfValueLangMap);
                  }
                }
                final int _tmpStatementLangMapMasterCsn;
                if (_cursorIndexOfStatementLangMapMasterCsn == -1) {
                  _tmpStatementLangMapMasterCsn = 0;
                } else {
                  _tmpStatementLangMapMasterCsn = cursor.getInt(_cursorIndexOfStatementLangMapMasterCsn);
                }
                final int _tmpStatementLangMapLocalCsn;
                if (_cursorIndexOfStatementLangMapLocalCsn == -1) {
                  _tmpStatementLangMapLocalCsn = 0;
                } else {
                  _tmpStatementLangMapLocalCsn = cursor.getInt(_cursorIndexOfStatementLangMapLocalCsn);
                }
                final int _tmpStatementLangMapLcb;
                if (_cursorIndexOfStatementLangMapLcb == -1) {
                  _tmpStatementLangMapLcb = 0;
                } else {
                  _tmpStatementLangMapLcb = cursor.getInt(_cursorIndexOfStatementLangMapLcb);
                }
                final long _tmpStatementLangMapLct;
                if (_cursorIndexOfStatementLangMapLct == -1) {
                  _tmpStatementLangMapLct = 0;
                } else {
                  _tmpStatementLangMapLct = cursor.getLong(_cursorIndexOfStatementLangMapLct);
                }
                _tmpXlangMapEntry = new XLangMapEntry(_tmpVerbLangMapUid,_tmpObjectLangMapUid,_tmpLanguageLangMapUid,_tmpLanguageVariantLangMapUid,_tmpValueLangMap,_tmpStatementLangMapMasterCsn,_tmpStatementLangMapLocalCsn,_tmpStatementLangMapLcb,_tmpStatementLangMapLct);
                if (_cursorIndexOfStatementLangMapUid != -1) {
                  final long _tmpStatementLangMapUid;
                  _tmpStatementLangMapUid = cursor.getLong(_cursorIndexOfStatementLangMapUid);
                  _tmpXlangMapEntry.setStatementLangMapUid(_tmpStatementLangMapUid);
                }
              }  else  {
                _tmpXlangMapEntry = null;
              }
              _item = new StatementEntityWithDisplayDetails();
              if (_cursorIndexOfStatementUid != -1) {
                final long _tmpStatementUid;
                _tmpStatementUid = cursor.getLong(_cursorIndexOfStatementUid);
                _item.setStatementUid(_tmpStatementUid);
              }
              if (_cursorIndexOfStatementId != -1) {
                final String _tmpStatementId;
                if (cursor.isNull(_cursorIndexOfStatementId)) {
                  _tmpStatementId = null;
                } else {
                  _tmpStatementId = cursor.getString(_cursorIndexOfStatementId);
                }
                _item.setStatementId(_tmpStatementId);
              }
              if (_cursorIndexOfStatementPersonUid != -1) {
                final long _tmpStatementPersonUid;
                _tmpStatementPersonUid = cursor.getLong(_cursorIndexOfStatementPersonUid);
                _item.setStatementPersonUid(_tmpStatementPersonUid);
              }
              if (_cursorIndexOfStatementVerbUid != -1) {
                final long _tmpStatementVerbUid;
                _tmpStatementVerbUid = cursor.getLong(_cursorIndexOfStatementVerbUid);
                _item.setStatementVerbUid(_tmpStatementVerbUid);
              }
              if (_cursorIndexOfXObjectUid != -1) {
                final long _tmpXObjectUid;
                _tmpXObjectUid = cursor.getLong(_cursorIndexOfXObjectUid);
                _item.setXObjectUid(_tmpXObjectUid);
              }
              if (_cursorIndexOfSubStatementActorUid != -1) {
                final long _tmpSubStatementActorUid;
                _tmpSubStatementActorUid = cursor.getLong(_cursorIndexOfSubStatementActorUid);
                _item.setSubStatementActorUid(_tmpSubStatementActorUid);
              }
              if (_cursorIndexOfSubstatementVerbUid != -1) {
                final long _tmpSubstatementVerbUid;
                _tmpSubstatementVerbUid = cursor.getLong(_cursorIndexOfSubstatementVerbUid);
                _item.setSubstatementVerbUid(_tmpSubstatementVerbUid);
              }
              if (_cursorIndexOfSubStatementObjectUid != -1) {
                final long _tmpSubStatementObjectUid;
                _tmpSubStatementObjectUid = cursor.getLong(_cursorIndexOfSubStatementObjectUid);
                _item.setSubStatementObjectUid(_tmpSubStatementObjectUid);
              }
              if (_cursorIndexOfAgentUid != -1) {
                final long _tmpAgentUid;
                _tmpAgentUid = cursor.getLong(_cursorIndexOfAgentUid);
                _item.setAgentUid(_tmpAgentUid);
              }
              if (_cursorIndexOfInstructorUid != -1) {
                final long _tmpInstructorUid;
                _tmpInstructorUid = cursor.getLong(_cursorIndexOfInstructorUid);
                _item.setInstructorUid(_tmpInstructorUid);
              }
              if (_cursorIndexOfAuthorityUid != -1) {
                final long _tmpAuthorityUid;
                _tmpAuthorityUid = cursor.getLong(_cursorIndexOfAuthorityUid);
                _item.setAuthorityUid(_tmpAuthorityUid);
              }
              if (_cursorIndexOfTeamUid != -1) {
                final long _tmpTeamUid;
                _tmpTeamUid = cursor.getLong(_cursorIndexOfTeamUid);
                _item.setTeamUid(_tmpTeamUid);
              }
              if (_cursorIndexOfResultCompletion != -1) {
                final boolean _tmpResultCompletion;
                final int _tmp_2;
                _tmp_2 = cursor.getInt(_cursorIndexOfResultCompletion);
                _tmpResultCompletion = _tmp_2 != 0;
                _item.setResultCompletion(_tmpResultCompletion);
              }
              if (_cursorIndexOfResultSuccess != -1) {
                final byte _tmpResultSuccess;
                _tmpResultSuccess = (byte) cursor.getShort(_cursorIndexOfResultSuccess);
                _item.setResultSuccess(_tmpResultSuccess);
              }
              if (_cursorIndexOfResultScoreScaled != -1) {
                final float _tmpResultScoreScaled;
                _tmpResultScoreScaled = cursor.getFloat(_cursorIndexOfResultScoreScaled);
                _item.setResultScoreScaled(_tmpResultScoreScaled);
              }
              if (_cursorIndexOfResultScoreRaw != -1) {
                final long _tmpResultScoreRaw;
                _tmpResultScoreRaw = cursor.getLong(_cursorIndexOfResultScoreRaw);
                _item.setResultScoreRaw(_tmpResultScoreRaw);
              }
              if (_cursorIndexOfResultScoreMin != -1) {
                final long _tmpResultScoreMin;
                _tmpResultScoreMin = cursor.getLong(_cursorIndexOfResultScoreMin);
                _item.setResultScoreMin(_tmpResultScoreMin);
              }
              if (_cursorIndexOfResultScoreMax != -1) {
                final long _tmpResultScoreMax;
                _tmpResultScoreMax = cursor.getLong(_cursorIndexOfResultScoreMax);
                _item.setResultScoreMax(_tmpResultScoreMax);
              }
              if (_cursorIndexOfResultDuration != -1) {
                final long _tmpResultDuration;
                _tmpResultDuration = cursor.getLong(_cursorIndexOfResultDuration);
                _item.setResultDuration(_tmpResultDuration);
              }
              if (_cursorIndexOfResultResponse != -1) {
                final String _tmpResultResponse;
                if (cursor.isNull(_cursorIndexOfResultResponse)) {
                  _tmpResultResponse = null;
                } else {
                  _tmpResultResponse = cursor.getString(_cursorIndexOfResultResponse);
                }
                _item.setResultResponse(_tmpResultResponse);
              }
              if (_cursorIndexOfTimestamp != -1) {
                final long _tmpTimestamp;
                _tmpTimestamp = cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
              }
              if (_cursorIndexOfStored != -1) {
                final long _tmpStored;
                _tmpStored = cursor.getLong(_cursorIndexOfStored);
                _item.setStored(_tmpStored);
              }
              if (_cursorIndexOfContextRegistration != -1) {
                final String _tmpContextRegistration;
                if (cursor.isNull(_cursorIndexOfContextRegistration)) {
                  _tmpContextRegistration = null;
                } else {
                  _tmpContextRegistration = cursor.getString(_cursorIndexOfContextRegistration);
                }
                _item.setContextRegistration(_tmpContextRegistration);
              }
              if (_cursorIndexOfContextPlatform != -1) {
                final String _tmpContextPlatform;
                if (cursor.isNull(_cursorIndexOfContextPlatform)) {
                  _tmpContextPlatform = null;
                } else {
                  _tmpContextPlatform = cursor.getString(_cursorIndexOfContextPlatform);
                }
                _item.setContextPlatform(_tmpContextPlatform);
              }
              if (_cursorIndexOfContextStatementId != -1) {
                final String _tmpContextStatementId;
                if (cursor.isNull(_cursorIndexOfContextStatementId)) {
                  _tmpContextStatementId = null;
                } else {
                  _tmpContextStatementId = cursor.getString(_cursorIndexOfContextStatementId);
                }
                _item.setContextStatementId(_tmpContextStatementId);
              }
              if (_cursorIndexOfFullStatement != -1) {
                final String _tmpFullStatement;
                if (cursor.isNull(_cursorIndexOfFullStatement)) {
                  _tmpFullStatement = null;
                } else {
                  _tmpFullStatement = cursor.getString(_cursorIndexOfFullStatement);
                }
                _item.setFullStatement(_tmpFullStatement);
              }
              if (_cursorIndexOfStatementMasterChangeSeqNum != -1) {
                final long _tmpStatementMasterChangeSeqNum;
                _tmpStatementMasterChangeSeqNum = cursor.getLong(_cursorIndexOfStatementMasterChangeSeqNum);
                _item.setStatementMasterChangeSeqNum(_tmpStatementMasterChangeSeqNum);
              }
              if (_cursorIndexOfStatementLocalChangeSeqNum != -1) {
                final long _tmpStatementLocalChangeSeqNum;
                _tmpStatementLocalChangeSeqNum = cursor.getLong(_cursorIndexOfStatementLocalChangeSeqNum);
                _item.setStatementLocalChangeSeqNum(_tmpStatementLocalChangeSeqNum);
              }
              if (_cursorIndexOfStatementLastChangedBy != -1) {
                final int _tmpStatementLastChangedBy;
                _tmpStatementLastChangedBy = cursor.getInt(_cursorIndexOfStatementLastChangedBy);
                _item.setStatementLastChangedBy(_tmpStatementLastChangedBy);
              }
              if (_cursorIndexOfStatementLct != -1) {
                final long _tmpStatementLct;
                _tmpStatementLct = cursor.getLong(_cursorIndexOfStatementLct);
                _item.setStatementLct(_tmpStatementLct);
              }
              if (_cursorIndexOfExtensionProgress != -1) {
                final int _tmpExtensionProgress;
                _tmpExtensionProgress = cursor.getInt(_cursorIndexOfExtensionProgress);
                _item.setExtensionProgress(_tmpExtensionProgress);
              }
              if (_cursorIndexOfContentEntryRoot != -1) {
                final boolean _tmpContentEntryRoot;
                final int _tmp_3;
                _tmp_3 = cursor.getInt(_cursorIndexOfContentEntryRoot);
                _tmpContentEntryRoot = _tmp_3 != 0;
                _item.setContentEntryRoot(_tmpContentEntryRoot);
              }
              if (_cursorIndexOfStatementContentEntryUid != -1) {
                final long _tmpStatementContentEntryUid;
                _tmpStatementContentEntryUid = cursor.getLong(_cursorIndexOfStatementContentEntryUid);
                _item.setStatementContentEntryUid(_tmpStatementContentEntryUid);
              }
              if (_cursorIndexOfStatementLearnerGroupUid != -1) {
                final long _tmpStatementLearnerGroupUid;
                _tmpStatementLearnerGroupUid = cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
                _item.setStatementLearnerGroupUid(_tmpStatementLearnerGroupUid);
              }
              if (_cursorIndexOfStatementClazzUid != -1) {
                final long _tmpStatementClazzUid;
                _tmpStatementClazzUid = cursor.getLong(_cursorIndexOfStatementClazzUid);
                _item.setStatementClazzUid(_tmpStatementClazzUid);
              }
              _item.setPerson(_tmpPerson);
              _item.setXlangMapEntry(_tmpXlangMapEntry);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
