package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.UserSession;
import com.ustadmobile.lib.db.entities.UserSessionAndPerson;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class UserSessionDao_Impl extends UserSessionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<UserSession> __insertionAdapterOfUserSession;

  private final SharedSQLiteStatement __preparedStmtOfUpdateReplicationTrackers;

  private final SharedSQLiteStatement __preparedStmtOfUpdateReplicationTrackersOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfEndSession;

  private final SharedSQLiteStatement __preparedStmtOfEndOtherSessions;

  public UserSessionDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfUserSession = new EntityInsertionAdapter<UserSession>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `UserSession` (`usUid`,`usPcsn`,`usLcsn`,`usLcb`,`usLct`,`usPersonUid`,`usClientNodeId`,`usStartTime`,`usEndTime`,`usStatus`,`usReason`,`usAuth`,`usSessionType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserSession value) {
        stmt.bindLong(1, value.getUsUid());
        stmt.bindLong(2, value.getUsPcsn());
        stmt.bindLong(3, value.getUsLcsn());
        stmt.bindLong(4, value.getUsLcb());
        stmt.bindLong(5, value.getUsLct());
        stmt.bindLong(6, value.getUsPersonUid());
        stmt.bindLong(7, value.getUsClientNodeId());
        stmt.bindLong(8, value.getUsStartTime());
        stmt.bindLong(9, value.getUsEndTime());
        stmt.bindLong(10, value.getUsStatus());
        stmt.bindLong(11, value.getUsReason());
        if (value.getUsAuth() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getUsAuth());
        }
        stmt.bindLong(13, value.getUsSessionType());
      }
    };
    this.__preparedStmtOfUpdateReplicationTrackers = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO UserSessionReplicate(usPk, usDestination)\n"
                + "         SELECT DISTINCT UserSessionSubject.usUid AS usPk,\n"
                + "                UserSession.usClientNodeId AS usDestination\n"
                + "           FROM ChangeLog\n"
                + "                JOIN UserSession UserSessionSubject\n"
                + "                     ON ChangeLog.chTableId = 679\n"
                + "                        AND ChangeLog.chEntityPk = UserSessionSubject.usUid\n"
                + "                        AND UserSessionSubject.usSessionType = 1\n"
                + "                JOIN Person\n"
                + "                     ON UserSessionSubject.usPersonUid = Person.personUid\n"
                + "                \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    64\n"
                + "                    /* Modify second part of query - remove requirement for session to be active.\n"
                + "                     * This ensures that deactivations are distributed\n"
                + "                     */\n"
                + "                    ) > 0\n"
                + "                     JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                          ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                     JOIN UserSession\n"
                + "                          ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "          WHERE UserSessionSubject.usClientNodeId = UserSessionSubject.usClientNodeId                \n"
                + "          --notpsql              \n"
                + "            AND UserSessionSubject.usLct != COALESCE(\n"
                + "                (SELECT usVersionId\n"
                + "                   FROM UserSessionReplicate\n"
                + "                  WHERE UserSessionReplicate.usPk = UserSessionSubject.usUid\n"
                + "                    AND UserSessionReplicate.usDestination = UserSession.usClientNodeId), 0)\n"
                + "          --endnotpsql                       \n"
                + "        /*psql ON CONFLICT(usPk, usDestination) \n"
                + "                DO UPDATE SET usPending = \n"
                + "                   (SELECT UserSession.usLct\n"
                + "                      FROM UserSession\n"
                + "                     WHERE UserSession.usUid = EXCLUDED.usPk ) \n"
                + "                        != UserSessionReplicate.usVersionId\n"
                + "         */         \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateReplicationTrackersOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO UserSessionReplicate(usPk, usDestination)\n"
                + "         SELECT DISTINCT UserSessionSubject.usUid AS usPk,\n"
                + "                UserSession.usClientNodeId AS usDestination\n"
                + "           FROM UserSession \n"
                + "                JOIN PersonGroupMember\n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "                \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                    64\n"
                + "                    \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "                JOIN UserSession UserSessionSubject\n"
                + "                     ON UserSessionSubject.usPersonUid = Person.personUid\n"
                + "                        AND UserSessionSubject.usSessionType = 1\n"
                + "                        AND UserSessionSubject.usClientNodeId = ?\n"
                + "          WHERE UserSession.usClientNodeId = ?\n"
                + "          --notpsql\n"
                + "            AND UserSessionSubject.usLct != COALESCE(\n"
                + "                (SELECT usVersionId\n"
                + "                   FROM UserSessionReplicate\n"
                + "                  WHERE UserSessionReplicate.usPk = UserSessionSubject.usUid\n"
                + "                    AND UserSessionReplicate.usDestination = UserSession.usClientNodeId), 0)\n"
                + "          --endnotpsql          \n"
                + "         /*psql ON CONFLICT(usPk, usDestination) \n"
                + "                DO UPDATE SET usPending = \n"
                + "                   (SELECT UserSession.usLct\n"
                + "                      FROM UserSession\n"
                + "                     WHERE UserSession.usUid = EXCLUDED.usPk ) \n"
                + "                        != UserSessionReplicate.usVersionId\n"
                + "         */\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfEndSession = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE UserSession\n"
                + "           SET usAuth = null,\n"
                + "               usStatus = ?,\n"
                + "               usReason = ?,\n"
                + "               usLcb = COALESCE(\n"
                + "                               (SELECT nodeClientId\n"
                + "                                  FROM SyncNode\n"
                + "                                 LIMIT 1), 0)\n"
                + "         WHERE UserSession.usUid = ?                        \n"
                + "               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfEndOtherSessions = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE UserSession\n"
                + "           SET usAuth = null,\n"
                + "               usStatus = ?,\n"
                + "               usReason = ?,\n"
                + "               usLct = ?\n"
                + "         WHERE usPersonUid = ?\n"
                + "           AND usClientNodeId != ?\n"
                + "           AND usStatus != ?                     \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertSession(final UserSession session,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfUserSession.insertAndReturnId(session);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateReplicationTrackers(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateReplicationTrackers.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateReplicationTrackers.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateReplicationTrackersOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateReplicationTrackersOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateReplicationTrackersOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object endSession(final long sessionUid, final int newStatus, final int reason,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfEndSession.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newStatus);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, reason);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, sessionUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfEndSession.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object endOtherSessions(final long personUid, final long exemptNodeId, final int newStatus,
      final int reason, final long changeTime, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfEndOtherSessions.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newStatus);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, reason);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, exemptNodeId);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, newStatus);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfEndOtherSessions.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findSessionsByPerson(final long personUid,
      final Continuation<? super List<UserSession>> continuation) {
    final String _sql = "\n"
            + "        SELECT UserSession.*\n"
            + "          FROM UserSession\n"
            + "         WHERE usPersonUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UserSession>>() {
      @Override
      public List<UserSession> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final List<UserSession> _result = new ArrayList<UserSession>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final UserSession _item;
            _item = new UserSession();
            final long _tmpUsUid;
            _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
            _item.setUsUid(_tmpUsUid);
            final long _tmpUsPcsn;
            _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
            _item.setUsPcsn(_tmpUsPcsn);
            final long _tmpUsLcsn;
            _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
            _item.setUsLcsn(_tmpUsLcsn);
            final int _tmpUsLcb;
            _tmpUsLcb = _cursor.getInt(_cursorIndexOfUsLcb);
            _item.setUsLcb(_tmpUsLcb);
            final long _tmpUsLct;
            _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
            _item.setUsLct(_tmpUsLct);
            final long _tmpUsPersonUid;
            _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
            _item.setUsPersonUid(_tmpUsPersonUid);
            final long _tmpUsClientNodeId;
            _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
            _item.setUsClientNodeId(_tmpUsClientNodeId);
            final long _tmpUsStartTime;
            _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
            _item.setUsStartTime(_tmpUsStartTime);
            final long _tmpUsEndTime;
            _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
            _item.setUsEndTime(_tmpUsEndTime);
            final int _tmpUsStatus;
            _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
            _item.setUsStatus(_tmpUsStatus);
            final int _tmpUsReason;
            _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
            _item.setUsReason(_tmpUsReason);
            final String _tmpUsAuth;
            if (_cursor.isNull(_cursorIndexOfUsAuth)) {
              _tmpUsAuth = null;
            } else {
              _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
            }
            _item.setUsAuth(_tmpUsAuth);
            final int _tmpUsSessionType;
            _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
            _item.setUsSessionType(_tmpUsSessionType);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<List<UserSessionAndPerson>> findAllLocalSessionsLive() {
    final String _sql = "\n"
            + "            SELECT UserSession.*, Person.*\n"
            + "              FROM UserSession\n"
            + "                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n"
            + "             WHERE UserSession.usClientNodeId = (\n"
            + "                   SELECT COALESCE(\n"
            + "                          (SELECT nodeClientId \n"
            + "                            FROM SyncNode\n"
            + "                           LIMIT 1), 0))\n"
            + "               AND UserSession.usStatus = 1        \n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[]{"UserSession","Person","SyncNode"}, false, new Callable<List<UserSessionAndPerson>>() {
      @Override
      public List<UserSessionAndPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final List<UserSessionAndPerson> _result = new ArrayList<UserSessionAndPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final UserSessionAndPerson _item;
            final UserSession _tmpUserSession;
            if (! (_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
              _tmpUserSession = new UserSession();
              final long _tmpUsUid;
              _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
              _tmpUserSession.setUsUid(_tmpUsUid);
              final long _tmpUsPcsn;
              _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
              _tmpUserSession.setUsPcsn(_tmpUsPcsn);
              final long _tmpUsLcsn;
              _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
              _tmpUserSession.setUsLcsn(_tmpUsLcsn);
              final int _tmpUsLcb;
              _tmpUsLcb = _cursor.getInt(_cursorIndexOfUsLcb);
              _tmpUserSession.setUsLcb(_tmpUsLcb);
              final long _tmpUsLct;
              _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
              _tmpUserSession.setUsLct(_tmpUsLct);
              final long _tmpUsPersonUid;
              _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
              _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
              final long _tmpUsClientNodeId;
              _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
              _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
              final long _tmpUsStartTime;
              _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
              _tmpUserSession.setUsStartTime(_tmpUsStartTime);
              final long _tmpUsEndTime;
              _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
              _tmpUserSession.setUsEndTime(_tmpUsEndTime);
              final int _tmpUsStatus;
              _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
              _tmpUserSession.setUsStatus(_tmpUsStatus);
              final int _tmpUsReason;
              _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
              _tmpUserSession.setUsReason(_tmpUsReason);
              final String _tmpUsAuth;
              if (_cursor.isNull(_cursorIndexOfUsAuth)) {
                _tmpUsAuth = null;
              } else {
                _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
              }
              _tmpUserSession.setUsAuth(_tmpUsAuth);
              final int _tmpUsSessionType;
              _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
              _tmpUserSession.setUsSessionType(_tmpUsSessionType);
            }  else  {
              _tmpUserSession = null;
            }
            final Person _tmpPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpPerson = null;
            }
            _item = new UserSessionAndPerson();
            _item.setUserSession(_tmpUserSession);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findAllLocalSessionsAsync(
      final Continuation<? super List<UserSessionAndPerson>> continuation) {
    final String _sql = "\n"
            + "            SELECT UserSession.*, Person.*\n"
            + "              FROM UserSession\n"
            + "                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n"
            + "             WHERE UserSession.usClientNodeId = (\n"
            + "                   SELECT COALESCE(\n"
            + "                          (SELECT nodeClientId \n"
            + "                            FROM SyncNode\n"
            + "                           LIMIT 1), 0))\n"
            + "               AND UserSession.usStatus = 1        \n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UserSessionAndPerson>>() {
      @Override
      public List<UserSessionAndPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final List<UserSessionAndPerson> _result = new ArrayList<UserSessionAndPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final UserSessionAndPerson _item;
            final UserSession _tmpUserSession;
            if (! (_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
              _tmpUserSession = new UserSession();
              final long _tmpUsUid;
              _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
              _tmpUserSession.setUsUid(_tmpUsUid);
              final long _tmpUsPcsn;
              _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
              _tmpUserSession.setUsPcsn(_tmpUsPcsn);
              final long _tmpUsLcsn;
              _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
              _tmpUserSession.setUsLcsn(_tmpUsLcsn);
              final int _tmpUsLcb;
              _tmpUsLcb = _cursor.getInt(_cursorIndexOfUsLcb);
              _tmpUserSession.setUsLcb(_tmpUsLcb);
              final long _tmpUsLct;
              _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
              _tmpUserSession.setUsLct(_tmpUsLct);
              final long _tmpUsPersonUid;
              _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
              _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
              final long _tmpUsClientNodeId;
              _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
              _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
              final long _tmpUsStartTime;
              _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
              _tmpUserSession.setUsStartTime(_tmpUsStartTime);
              final long _tmpUsEndTime;
              _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
              _tmpUserSession.setUsEndTime(_tmpUsEndTime);
              final int _tmpUsStatus;
              _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
              _tmpUserSession.setUsStatus(_tmpUsStatus);
              final int _tmpUsReason;
              _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
              _tmpUserSession.setUsReason(_tmpUsReason);
              final String _tmpUsAuth;
              if (_cursor.isNull(_cursorIndexOfUsAuth)) {
                _tmpUsAuth = null;
              } else {
                _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
              }
              _tmpUserSession.setUsAuth(_tmpUsAuth);
              final int _tmpUsSessionType;
              _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
              _tmpUserSession.setUsSessionType(_tmpUsSessionType);
            }  else  {
              _tmpUserSession = null;
            }
            final Person _tmpPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpPerson = null;
            }
            _item = new UserSessionAndPerson();
            _item.setUserSession(_tmpUserSession);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object countAllLocalSessionsAsync(final long maxDateOfBirth,
      final Continuation<? super Integer> continuation) {
    final String _sql = "\n"
            + "        SELECT COUNT(*)\n"
            + "          FROM UserSession\n"
            + "               JOIN Person \n"
            + "                    ON UserSession.usPersonUid = Person.personUid\n"
            + "         WHERE UserSession.usClientNodeId = (\n"
            + "                   SELECT COALESCE(\n"
            + "                          (SELECT nodeClientId \n"
            + "                            FROM SyncNode\n"
            + "                           LIMIT 1), 0))\n"
            + "           AND UserSession.usStatus = 1                \n"
            + "           AND (? = 0 OR Person.dateOfBirth < ?)                 \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, maxDateOfBirth);
    _argIndex = 2;
    _statement.bindLong(_argIndex, maxDateOfBirth);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<UserSession> findByUidLive(final long sessionUid) {
    final String _sql = "\n"
            + "        SELECT UserSession.*\n"
            + "          FROM UserSession\n"
            + "         WHERE UserSession.usUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, sessionUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"UserSession"}, false, new Callable<UserSession>() {
      @Override
      public UserSession call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final UserSession _result;
          if(_cursor.moveToFirst()) {
            _result = new UserSession();
            final long _tmpUsUid;
            _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
            _result.setUsUid(_tmpUsUid);
            final long _tmpUsPcsn;
            _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
            _result.setUsPcsn(_tmpUsPcsn);
            final long _tmpUsLcsn;
            _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
            _result.setUsLcsn(_tmpUsLcsn);
            final int _tmpUsLcb;
            _tmpUsLcb = _cursor.getInt(_cursorIndexOfUsLcb);
            _result.setUsLcb(_tmpUsLcb);
            final long _tmpUsLct;
            _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
            _result.setUsLct(_tmpUsLct);
            final long _tmpUsPersonUid;
            _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
            _result.setUsPersonUid(_tmpUsPersonUid);
            final long _tmpUsClientNodeId;
            _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
            _result.setUsClientNodeId(_tmpUsClientNodeId);
            final long _tmpUsStartTime;
            _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
            _result.setUsStartTime(_tmpUsStartTime);
            final long _tmpUsEndTime;
            _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
            _result.setUsEndTime(_tmpUsEndTime);
            final int _tmpUsStatus;
            _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
            _result.setUsStatus(_tmpUsStatus);
            final int _tmpUsReason;
            _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
            _result.setUsReason(_tmpUsReason);
            final String _tmpUsAuth;
            if (_cursor.isNull(_cursorIndexOfUsAuth)) {
              _tmpUsAuth = null;
            } else {
              _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
            }
            _result.setUsAuth(_tmpUsAuth);
            final int _tmpUsSessionType;
            _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
            _result.setUsSessionType(_tmpUsSessionType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findActiveNodeIdsByPersonUids(final List<Long> personUids,
      final Continuation<? super List<Long>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT DISTINCT UserSession.usClientNodeId");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM UserSession");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE UserSession.usPersonUid IN (");
    final int _inputSize = personUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND UserSession.usStatus = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : personUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findActiveNodesIdsByGroupUids(final List<Long> groupUids,
      final Continuation<? super List<Long>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT DISTINCT UserSession.usClientNodeId");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM UserSession");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN PersonGroupMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON PersonGroupMember.groupMemberPersonUid = UserSession.usPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE PersonGroupMember.groupMemberGroupUid IN (");
    final int _inputSize = groupUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")            ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : groupUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllActiveNodeIdsWithClazzBasedPermission(final List<Long> clazzUids,
      final Continuation<? super List<Long>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT UserSession.usClientNodeId");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM ScopedGrant");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN PersonGroupMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON PersonGroupMember.groupMemberGroupUid = ScopedGrant.sgGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN UserSession");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE (ScopedGrant.sgTableId = 6 AND ScopedGrant.sgEntityUid IN (");
    final int _inputSize = clazzUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append("))");
    _stringBuilder.append("\n");
    _stringBuilder.append("            OR (ScopedGrant.sgTableId = 164 AND ScopedGrant.sgEntityUid IN ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                (SELECT clazzSchoolUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   FROM Clazz");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  WHERE clazzUid IN (");
    final int _inputSize_1 = clazzUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize_1);
    _stringBuilder.append(")))");
    _stringBuilder.append("\n");
    _stringBuilder.append("          ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize + _inputSize_1;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : clazzUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    _argIndex = 1 + _inputSize;
    for (long _item_1 : clazzUids) {
      _statement.bindLong(_argIndex, _item_1);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Long _item_2;
            _item_2 = _cursor.getLong(0);
            _result.add(_item_2);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllActiveNodeIdsWithSchoolBasedPermission(final List<Long> schoolUids,
      final Continuation<? super List<Long>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT UserSession.usClientNodeId");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM ScopedGrant");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN PersonGroupMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON PersonGroupMember.groupMemberGroupUid = ScopedGrant.sgGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN UserSession");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE ScopedGrant.sgTableId = 164 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ScopedGrant.sgEntityUid IN (");
    final int _inputSize = schoolUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(") ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : schoolUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
