package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.XObjectEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class XObjectDao_Impl extends XObjectDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<XObjectEntity> __insertionAdapterOfXObjectEntity;

  private final EntityDeletionOrUpdateAdapter<XObjectEntity> __updateAdapterOfXObjectEntity;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public XObjectDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfXObjectEntity = new EntityInsertionAdapter<XObjectEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `XObjectEntity` (`xObjectUid`,`objectType`,`objectId`,`definitionType`,`interactionType`,`correctResponsePattern`,`objectContentEntryUid`,`objectStatementRefUid`,`xObjectMasterChangeSeqNum`,`xObjectocalChangeSeqNum`,`xObjectLastChangedBy`,`xObjectLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, XObjectEntity value) {
        stmt.bindLong(1, value.getXObjectUid());
        if (value.getObjectType() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getObjectType());
        }
        if (value.getObjectId() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getObjectId());
        }
        if (value.getDefinitionType() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDefinitionType());
        }
        if (value.getInteractionType() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getInteractionType());
        }
        if (value.getCorrectResponsePattern() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCorrectResponsePattern());
        }
        stmt.bindLong(7, value.getObjectContentEntryUid());
        stmt.bindLong(8, value.getObjectStatementRefUid());
        stmt.bindLong(9, value.getXObjectMasterChangeSeqNum());
        stmt.bindLong(10, value.getXObjectocalChangeSeqNum());
        stmt.bindLong(11, value.getXObjectLastChangedBy());
        stmt.bindLong(12, value.getXObjectLct());
      }
    };
    this.__updateAdapterOfXObjectEntity = new EntityDeletionOrUpdateAdapter<XObjectEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `XObjectEntity` SET `xObjectUid` = ?,`objectType` = ?,`objectId` = ?,`definitionType` = ?,`interactionType` = ?,`correctResponsePattern` = ?,`objectContentEntryUid` = ?,`objectStatementRefUid` = ?,`xObjectMasterChangeSeqNum` = ?,`xObjectocalChangeSeqNum` = ?,`xObjectLastChangedBy` = ?,`xObjectLct` = ? WHERE `xObjectUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, XObjectEntity value) {
        stmt.bindLong(1, value.getXObjectUid());
        if (value.getObjectType() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getObjectType());
        }
        if (value.getObjectId() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getObjectId());
        }
        if (value.getDefinitionType() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDefinitionType());
        }
        if (value.getInteractionType() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getInteractionType());
        }
        if (value.getCorrectResponsePattern() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getCorrectResponsePattern());
        }
        stmt.bindLong(7, value.getObjectContentEntryUid());
        stmt.bindLong(8, value.getObjectStatementRefUid());
        stmt.bindLong(9, value.getXObjectMasterChangeSeqNum());
        stmt.bindLong(10, value.getXObjectocalChangeSeqNum());
        stmt.bindLong(11, value.getXObjectLastChangedBy());
        stmt.bindLong(12, value.getXObjectLct());
        stmt.bindLong(13, value.getXObjectUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO XObjectEntityReplicate(xoePk, xoeDestination)\n"
                + "      SELECT DISTINCT XObjectEntity.xObjectUid AS xoePk,\n"
                + "             ? AS xoeDestination\n"
                + "        FROM XObjectEntity\n"
                + "       WHERE XObjectEntity.xObjectLct != COALESCE(\n"
                + "             (SELECT xoeVersionId\n"
                + "                FROM XObjectEntityReplicate\n"
                + "               WHERE xoePk = XObjectEntity.xObjectUid\n"
                + "                 AND xoeDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(xoePk, xoeDestination) DO UPDATE\n"
                + "             SET xoePending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO XObjectEntityReplicate(xoePk, xoeDestination)\n"
                + "  SELECT DISTINCT XObjectEntity.xObjectUid AS xoeUid,\n"
                + "         UserSession.usClientNodeId AS xoeDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN XObjectEntity\n"
                + "             ON ChangeLog.chTableId = 64\n"
                + "                AND ChangeLog.chEntityPk = XObjectEntity.xObjectUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND XObjectEntity.xObjectLct != COALESCE(\n"
                + "         (SELECT xoeVersionId\n"
                + "            FROM XObjectEntityReplicate\n"
                + "           WHERE xoePk = XObjectEntity.xObjectUid\n"
                + "             AND xoeDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(xoePk, xoeDestination) DO UPDATE\n"
                + "     SET xoePending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final XObjectEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfXObjectEntity.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final XObjectEntity entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfXObjectEntity.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends XObjectEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfXObjectEntity.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends XObjectEntity> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfXObjectEntity.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final XObjectEntity entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfXObjectEntity.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public XObjectEntity findByObjectId(final String id) {
    final String _sql = "SELECT * from XObjectEntity WHERE objectId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (id == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, id);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectUid");
      final int _cursorIndexOfObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "objectType");
      final int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow(_cursor, "objectId");
      final int _cursorIndexOfDefinitionType = CursorUtil.getColumnIndexOrThrow(_cursor, "definitionType");
      final int _cursorIndexOfInteractionType = CursorUtil.getColumnIndexOrThrow(_cursor, "interactionType");
      final int _cursorIndexOfCorrectResponsePattern = CursorUtil.getColumnIndexOrThrow(_cursor, "correctResponsePattern");
      final int _cursorIndexOfObjectContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectContentEntryUid");
      final int _cursorIndexOfObjectStatementRefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectStatementRefUid");
      final int _cursorIndexOfXObjectMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectMasterChangeSeqNum");
      final int _cursorIndexOfXObjectocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectocalChangeSeqNum");
      final int _cursorIndexOfXObjectLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectLastChangedBy");
      final int _cursorIndexOfXObjectLct = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectLct");
      final XObjectEntity _result;
      if(_cursor.moveToFirst()) {
        _result = new XObjectEntity();
        final long _tmpXObjectUid;
        _tmpXObjectUid = _cursor.getLong(_cursorIndexOfXObjectUid);
        _result.setXObjectUid(_tmpXObjectUid);
        final String _tmpObjectType;
        if (_cursor.isNull(_cursorIndexOfObjectType)) {
          _tmpObjectType = null;
        } else {
          _tmpObjectType = _cursor.getString(_cursorIndexOfObjectType);
        }
        _result.setObjectType(_tmpObjectType);
        final String _tmpObjectId;
        if (_cursor.isNull(_cursorIndexOfObjectId)) {
          _tmpObjectId = null;
        } else {
          _tmpObjectId = _cursor.getString(_cursorIndexOfObjectId);
        }
        _result.setObjectId(_tmpObjectId);
        final String _tmpDefinitionType;
        if (_cursor.isNull(_cursorIndexOfDefinitionType)) {
          _tmpDefinitionType = null;
        } else {
          _tmpDefinitionType = _cursor.getString(_cursorIndexOfDefinitionType);
        }
        _result.setDefinitionType(_tmpDefinitionType);
        final String _tmpInteractionType;
        if (_cursor.isNull(_cursorIndexOfInteractionType)) {
          _tmpInteractionType = null;
        } else {
          _tmpInteractionType = _cursor.getString(_cursorIndexOfInteractionType);
        }
        _result.setInteractionType(_tmpInteractionType);
        final String _tmpCorrectResponsePattern;
        if (_cursor.isNull(_cursorIndexOfCorrectResponsePattern)) {
          _tmpCorrectResponsePattern = null;
        } else {
          _tmpCorrectResponsePattern = _cursor.getString(_cursorIndexOfCorrectResponsePattern);
        }
        _result.setCorrectResponsePattern(_tmpCorrectResponsePattern);
        final long _tmpObjectContentEntryUid;
        _tmpObjectContentEntryUid = _cursor.getLong(_cursorIndexOfObjectContentEntryUid);
        _result.setObjectContentEntryUid(_tmpObjectContentEntryUid);
        final long _tmpObjectStatementRefUid;
        _tmpObjectStatementRefUid = _cursor.getLong(_cursorIndexOfObjectStatementRefUid);
        _result.setObjectStatementRefUid(_tmpObjectStatementRefUid);
        final long _tmpXObjectMasterChangeSeqNum;
        _tmpXObjectMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfXObjectMasterChangeSeqNum);
        _result.setXObjectMasterChangeSeqNum(_tmpXObjectMasterChangeSeqNum);
        final long _tmpXObjectocalChangeSeqNum;
        _tmpXObjectocalChangeSeqNum = _cursor.getLong(_cursorIndexOfXObjectocalChangeSeqNum);
        _result.setXObjectocalChangeSeqNum(_tmpXObjectocalChangeSeqNum);
        final int _tmpXObjectLastChangedBy;
        _tmpXObjectLastChangedBy = _cursor.getInt(_cursorIndexOfXObjectLastChangedBy);
        _result.setXObjectLastChangedBy(_tmpXObjectLastChangedBy);
        final long _tmpXObjectLct;
        _tmpXObjectLct = _cursor.getLong(_cursorIndexOfXObjectLct);
        _result.setXObjectLct(_tmpXObjectLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public XObjectEntity findByXobjectUid(final long xObjectUid) {
    final String _sql = "SELECT * from XObjectEntity WHERE xObjectUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, xObjectUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectUid");
      final int _cursorIndexOfObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "objectType");
      final int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow(_cursor, "objectId");
      final int _cursorIndexOfDefinitionType = CursorUtil.getColumnIndexOrThrow(_cursor, "definitionType");
      final int _cursorIndexOfInteractionType = CursorUtil.getColumnIndexOrThrow(_cursor, "interactionType");
      final int _cursorIndexOfCorrectResponsePattern = CursorUtil.getColumnIndexOrThrow(_cursor, "correctResponsePattern");
      final int _cursorIndexOfObjectContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectContentEntryUid");
      final int _cursorIndexOfObjectStatementRefUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectStatementRefUid");
      final int _cursorIndexOfXObjectMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectMasterChangeSeqNum");
      final int _cursorIndexOfXObjectocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectocalChangeSeqNum");
      final int _cursorIndexOfXObjectLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectLastChangedBy");
      final int _cursorIndexOfXObjectLct = CursorUtil.getColumnIndexOrThrow(_cursor, "xObjectLct");
      final XObjectEntity _result;
      if(_cursor.moveToFirst()) {
        _result = new XObjectEntity();
        final long _tmpXObjectUid;
        _tmpXObjectUid = _cursor.getLong(_cursorIndexOfXObjectUid);
        _result.setXObjectUid(_tmpXObjectUid);
        final String _tmpObjectType;
        if (_cursor.isNull(_cursorIndexOfObjectType)) {
          _tmpObjectType = null;
        } else {
          _tmpObjectType = _cursor.getString(_cursorIndexOfObjectType);
        }
        _result.setObjectType(_tmpObjectType);
        final String _tmpObjectId;
        if (_cursor.isNull(_cursorIndexOfObjectId)) {
          _tmpObjectId = null;
        } else {
          _tmpObjectId = _cursor.getString(_cursorIndexOfObjectId);
        }
        _result.setObjectId(_tmpObjectId);
        final String _tmpDefinitionType;
        if (_cursor.isNull(_cursorIndexOfDefinitionType)) {
          _tmpDefinitionType = null;
        } else {
          _tmpDefinitionType = _cursor.getString(_cursorIndexOfDefinitionType);
        }
        _result.setDefinitionType(_tmpDefinitionType);
        final String _tmpInteractionType;
        if (_cursor.isNull(_cursorIndexOfInteractionType)) {
          _tmpInteractionType = null;
        } else {
          _tmpInteractionType = _cursor.getString(_cursorIndexOfInteractionType);
        }
        _result.setInteractionType(_tmpInteractionType);
        final String _tmpCorrectResponsePattern;
        if (_cursor.isNull(_cursorIndexOfCorrectResponsePattern)) {
          _tmpCorrectResponsePattern = null;
        } else {
          _tmpCorrectResponsePattern = _cursor.getString(_cursorIndexOfCorrectResponsePattern);
        }
        _result.setCorrectResponsePattern(_tmpCorrectResponsePattern);
        final long _tmpObjectContentEntryUid;
        _tmpObjectContentEntryUid = _cursor.getLong(_cursorIndexOfObjectContentEntryUid);
        _result.setObjectContentEntryUid(_tmpObjectContentEntryUid);
        final long _tmpObjectStatementRefUid;
        _tmpObjectStatementRefUid = _cursor.getLong(_cursorIndexOfObjectStatementRefUid);
        _result.setObjectStatementRefUid(_tmpObjectStatementRefUid);
        final long _tmpXObjectMasterChangeSeqNum;
        _tmpXObjectMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfXObjectMasterChangeSeqNum);
        _result.setXObjectMasterChangeSeqNum(_tmpXObjectMasterChangeSeqNum);
        final long _tmpXObjectocalChangeSeqNum;
        _tmpXObjectocalChangeSeqNum = _cursor.getLong(_cursorIndexOfXObjectocalChangeSeqNum);
        _result.setXObjectocalChangeSeqNum(_tmpXObjectocalChangeSeqNum);
        final int _tmpXObjectLastChangedBy;
        _tmpXObjectLastChangedBy = _cursor.getInt(_cursorIndexOfXObjectLastChangedBy);
        _result.setXObjectLastChangedBy(_tmpXObjectLastChangedBy);
        final long _tmpXObjectLct;
        _tmpXObjectLct = _cursor.getLong(_cursorIndexOfXObjectLct);
        _result.setXObjectLct(_tmpXObjectLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
