package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContentCategory
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class ContentCategoryDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContentCategoryDao,
) : ContentCategoryDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun publicContentCategories(): List<ContentCategory> =
      _dao.publicContentCategories()

  public override fun findCategoryBySchemaIdAndName(schemaId: Long, name: String): ContentCategory?
      = _dao.findCategoryBySchemaIdAndName(schemaId, name)

  public override fun insert(entity: ContentCategory): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.contentCategoryUid == 0L) {
      val _newPk = _pkManager.nextId(1)
      entity.contentCategoryUid = _newPk
    }
    entity.contentCategoryLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.contentCategoryUid
  }

  public override suspend fun insertAsync(entity: ContentCategory): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.contentCategoryUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(1)
      entity.contentCategoryUid = _newPk
    }
    entity.contentCategoryLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.contentCategoryUid
  }

  public override fun insertList(entityList: List<ContentCategory>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.contentCategoryUid == 0L) {
        val _newPk = _pkManager.nextId(1)
        it.contentCategoryUid = _newPk
        _generatedPks += _newPk
      }
      it.contentCategoryLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ContentCategory>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.contentCategoryLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: ContentCategory): Unit {
    entity.contentCategoryLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
