package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.CoursePicture
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class CoursePictureDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: CoursePictureDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : CoursePictureDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend fun findByClazzUidAsync(clazzUid: Long): CoursePicture? {
    val _result = _dao.findByClazzUidAsync(clazzUid)
    return _result
  }

  public override fun findByClazzUidLive(clazzUid: Long): LiveData<CoursePicture?> {
    val _result = _dao.findByClazzUidLive(clazzUid)
    return _result
  }

  public override suspend fun updateAsync(coursePicture: CoursePicture): Unit {
    _dao.updateAsync(coursePicture)
  }

  public override fun insert(entity: CoursePicture): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: CoursePicture): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<CoursePicture>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<CoursePicture>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: CoursePicture): Unit {
    _dao.update(entity)
  }
}
