package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.GroupLearningSession
import kotlin.Long
import kotlin.Unit

@Dao
public actual abstract class GroupLearningSessionDao : BaseDao<GroupLearningSession> {
  @Query(`value` =
      "\n     REPLACE INTO GroupLearningSessionReplicate(glsPk, glsDestination)\n      SELECT DISTINCT GroupLearningSession.groupLearningSessionUid AS glsPk,\n             :newNodeId AS glsDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                  64\n                  \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN LearnerGroupMember\n                  ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid\n             JOIN GroupLearningSession\n                  ON GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND GroupLearningSession.groupLearningSessionLct != COALESCE(\n             (SELECT glsVersionId\n                FROM GroupLearningSessionReplicate\n               WHERE glsPk = GroupLearningSession.groupLearningSessionUid\n                 AND glsDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(glsPk, glsDestination) DO UPDATE\n             SET glsPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO GroupLearningSessionReplicate(glsPk, glsDestination)\n  SELECT DISTINCT GroupLearningSession.groupLearningSessionUid AS glsUid,\n         UserSession.usClientNodeId AS glsDestination\n    FROM ChangeLog\n         JOIN GroupLearningSession\n              ON ChangeLog.chTableId = 302\n                 AND ChangeLog.chEntityPk = GroupLearningSession.groupLearningSessionUid\n         JOIN LearnerGroupMember\n              ON LearnerGroupMember.learnerGroupMemberLgUid = GroupLearningSession.groupLearningSessionLearnerGroupUid\n         JOIN Person\n              ON Person.personUid = LearnerGroupMember.learnerGroupMemberPersonUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND GroupLearningSession.groupLearningSessionLct != COALESCE(\n         (SELECT glsVersionId\n            FROM GroupLearningSessionReplicate\n           WHERE glsPk = GroupLearningSession.groupLearningSessionUid\n             AND glsDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(glsPk, glsDestination) DO UPDATE\n     SET glsPending = true\n  */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit
}
