package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.LanguageVariant
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class LanguageVariantDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: LanguageVariantDao,
) : LanguageVariantDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findByCode(countryCode: String): LanguageVariant? =
      _dao.findByCode(countryCode)

  public override fun insert(entity: LanguageVariant): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.langVariantUid == 0L) {
      val _newPk = _pkManager.nextId(10)
      entity.langVariantUid = _newPk
    }
    entity.langVariantLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.langVariantUid
  }

  public override suspend fun insertAsync(entity: LanguageVariant): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.langVariantUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(10)
      entity.langVariantUid = _newPk
    }
    entity.langVariantLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.langVariantUid
  }

  public override fun insertList(entityList: List<LanguageVariant>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.langVariantUid == 0L) {
        val _newPk = _pkManager.nextId(10)
        it.langVariantUid = _newPk
        _generatedPks += _newPk
      }
      it.langVariantLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<LanguageVariant>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.langVariantLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: LanguageVariant): Unit {
    entity.langVariantLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
