package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.LearnerGroupMember
import com.ustadmobile.lib.db.entities.LearnerGroupMemberWithPerson
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class LearnerGroupMemberDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: LearnerGroupMemberDao,
) : LearnerGroupMemberDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findLearnerGroupMembersByGroupIdAndEntry(learnerGroupUid: Long,
      contentEntryUid: Long): DataSource.Factory<Int, LearnerGroupMemberWithPerson> =
      _dao.findLearnerGroupMembersByGroupIdAndEntry(learnerGroupUid, contentEntryUid)

  public override suspend fun findLearnerGroupMembersByGroupIdAndEntryList(learnerGroupUid: Long,
      contentEntryUid: Long): List<LearnerGroupMemberWithPerson> =
      _dao.findLearnerGroupMembersByGroupIdAndEntryList(learnerGroupUid, contentEntryUid)

  public override fun insert(entity: LearnerGroupMember): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.learnerGroupMemberUid == 0L) {
      val _newPk = _pkManager.nextId(300)
      entity.learnerGroupMemberUid = _newPk
    }
    entity.learnerGroupMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.learnerGroupMemberUid
  }

  public override suspend fun insertAsync(entity: LearnerGroupMember): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.learnerGroupMemberUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(300)
      entity.learnerGroupMemberUid = _newPk
    }
    entity.learnerGroupMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.learnerGroupMemberUid
  }

  public override fun insertList(entityList: List<LearnerGroupMember>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.learnerGroupMemberUid == 0L) {
        val _newPk = _pkManager.nextId(300)
        it.learnerGroupMemberUid = _newPk
        _generatedPks += _newPk
      }
      it.learnerGroupMemberLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<LearnerGroupMember>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.learnerGroupMemberLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: LearnerGroupMember): Unit {
    entity.learnerGroupMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
