package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.LocallyAvailableContainer
import kotlin.Unit
import kotlin.collections.List

@Dao
public actual abstract class LocallyAvailableContainerDao {
  @Insert(onConflict = 1)
  public actual abstract suspend
      fun insertList(locallyAvailableContainers: List<LocallyAvailableContainer>): Unit

  @Delete
  public actual abstract suspend
      fun deleteList(locallyAvailableContainers: List<LocallyAvailableContainer>): Unit

  @Query(`value` = "DELETE FROM LocallyAvailableContainer")
  public actual abstract fun deleteAll(): Unit
}
