package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.MessageRead
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class MessageReadDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: MessageReadDao,
) : MessageReadDao() {
  public override suspend fun replicateOnNewNodeChats(newNodeId: Long): Unit {
    _dao.replicateOnNewNodeChats(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun insert(entity: MessageRead): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.messageReadUid == 0L) {
      val _newPk = _pkManager.nextId(129)
      entity.messageReadUid = _newPk
    }
    entity.messageReadLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.messageReadUid
  }

  public override suspend fun insertAsync(entity: MessageRead): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.messageReadUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(129)
      entity.messageReadUid = _newPk
    }
    entity.messageReadLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.messageReadUid
  }

  public override fun insertList(entityList: List<MessageRead>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.messageReadUid == 0L) {
        val _newPk = _pkManager.nextId(129)
        it.messageReadUid = _newPk
        _generatedPks += _newPk
      }
      it.messageReadLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<MessageRead>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.messageReadLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: MessageRead): Unit {
    entity.messageReadLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
