package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.PersonPicture
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class PersonPictureDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: PersonPictureDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : PersonPictureDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend fun findByPersonUidAsync(personUid: Long): PersonPicture? {
    val _result = _dao.findByPersonUidAsync(personUid)
    return _result
  }

  public override fun findByPersonUidLive(personUid: Long): LiveData<PersonPicture?> {
    val _result = _dao.findByPersonUidLive(personUid)
    return _result
  }

  public override suspend fun updateAsync(personPicture: PersonPicture): Unit {
    _dao.updateAsync(personPicture)
  }

  public override fun insert(entity: PersonPicture): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: PersonPicture): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<PersonPicture>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<PersonPicture>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: PersonPicture): Unit {
    _dao.update(entity)
  }
}
