package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.StateContentEntity
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class StateContentDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: StateContentDao,
) : StateContentDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findAllStateContentWithStateUid(id: Long): List<StateContentEntity> =
      _dao.findAllStateContentWithStateUid(id)

  public override fun findStateContentByKeyAndStateUid(key: String, stateUid: Long):
      StateContentEntity? = _dao.findStateContentByKeyAndStateUid(key, stateUid)

  public override fun setInActiveStateContentByKeyAndUid(
    isActive: Boolean,
    stateUid: Long,
    updateTime: Long,
  ): Unit {
    _dao.setInActiveStateContentByKeyAndUid(isActive, stateUid, updateTime)
  }

  public override fun insert(entity: StateContentEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.stateContentUid == 0L) {
      val _newPk = _pkManager.nextId(72)
      entity.stateContentUid = _newPk
    }
    entity.stateContentLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.stateContentUid
  }

  public override suspend fun insertAsync(entity: StateContentEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.stateContentUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(72)
      entity.stateContentUid = _newPk
    }
    entity.stateContentLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.stateContentUid
  }

  public override fun insertList(entityList: List<StateContentEntity>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.stateContentUid == 0L) {
        val _newPk = _pkManager.nextId(72)
        it.stateContentUid = _newPk
        _generatedPks += _newPk
      }
      it.stateContentLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<StateContentEntity>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.stateContentLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: StateContentEntity): Unit {
    entity.stateContentLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
