package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.XObjectEntity
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class XObjectDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: XObjectDao,
) : XObjectDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findByObjectId(id: String?): XObjectEntity? = _dao.findByObjectId(id)

  public override fun findByXobjectUid(xObjectUid: Long): XObjectEntity? =
      _dao.findByXobjectUid(xObjectUid)

  public override fun insert(entity: XObjectEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.xObjectUid == 0L) {
      val _newPk = _pkManager.nextId(64)
      entity.xObjectUid = _newPk
    }
    entity.xObjectLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.xObjectUid
  }

  public override suspend fun insertAsync(entity: XObjectEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.xObjectUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(64)
      entity.xObjectUid = _newPk
    }
    entity.xObjectLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.xObjectUid
  }

  public override fun insertList(entityList: List<XObjectEntity>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.xObjectUid == 0L) {
        val _newPk = _pkManager.nextId(64)
        it.xObjectUid = _newPk
        _generatedPks += _newPk
      }
      it.xObjectLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<XObjectEntity>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.xObjectLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: XObjectEntity): Unit {
    entity.xObjectLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
