(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-coroutines-core', 'door-door-runtime-js-legacy', 'xmlpullparserkmp-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-coroutines-core'), require('door-door-runtime-js-legacy'), require('xmlpullparserkmp-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'UstadMobile-lib-util'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'UstadMobile-lib-util'.");
    }
    if (typeof this['door-door-runtime-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'door-door-runtime-js-legacy' was not found. Please, check whether 'door-door-runtime-js-legacy' is loaded prior to 'UstadMobile-lib-util'.");
    }
    if (typeof this['xmlpullparserkmp-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'UstadMobile-lib-util'. Its dependency 'xmlpullparserkmp-js-legacy' was not found. Please, check whether 'xmlpullparserkmp-js-legacy' is loaded prior to 'UstadMobile-lib-util'.");
    }
    root['UstadMobile-lib-util'] = factory(typeof this['UstadMobile-lib-util'] === 'undefined' ? {} : this['UstadMobile-lib-util'], kotlin, this['kotlinx-coroutines-core'], this['door-door-runtime-js-legacy'], this['xmlpullparserkmp-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kotlinx_coroutines_core, $module$door_door_runtime_js_legacy, $module$xmlpullparserkmp_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var Unit = Kotlin.kotlin.Unit;
  var Observer = $module$door_door_runtime_js_legacy.com.ustadmobile.door.lifecycle.Observer;
  var withTimeoutOrNull = $module$kotlinx_coroutines_core.kotlinx.coroutines.withTimeoutOrNull_ms3uf5$;
  var L5000 = Kotlin.Long.fromInt(5000);
  var CompletableDeferred = $module$kotlinx_coroutines_core.kotlinx.coroutines.CompletableDeferred_xptg6w$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var split = Kotlin.kotlin.text.split_ip8yn$;
  var substringBefore = Kotlin.kotlin.text.substringBefore_8cymmc$;
  var substringAfter = Kotlin.kotlin.text.substringAfter_j4ogox$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var Random = Kotlin.kotlin.random.Random;
  var toBoxedChar = Kotlin.toBoxedChar;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var L_1 = Kotlin.Long.NEG_ONE;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var L0 = Kotlin.Long.ZERO;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var toLong = Kotlin.kotlin.text.toLong_pdl1vz$;
  var equals = Kotlin.equals;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var Exception = Kotlin.kotlin.Exception;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var removePrefix = Kotlin.kotlin.text.removePrefix_gsj5wt$;
  var xmlpullparserkmp = $module$xmlpullparserkmp_js_legacy.com.ustadmobile.xmlpullparserkmp;
  var toString = Kotlin.toString;
  var contains = Kotlin.kotlin.collections.contains_mjy6jw$;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var mutableListOf = Kotlin.kotlin.collections.mutableListOf_i5x0yv$;
  var mutableMapOf = Kotlin.kotlin.collections.mutableMapOf_qfcya0$;
  function waitForLiveData$lambda(closure$checker, closure$channel) {
    return function (t) {
      if (closure$checker(t))
        closure$channel.trySend_11rb$(t);
      return Unit;
    };
  }
  function Coroutine$waitForLiveData$lambda(closure$channel_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$channel = closure$channel_0;
  }
  Coroutine$waitForLiveData$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$waitForLiveData$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$waitForLiveData$lambda.prototype.constructor = Coroutine$waitForLiveData$lambda;
  Coroutine$waitForLiveData$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$channel.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function waitForLiveData$lambda_0(closure$channel_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$waitForLiveData$lambda(closure$channel_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$waitForLiveData(liveData_0, timeout_0, checker_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$channel = void 0;
    this.local$observerFn = void 0;
    this.local$liveData = liveData_0;
    this.local$timeout = timeout_0;
    this.local$checker = checker_0;
  }
  Coroutine$waitForLiveData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$waitForLiveData.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$waitForLiveData.prototype.constructor = Coroutine$waitForLiveData;
  Coroutine$waitForLiveData.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$channel = Channel(1);
            this.local$observerFn = new Observer(waitForLiveData$lambda(this.local$checker, this.local$channel));
            this.local$liveData.observeForever_fujmse$(this.local$observerFn);
            this.state_0 = 2;
            this.result_0 = withTimeoutOrNull(this.local$timeout, waitForLiveData$lambda_0(this.local$channel), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$liveData.removeObserver_fujmse$(this.local$observerFn);
            this.local$channel.close_dbl4no$();
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function waitForLiveData(liveData_0, timeout_0, checker_0, continuation_0, suspended) {
    var instance = new Coroutine$waitForLiveData(liveData_0, timeout_0, checker_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function waitUntil$lambda(closure$checker, closure$completableDeferred) {
    return function (t) {
      if (closure$checker(t))
        closure$completableDeferred.complete_11rb$(t);
      return Unit;
    };
  }
  function Coroutine$waitUntil$lambda(closure$completableDeferred_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$completableDeferred = closure$completableDeferred_0;
  }
  Coroutine$waitUntil$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$waitUntil$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$waitUntil$lambda.prototype.constructor = Coroutine$waitUntil$lambda;
  Coroutine$waitUntil$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$completableDeferred.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function waitUntil$lambda_0(closure$completableDeferred_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$waitUntil$lambda(closure$completableDeferred_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$waitUntil($receiver_0, timeout_0, checker_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$observerFn = void 0;
    this.local$$receiver = $receiver_0;
    this.local$timeout = timeout_0;
    this.local$checker = checker_0;
  }
  Coroutine$waitUntil.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$waitUntil.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$waitUntil.prototype.constructor = Coroutine$waitUntil;
  Coroutine$waitUntil.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$timeout === void 0)
              this.local$timeout = L5000;
            var completableDeferred = CompletableDeferred();
            this.local$observerFn = new Observer(waitUntil$lambda(this.local$checker, completableDeferred));
            this.local$$receiver.observeForever_fujmse$(this.local$observerFn);
            this.state_0 = 2;
            this.result_0 = withTimeoutOrNull(this.local$timeout, waitUntil$lambda_0(completableDeferred), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$$receiver.removeObserver_fujmse$(this.local$observerFn);
            return this.local$$receiver;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function waitUntil($receiver_0, timeout_0, checker_0, continuation_0, suspended) {
    var instance = new Coroutine$waitUntil($receiver_0, timeout_0, checker_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function UmLiveData() {
  }
  UmLiveData.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'UmLiveData',
    interfaces: []
  };
  function UmObserver() {
  }
  UmObserver.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'UmObserver',
    interfaces: []
  };
  function UmProvider() {
  }
  UmProvider.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'UmProvider',
    interfaces: []
  };
  function UtilPojo(someUid, name) {
    this.someUid = someUid;
    this.name = name;
  }
  UtilPojo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UtilPojo',
    interfaces: []
  };
  UtilPojo.prototype.component1 = function () {
    return this.someUid;
  };
  UtilPojo.prototype.component2 = function () {
    return this.name;
  };
  UtilPojo.prototype.copy_19mbxw$ = function (someUid, name) {
    return new UtilPojo(someUid === void 0 ? this.someUid : someUid, name === void 0 ? this.name : name);
  };
  UtilPojo.prototype.toString = function () {
    return 'UtilPojo(someUid=' + Kotlin.toString(this.someUid) + (', name=' + Kotlin.toString(this.name)) + ')';
  };
  UtilPojo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.someUid) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  UtilPojo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.someUid, other.someUid) && Kotlin.equals(this.name, other.name)))));
  };
  function UmLifecycleListener() {
  }
  UmLifecycleListener.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'UmLifecycleListener',
    interfaces: []
  };
  function UmLifecycleOwner() {
    UmLifecycleOwner$Companion_getInstance();
  }
  function UmLifecycleOwner$Companion() {
    UmLifecycleOwner$Companion_instance = this;
    this.STATUS_CREATED = 1;
    this.STATUS_STARTED = 2;
    this.STATUS_RESUMED = 3;
    this.STATUS_PAUSED = 4;
    this.STATUS_STOPPED = 5;
    this.STATUS_DESTROYED = 6;
  }
  UmLifecycleOwner$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UmLifecycleOwner$Companion_instance = null;
  function UmLifecycleOwner$Companion_getInstance() {
    if (UmLifecycleOwner$Companion_instance === null) {
      new UmLifecycleOwner$Companion();
    }
    return UmLifecycleOwner$Companion_instance;
  }
  UmLifecycleOwner.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'UmLifecycleOwner',
    interfaces: []
  };
  function AcceptEncodingHeader(acceptableEncodings) {
    this.acceptableEncodings = acceptableEncodings;
  }
  AcceptEncodingHeader.prototype.isEncodingAcceptable_61zpoe$ = function (encodingName) {
    var tmp$, tmp$_0;
    return ((tmp$ = this.acceptableEncodings.get_11rb$(encodingName)) != null ? tmp$ : 0.0) > 0.0 || ((tmp$_0 = this.acceptableEncodings.get_11rb$('*')) != null ? tmp$_0 : 0.0) > 0.0;
  };
  AcceptEncodingHeader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AcceptEncodingHeader',
    interfaces: []
  };
  function parseAcceptedEncoding(acceptEncodingHeader) {
    var $receiver = split(acceptEncodingHeader != null ? acceptEncodingHeader : '*', [',']);
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var $receiver_0 = substringBefore(item, 59);
      var tmp$_1;
      tmp$_0.call(destination, to(trim(Kotlin.isCharSequence(tmp$_1 = $receiver_0) ? tmp$_1 : throwCCE()).toString(), toDouble(substringAfter(substringAfter(item, ';', 'q=1'), 'q='))));
    }
    var acceptedEncodingsMap = toMap(destination);
    return new AcceptEncodingHeader(acceptedEncodingsMap);
  }
  var sumByLong = defineInlineFunction('UstadMobile-lib-util.com.ustadmobile.lib.util.sumByLong_8a1mrt$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    return function ($receiver, selector) {
      var tmp$;
      var sum = L0;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        sum = sum.add(selector(element));
      }
      return sum;
    };
  }));
  var CHAR_POOL_DEFAULT;
  function randomString(length, charPool) {
    if (charPool === void 0)
      charPool = CHAR_POOL_DEFAULT;
    var $receiver = new IntRange(1, length);
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(toBoxedChar(charPool.charCodeAt(Random.Default.nextInt_vux9f0$(0, charPool.length))));
    }
    return joinToString(destination, '');
  }
  function RangeResponse(statusCode, fromByte, toByte, actualContentLength, responseHeaders) {
    this.statusCode = statusCode;
    this.fromByte = fromByte;
    this.toByte = toByte;
    this.actualContentLength = actualContentLength;
    this.responseHeaders = responseHeaders;
  }
  RangeResponse.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RangeResponse',
    interfaces: []
  };
  RangeResponse.prototype.component1 = function () {
    return this.statusCode;
  };
  RangeResponse.prototype.component2 = function () {
    return this.fromByte;
  };
  RangeResponse.prototype.component3 = function () {
    return this.toByte;
  };
  RangeResponse.prototype.component4 = function () {
    return this.actualContentLength;
  };
  RangeResponse.prototype.component5 = function () {
    return this.responseHeaders;
  };
  RangeResponse.prototype.copy_nu9wkq$ = function (statusCode, fromByte, toByte, actualContentLength, responseHeaders) {
    return new RangeResponse(statusCode === void 0 ? this.statusCode : statusCode, fromByte === void 0 ? this.fromByte : fromByte, toByte === void 0 ? this.toByte : toByte, actualContentLength === void 0 ? this.actualContentLength : actualContentLength, responseHeaders === void 0 ? this.responseHeaders : responseHeaders);
  };
  RangeResponse.prototype.toString = function () {
    return 'RangeResponse(statusCode=' + Kotlin.toString(this.statusCode) + (', fromByte=' + Kotlin.toString(this.fromByte)) + (', toByte=' + Kotlin.toString(this.toByte)) + (', actualContentLength=' + Kotlin.toString(this.actualContentLength)) + (', responseHeaders=' + Kotlin.toString(this.responseHeaders)) + ')';
  };
  RangeResponse.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.statusCode) | 0;
    result = result * 31 + Kotlin.hashCode(this.fromByte) | 0;
    result = result * 31 + Kotlin.hashCode(this.toByte) | 0;
    result = result * 31 + Kotlin.hashCode(this.actualContentLength) | 0;
    result = result * 31 + Kotlin.hashCode(this.responseHeaders) | 0;
    return result;
  };
  RangeResponse.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.statusCode, other.statusCode) && Kotlin.equals(this.fromByte, other.fromByte) && Kotlin.equals(this.toByte, other.toByte) && Kotlin.equals(this.actualContentLength, other.actualContentLength) && Kotlin.equals(this.responseHeaders, other.responseHeaders)))));
  };
  var RANGE_CONTENT_LENGTH_HEADER;
  var RANGE_CONTENT_RANGE_HEADER;
  var RANGE_CONTENT_ACCEPT_RANGE_HEADER;
  function parseRangeRequestHeader(rangeHeader, totalLength) {
    var fromByte = L_1;
    var toByte = L_1;
    var statusCode = 0;
    var responseHeaders = emptyMap();
    var actualContentLength = L0;
    try {
      var header = rangeHeader.substring(6);
      var dashPos = indexOf(header, 45);
      if (dashPos > 0) {
        fromByte = toLong(header.substring(0, dashPos));
      }
      if (dashPos === (header.length - 1 | 0)) {
        toByte = totalLength.subtract(Kotlin.Long.fromInt(1));
      } else if (dashPos > 0) {
        var startIndex = dashPos + 1 | 0;
        toByte = toLong(header.substring(startIndex));
      }
      if (equals(fromByte, L_1) || equals(toByte, L_1)) {
        statusCode = 400;
      } else if (fromByte.toNumber() >= 0 && fromByte.compareTo_11rb$(totalLength) < 0 && toByte.toNumber() > 0 && toByte.compareTo_11rb$(totalLength) <= 0) {
        actualContentLength = toByte.add(Kotlin.Long.fromInt(1)).subtract(fromByte);
        responseHeaders = mapOf([to(RANGE_CONTENT_LENGTH_HEADER, actualContentLength.toString()), to(RANGE_CONTENT_RANGE_HEADER, 'bytes ' + fromByte.toString() + '-' + toByte.toString() + '/' + totalLength.toString()), to(RANGE_CONTENT_ACCEPT_RANGE_HEADER, 'bytes')]);
        statusCode = 206;
      } else {
        statusCode = 416;
      }
    } catch (e) {
      if (Kotlin.isType(e, Exception)) {
        statusCode = 400;
      } else
        throw e;
    }
    return new RangeResponse(statusCode, fromByte, toByte, actualContentLength, responseHeaders);
  }
  function RunWhenReadyManager(isReady) {
    if (isReady === void 0)
      isReady = false;
    this.ready_t50ktj$_0 = false;
    this.ready = isReady;
    this.pendingBlocks_0 = ArrayList_init_0();
  }
  Object.defineProperty(RunWhenReadyManager.prototype, 'ready', {
    configurable: true,
    get: function () {
      return this.ready_t50ktj$_0;
    },
    set: function (value) {
      this.ready_t50ktj$_0 = value;
      if (value) {
        var tmp$;
        tmp$ = this.pendingBlocks_0.iterator();
        while (tmp$.hasNext()) {
          var element = tmp$.next();
          element();
        }
        this.pendingBlocks_0.clear();
      }
    }
  });
  RunWhenReadyManager.prototype.runWhenReady_o14v8n$ = function (block) {
    if (this.ready) {
      block();
    } else {
      this.pendingBlocks_0.add_11rb$(block);
    }
  };
  RunWhenReadyManager.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RunWhenReadyManager',
    interfaces: []
  };
  var sanitizeRegex;
  function sanitizeDbNameFromUrl(url) {
    var $receiver = removePrefix(removePrefix(url, 'https://'), 'http://');
    return sanitizeRegex.replace_x2uqeu$($receiver, '_');
  }
  function ContainerFilesWithContentEntry() {
    this.containerUid = L0;
    this.containerEntryFileUid = L0;
    this.containerEntryFilePath = null;
    this.contentEntryTitle = null;
    this.contentEntryDesc = null;
    this.contentEntryId = null;
  }
  ContainerFilesWithContentEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ContainerFilesWithContentEntry',
    interfaces: []
  };
  var SEPARATE_END_TAG_REQUIRED_ELEMENTS;
  function XmlSerializerFilter() {
  }
  XmlSerializerFilter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'XmlSerializerFilter',
    interfaces: []
  };
  function serializeTo($receiver, xmlSerializer, inclusive, filter, separateEndTagRequiredElements) {
    if (inclusive === void 0)
      inclusive = true;
    if (filter === void 0)
      filter = null;
    if (separateEndTagRequiredElements === void 0)
      separateEndTagRequiredElements = SEPARATE_END_TAG_REQUIRED_ELEMENTS;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    var evtType = $receiver.getEventType();
    var lastEvent = -1;
    var tagName;
    var endTagName = null;
    var endDepth = -1;
    if (evtType === 2) {
      endTagName = $receiver.getName();
      endDepth = $receiver.getDepth();
    }
    if (!inclusive)
      evtType = $receiver.nextToken();
    do {
      if (filter != null && !filter.beforePassthrough_1mfj68$(evtType, $receiver, xmlSerializer)) {
        lastEvent = evtType;
        evtType = $receiver.nextToken();
        continue;
      }
      switch (evtType) {
        case 10:
          if ((tmp$ = $receiver.getText()) != null) {
            xmlSerializer.docdecl_61zpoe$(tmp$);
          }

          break;
        case 0:
          xmlSerializer.startDocument_ivxn3r$($receiver.getInputEncoding(), (tmp$_1 = typeof (tmp$_0 = $receiver.getProperty_61zpoe$(xmlpullparserkmp.XmlPullParserConstants.PROPERTY_STANDALONE)) === 'boolean' ? tmp$_0 : null) != null ? tmp$_1 : false);
          break;
        case 2:
          tmp$_2 = $receiver.getNamespaceCount_za3lpa$($receiver.getDepth() - 1 | 0);
          tmp$_3 = $receiver.getNamespaceCount_za3lpa$($receiver.getDepth());
          for (var i = tmp$_2; i < tmp$_3; i++) {
            var prefix = $receiver.getNamespacePrefix_za3lpa$(i);
            var nsUri = $receiver.getNamespaceUri_za3lpa$(i);
            if (xmlSerializer.getPrefix_4mavae$(nsUri, false) == null) {
              xmlSerializer.setPrefix_puj7f4$(prefix != null ? prefix : '', nsUri);
            }
          }

          xmlSerializer.startTag_f5e6j7$($receiver.getNamespace(), toString($receiver.getName()));
          tmp$_4 = $receiver.getAttributeCount();
          for (var i_0 = 0; i_0 < tmp$_4; i_0++) {
            xmlSerializer.attribute_kunee3$($receiver.getAttributeNamespace_za3lpa$(i_0), $receiver.getAttributeName_za3lpa$(i_0), $receiver.getAttributeValue_za3lpa$(i_0));
          }

          break;
        case 4:
          xmlSerializer.text_61zpoe$(toString($receiver.getText()));
          break;
        case 5:
          xmlSerializer.cdsect_61zpoe$(toString($receiver.getText()));
          break;
        case 3:
          tagName = toString($receiver.getName());
          var isEndTag = $receiver.getDepth() === endDepth && equals(tagName, endTagName);
          if (isEndTag && !inclusive)
            return;
          if (lastEvent === 2 && contains(separateEndTagRequiredElements, tagName)) {
            xmlSerializer.text_61zpoe$(' ');
          }

          xmlSerializer.endTag_f5e6j7$($receiver.getNamespace(), tagName);
          if (isEndTag)
            return;
          break;
      }
      if (filter != null && !filter.afterPassthrough_1mfj68$(evtType, $receiver, xmlSerializer))
        return;
      lastEvent = evtType;
      evtType = $receiver.nextToken();
    }
     while (evtType !== 1);
    xmlSerializer.flush();
  }
  function dumpException(e) {
    console.error(e);
  }
  function authenticateEncryptedPassword(providedPassword, encryptedPassword) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'not implemented');
  }
  function encryptPassword(originalPassword) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'not implemented');
  }
  function getSystemTimeInMillis() {
    return Kotlin.Long.fromNumber((new Date()).getTime());
  }
  function getDefaultTimeZoneId() {
    var tmp$;
    return typeof (tmp$ = Intl.DateTimeFormat().resolvedOptions().timeZone) === 'string' ? tmp$ : throwCCE();
  }
  function copyOnWriteListOf(items) {
    return mutableListOf(items.slice());
  }
  function sharedMutableMapOf(pairs) {
    return mutableMapOf(pairs.slice());
  }
  function fixTincan($receiver) {
  }
  var package$com = _.com || (_.com = {});
  var package$ustadmobile = package$com.ustadmobile || (package$com.ustadmobile = {});
  var package$core = package$ustadmobile.core || (package$ustadmobile.core = {});
  var package$db = package$core.db || (package$core.db = {});
  package$db.waitForLiveData_qbhq6e$ = waitForLiveData;
  package$db.waitUntil_82zpj1$ = waitUntil;
  package$db.UmLiveData = UmLiveData;
  package$db.UmObserver = UmObserver;
  package$db.UmProvider = UmProvider;
  package$db.UtilPojo = UtilPojo;
  var package$impl = package$core.impl || (package$core.impl = {});
  package$impl.UmLifecycleListener = UmLifecycleListener;
  Object.defineProperty(UmLifecycleOwner, 'Companion', {
    get: UmLifecycleOwner$Companion_getInstance
  });
  package$impl.UmLifecycleOwner = UmLifecycleOwner;
  var package$lib = package$ustadmobile.lib || (package$ustadmobile.lib = {});
  var package$util = package$lib.util || (package$lib.util = {});
  package$util.AcceptEncodingHeader = AcceptEncodingHeader;
  package$util.parseAcceptedEncoding_pdl1vj$ = parseAcceptedEncoding;
  $$importsForInline$$['UstadMobile-lib-util'] = _;
  package$util.sumByLong_8a1mrt$ = sumByLong;
  package$util.randomString_19mbxw$ = randomString;
  package$util.RangeResponse = RangeResponse;
  Object.defineProperty(package$util, 'RANGE_CONTENT_LENGTH_HEADER', {
    get: function () {
      return RANGE_CONTENT_LENGTH_HEADER;
    }
  });
  Object.defineProperty(package$util, 'RANGE_CONTENT_RANGE_HEADER', {
    get: function () {
      return RANGE_CONTENT_RANGE_HEADER;
    }
  });
  Object.defineProperty(package$util, 'RANGE_CONTENT_ACCEPT_RANGE_HEADER', {
    get: function () {
      return RANGE_CONTENT_ACCEPT_RANGE_HEADER;
    }
  });
  package$util.parseRangeRequestHeader_4wgjuj$ = parseRangeRequestHeader;
  package$util.RunWhenReadyManager = RunWhenReadyManager;
  package$util.sanitizeDbNameFromUrl_61zpoe$ = sanitizeDbNameFromUrl;
  var package$ext = package$util.ext || (package$util.ext = {});
  package$ext.ContainerFilesWithContentEntry = ContainerFilesWithContentEntry;
  package$ext.XmlSerializerFilter = XmlSerializerFilter;
  package$ext.serializeTo_61lhlc$ = serializeTo;
  package$impl.dumpException_tcv7n7$ = dumpException;
  package$util.authenticateEncryptedPassword_puj7f4$ = authenticateEncryptedPassword;
  package$util.encryptPassword_61zpoe$ = encryptPassword;
  package$util.getSystemTimeInMillis = getSystemTimeInMillis;
  package$util.getDefaultTimeZoneId = getDefaultTimeZoneId;
  package$util.copyOnWriteListOf_i5x0yv$ = copyOnWriteListOf;
  package$util.sharedMutableMapOf_qfcya0$ = sharedMutableMapOf;
  package$ext.fixTincan_omobsc$ = fixTincan;
  CHAR_POOL_DEFAULT = 'abcdefghikjmnpqrstuvxwyz23456789';
  RANGE_CONTENT_LENGTH_HEADER = 'Content-Length';
  RANGE_CONTENT_RANGE_HEADER = 'Content-Range';
  RANGE_CONTENT_ACCEPT_RANGE_HEADER = 'Accept-Ranges';
  sanitizeRegex = Regex_init('\\W');
  SEPARATE_END_TAG_REQUIRED_ELEMENTS = ['script', 'style', 'title'];
  Kotlin.defineModule('UstadMobile-lib-util', _);
  return _;
}));

//# sourceMappingURL=UstadMobile-lib-util.js.map
