/*
 * Decompiled with CFR 0.152.
 */
package com.eygraber.uri.uris;

import com.eygraber.uri.PathSegments;
import com.eygraber.uri.Uri;
import com.eygraber.uri.parts.Part;
import com.eygraber.uri.parts.PathPart;
import com.eygraber.uri.uris.AbstractHierarchicalUri;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 T2\u00020\u0001:\u0001TB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010M\u001a\u00020\u00102\b\u0010N\u001a\u0004\u0018\u00010OH\u0096\u0002J\b\u0010P\u001a\u00020\u0007H\u0016J\b\u0010Q\u001a\u00020\u0003H\u0016J\b\u0010R\u001a\u00020SH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u000f\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0013\u0010\u0011R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000b\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0016\u0010 \u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u001b\u0010\"\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000b\u001a\u0004\b#\u0010\u001cR\u001d\u0010%\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000b\u001a\u0004\b&\u0010\u0017R\u001d\u0010(\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u000b\u001a\u0004\b)\u0010\u0017R\u001b\u0010+\u001a\u00020,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u000b\u001a\u0004\b-\u0010.R\u001d\u00100\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u000b\u001a\u0004\b1\u0010\u0017R\u001d\u00103\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u000b\u001a\u0004\b4\u0010\u0017R!\u00106\u001a\b\u0012\u0004\u0012\u00020\u0003078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u000b\u001a\u0004\b8\u00109R\u001b\u0010;\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u000b\u001a\u0004\b<\u0010\u001cR\u001d\u0010>\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u000b\u001a\u0004\b?\u0010\u0017R\u001d\u0010A\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010\u000b\u001a\u0004\bB\u0010\u0017R\u001b\u0010D\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010\u000b\u001a\u0004\bE\u0010\u001cR\u001d\u0010G\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010\u000b\u001a\u0004\bH\u0010\u0017R\u001d\u0010J\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u0010\u000b\u001a\u0004\bK\u0010\u0017\u00a8\u0006U"}, d2={"Lcom/eygraber/uri/uris/StringUri;", "Lcom/eygraber/uri/uris/AbstractHierarchicalUri;", "uriString", "", "<init>", "(Ljava/lang/String;)V", "cachedSsi", "", "getCachedSsi", "()I", "cachedSsi$delegate", "Lkotlin/Lazy;", "cachedFsi", "getCachedFsi", "cachedFsi$delegate", "isHierarchical", "", "()Z", "isHierarchical$delegate", "isRelative", "isRelative$delegate", "scheme", "getScheme", "()Ljava/lang/String;", "scheme$delegate", "ssp", "Lcom/eygraber/uri/parts/Part;", "getSsp", "()Lcom/eygraber/uri/parts/Part;", "ssp$delegate", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "schemeSpecificPart", "getSchemeSpecificPart", "authorityPart", "getAuthorityPart", "authorityPart$delegate", "authority", "getAuthority", "authority$delegate", "encodedAuthority", "getEncodedAuthority", "encodedAuthority$delegate", "pathPart", "Lcom/eygraber/uri/parts/PathPart;", "getPathPart", "()Lcom/eygraber/uri/parts/PathPart;", "pathPart$delegate", "path", "getPath", "path$delegate", "encodedPath", "getEncodedPath", "encodedPath$delegate", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "pathSegments$delegate", "queryPart", "getQueryPart", "queryPart$delegate", "query", "getQuery", "query$delegate", "encodedQuery", "getEncodedQuery", "encodedQuery$delegate", "fragmentPart", "getFragmentPart", "fragmentPart$delegate", "fragment", "getFragment", "fragment$delegate", "encodedFragment", "getEncodedFragment", "encodedFragment$delegate", "equals", "other", "", "hashCode", "toString", "buildUpon", "Lcom/eygraber/uri/Uri$Builder;", "Companion", "uri"})
public final class StringUri
extends AbstractHierarchicalUri {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uriString;
    @NotNull
    private final Lazy cachedSsi$delegate;
    @NotNull
    private final Lazy cachedFsi$delegate;
    @NotNull
    private final Lazy isHierarchical$delegate;
    @NotNull
    private final Lazy isRelative$delegate;
    @NotNull
    private final Lazy scheme$delegate;
    @NotNull
    private final Lazy ssp$delegate;
    @NotNull
    private final Lazy authorityPart$delegate;
    @NotNull
    private final Lazy authority$delegate;
    @NotNull
    private final Lazy encodedAuthority$delegate;
    @NotNull
    private final Lazy pathPart$delegate;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final Lazy encodedPath$delegate;
    @NotNull
    private final Lazy pathSegments$delegate;
    @NotNull
    private final Lazy queryPart$delegate;
    @NotNull
    private final Lazy query$delegate;
    @NotNull
    private final Lazy encodedQuery$delegate;
    @NotNull
    private final Lazy fragmentPart$delegate;
    @NotNull
    private final Lazy fragment$delegate;
    @NotNull
    private final Lazy encodedFragment$delegate;

    public StringUri(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        this.uriString = uriString;
        this.cachedSsi$delegate = LazyKt.lazy(() -> StringUri.cachedSsi_delegate$lambda$0(this));
        this.cachedFsi$delegate = LazyKt.lazy(() -> StringUri.cachedFsi_delegate$lambda$1(this));
        this.isHierarchical$delegate = LazyKt.lazy(() -> StringUri.isHierarchical_delegate$lambda$2(this));
        this.isRelative$delegate = LazyKt.lazy(() -> StringUri.isRelative_delegate$lambda$3(this));
        this.scheme$delegate = LazyKt.lazy(() -> StringUri.scheme_delegate$lambda$4(this));
        this.ssp$delegate = LazyKt.lazy(() -> StringUri.ssp_delegate$lambda$5(this));
        this.authorityPart$delegate = LazyKt.lazy(() -> StringUri.authorityPart_delegate$lambda$6(this));
        this.authority$delegate = LazyKt.lazy(() -> StringUri.authority_delegate$lambda$7(this));
        this.encodedAuthority$delegate = LazyKt.lazy(() -> StringUri.encodedAuthority_delegate$lambda$8(this));
        this.pathPart$delegate = LazyKt.lazy(() -> StringUri.pathPart_delegate$lambda$9(this));
        this.path$delegate = LazyKt.lazy(() -> StringUri.path_delegate$lambda$10(this));
        this.encodedPath$delegate = LazyKt.lazy(() -> StringUri.encodedPath_delegate$lambda$11(this));
        this.pathSegments$delegate = LazyKt.lazy(() -> StringUri.pathSegments_delegate$lambda$12(this));
        this.queryPart$delegate = LazyKt.lazy(() -> StringUri.queryPart_delegate$lambda$13(this));
        this.query$delegate = LazyKt.lazy(() -> StringUri.query_delegate$lambda$14(this));
        this.encodedQuery$delegate = LazyKt.lazy(() -> StringUri.encodedQuery_delegate$lambda$15(this));
        this.fragmentPart$delegate = LazyKt.lazy(() -> StringUri.fragmentPart_delegate$lambda$16(this));
        this.fragment$delegate = LazyKt.lazy(() -> StringUri.fragment_delegate$lambda$17(this));
        this.encodedFragment$delegate = LazyKt.lazy(() -> StringUri.encodedFragment_delegate$lambda$18(this));
    }

    private final int getCachedSsi() {
        Lazy lazy = this.cachedSsi$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int getCachedFsi() {
        Lazy lazy = this.cachedFsi$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public boolean isHierarchical() {
        Lazy lazy = this.isHierarchical$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean isRelative() {
        Lazy lazy = this.isRelative$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @Nullable
    public String getScheme() {
        Lazy lazy = this.scheme$delegate;
        return (String)lazy.getValue();
    }

    private final Part getSsp() {
        Lazy lazy = this.ssp$delegate;
        return (Part)lazy.getValue();
    }

    @Override
    @Nullable
    public String getEncodedSchemeSpecificPart() {
        return this.getSsp().getEncoded();
    }

    @Override
    @Nullable
    public String getSchemeSpecificPart() {
        return this.getSsp().getDecoded();
    }

    private final Part getAuthorityPart() {
        Lazy lazy = this.authorityPart$delegate;
        return (Part)lazy.getValue();
    }

    @Override
    @Nullable
    public String getAuthority() {
        Lazy lazy = this.authority$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getEncodedAuthority() {
        Lazy lazy = this.encodedAuthority$delegate;
        return (String)lazy.getValue();
    }

    private final PathPart getPathPart() {
        Lazy lazy = this.pathPart$delegate;
        return (PathPart)lazy.getValue();
    }

    @Override
    @Nullable
    public String getPath() {
        Lazy lazy = this.path$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getEncodedPath() {
        Lazy lazy = this.encodedPath$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public List<String> getPathSegments() {
        Lazy lazy = this.pathSegments$delegate;
        return (List)lazy.getValue();
    }

    private final Part getQueryPart() {
        Lazy lazy = this.queryPart$delegate;
        return (Part)lazy.getValue();
    }

    @Override
    @Nullable
    public String getQuery() {
        Lazy lazy = this.query$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getEncodedQuery() {
        Lazy lazy = this.encodedQuery$delegate;
        return (String)lazy.getValue();
    }

    private final Part getFragmentPart() {
        Lazy lazy = this.fragmentPart$delegate;
        return (Part)lazy.getValue();
    }

    @Override
    @Nullable
    public String getFragment() {
        Lazy lazy = this.fragment$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getEncodedFragment() {
        Lazy lazy = this.encodedFragment$delegate;
        return (String)lazy.getValue();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Uri && Intrinsics.areEqual((Object)this.toString(), (Object)other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @NotNull
    public String toString() {
        return this.uriString;
    }

    @Override
    @NotNull
    public Uri.Builder buildUpon() {
        return this.isHierarchical() ? new Uri.Builder().scheme(this.getScheme()).authority$uri(this.getAuthorityPart()).path$uri(this.getPathPart()).query$uri(this.getQueryPart()).fragment$uri(this.getFragmentPart()) : new Uri.Builder().scheme(this.getScheme()).opaquePart$uri(this.getSsp()).fragment$uri(this.getFragmentPart());
    }

    private static final int cachedSsi_delegate$lambda$0(StringUri this$0) {
        return StringsKt.indexOf$default((CharSequence)this$0.uriString, (char)':', (int)0, (boolean)false, (int)6, null);
    }

    private static final int cachedFsi_delegate$lambda$1(StringUri this$0) {
        return StringsKt.indexOf$default((CharSequence)this$0.uriString, (char)'#', (int)this$0.getCachedSsi(), (boolean)false, (int)4, null);
    }

    private static final boolean isHierarchical_delegate$lambda$2(StringUri this$0) {
        int ssi = this$0.getCachedSsi();
        return ssi == -1 ? true : (this$0.uriString.length() == ssi + 1 ? false : this$0.uriString.charAt(ssi + 1) == '/');
    }

    private static final boolean isRelative_delegate$lambda$3(StringUri this$0) {
        return this$0.getCachedSsi() == -1;
    }

    private static final String scheme_delegate$lambda$4(StringUri this$0) {
        String string;
        int ssi = this$0.getCachedSsi();
        if (ssi == -1) {
            string = null;
        } else {
            String string2 = this$0.uriString.substring(0, ssi);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    private static final Part ssp_delegate$lambda$5(StringUri this$0) {
        String string;
        int ssi = this$0.getCachedSsi();
        int fsi = this$0.getCachedFsi();
        if (fsi == -1) {
            String string2 = this$0.uriString.substring(ssi + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String string3 = this$0.uriString.substring(ssi + 1, fsi);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        return Part.Companion.fromEncoded(string);
    }

    private static final Part authorityPart_delegate$lambda$6(StringUri this$0) {
        String encodedAuthority = Companion.parseAuthority(this$0.uriString, this$0.getCachedSsi());
        return Part.Companion.fromEncoded(encodedAuthority);
    }

    private static final String authority_delegate$lambda$7(StringUri this$0) {
        return this$0.getAuthorityPart().getDecoded();
    }

    private static final String encodedAuthority_delegate$lambda$8(StringUri this$0) {
        return this$0.getAuthorityPart().getEncoded();
    }

    private static final PathPart pathPart_delegate$lambda$9(StringUri this$0) {
        Object object;
        int ssi = this$0.getCachedSsi();
        if (ssi > -1) {
            boolean schemeOnly = ssi + 1 == this$0.uriString.length();
            object = schemeOnly ? null : (this$0.uriString.charAt(ssi + 1) != '/' ? null : Companion.parsePath(this$0.uriString, ssi));
        } else {
            object = Companion.parsePath(this$0.uriString, ssi);
        }
        String encoded = object;
        return PathPart.Companion.fromEncoded(encoded);
    }

    private static final String path_delegate$lambda$10(StringUri this$0) {
        return this$0.getPathPart().getDecoded();
    }

    private static final String encodedPath_delegate$lambda$11(StringUri this$0) {
        return this$0.getPathPart().getEncoded();
    }

    private static final PathSegments pathSegments_delegate$lambda$12(StringUri this$0) {
        return this$0.getPathPart().getPathSegments();
    }

    private static final Part queryPart_delegate$lambda$13(StringUri this$0) {
        String string;
        int qsi = StringsKt.indexOf$default((CharSequence)this$0.uriString, (char)'?', (int)this$0.getCachedSsi(), (boolean)false, (int)4, null);
        if (qsi == -1) {
            string = null;
        } else {
            int fsi = this$0.getCachedFsi();
            if (fsi == -1) {
                String string2 = this$0.uriString.substring(qsi + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else if (fsi < qsi) {
                string = null;
            } else {
                String string3 = this$0.uriString.substring(qsi + 1, fsi);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
        }
        String encoded = string;
        return Part.Companion.fromEncoded(encoded);
    }

    private static final String query_delegate$lambda$14(StringUri this$0) {
        return this$0.getQueryPart().getDecoded();
    }

    private static final String encodedQuery_delegate$lambda$15(StringUri this$0) {
        return this$0.getQueryPart().getEncoded();
    }

    private static final Part fragmentPart_delegate$lambda$16(StringUri this$0) {
        String string;
        int fsi = this$0.getCachedFsi();
        if (fsi == -1) {
            string = null;
        } else {
            String string2 = this$0.uriString.substring(fsi + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return Part.Companion.fromEncoded(string);
    }

    private static final String fragment_delegate$lambda$17(StringUri this$0) {
        return this$0.getFragmentPart().getDecoded();
    }

    private static final String encodedFragment_delegate$lambda$18(StringUri this$0) {
        return this$0.getFragmentPart().getEncoded();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/eygraber/uri/uris/StringUri$Companion;", "", "<init>", "()V", "parseAuthority", "", "uriString", "ssi", "", "parsePath", "uri"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String parseAuthority(@NotNull String uriString, int ssi) {
            String string;
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            int length = uriString.length();
            if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                int end;
                block6: for (end = ssi + 3; end < length; ++end) {
                    char c = uriString.charAt(end);
                    switch (c) {
                        case '/': 
                        case '\\': {
                            break block6;
                        }
                        default: {
                            switch (c) {
                                case '#': 
                                case '?': {
                                    break block6;
                                }
                            }
                            continue block6;
                        }
                    }
                }
                String string2 = uriString.substring(ssi + 3, end);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = null;
            }
            return string;
        }

        @NotNull
        public final String parsePath(@NotNull String uriString, int ssi) {
            int pathEnd;
            int pathStart;
            int length;
            block13: {
                Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
                length = uriString.length();
                pathStart = 0;
                if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                    pathStart = ssi + 3;
                    while (pathStart < length) {
                        char c = uriString.charAt(pathStart);
                        switch (c) {
                            case '#': 
                            case '?': {
                                return "";
                            }
                        }
                        switch (c) {
                            case '/': 
                            case '\\': {
                                break block13;
                            }
                            default: {
                                ++pathStart;
                                break;
                            }
                        }
                    }
                } else {
                    pathStart = ssi + 1;
                }
            }
            block10: for (pathEnd = pathStart; pathEnd < length; ++pathEnd) {
                char c = uriString.charAt(pathEnd);
                switch (c) {
                    case '#': 
                    case '?': {
                        break block10;
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            String string = uriString.substring(pathStart, pathEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

