/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.node.DepthSortedSetsForDifferentPasses;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasureAndLayoutDelegate;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;", "postponedMeasureRequests", "", "Landroidx/compose/ui/node/MeasureAndLayoutDelegate$PostponedRequest;", "<init>", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;Ljava/util/List;)V", "assertConsistent", "", "isTreeConsistent", "", "node", "consistentLayoutState", "nodeToString", "", "logTree", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLayoutTreeConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,154:1\n35#2,5:155\n118#2:160\n35#2,5:161\n119#2:166\n103#2:167\n35#2,5:168\n104#2:173\n118#2:174\n35#2,5:175\n119#2:180\n35#2,5:181\n*S KotlinDebug\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n*L\n45#1:155,5\n59#1:160\n59#1:161,5\n59#1:166\n86#1:167\n86#1:168,5\n86#1:173\n93#1:174\n93#1:175,5\n93#1:180\n147#1:181,5\n*E\n"})
public final class LayoutTreeConsistencyChecker {
    @NotNull
    private final LayoutNode root;
    @NotNull
    private final DepthSortedSetsForDifferentPasses relayoutNodes;
    @NotNull
    private final List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests;
    public static final int $stable = 8;

    public LayoutTreeConsistencyChecker(@NotNull LayoutNode root, @NotNull DepthSortedSetsForDifferentPasses relayoutNodes, @NotNull List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(relayoutNodes, "relayoutNodes");
        Intrinsics.checkNotNullParameter(postponedMeasureRequests, "postponedMeasureRequests");
        this.root = root;
        this.relayoutNodes = relayoutNodes;
        this.postponedMeasureRequests = postponedMeasureRequests;
    }

    public final void assertConsistent() {
        boolean inconsistencyFound;
        boolean bl = inconsistencyFound = !this.isTreeConsistent(this.root);
        if (inconsistencyFound) {
            System.out.println((Object)this.logTree());
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode node2) {
        if (!this.consistentLayoutState(node2)) {
            return false;
        }
        List<LayoutNode> $this$fastForEach$iv = node2.getChildren$ui();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutNode item$iv;
            LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (this.isTreeConsistent(it)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean consistentLayoutState(LayoutNode $this$consistentLayoutState) {
        MeasureAndLayoutDelegate.PostponedRequest it;
        boolean bl;
        MeasureAndLayoutDelegate.PostponedRequest it$iv;
        MeasureAndLayoutDelegate.PostponedRequest item$iv$iv;
        int index$iv$iv;
        int n;
        boolean $i$f$fastForEach;
        List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastForEach$iv$iv;
        boolean $i$f$fastFirstOrNull;
        List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastFirstOrNull$iv;
        LayoutNode.LayoutState parentLayoutState;
        LayoutNode parent;
        block25: {
            block24: {
                LayoutNode layoutNode = parent = $this$consistentLayoutState.getParent$ui();
                LayoutNode.LayoutState layoutState = parentLayoutState = layoutNode != null ? layoutNode.getLayoutState$ui() : null;
                if ($this$consistentLayoutState.isPlaced()) break block24;
                if ($this$consistentLayoutState.getPlaceOrder$ui() == Integer.MAX_VALUE) break block25;
                LayoutNode layoutNode2 = parent;
                boolean bl2 = layoutNode2 != null ? layoutNode2.isPlaced() : false;
                if (!bl2) break block25;
            }
            if ($this$consistentLayoutState.getMeasurePending$ui()) {
                MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                block22: {
                    $this$fastFirstOrNull$iv = this.postponedMeasureRequests;
                    $i$f$fastFirstOrNull = false;
                    $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
                    $i$f$fastForEach = false;
                    n = ((Collection)$this$fastForEach$iv$iv).size();
                    for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                        it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                        bl = false;
                        it = it$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(it.getNode(), $this$consistentLayoutState) && !it.isLookahead())) continue;
                        postponedRequest = it$iv;
                        break block22;
                    }
                    postponedRequest = null;
                }
                if (postponedRequest != null) {
                    return true;
                }
            }
            if ($this$consistentLayoutState.isDeactivated()) {
                return true;
            }
            if ($this$consistentLayoutState.getMeasurePending$ui()) {
                boolean bl4;
                boolean bl5;
                if (this.relayoutNodes.contains($this$consistentLayoutState)) return true;
                if ($this$consistentLayoutState.getLayoutState$ui() == LayoutNode.LayoutState.LookaheadMeasuring) return true;
                LayoutNode layoutNode = parent;
                if (layoutNode != null) {
                    if (layoutNode.getMeasurePending$ui()) {
                        return true;
                    }
                    bl5 = false;
                } else {
                    bl5 = false;
                }
                if (bl5) return true;
                LayoutNode layoutNode3 = parent;
                if (layoutNode3 != null) {
                    if (layoutNode3.getLookaheadMeasurePending$ui()) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) return true;
                if (parentLayoutState != LayoutNode.LayoutState.Measuring) return false;
                return true;
            }
            if ($this$consistentLayoutState.getLayoutPending$ui()) {
                if (this.relayoutNodes.contains($this$consistentLayoutState)) return true;
                if (parent == null) return true;
                if (parent.getMeasurePending$ui()) return true;
                if (parent.getLayoutPending$ui()) return true;
                if (parentLayoutState == LayoutNode.LayoutState.Measuring) return true;
                if (parentLayoutState == LayoutNode.LayoutState.LayingOut) return true;
                List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastAny$iv = this.postponedMeasureRequests;
                boolean $i$f$fastAny = false;
                $this$fastForEach$iv$iv = $this$fastAny$iv;
                $i$f$fastForEach = false;
                n = ((Collection)$this$fastForEach$iv$iv).size();
                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl6 = false;
                    it = it$iv;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual(it.getNode(), $this$consistentLayoutState)) continue;
                    return true;
                }
                boolean bl8 = false;
                if (bl8) return true;
                if ($this$consistentLayoutState.getLayoutState$ui() != LayoutNode.LayoutState.Measuring) return false;
                return true;
            }
        }
        if (!Intrinsics.areEqual($this$consistentLayoutState.isPlacedInLookahead(), true)) return true;
        if ($this$consistentLayoutState.getLookaheadMeasurePending$ui()) {
            MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
            block23: {
                $this$fastFirstOrNull$iv = this.postponedMeasureRequests;
                $i$f$fastFirstOrNull = false;
                $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
                $i$f$fastForEach = false;
                n = ((Collection)$this$fastForEach$iv$iv).size();
                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    bl = false;
                    it = it$iv;
                    boolean bl9 = false;
                    if (!(Intrinsics.areEqual(it.getNode(), $this$consistentLayoutState) && it.isLookahead())) continue;
                    postponedRequest = it$iv;
                    break block23;
                }
                postponedRequest = null;
            }
            if (postponedRequest != null) {
                return true;
            }
        }
        if ($this$consistentLayoutState.getLookaheadMeasurePending$ui()) {
            boolean bl10;
            if (this.relayoutNodes.contains($this$consistentLayoutState, true)) return true;
            LayoutNode layoutNode = parent;
            if (layoutNode != null) {
                if (layoutNode.getLookaheadMeasurePending$ui()) {
                    return true;
                }
                bl10 = false;
            } else {
                bl10 = false;
            }
            if (bl10) return true;
            if (parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring) return true;
            LayoutNode layoutNode4 = parent;
            if (layoutNode4 == null) return false;
            if (!layoutNode4.getMeasurePending$ui()) return false;
            boolean bl11 = true;
            if (!bl11) return false;
            if (!Intrinsics.areEqual($this$consistentLayoutState.getLookaheadRoot$ui(), $this$consistentLayoutState)) return false;
            return true;
        }
        if (!$this$consistentLayoutState.getLookaheadLayoutPending$ui()) return true;
        if (this.relayoutNodes.contains($this$consistentLayoutState, true)) return true;
        if (parent == null) return true;
        if (parent.getLookaheadMeasurePending$ui()) return true;
        if (parent.getLookaheadLayoutPending$ui()) return true;
        if (parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring) return true;
        if (parentLayoutState == LayoutNode.LayoutState.LookaheadLayingOut) return true;
        if (!parent.getLayoutPending$ui()) return false;
        if (!Intrinsics.areEqual($this$consistentLayoutState.getLookaheadRoot$ui(), $this$consistentLayoutState)) return false;
        return true;
    }

    private final String nodeToString(LayoutNode node2) {
        StringBuilder $this$nodeToString_u24lambda_u244 = new StringBuilder();
        boolean bl = false;
        $this$nodeToString_u24lambda_u244.append(node2);
        $this$nodeToString_u24lambda_u244.append("[" + node2.getLayoutState$ui() + "]");
        if (!node2.isPlaced()) {
            $this$nodeToString_u24lambda_u244.append("[!isPlaced]");
        }
        $this$nodeToString_u24lambda_u244.append("[measuredByParent=" + node2.getMeasuredByParent$ui() + "]");
        if (!this.consistentLayoutState(node2)) {
            $this$nodeToString_u24lambda_u244.append("[INCONSISTENT]");
        }
        String string2 = $this$nodeToString_u24lambda_u244.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "with(...)");
        return string2;
    }

    private final String logTree() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tree state:").append('\n');
        LayoutTreeConsistencyChecker.logTree$printSubTree(this, stringBuilder, this.root, 0);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker this$0, StringBuilder stringBuilder, LayoutNode node2, int depth) {
        int childrenDepth = 0;
        childrenDepth = depth;
        String nodeRepresentation = this$0.nodeToString(node2);
        if (((CharSequence)nodeRepresentation).length() > 0) {
            for (int i2 = 0; i2 < depth; ++i2) {
                stringBuilder.append("..");
            }
            stringBuilder.append(nodeRepresentation).append('\n');
            ++childrenDepth;
        }
        List<LayoutNode> $this$fastForEach$iv = node2.getChildren$ui();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutNode item$iv;
            LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            LayoutTreeConsistencyChecker.logTree$printSubTree(this$0, stringBuilder, it, childrenDepth);
        }
    }
}

