package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.school.entities.AuthTokenEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class AuthTokenEntityDao_Impl(
  __db: RoomDatabase,
) : AuthTokenEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfAuthTokenEntity: EntityInsertAdapter<AuthTokenEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfAuthTokenEntity = object : EntityInsertAdapter<AuthTokenEntity>() {
      protected override fun createQuery(): String = "INSERT OR ABORT INTO `AuthTokenEntity` (`atUid`,`atPGuidHash`,`atPGuid`,`atCode`,`atToken`,`atTimeCreated`,`atTtl`,`atPlatform`,`atAndroidSdkInt`,`atVersion`,`atManufacturer`,`atModel`,`atRam`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: AuthTokenEntity) {
        statement.bindLong(1, entity.atUid)
        statement.bindLong(2, entity.atPGuidHash)
        statement.bindText(3, entity.atPGuid)
        val _tmpAtCode: String? = entity.atCode
        if (_tmpAtCode == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmpAtCode)
        }
        statement.bindText(5, entity.atToken)
        statement.bindLong(6, entity.atTimeCreated)
        statement.bindLong(7, entity.atTtl.toLong())
        val _tmpAtPlatform: String? = entity.atPlatform
        if (_tmpAtPlatform == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpAtPlatform)
        }
        val _tmpAtAndroidSdkInt: Int? = entity.atAndroidSdkInt
        if (_tmpAtAndroidSdkInt == null) {
          statement.bindNull(9)
        } else {
          statement.bindLong(9, _tmpAtAndroidSdkInt.toLong())
        }
        val _tmpAtVersion: String? = entity.atVersion
        if (_tmpAtVersion == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmpAtVersion)
        }
        val _tmpAtManufacturer: String? = entity.atManufacturer
        if (_tmpAtManufacturer == null) {
          statement.bindNull(11)
        } else {
          statement.bindText(11, _tmpAtManufacturer)
        }
        val _tmpAtModel: String? = entity.atModel
        if (_tmpAtModel == null) {
          statement.bindNull(12)
        } else {
          statement.bindText(12, _tmpAtModel)
        }
        val _tmpAtRam: Long? = entity.atRam
        if (_tmpAtRam == null) {
          statement.bindNull(13)
        } else {
          statement.bindLong(13, _tmpAtRam)
        }
      }
    }
  }

  public override suspend fun insert(token: AuthTokenEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfAuthTokenEntity.insert(_connection, token)
  }

  public override suspend fun findByToken(token: String, timeNow: Long): AuthTokenEntity? {
    val _sql: String = """
        |
        |        SELECT AuthTokenEntity.*
        |          FROM AuthTokenEntity
        |         WHERE AuthTokenEntity.atToken = ?
        |           AND ? BETWEEN AuthTokenEntity.atTimeCreated 
        |                            AND (AuthTokenEntity.atTimeCreated + (AuthTokenEntity.atTtl * 1000))
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, token)
        _argIndex = 2
        _stmt.bindLong(_argIndex, timeNow)
        val _columnIndexOfAtUid: Int = getColumnIndexOrThrow(_stmt, "atUid")
        val _columnIndexOfAtPGuidHash: Int = getColumnIndexOrThrow(_stmt, "atPGuidHash")
        val _columnIndexOfAtPGuid: Int = getColumnIndexOrThrow(_stmt, "atPGuid")
        val _columnIndexOfAtCode: Int = getColumnIndexOrThrow(_stmt, "atCode")
        val _columnIndexOfAtToken: Int = getColumnIndexOrThrow(_stmt, "atToken")
        val _columnIndexOfAtTimeCreated: Int = getColumnIndexOrThrow(_stmt, "atTimeCreated")
        val _columnIndexOfAtTtl: Int = getColumnIndexOrThrow(_stmt, "atTtl")
        val _columnIndexOfAtPlatform: Int = getColumnIndexOrThrow(_stmt, "atPlatform")
        val _columnIndexOfAtAndroidSdkInt: Int = getColumnIndexOrThrow(_stmt, "atAndroidSdkInt")
        val _columnIndexOfAtVersion: Int = getColumnIndexOrThrow(_stmt, "atVersion")
        val _columnIndexOfAtManufacturer: Int = getColumnIndexOrThrow(_stmt, "atManufacturer")
        val _columnIndexOfAtModel: Int = getColumnIndexOrThrow(_stmt, "atModel")
        val _columnIndexOfAtRam: Int = getColumnIndexOrThrow(_stmt, "atRam")
        val _result: AuthTokenEntity?
        if (_stmt.step()) {
          val _tmpAtUid: Long
          _tmpAtUid = _stmt.getLong(_columnIndexOfAtUid)
          val _tmpAtPGuidHash: Long
          _tmpAtPGuidHash = _stmt.getLong(_columnIndexOfAtPGuidHash)
          val _tmpAtPGuid: String
          _tmpAtPGuid = _stmt.getText(_columnIndexOfAtPGuid)
          val _tmpAtCode: String?
          if (_stmt.isNull(_columnIndexOfAtCode)) {
            _tmpAtCode = null
          } else {
            _tmpAtCode = _stmt.getText(_columnIndexOfAtCode)
          }
          val _tmpAtToken: String
          _tmpAtToken = _stmt.getText(_columnIndexOfAtToken)
          val _tmpAtTimeCreated: Long
          _tmpAtTimeCreated = _stmt.getLong(_columnIndexOfAtTimeCreated)
          val _tmpAtTtl: Int
          _tmpAtTtl = _stmt.getLong(_columnIndexOfAtTtl).toInt()
          val _tmpAtPlatform: String?
          if (_stmt.isNull(_columnIndexOfAtPlatform)) {
            _tmpAtPlatform = null
          } else {
            _tmpAtPlatform = _stmt.getText(_columnIndexOfAtPlatform)
          }
          val _tmpAtAndroidSdkInt: Int?
          if (_stmt.isNull(_columnIndexOfAtAndroidSdkInt)) {
            _tmpAtAndroidSdkInt = null
          } else {
            _tmpAtAndroidSdkInt = _stmt.getLong(_columnIndexOfAtAndroidSdkInt).toInt()
          }
          val _tmpAtVersion: String?
          if (_stmt.isNull(_columnIndexOfAtVersion)) {
            _tmpAtVersion = null
          } else {
            _tmpAtVersion = _stmt.getText(_columnIndexOfAtVersion)
          }
          val _tmpAtManufacturer: String?
          if (_stmt.isNull(_columnIndexOfAtManufacturer)) {
            _tmpAtManufacturer = null
          } else {
            _tmpAtManufacturer = _stmt.getText(_columnIndexOfAtManufacturer)
          }
          val _tmpAtModel: String?
          if (_stmt.isNull(_columnIndexOfAtModel)) {
            _tmpAtModel = null
          } else {
            _tmpAtModel = _stmt.getText(_columnIndexOfAtModel)
          }
          val _tmpAtRam: Long?
          if (_stmt.isNull(_columnIndexOfAtRam)) {
            _tmpAtRam = null
          } else {
            _tmpAtRam = _stmt.getLong(_columnIndexOfAtRam)
          }
          _result = AuthTokenEntity(_tmpAtUid,_tmpAtPGuidHash,_tmpAtPGuid,_tmpAtCode,_tmpAtToken,_tmpAtTimeCreated,_tmpAtTtl,_tmpAtPlatform,_tmpAtAndroidSdkInt,_tmpAtVersion,_tmpAtManufacturer,_tmpAtModel,_tmpAtRam)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
