/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.exc;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.util.RequestPayload;

public abstract class StreamReadException
extends JsonProcessingException {
    static final long serialVersionUID = 2L;
    protected transient JsonParser _processor;
    protected RequestPayload _requestPayload;

    protected StreamReadException(String msg) {
        this(null, msg, null, null);
    }

    protected StreamReadException(JsonParser p2, String msg) {
        this(p2, msg, StreamReadException._currentLocation(p2), null);
    }

    protected StreamReadException(JsonParser p2, String msg, Throwable rootCause) {
        this(p2, msg, StreamReadException._currentLocation(p2), rootCause);
    }

    protected StreamReadException(JsonParser p2, String msg, JsonLocation loc) {
        this(p2, msg, loc, null);
    }

    protected StreamReadException(String msg, JsonLocation loc, Throwable rootCause) {
        this(null, msg, loc, rootCause);
    }

    protected StreamReadException(JsonParser p2, String msg, JsonLocation loc, Throwable rootCause) {
        super(msg, loc, rootCause);
        this._processor = p2;
    }

    public abstract StreamReadException withParser(JsonParser var1);

    public abstract StreamReadException withRequestPayload(RequestPayload var1);

    @Override
    public JsonParser getProcessor() {
        return this._processor;
    }

    public RequestPayload getRequestPayload() {
        return this._requestPayload;
    }

    public String getRequestPayloadAsString() {
        return this._requestPayload != null ? this._requestPayload.toString() : null;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (this._requestPayload != null) {
            msg = msg + "\nRequest payload : " + this._requestPayload.toString();
        }
        return msg;
    }

    protected static JsonLocation _currentLocation(JsonParser p2) {
        return p2 == null ? null : p2.currentLocation();
    }
}

