/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.annotation.RestrictTo;
import androidx.collection.SparseArrayCompat;
import androidx.collection.SparseArrayKt;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavType;
import androidx.navigation.serialization.RouteSerializerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b J9\u0010!\u001a\u0004\u0018\u00010\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b%J!\u0010&\u001a\u0004\u0018\u00010\u001a2\b\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020$H\u0001\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b,J\u001d\u0010-\u001a\u00020*2\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0.H\u0000\u00a2\u0006\u0002\b/J#\u0010-\u001a\u00020*2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n00\"\u00020\nH\u0000\u00a2\u0006\u0004\b/\u00101J\u0017\u00102\u001a\u0004\u0018\u00010\n2\u0006\u00103\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b4J5\u00105\u001a\u0004\u0018\u00010\n2\u0006\u00103\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u00106\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b7J\u0019\u00102\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b4J\u001b\u00102\u001a\u0004\u0018\u00010\n2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u000308H\u0000\u00a2\u0006\u0002\b4J!\u00102\u001a\u0004\u0018\u00010\n\"\u0004\b\u0000\u001092\b\u0010\u001b\u001a\u0004\u0018\u0001H9H\u0000\u00a2\u0006\u0004\b4\u0010:J\u001f\u00102\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b4J\u0013\u0010<\u001a\b\u0012\u0004\u0012\u00020\n0=H\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020*2\u0006\u0010+\u001a\u00020\nH\u0000\u00a2\u0006\u0002\bCJ\r\u0010D\u001a\u00020*H\u0000\u00a2\u0006\u0002\bEJ\u0015\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bHJ\u0015\u0010L\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\bMJ\u0015\u0010L\u001a\u00020*2\u0006\u0010N\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bMJ%\u0010L\u001a\u00020*\"\b\b\u0000\u00109*\u00020\u00012\f\u0010N\u001a\b\u0012\u0004\u0012\u0002H908H\u0000\u00a2\u0006\u0002\bMJ!\u0010L\u001a\u00020*\"\b\b\u0000\u00109*\u00020\u00012\u0006\u0010N\u001a\u0002H9H\u0000\u00a2\u0006\u0004\bM\u0010OJ5\u0010L\u001a\u00020*\"\u0004\b\u0000\u001092\f\u0010P\u001a\b\u0012\u0004\u0012\u0002H90Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140SH\u0000\u00a2\u0006\u0002\bMR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010I\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010\u0010\"\u0004\bK\u0010\u0012R(\u0010T\u001a\u0004\u0018\u00010\u00142\b\u0010N\u001a\u0004\u0018\u00010\u0014@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010\u0016\"\u0004\bV\u0010\u0018R\u0014\u0010W\u001a\u00020\u00148AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u0016\u00a8\u0006Y"}, d2={"Landroidx/navigation/internal/NavGraphImpl;", "", "graph", "Landroidx/navigation/NavGraph;", "<init>", "(Landroidx/navigation/NavGraph;)V", "getGraph", "()Landroidx/navigation/NavGraph;", "nodes", "Landroidx/collection/SparseArrayCompat;", "Landroidx/navigation/NavDestination;", "getNodes$navigation_common", "()Landroidx/collection/SparseArrayCompat;", "startDestId", "", "getStartDestId$navigation_common", "()I", "setStartDestId$navigation_common", "(I)V", "startDestIdName", "", "getStartDestIdName$navigation_common", "()Ljava/lang/String;", "setStartDestIdName$navigation_common", "(Ljava/lang/String;)V", "matchRouteComprehensive", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "route", "searchChildren", "", "searchParent", "lastVisited", "matchRouteComprehensive$navigation_common", "matchDeepLinkComprehensive", "bestMatch", "navDeepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "matchDeepLinkComprehensive$navigation_common", "matchDeepLink", "superBestMatch", "matchDeepLink$navigation_common", "addDestination", "", "node", "addDestination$navigation_common", "addDestinations", "", "addDestinations$navigation_common", "", "([Landroidx/navigation/NavDestination;)V", "findNode", "resId", "findNode$navigation_common", "findNodeComprehensive", "matchingDest", "findNodeComprehensive$navigation_common", "Lkotlin/reflect/KClass;", "T", "(Ljava/lang/Object;)Landroidx/navigation/NavDestination;", "searchParents", "iterator", "", "iterator$navigation_common", "addAll", "other", "addAll$navigation_common", "remove", "remove$navigation_common", "clear", "clear$navigation_common", "getDisplayName", "superName", "getDisplayName$navigation_common", "startDestinationId", "getStartDestinationId$navigation_common", "setStartDestinationId$navigation_common", "setStartDestination", "setStartDestination$navigation_common", "startDestRoute", "(Ljava/lang/Object;)V", "serializer", "Lkotlinx/serialization/KSerializer;", "parseRoute", "Lkotlin/Function1;", "startDestinationRoute", "getStartDestinationRoute$navigation_common", "setStartDestinationRoute$navigation_common", "startDestDisplayName", "getStartDestDisplayName$navigation_common", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavGraphImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavGraphImpl.kt\nandroidx/navigation/internal/NavGraphImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,372:1\n1617#2,9:373\n1869#2:382\n1870#2:384\n1626#2:385\n1617#2,9:386\n1869#2:395\n1870#2:397\n1626#2:398\n1252#2,4:404\n1#3:383\n1#3:396\n1#3:399\n183#4,2:400\n465#5:402\n415#5:403\n*S KotlinDebug\n*F\n+ 1 NavGraphImpl.kt\nandroidx/navigation/internal/NavGraphImpl\n*L\n55#1:373,9\n55#1:382\n55#1:384\n55#1:385\n94#1:386,9\n94#1:395\n94#1:397\n94#1:398\n322#1:404,4\n55#1:383\n94#1:396\n221#1:400,2\n322#1:402\n322#1:403\n*E\n"})
public final class NavGraphImpl {
    @NotNull
    private final NavGraph graph;
    @NotNull
    private final SparseArrayCompat<NavDestination> nodes;
    private int startDestId;
    @Nullable
    private String startDestIdName;
    @Nullable
    private String startDestinationRoute;

    public NavGraphImpl(@NotNull NavGraph graph) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        this.graph = graph;
        this.nodes = new SparseArrayCompat(0, 1, null);
    }

    @NotNull
    public final NavGraph getGraph() {
        return this.graph;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final SparseArrayCompat<NavDestination> getNodes$navigation_common() {
        return this.nodes;
    }

    public final int getStartDestId$navigation_common() {
        return this.startDestId;
    }

    public final void setStartDestId$navigation_common(int n) {
        this.startDestId = n;
    }

    @Nullable
    public final String getStartDestIdName$navigation_common() {
        return this.startDestIdName;
    }

    public final void setStartDestIdName$navigation_common(@Nullable String string2) {
        this.startDestIdName = string2;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination.DeepLinkMatch matchRouteComprehensive$navigation_common(@NotNull String route, boolean searchChildren, boolean searchParent, @NotNull NavDestination lastVisited) {
        NavDestination.DeepLinkMatch deepLinkMatch;
        NavDestination.DeepLinkMatch deepLinkMatch2;
        Intrinsics.checkNotNullParameter(route, "route");
        Intrinsics.checkNotNullParameter(lastVisited, "lastVisited");
        NavDestination.DeepLinkMatch bestMatch = this.graph.matchRoute(route);
        if (searchChildren) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = this.graph;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                NavDestination.DeepLinkMatch it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                NavDestination child = (NavDestination)element$iv$iv;
                boolean bl2 = false;
                NavDestination navDestination = child;
                if ((Intrinsics.areEqual(navDestination, lastVisited) ? null : (navDestination instanceof NavGraph ? ((NavGraph)child).matchRouteComprehensive(route, true, false, this.graph) : child.matchRoute(route))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            deepLinkMatch2 = (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((List)destination$iv$iv);
        } else {
            deepLinkMatch2 = null;
        }
        NavDestination.DeepLinkMatch bestChildMatch = deepLinkMatch2;
        NavGraph navGraph = this.graph.getParent();
        if (navGraph != null) {
            NavGraph it = navGraph;
            boolean bl = false;
            deepLinkMatch = searchParent && !Intrinsics.areEqual(it, lastVisited) ? it.matchRouteComprehensive(route, searchChildren, true, this.graph) : null;
        } else {
            deepLinkMatch = null;
        }
        NavDestination.DeepLinkMatch bestParentMatch = deepLinkMatch;
        NavDestination.DeepLinkMatch[] deepLinkMatchArray = new NavDestination.DeepLinkMatch[]{bestMatch, bestChildMatch, bestParentMatch};
        return (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull(deepLinkMatchArray));
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination.DeepLinkMatch matchDeepLinkComprehensive$navigation_common(@Nullable NavDestination.DeepLinkMatch bestMatch, @NotNull NavDeepLinkRequest navDeepLinkRequest, boolean searchChildren, boolean searchParent, @NotNull NavDestination lastVisited) {
        NavDestination.DeepLinkMatch deepLinkMatch;
        NavDestination.DeepLinkMatch deepLinkMatch2;
        Intrinsics.checkNotNullParameter(navDeepLinkRequest, "navDeepLinkRequest");
        Intrinsics.checkNotNullParameter(lastVisited, "lastVisited");
        if (searchChildren) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = this.graph;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                NavDestination.DeepLinkMatch it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                NavDestination child = (NavDestination)element$iv$iv;
                boolean bl2 = false;
                if ((!Intrinsics.areEqual(child, lastVisited) ? child.matchDeepLink(navDeepLinkRequest) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            deepLinkMatch2 = (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((List)destination$iv$iv);
        } else {
            deepLinkMatch2 = null;
        }
        NavDestination.DeepLinkMatch bestChildMatch = deepLinkMatch2;
        NavGraph navGraph = this.graph.getParent();
        if (navGraph != null) {
            NavGraph it = navGraph;
            boolean bl = false;
            deepLinkMatch = searchParent && !Intrinsics.areEqual(it, lastVisited) ? it.matchDeepLinkComprehensive(navDeepLinkRequest, searchChildren, true, this.graph) : null;
        } else {
            deepLinkMatch = null;
        }
        NavDestination.DeepLinkMatch bestParentMatch = deepLinkMatch;
        NavDestination.DeepLinkMatch[] deepLinkMatchArray = new NavDestination.DeepLinkMatch[]{bestMatch, bestChildMatch, bestParentMatch};
        return (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull(deepLinkMatchArray));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination.DeepLinkMatch matchDeepLink$navigation_common(@Nullable NavDestination.DeepLinkMatch superBestMatch, @NotNull NavDeepLinkRequest navDeepLinkRequest) {
        Intrinsics.checkNotNullParameter(navDeepLinkRequest, "navDeepLinkRequest");
        return this.matchDeepLinkComprehensive$navigation_common(superBestMatch, navDeepLinkRequest, true, false, this.graph);
    }

    public final void addDestination$navigation_common(@NotNull NavDestination node2) {
        Intrinsics.checkNotNullParameter(node2, "node");
        int id = node2.getId();
        String innerRoute = node2.getRoute();
        if (!(id != 0 || innerRoute != null)) {
            boolean $i$a$-require-NavGraphImpl$addDestination$42 = false;
            String $i$a$-require-NavGraphImpl$addDestination$42 = "Destinations must have an id or route. Call setId(), setRoute(), or include an android:id or app:route in your navigation XML.";
            throw new IllegalArgumentException($i$a$-require-NavGraphImpl$addDestination$42.toString());
        }
        if (this.graph.getRoute() != null && !(!Intrinsics.areEqual(innerRoute, this.graph.getRoute()))) {
            boolean $i$a$-require-NavGraphImpl$addDestination$52 = false;
            String $i$a$-require-NavGraphImpl$addDestination$52 = "Destination " + node2 + " cannot have the same route as graph " + this.graph;
            throw new IllegalArgumentException($i$a$-require-NavGraphImpl$addDestination$52.toString());
        }
        if (!(id != this.graph.getId())) {
            boolean bl = false;
            String string2 = "Destination " + node2 + " cannot have the same id as graph " + this.graph;
            throw new IllegalArgumentException(string2.toString());
        }
        NavDestination existingDestination = this.nodes.get(id);
        if (existingDestination == node2) {
            return;
        }
        if (!(node2.getParent() == null)) {
            boolean bl = false;
            String string3 = "Destination already has a parent set. Call NavGraph.remove() to remove the previous parent.";
            throw new IllegalStateException(string3.toString());
        }
        if (existingDestination != null) {
            existingDestination.setParent(null);
        }
        node2.setParent(this.graph);
        this.nodes.put(node2.getId(), node2);
    }

    public final void addDestinations$navigation_common(@NotNull Collection<? extends NavDestination> nodes) {
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        for (NavDestination navDestination : nodes) {
            if (navDestination == null) continue;
            this.addDestination$navigation_common(navDestination);
        }
    }

    public final void addDestinations$navigation_common(NavDestination ... nodes) {
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        for (NavDestination node2 : nodes) {
            this.addDestination$navigation_common(node2);
        }
    }

    @Nullable
    public final NavDestination findNode$navigation_common(int resId) {
        return NavGraphImpl.findNodeComprehensive$navigation_common$default(this, resId, this.graph, false, null, 8, null);
    }

    @Nullable
    public final NavDestination findNodeComprehensive$navigation_common(int resId, @Nullable NavDestination lastVisited, boolean searchChildren, @Nullable NavDestination matchingDest) {
        NavDestination navDestination;
        NavDestination destination;
        block9: {
            destination = this.nodes.get(resId);
            if (matchingDest != null) {
                if (Intrinsics.areEqual(destination, matchingDest) && Intrinsics.areEqual(destination.getParent(), matchingDest.getParent())) {
                    return destination;
                }
                destination = null;
            } else if (destination != null) {
                return destination;
            }
            if (searchChildren) {
                NavDestination navDestination2;
                Iterator<NavDestination> iterator2 = SequencesKt.asSequence(SparseArrayKt.valueIterator(this.nodes)).iterator();
                while (iterator2.hasNext()) {
                    NavDestination child = iterator2.next();
                    boolean bl = false;
                    NavDestination navDestination3 = child instanceof NavGraph && !Intrinsics.areEqual(child, lastVisited) ? ((NavGraph)child).findNodeComprehensive(resId, this.graph, true, matchingDest) : null;
                    if (navDestination3 == null) continue;
                    navDestination2 = navDestination3;
                    break block9;
                }
                navDestination2 = destination = null;
            }
        }
        if ((navDestination = destination) == null) {
            if (this.graph.getParent() != null && !Intrinsics.areEqual(this.graph.getParent(), lastVisited)) {
                NavGraph navGraph = this.graph.getParent();
                Intrinsics.checkNotNull(navGraph);
                navDestination = navGraph.findNodeComprehensive(resId, this.graph, searchChildren, matchingDest);
            } else {
                navDestination = null;
            }
        }
        return navDestination;
    }

    public static /* synthetic */ NavDestination findNodeComprehensive$navigation_common$default(NavGraphImpl navGraphImpl, int n, NavDestination navDestination, boolean bl, NavDestination navDestination2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            navDestination2 = null;
        }
        return navGraphImpl.findNodeComprehensive$navigation_common(n, navDestination, bl, navDestination2);
    }

    @Nullable
    public final NavDestination findNode$navigation_common(@Nullable String route) {
        CharSequence charSequence = route;
        return !(charSequence == null || StringsKt.isBlank(charSequence)) ? this.findNode$navigation_common(route, true) : null;
    }

    @Nullable
    public final NavDestination findNode$navigation_common(@NotNull KClass<?> route) {
        Intrinsics.checkNotNullParameter(route, "route");
        return this.findNode$navigation_common(RouteSerializerKt.generateHashCode(SerializersKt.serializer(route)));
    }

    @Nullable
    public final <T> NavDestination findNode$navigation_common(@Nullable T route) {
        NavDestination navDestination;
        T t = route;
        if (t != null) {
            T it = t;
            boolean bl = false;
            navDestination = this.findNode$navigation_common(RouteSerializerKt.generateHashCode(SerializersKt.serializer(Reflection.getOrCreateKotlinClass(it.getClass()))));
        } else {
            navDestination = null;
        }
        return navDestination;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination findNode$navigation_common(@NotNull String route, boolean searchParents) {
        NavDestination destination;
        NavDestination navDestination;
        NavDestination navDestination2;
        block4: {
            Intrinsics.checkNotNullParameter(route, "route");
            Sequence<NavDestination> $this$firstOrNull$iv = SequencesKt.asSequence(SparseArrayKt.valueIterator(this.nodes));
            boolean $i$f$firstOrNull = false;
            Iterator<NavDestination> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                NavDestination element$iv;
                NavDestination it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(StringsKt.equals$default(it.getRoute(), route, false, 2, null) || it.matchRoute(route) != null)) continue;
                navDestination2 = element$iv;
                break block4;
            }
            navDestination2 = null;
        }
        if ((navDestination = (destination = (NavDestination)navDestination2)) == null) {
            if (searchParents && this.graph.getParent() != null) {
                NavGraph navGraph = this.graph.getParent();
                Intrinsics.checkNotNull(navGraph);
                navDestination = navGraph.findNode(route);
            } else {
                navDestination = null;
            }
        }
        return navDestination;
    }

    @NotNull
    public final Iterator<NavDestination> iterator$navigation_common() {
        return new Iterator<NavDestination>(this){
            private int index;
            private boolean wentToNext;
            final /* synthetic */ NavGraphImpl this$0;
            {
                this.this$0 = $receiver;
                this.index = -1;
            }

            public boolean hasNext() {
                return this.index + 1 < this.this$0.getNodes$navigation_common().size();
            }

            public NavDestination next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.wentToNext = true;
                ++this.index;
                return this.this$0.getNodes$navigation_common().valueAt(this.index);
            }

            public void remove() {
                if (!this.wentToNext) {
                    boolean $i$a$-check-NavGraphImpl$iterator$1$remove$22 = false;
                    String $i$a$-check-NavGraphImpl$iterator$1$remove$22 = "You must call next() before you can remove an element";
                    throw new IllegalStateException($i$a$-check-NavGraphImpl$iterator$1$remove$22.toString());
                }
                SparseArrayCompat<NavDestination> $this$remove_u24lambda_u241 = this.this$0.getNodes$navigation_common();
                boolean bl = false;
                $this$remove_u24lambda_u241.valueAt(this.index).setParent(null);
                $this$remove_u24lambda_u241.removeAt(this.index);
                int n = this.index;
                this.index = n + -1;
                this.wentToNext = false;
            }
        };
    }

    public final void addAll$navigation_common(@NotNull NavGraph other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Iterator<NavDestination> iterator2 = other.iterator();
        while (iterator2.hasNext()) {
            NavDestination destination = iterator2.next();
            iterator2.remove();
            this.addDestination$navigation_common(destination);
        }
    }

    public final void remove$navigation_common(@NotNull NavDestination node2) {
        Intrinsics.checkNotNullParameter(node2, "node");
        int index2 = this.nodes.indexOfKey(node2.getId());
        if (index2 >= 0) {
            this.nodes.valueAt(index2).setParent(null);
            this.nodes.removeAt(index2);
        }
    }

    public final void clear$navigation_common() {
        Iterator<NavDestination> iterator2 = this.iterator$navigation_common();
        while (iterator2.hasNext()) {
            iterator2.next();
            iterator2.remove();
        }
    }

    @NotNull
    public final String getDisplayName$navigation_common(@NotNull String superName) {
        Intrinsics.checkNotNullParameter(superName, "superName");
        return this.graph.getId() != 0 ? superName : "the root navigation";
    }

    public final int getStartDestinationId$navigation_common() {
        return this.startDestId;
    }

    public final void setStartDestinationId$navigation_common(int startDestId) {
        if (!(startDestId != this.graph.getId())) {
            boolean bl = false;
            String string2 = "Start destination " + startDestId + " cannot use the same id as the graph " + this.graph;
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.startDestinationRoute != null) {
            this.setStartDestinationRoute$navigation_common(null);
        }
        this.startDestId = startDestId;
        this.startDestIdName = null;
    }

    public final void setStartDestination$navigation_common(int startDestId) {
        this.setStartDestinationId$navigation_common(startDestId);
    }

    public final void setStartDestination$navigation_common(@NotNull String startDestRoute) {
        Intrinsics.checkNotNullParameter(startDestRoute, "startDestRoute");
        this.setStartDestinationRoute$navigation_common(startDestRoute);
    }

    public final <T> void setStartDestination$navigation_common(@NotNull KClass<T> startDestRoute) {
        Intrinsics.checkNotNullParameter(startDestRoute, "startDestRoute");
        this.setStartDestination$navigation_common(SerializersKt.serializer(startDestRoute), NavGraphImpl::setStartDestination$lambda$12);
    }

    public final <T> void setStartDestination$navigation_common(@NotNull T startDestRoute) {
        Intrinsics.checkNotNullParameter(startDestRoute, "startDestRoute");
        this.setStartDestination$navigation_common(SerializersKt.serializer(Reflection.getOrCreateKotlinClass(startDestRoute.getClass())), arg_0 -> NavGraphImpl.setStartDestination$lambda$14(startDestRoute, arg_0));
    }

    public final <T> void setStartDestination$navigation_common(@NotNull KSerializer<T> serializer2, @NotNull Function1<? super NavDestination, String> parseRoute) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        Intrinsics.checkNotNullParameter(parseRoute, "parseRoute");
        int id = RouteSerializerKt.generateHashCode(serializer2);
        NavDestination startDest = this.findNode$navigation_common(id);
        if (startDest == null) {
            boolean bl = false;
            String string2 = "Cannot find startDestination " + serializer2.getDescriptor().getSerialName() + " from NavGraph. Ensure the starting NavDestination was added with route from KClass.";
            throw new IllegalStateException(string2.toString());
        }
        this.setStartDestinationRoute$navigation_common(parseRoute.invoke(startDest));
        this.startDestId = id;
    }

    @Nullable
    public final String getStartDestinationRoute$navigation_common() {
        return this.startDestinationRoute;
    }

    public final void setStartDestinationRoute$navigation_common(@Nullable String startDestRoute) {
        int n;
        NavGraphImpl navGraphImpl = this;
        if (startDestRoute == null) {
            n = 0;
        } else {
            if (!(!Intrinsics.areEqual(startDestRoute, this.graph.getRoute()))) {
                NavGraphImpl navGraphImpl2 = navGraphImpl;
                boolean $i$a$-require-NavGraphImpl$startDestinationRoute$32 = false;
                NavGraphImpl navGraphImpl3 = navGraphImpl2;
                String $i$a$-require-NavGraphImpl$startDestinationRoute$32 = "Start destination " + startDestRoute + " cannot use the same route as the graph " + this.graph;
                throw new IllegalArgumentException($i$a$-require-NavGraphImpl$startDestinationRoute$32.toString());
            }
            if (!(!StringsKt.isBlank(startDestRoute))) {
                NavGraphImpl navGraphImpl4 = navGraphImpl;
                boolean bl = false;
                NavGraphImpl navGraphImpl5 = navGraphImpl4;
                String string2 = "Cannot have an empty start destination route";
                throw new IllegalArgumentException(string2.toString());
            }
            String internalRoute = NavDestination.Companion.createRoute(startDestRoute);
            n = internalRoute.hashCode();
        }
        navGraphImpl.startDestId = n;
        this.startDestinationRoute = startDestRoute;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final String getStartDestDisplayName$navigation_common() {
        if (this.startDestIdName == null) {
            String string2 = this.startDestinationRoute;
            if (string2 == null) {
                string2 = String.valueOf(this.startDestId);
            }
            this.startDestIdName = string2;
        }
        String string3 = this.startDestIdName;
        Intrinsics.checkNotNull(string3);
        return string3;
    }

    private static final String setStartDestination$lambda$12(NavDestination startDestination) {
        Intrinsics.checkNotNullParameter(startDestination, "startDestination");
        String string2 = startDestination.getRoute();
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static final String setStartDestination$lambda$14(Object $startDestRoute, NavDestination startDestination) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(startDestination, "startDestination");
        Map<String, NavArgument> $this$mapValues$iv = startDestination.getArguments();
        boolean $i$f$mapValues = false;
        Map<String, NavArgument> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            NavType<Object> navType = ((NavArgument)it.getValue()).getType();
            map4.put(k, navType);
        }
        Map args = destination$iv$iv;
        return RouteSerializerKt.generateRouteWithArgs($startDestRoute, args);
    }
}

