/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.server.auth.UserIdPrincipal;
import io.ktor.server.auth.UserPasswordCredential;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/auth/UserHashedTableAuth;", "", "Lkotlin/Function1;", "", "", "digester", "", "table", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/Map;)V", "Lio/ktor/server/auth/UserPasswordCredential;", "credential", "Lio/ktor/server/auth/UserIdPrincipal;", "authenticate", "(Lio/ktor/server/auth/UserPasswordCredential;)Lio/ktor/server/auth/UserIdPrincipal;", "Lkotlin/jvm/functions/Function1;", "getDigester", "()Lkotlin/jvm/functions/Function1;", "Ljava/util/Map;", "getTable", "()Ljava/util/Map;", "ktor-server-auth"})
public final class UserHashedTableAuth {
    @NotNull
    private final Function1<String, byte[]> digester;
    @NotNull
    private final Map<String, byte[]> table;

    public UserHashedTableAuth(@NotNull Function1<? super String, byte[]> digester, @NotNull Map<String, byte[]> table) {
        Intrinsics.checkNotNullParameter(digester, (String)"digester");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        this.digester = digester;
        this.table = table;
        if (this.table.isEmpty()) {
            // empty if block
        }
    }

    @NotNull
    public final Function1<String, byte[]> getDigester() {
        return this.digester;
    }

    @NotNull
    public final Map<String, byte[]> getTable() {
        return this.table;
    }

    @Nullable
    public final UserIdPrincipal authenticate(@NotNull UserPasswordCredential credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        byte[] userPasswordHash = this.table.get(credential.getName());
        if (userPasswordHash != null && Arrays.equals((byte[])this.digester.invoke((Object)credential.getPassword()), userPasswordHash)) {
            return new UserIdPrincipal(credential.getName());
        }
        return null;
    }
}

