/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimeArithmeticException;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.YearMonth;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.internal.MathJvmKt;
import kotlinx.datetime.internal.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\n*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\u0012\u0010\r\u001a\u00020\n*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0002*\u00020\u0002\u001a\u001a\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0018\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0018\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001c\u001a\u00020\u0002*\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u000fH\u0000\"\u0015\u0010\u0004\u001a\u00020\u0002*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\u0019\u001a\u00020\u000f*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0018\u0010\u001e\u001a\u00020\u0002*\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0018\u0010!\u001a\u00020\u0002*\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006#"}, d2={"format", "", "Lkotlinx/datetime/YearMonth;", "Lkotlinx/datetime/format/DateTimeFormat;", "yearMonth", "Lkotlinx/datetime/LocalDate;", "getYearMonth", "(Lkotlinx/datetime/LocalDate;)Lkotlinx/datetime/YearMonth;", "onDay", "day", "", "yearsUntil", "other", "monthsUntil", "until", "", "unit", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "plusYear", "minusYear", "plusMonth", "minusMonth", "plus", "value", "minus", "prolepticMonth", "getProlepticMonth", "(Lkotlinx/datetime/YearMonth;)J", "fromProlepticMonth", "Lkotlinx/datetime/YearMonth$Companion;", "MAX", "getMAX", "(Lkotlinx/datetime/YearMonth$Companion;)Lkotlinx/datetime/YearMonth;", "MIN", "getMIN", "kotlinx-datetime"})
public final class YearMonthKt {
    @NotNull
    public static final String format(@NotNull YearMonth $this$format, @NotNull DateTimeFormat<YearMonth> format) {
        Intrinsics.checkNotNullParameter($this$format, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return format.format($this$format);
    }

    @NotNull
    public static final YearMonth getYearMonth(@NotNull LocalDate $this$yearMonth) {
        Intrinsics.checkNotNullParameter($this$yearMonth, "<this>");
        return new YearMonth($this$yearMonth.getYear(), $this$yearMonth.getMonth());
    }

    @NotNull
    public static final LocalDate onDay(@NotNull YearMonth $this$onDay, int day2) {
        Intrinsics.checkNotNullParameter($this$onDay, "<this>");
        return new LocalDate($this$onDay.getYear(), $this$onDay.getMonth(), day2);
    }

    public static final int yearsUntil(@NotNull YearMonth $this$yearsUntil, @NotNull YearMonth other) {
        Intrinsics.checkNotNullParameter($this$yearsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return (int)((YearMonthKt.getProlepticMonth(other) - YearMonthKt.getProlepticMonth($this$yearsUntil)) / 12L);
    }

    public static final int monthsUntil(@NotNull YearMonth $this$monthsUntil, @NotNull YearMonth other) {
        Intrinsics.checkNotNullParameter($this$monthsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return MathKt.clampToInt(YearMonthKt.getProlepticMonth(other) - YearMonthKt.getProlepticMonth($this$monthsUntil));
    }

    public static final long until(@NotNull YearMonth $this$until, @NotNull YearMonth other, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter($this$until, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return (YearMonthKt.getProlepticMonth(other) - YearMonthKt.getProlepticMonth($this$until)) / (long)unit.getMonths();
    }

    @NotNull
    public static final YearMonth plusYear(@NotNull YearMonth $this$plusYear) {
        Intrinsics.checkNotNullParameter($this$plusYear, "<this>");
        return YearMonthKt.plus($this$plusYear, 1, DateTimeUnit.Companion.getYEAR());
    }

    @NotNull
    public static final YearMonth minusYear(@NotNull YearMonth $this$minusYear) {
        Intrinsics.checkNotNullParameter($this$minusYear, "<this>");
        return YearMonthKt.minus($this$minusYear, 1, DateTimeUnit.Companion.getYEAR());
    }

    @NotNull
    public static final YearMonth plusMonth(@NotNull YearMonth $this$plusMonth) {
        Intrinsics.checkNotNullParameter($this$plusMonth, "<this>");
        return YearMonthKt.plus($this$plusMonth, 1, DateTimeUnit.Companion.getMONTH());
    }

    @NotNull
    public static final YearMonth minusMonth(@NotNull YearMonth $this$minusMonth) {
        Intrinsics.checkNotNullParameter($this$minusMonth, "<this>");
        return YearMonthKt.minus($this$minusMonth, 1, DateTimeUnit.Companion.getMONTH());
    }

    @NotNull
    public static final YearMonth plus(@NotNull YearMonth $this$plus, int value, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return YearMonthKt.plus($this$plus, (long)value, unit);
    }

    @NotNull
    public static final YearMonth minus(@NotNull YearMonth $this$minus, int value, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return YearMonthKt.minus($this$minus, (long)value, unit);
    }

    @NotNull
    public static final YearMonth plus(@NotNull YearMonth $this$plus, long value, @NotNull DateTimeUnit.MonthBased unit) {
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        try {
            long monthsToAdd = MathJvmKt.safeMultiply(value, (long)unit.getMonths());
            boolean bl = false;
            yearMonth = monthsToAdd == 0L ? $this$plus : YearMonthKt.fromProlepticMonth(YearMonth.Companion, MathJvmKt.safeAdd(YearMonthKt.getProlepticMonth($this$plus), monthsToAdd));
        }
        catch (ArithmeticException e) {
            throw new DateTimeArithmeticException("Arithmetic overflow when adding " + value + " of " + unit + " to " + $this$plus, e);
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeArithmeticException("Boundaries of YearMonth exceeded when adding " + value + " of " + unit + " to " + $this$plus, e);
        }
        return yearMonth;
    }

    @NotNull
    public static final YearMonth minus(@NotNull YearMonth $this$minus, long value, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value != Long.MIN_VALUE ? YearMonthKt.plus($this$minus, -value, unit) : YearMonthKt.plus(YearMonthKt.plus($this$minus, Long.MAX_VALUE, unit), 1, unit);
    }

    public static final long getProlepticMonth(@NotNull YearMonth $this$prolepticMonth) {
        Intrinsics.checkNotNullParameter($this$prolepticMonth, "<this>");
        return (long)$this$prolepticMonth.getYear() * 12L + (long)($this$prolepticMonth.getMonthNumber$kotlinx_datetime() - 1);
    }

    @NotNull
    public static final YearMonth fromProlepticMonth(@NotNull YearMonth.Companion $this$fromProlepticMonth, long prolepticMonth) {
        Intrinsics.checkNotNullParameter($this$fromProlepticMonth, "<this>");
        long l = prolepticMonth;
        long l2 = 12;
        long l3 = l / l2;
        if ((l ^ l2) < 0L && l3 * l2 != l) {
            l3 += -1L;
        }
        long year2 = l3;
        int n = LocalDate.Companion.getMIN$kotlinx_datetime().getYear();
        if (!(year2 <= (long)LocalDate.Companion.getMAX$kotlinx_datetime().getYear() ? (long)n <= year2 : false)) {
            boolean bl = false;
            String string2 = "Year " + year2 + " is out of range: " + LocalDate.Companion.getMIN$kotlinx_datetime().getYear() + ".." + LocalDate.Companion.getMAX$kotlinx_datetime().getYear();
            throw new IllegalArgumentException(string2.toString());
        }
        long l4 = prolepticMonth;
        long l5 = 12;
        long l6 = l4 % l5;
        int month2 = (int)(l6 + (l5 & ((l6 ^ l5) & (l6 | -l6)) >> 63)) + 1;
        return new YearMonth((int)year2, month2);
    }

    @NotNull
    public static final YearMonth getMAX(@NotNull YearMonth.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter($this$MAX, "<this>");
        return YearMonthKt.getYearMonth(LocalDate.Companion.getMAX$kotlinx_datetime());
    }

    @NotNull
    public static final YearMonth getMIN(@NotNull YearMonth.Companion $this$MIN) {
        Intrinsics.checkNotNullParameter($this$MIN, "<this>");
        return YearMonthKt.getYearMonth(LocalDate.Companion.getMIN$kotlinx_datetime());
    }
}

