/*
 * Decompiled with CFR 0.152.
 */
package io.sanghun.compose.video.uri;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import androidx.media3.datasource.AssetDataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.FileDataSource;
import androidx.media3.datasource.RawResourceDataSource;
import io.sanghun.compose.video.uri.LiveLiterals$VideoPlayerMediaItemConverterKt;
import io.sanghun.compose.video.uri.VideoPlayerMediaItem;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u00a8\u0006\u0005"}, d2={"toUri", "Landroid/net/Uri;", "Lio/sanghun/compose/video/uri/VideoPlayerMediaItem;", "context", "Landroid/content/Context;", "compose-video_debug"})
public final class VideoPlayerMediaItemConverterKt {
    @SuppressLint(value={"UnsafeOptInUsageError"})
    @NotNull
    public static final Uri toUri(@NotNull VideoPlayerMediaItem $this$toUri, @NotNull Context context) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VideoPlayerMediaItem videoPlayerMediaItem = $this$toUri;
        if (videoPlayerMediaItem instanceof VideoPlayerMediaItem.RawResourceMediaItem) {
            Uri uri2 = RawResourceDataSource.buildRawResourceUri((int)((VideoPlayerMediaItem.RawResourceMediaItem)$this$toUri).getResourceId());
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n        RawResourceDat\u2026urceUri(resourceId)\n    }");
            uri = uri2;
        } else if (videoPlayerMediaItem instanceof VideoPlayerMediaItem.AssetFileMediaItem) {
            Uri uri3;
            DataSpec dataSpec = new DataSpec(Uri.parse((String)(LiveLiterals$VideoPlayerMediaItemConverterKt.INSTANCE.String$0$str$arg-0$call-parse$arg-0$call-$init$$val-dataSpec$branch-1$when$fun-toUri() + ((VideoPlayerMediaItem.AssetFileMediaItem)$this$toUri).getAssetPath())));
            AssetDataSource assetDataSource = new AssetDataSource(context);
            try {
                assetDataSource.open(dataSpec);
            }
            catch (AssetDataSource.AssetDataSourceException e) {
                e.printStackTrace();
            }
            if ((uri3 = assetDataSource.getUri()) == null) {
                uri3 = Uri.EMPTY;
            }
            Uri uri4 = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"{\n        val dataSpec =\u2026ce.uri ?: Uri.EMPTY\n    }");
            uri = uri4;
        } else if (videoPlayerMediaItem instanceof VideoPlayerMediaItem.NetworkMediaItem) {
            Uri uri5 = Uri.parse((String)((VideoPlayerMediaItem.NetworkMediaItem)$this$toUri).getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)uri5, (String)"{\n        Uri.parse(url)\n    }");
            uri = uri5;
        } else if (videoPlayerMediaItem instanceof VideoPlayerMediaItem.StorageMediaItem) {
            Uri uri6;
            DataSpec dataSpec = new DataSpec(((VideoPlayerMediaItem.StorageMediaItem)$this$toUri).getStorageUri());
            FileDataSource fileDataSource = new FileDataSource();
            try {
                fileDataSource.open(dataSpec);
            }
            catch (FileDataSource.FileDataSourceException e) {
                e.printStackTrace();
            }
            if ((uri6 = fileDataSource.getUri()) == null) {
                uri6 = Uri.EMPTY;
            }
            Uri uri7 = uri6;
            Intrinsics.checkNotNullExpressionValue((Object)uri7, (String)"{\n        val dataSpec =\u2026ce.uri ?: Uri.EMPTY\n    }");
            uri = uri7;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uri;
    }
}

