/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.BigSignificand;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FftMultiplier;
import java.math.BigInteger;
import java.util.Map;

class ParseDigitsTaskByteArray {
    private ParseDigitsTaskByteArray() {
    }

    static BigInteger parseDigitsIterative(byte[] str2, int from, int to) {
        assert (str2 != null) : "str==null";
        int numDigits = to - from;
        BigSignificand bigSignificand = new BigSignificand(FastIntegerMath.estimateNumBits(numDigits));
        int preroll = from + (numDigits & 7);
        int value = FastDoubleSwar.tryToParseUpTo7Digits(str2, from, preroll);
        boolean success = value >= 0;
        bigSignificand.add(value);
        for (from = preroll; from < to; from += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigits(str2, from);
            success &= addend >= 0;
            bigSignificand.fma(100000000, addend);
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return bigSignificand.toBigInteger();
    }

    static BigInteger parseDigitsRecursive(byte[] str2, int from, int to, Map<Integer, BigInteger> powersOfTen, int recursionThreshold) {
        assert (str2 != null) : "str==null";
        assert (powersOfTen != null) : "powersOfTen==null";
        int numDigits = to - from;
        if (numDigits <= recursionThreshold) {
            return ParseDigitsTaskByteArray.parseDigitsIterative(str2, from, to);
        }
        int mid = FastIntegerMath.splitFloor16(from, to);
        BigInteger high = ParseDigitsTaskByteArray.parseDigitsRecursive(str2, from, mid, powersOfTen, recursionThreshold);
        BigInteger low = ParseDigitsTaskByteArray.parseDigitsRecursive(str2, mid, to, powersOfTen, recursionThreshold);
        high = FftMultiplier.multiply(high, powersOfTen.get(to - mid));
        return low.add(high);
    }
}

