/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Lockable;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskLoggerKt;
import okhttp3.internal.concurrent.TaskRunner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u00014B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\b\b\u0002\u0010%\u001a\u00020&J&\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0(J0\u0010)\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010*\u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(J\u0006\u0010+\u001a\u00020,J%\u0010-\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b/J\u0006\u00100\u001a\u00020#J\u0006\u0010\f\u001a\u00020#J\r\u00101\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b2J\b\u00103\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000f\"\u0004\b\u001e\u0010\u0011R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001b\u00a8\u00065"}, d2={"Lokhttp3/internal/concurrent/TaskQueue;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "name", "", "<init>", "(Lokhttp3/internal/concurrent/TaskRunner;Ljava/lang/String;)V", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "getName$okhttp", "()Ljava/lang/String;", "shutdown", "", "getShutdown$okhttp", "()Z", "setShutdown$okhttp", "(Z)V", "activeTask", "Lokhttp3/internal/concurrent/Task;", "getActiveTask$okhttp", "()Lokhttp3/internal/concurrent/Task;", "setActiveTask$okhttp", "(Lokhttp3/internal/concurrent/Task;)V", "futureTasks", "", "getFutureTasks$okhttp", "()Ljava/util/List;", "cancelActiveTask", "getCancelActiveTask$okhttp", "setCancelActiveTask$okhttp", "scheduledTasks", "", "getScheduledTasks", "schedule", "", "task", "delayNanos", "", "block", "Lkotlin/Function0;", "execute", "cancelable", "idleLatch", "Ljava/util/concurrent/CountDownLatch;", "scheduleAndDecide", "recurrence", "scheduleAndDecide$okhttp", "cancelAll", "cancelAllAndDecide", "cancelAllAndDecide$okhttp", "toString", "AwaitIdleTask", "okhttp"})
@SourceDebugExtension(value={"SMAP\nTaskQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 3 TaskLogger.kt\nokhttp3/internal/concurrent/TaskLoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n63#2:242\n63#2:243\n63#2:252\n49#2,4:268\n63#2:272\n49#2,4:273\n63#2:277\n26#3,4:244\n26#3,4:248\n26#3,4:253\n26#3,4:257\n26#3,4:278\n360#4,7:261\n*S KotlinDebug\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n*L\n48#1:242\n64#1:243\n122#1:252\n202#1:268,4\n204#1:272\n212#1:273,4\n214#1:277\n67#1:244,4\n70#1:248,4\n173#1:253,4\n179#1:257,4\n231#1:278,4\n188#1:261,7\n*E\n"})
public final class TaskQueue {
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final String name;
    private boolean shutdown;
    @Nullable
    private Task activeTask;
    @NotNull
    private final List<Task> futureTasks;
    private boolean cancelActiveTask;

    public TaskQueue(@NotNull TaskRunner taskRunner, @NotNull String name) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(name, "name");
        this.taskRunner = taskRunner;
        this.name = name;
        this.futureTasks = new ArrayList();
    }

    @NotNull
    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    @NotNull
    public final String getName$okhttp() {
        return this.name;
    }

    public final boolean getShutdown$okhttp() {
        return this.shutdown;
    }

    public final void setShutdown$okhttp(boolean bl) {
        this.shutdown = bl;
    }

    @Nullable
    public final Task getActiveTask$okhttp() {
        return this.activeTask;
    }

    public final void setActiveTask$okhttp(@Nullable Task task) {
        this.activeTask = task;
    }

    @NotNull
    public final List<Task> getFutureTasks$okhttp() {
        return this.futureTasks;
    }

    public final boolean getCancelActiveTask$okhttp() {
        return this.cancelActiveTask;
    }

    public final void setCancelActiveTask$okhttp(boolean bl) {
        this.cancelActiveTask = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Task> getScheduledTasks() {
        List<Task> list2;
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            list2 = CollectionsKt.toList((Iterable)this.futureTasks);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void schedule(@NotNull Task task, long delayNanos) {
        Intrinsics.checkNotNullParameter(task, "task");
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.shutdown) {
                if (task.getCancelable()) {
                    void $this$taskLog$iv;
                    Logger logger = this.taskRunner.getLogger$okhttp();
                    Task task2 = task;
                    TaskQueue queue$iv = this;
                    boolean $i$f$taskLog = false;
                    if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                        void task$iv;
                        TaskQueue taskQueue = queue$iv;
                        void var13_17 = task$iv;
                        void var14_19 = $this$taskLog$iv;
                        boolean bl2 = false;
                        String string2 = "schedule canceled (queue is shutdown)";
                        TaskLoggerKt.access$log((Logger)var14_19, (Task)var13_17, taskQueue, string2);
                    }
                    return;
                }
                Logger $this$taskLog$iv = this.taskRunner.getLogger$okhttp();
                Task task$iv = task;
                TaskQueue queue$iv = this;
                boolean $i$f$taskLog = false;
                if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                    TaskQueue taskQueue = queue$iv;
                    Task task3 = task$iv;
                    Logger logger = $this$taskLog$iv;
                    boolean bl3 = false;
                    String string3 = "schedule failed (queue is shutdown)";
                    TaskLoggerKt.access$log(logger, task3, taskQueue, string3);
                }
                throw new RejectedExecutionException();
            }
            if (this.scheduleAndDecide$okhttp(task, delayNanos, false)) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void schedule$default(TaskQueue taskQueue, Task task, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        taskQueue.schedule(task, l);
    }

    public final void schedule(@NotNull String name, long delayNanos, @NotNull Function0<Long> block2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(block2, "block");
        this.schedule(new Task(name, block2){
            final /* synthetic */ Function0<Long> $block;
            {
                this.$block = $block;
                super($name, false, 2, null);
            }

            public long runOnce() {
                return ((Number)this.$block.invoke()).longValue();
            }
        }, delayNanos);
    }

    public static /* synthetic */ void schedule$default(TaskQueue taskQueue, String string2, long l, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        taskQueue.schedule(string2, l, function0);
    }

    public final void execute(@NotNull String name, long delayNanos, boolean cancelable, @NotNull Function0<Unit> block2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(block2, "block");
        this.schedule(new Task(name, cancelable, block2){
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$block = $block;
                super($name, $cancelable);
            }

            public long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, delayNanos);
    }

    public static /* synthetic */ void execute$default(TaskQueue taskQueue, String string2, long l, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        taskQueue.execute(string2, l, bl, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CountDownLatch idleLatch() {
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block9: {
                block8: {
                    boolean bl = false;
                    if (this.activeTask != null || !this.futureTasks.isEmpty()) break block8;
                    CountDownLatch countDownLatch = new CountDownLatch(0);
                    return countDownLatch;
                }
                Task existingTask = this.activeTask;
                if (!(existingTask instanceof AwaitIdleTask)) break block9;
                CountDownLatch countDownLatch = ((AwaitIdleTask)existingTask).getLatch();
                return countDownLatch;
            }
            for (Task futureTask : this.futureTasks) {
                if (!(futureTask instanceof AwaitIdleTask)) continue;
                CountDownLatch countDownLatch = ((AwaitIdleTask)futureTask).getLatch();
                return countDownLatch;
            }
            AwaitIdleTask newTask = new AwaitIdleTask();
            if (this.scheduleAndDecide$okhttp(newTask, 0L, false)) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            CountDownLatch countDownLatch = newTask.getLatch();
            return countDownLatch;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean scheduleAndDecide$okhttp(@NotNull Task task, long delayNanos, boolean recurrence) {
        int insertAt;
        block7: {
            int n;
            Intrinsics.checkNotNullParameter(task, "task");
            task.initQueue$okhttp(this);
            long now = this.taskRunner.getBackend().nanoTime();
            long executeNanoTime = now + delayNanos;
            int existingIndex = this.futureTasks.indexOf(task);
            if (existingIndex != -1) {
                if (task.getNextExecuteNanoTime$okhttp() <= executeNanoTime) {
                    void $this$taskLog$iv;
                    Logger logger = this.taskRunner.getLogger$okhttp();
                    Task task2 = task;
                    TaskQueue queue$iv = this;
                    boolean $i$f$taskLog = false;
                    if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                        void task$iv;
                        TaskQueue taskQueue = queue$iv;
                        void var19_19 = task$iv;
                        void var18_21 = $this$taskLog$iv;
                        boolean bl = false;
                        String string2 = "already scheduled";
                        TaskLoggerKt.access$log((Logger)var18_21, (Task)var19_19, taskQueue, string2);
                    }
                    return false;
                }
                this.futureTasks.remove(existingIndex);
            }
            task.setNextExecuteNanoTime$okhttp(executeNanoTime);
            Logger $this$taskLog$iv = this.taskRunner.getLogger$okhttp();
            Task task$iv = task;
            TaskQueue queue$iv = this;
            boolean $i$f$taskLog = false;
            if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                TaskQueue taskQueue = queue$iv;
                Task task3 = task$iv;
                Logger logger = $this$taskLog$iv;
                boolean bl = false;
                String string3 = recurrence ? "run again after " + TaskLoggerKt.formatDuration(executeNanoTime - now) : "scheduled after " + TaskLoggerKt.formatDuration(executeNanoTime - now);
                TaskLoggerKt.access$log(logger, task3, taskQueue, string3);
            }
            List<Task> $this$indexOfFirst$iv = this.futureTasks;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Task> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                Task item$iv;
                Task it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getNextExecuteNanoTime$okhttp() - now > delayNanos) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = insertAt = -1;
        }
        if (insertAt == -1) {
            insertAt = this.futureTasks.size();
        }
        this.futureTasks.add(insertAt, task);
        return insertAt == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelAll() {
        Lockable $this$assertLockNotHeld$iv = this.taskRunner;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Lockable $this$assertLockNotHeld$iv = this.taskRunner;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this.shutdown = true;
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean cancelAllAndDecide$okhttp() {
        if (this.activeTask != null) {
            Task task = this.activeTask;
            Intrinsics.checkNotNull(task);
            if (task.getCancelable()) {
                this.cancelActiveTask = true;
            }
        }
        boolean tasksCanceled = false;
        for (int i2 = this.futureTasks.size() - 1; -1 < i2; --i2) {
            void $this$taskLog$iv;
            if (!this.futureTasks.get(i2).getCancelable()) continue;
            Logger logger = this.taskRunner.getLogger$okhttp();
            Task task = this.futureTasks.get(i2);
            TaskQueue queue$iv = this;
            boolean $i$f$taskLog = false;
            if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                void task$iv;
                TaskQueue taskQueue = queue$iv;
                void var9_9 = task$iv;
                void var8_8 = $this$taskLog$iv;
                boolean bl = false;
                String string2 = "canceled";
                TaskLoggerKt.access$log((Logger)var8_8, (Task)var9_9, taskQueue, string2);
            }
            tasksCanceled = true;
            this.futureTasks.remove(i2);
        }
        return tasksCanceled;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lokhttp3/internal/concurrent/TaskQueue$AwaitIdleTask;", "Lokhttp3/internal/concurrent/Task;", "<init>", "()V", "latch", "Ljava/util/concurrent/CountDownLatch;", "getLatch", "()Ljava/util/concurrent/CountDownLatch;", "runOnce", "", "okhttp"})
    private static final class AwaitIdleTask
    extends Task {
        @NotNull
        private final CountDownLatch latch = new CountDownLatch(1);

        public AwaitIdleTask() {
            super(_UtilJvmKt.okHttpName + " awaitIdle", false);
        }

        @NotNull
        public final CountDownLatch getLatch() {
            return this.latch;
        }

        @Override
        public long runOnce() {
            this.latch.countDown();
            return -1L;
        }
    }
}

