/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.parse;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Tag;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1Header;
import org.apache.kerby.asn1.parse.Asn1Item;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Reader;

public class Asn1Parser {
    public static void parse(Asn1Container container2) throws IOException {
        Asn1ParseResult asn1Obj;
        Asn1Reader reader2 = new Asn1Reader(container2.getBuffer());
        int pos = container2.getBodyStart();
        do {
            reader2.setPosition(pos);
            asn1Obj = Asn1Parser.parse(reader2);
            if (asn1Obj == null) break;
            container2.addItem(asn1Obj);
        } while (!asn1Obj.isEOC() && !container2.checkBodyFinished(pos += asn1Obj.getEncodingLength()));
        container2.setBodyEnd(pos);
    }

    public static Asn1ParseResult parse(ByteBuffer content2) throws IOException {
        Asn1Reader reader2 = new Asn1Reader(content2);
        return Asn1Parser.parse(reader2);
    }

    public static Asn1ParseResult parse(Asn1Reader reader2) throws IOException {
        Asn1ParseResult parseResult;
        if (!reader2.available()) {
            return null;
        }
        Asn1Header header2 = reader2.readHeader();
        Tag tmpTag = header2.getTag();
        int bodyStart = reader2.getPosition();
        if (tmpTag.isPrimitive()) {
            parseResult = new Asn1Item(header2, bodyStart, reader2.getBuffer());
        } else {
            Asn1Container container2 = new Asn1Container(header2, bodyStart, reader2.getBuffer());
            if (header2.getLength() != 0) {
                Asn1Parser.parse(container2);
            }
            parseResult = container2;
        }
        return parseResult;
    }
}

