/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.paging.InvalidateCallbackTracker;
import androidx.paging.LoadType;
import androidx.paging.PagingLogger;
import androidx.paging.PagingState;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\tJ\u0014\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u0019\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bJ(\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u00a6@\u00a2\u0006\u0002\u0010\u001eJ#\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010!H&\u00a2\u0006\u0002\u0010\"R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006%"}, d2={"Landroidx/paging/PagingSource;", "Key", "", "Value", "<init>", "()V", "invalidateCallbackTracker", "Landroidx/paging/InvalidateCallbackTracker;", "Lkotlin/Function0;", "", "invalidateCallbackCount", "", "getInvalidateCallbackCount$paging_common", "()I", "jumpingSupported", "", "getJumpingSupported", "()Z", "keyReuseSupported", "getKeyReuseSupported", "invalid", "getInvalid", "invalidate", "registerInvalidatedCallback", "onInvalidatedCallback", "unregisterInvalidatedCallback", "load", "Landroidx/paging/PagingSource$LoadResult;", "params", "Landroidx/paging/PagingSource$LoadParams;", "(Landroidx/paging/PagingSource$LoadParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Object;", "LoadParams", "LoadResult", "paging-common"})
@SourceDebugExtension(value={"SMAP\nPagingSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagingSource.kt\nandroidx/paging/PagingSource\n+ 2 PagingLogger.kt\nandroidx/paging/PagingLoggerKt\n*L\n1#1,402:1\n33#2,10:403\n*S KotlinDebug\n*F\n+ 1 PagingSource.kt\nandroidx/paging/PagingSource\n*L\n337#1:403,10\n*E\n"})
public abstract class PagingSource<Key, Value> {
    @NotNull
    private final InvalidateCallbackTracker<Function0<Unit>> invalidateCallbackTracker = new InvalidateCallbackTracker(PagingSource::invalidateCallbackTracker$lambda$0, null, 2, null);

    @VisibleForTesting
    public final int getInvalidateCallbackCount$paging_common() {
        return this.invalidateCallbackTracker.callbackCount$paging_common();
    }

    public boolean getJumpingSupported() {
        return false;
    }

    public boolean getKeyReuseSupported() {
        return false;
    }

    public final boolean getInvalid() {
        return this.invalidateCallbackTracker.getInvalid$paging_common();
    }

    public final void invalidate() {
        if (this.invalidateCallbackTracker.invalidate$paging_common()) {
            int level$iv = 3;
            Throwable tr$iv = null;
            boolean $i$f$log = false;
            PagingLogger logger$iv = PagingLogger.INSTANCE;
            if (logger$iv.isLoggable(level$iv)) {
                int n = level$iv;
                PagingLogger pagingLogger = logger$iv;
                boolean bl = false;
                String string = "Invalidated PagingSource " + this;
                pagingLogger.log(n, string, tr$iv);
            }
        }
    }

    public final void registerInvalidatedCallback(@NotNull Function0<Unit> onInvalidatedCallback) {
        Intrinsics.checkNotNullParameter(onInvalidatedCallback, (String)"onInvalidatedCallback");
        this.invalidateCallbackTracker.registerInvalidatedCallback$paging_common(onInvalidatedCallback);
    }

    public final void unregisterInvalidatedCallback(@NotNull Function0<Unit> onInvalidatedCallback) {
        Intrinsics.checkNotNullParameter(onInvalidatedCallback, (String)"onInvalidatedCallback");
        this.invalidateCallbackTracker.unregisterInvalidatedCallback$paging_common(onInvalidatedCallback);
    }

    @Nullable
    public abstract Object load(@NotNull LoadParams<Key> var1, @NotNull Continuation<? super LoadResult<Key, Value>> var2);

    @Nullable
    public abstract Key getRefreshKey(@NotNull PagingState<Key, Value> var1);

    private static final Unit invalidateCallbackTracker$lambda$0(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.invoke();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0013*\b\b\u0002\u0010\u0001*\u00020\u00022\u00020\u0002:\u0004\u0010\u0011\u0012\u0013B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00018\u0002X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0003\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Landroidx/paging/PagingSource$LoadParams;", "Key", "", "loadSize", "", "placeholdersEnabled", "", "<init>", "(IZ)V", "getLoadSize", "()I", "getPlaceholdersEnabled", "()Z", "key", "getKey", "()Ljava/lang/Object;", "Refresh", "Append", "Prepend", "Companion", "Landroidx/paging/PagingSource$LoadParams$Append;", "Landroidx/paging/PagingSource$LoadParams$Prepend;", "Landroidx/paging/PagingSource$LoadParams$Refresh;", "paging-common"})
    public static abstract class LoadParams<Key> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int loadSize;
        private final boolean placeholdersEnabled;

        private LoadParams(int loadSize, boolean placeholdersEnabled) {
            this.loadSize = loadSize;
            this.placeholdersEnabled = placeholdersEnabled;
        }

        public final int getLoadSize() {
            return this.loadSize;
        }

        public final boolean getPlaceholdersEnabled() {
            return this.placeholdersEnabled;
        }

        @Nullable
        public abstract Key getKey();

        public /* synthetic */ LoadParams(int loadSize, boolean placeholdersEnabled, DefaultConstructorMarker $constructor_marker) {
            this(loadSize, placeholdersEnabled);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Landroidx/paging/PagingSource$LoadParams$Append;", "Key", "", "Landroidx/paging/PagingSource$LoadParams;", "key", "loadSize", "", "placeholdersEnabled", "", "<init>", "(Ljava/lang/Object;IZ)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "paging-common"})
        public static final class Append<Key>
        extends LoadParams<Key> {
            @NotNull
            private final Key key;

            public Append(@NotNull Key key, int loadSize, boolean placeholdersEnabled) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                super(loadSize, placeholdersEnabled, null);
                this.key = key;
            }

            @Override
            @NotNull
            public Key getKey() {
                return this.key;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0003\u0010\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u0001H\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/paging/PagingSource$LoadParams$Companion;", "", "<init>", "()V", "create", "Landroidx/paging/PagingSource$LoadParams;", "Key", "loadType", "Landroidx/paging/LoadType;", "key", "loadSize", "", "placeholdersEnabled", "", "(Landroidx/paging/LoadType;Ljava/lang/Object;IZ)Landroidx/paging/PagingSource$LoadParams;", "paging-common"})
        @SourceDebugExtension(value={"SMAP\nPagingSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagingSource.kt\nandroidx/paging/PagingSource$LoadParams$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,402:1\n1#2:403\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <Key> LoadParams<Key> create(@NotNull LoadType loadType, @Nullable Key key, int loadSize, boolean placeholdersEnabled) {
                LoadParams loadParams;
                Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
                switch (WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()]) {
                    case 1: {
                        loadParams = new Refresh<Key>(key, loadSize, placeholdersEnabled);
                        break;
                    }
                    case 2: {
                        Key Key = key;
                        if (Key == null) {
                            boolean $i$a$-requireNotNull-PagingSource$LoadParams$Companion$create$32 = false;
                            String $i$a$-requireNotNull-PagingSource$LoadParams$Companion$create$32 = "key cannot be null for prepend";
                            throw new IllegalArgumentException($i$a$-requireNotNull-PagingSource$LoadParams$Companion$create$32.toString());
                        }
                        Key Key2 = Key;
                        loadParams = new Prepend<Key>(Key2, loadSize, placeholdersEnabled);
                        break;
                    }
                    case 3: {
                        Key Key = key;
                        if (Key == null) {
                            boolean bl = false;
                            String string = "key cannot be null for append";
                            throw new IllegalArgumentException(string.toString());
                        }
                        Key Key3 = Key;
                        loadParams = new Append<Key>(Key3, loadSize, placeholdersEnabled);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return loadParams;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LoadType.values().length];
                    try {
                        nArray[LoadType.REFRESH.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoadType.PREPEND.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoadType.APPEND.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Landroidx/paging/PagingSource$LoadParams$Prepend;", "Key", "", "Landroidx/paging/PagingSource$LoadParams;", "key", "loadSize", "", "placeholdersEnabled", "", "<init>", "(Ljava/lang/Object;IZ)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "paging-common"})
        public static final class Prepend<Key>
        extends LoadParams<Key> {
            @NotNull
            private final Key key;

            public Prepend(@NotNull Key key, int loadSize, boolean placeholdersEnabled) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                super(loadSize, placeholdersEnabled, null);
                this.key = key;
            }

            @Override
            @NotNull
            public Key getKey() {
                return this.key;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0018\u0010\u0004\u001a\u0004\u0018\u00018\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Landroidx/paging/PagingSource$LoadParams$Refresh;", "Key", "", "Landroidx/paging/PagingSource$LoadParams;", "key", "loadSize", "", "placeholdersEnabled", "", "<init>", "(Ljava/lang/Object;IZ)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "paging-common"})
        public static final class Refresh<Key>
        extends LoadParams<Key> {
            @Nullable
            private final Key key;

            public Refresh(@Nullable Key key, int loadSize, boolean placeholdersEnabled) {
                super(loadSize, placeholdersEnabled, null);
                this.key = key;
            }

            @Override
            @Nullable
            public Key getKey() {
                return this.key;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0002:\u0003\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0004\u0010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Landroidx/paging/PagingSource$LoadResult;", "Key", "", "Value", "<init>", "()V", "Error", "Invalid", "Page", "Landroidx/paging/PagingSource$LoadResult$Error;", "Landroidx/paging/PagingSource$LoadResult$Invalid;", "Landroidx/paging/PagingSource$LoadResult$Page;", "paging-common"})
    public static abstract class LoadResult<Key, Value> {
        private LoadResult() {
        }

        public /* synthetic */ LoadResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0004\u0010\u0001*\u00020\u0002*\b\b\u0005\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\u001f\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/paging/PagingSource$LoadResult$Error;", "Key", "", "Value", "Landroidx/paging/PagingSource$LoadResult;", "throwable", "", "<init>", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "toString", "", "component1", "copy", "equals", "", "other", "hashCode", "", "paging-common"})
        public static final class Error<Key, Value>
        extends LoadResult<Key, Value> {
            @NotNull
            private final Throwable throwable;

            public Error(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                super(null);
                this.throwable = throwable;
            }

            @NotNull
            public final Throwable getThrowable() {
                return this.throwable;
            }

            @NotNull
            public String toString() {
                return StringsKt.trimMargin$default((String)("LoadResult.Error(\n                    |   throwable: " + this.throwable + "\n                    |) "), null, (int)1, null);
            }

            @NotNull
            public final Throwable component1() {
                return this.throwable;
            }

            @NotNull
            public final Error<Key, Value> copy(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                return new Error<Key, Value>(throwable);
            }

            public static /* synthetic */ Error copy$default(Error error, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = error.throwable;
                }
                return error.copy(throwable);
            }

            public int hashCode() {
                return this.throwable.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.throwable, (Object)error.throwable);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0004\u0010\u0001*\u00020\u0002*\b\b\u0005\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Landroidx/paging/PagingSource$LoadResult$Invalid;", "Key", "", "Value", "Landroidx/paging/PagingSource$LoadResult;", "<init>", "()V", "toString", "", "paging-common"})
        public static final class Invalid<Key, Value>
        extends LoadResult<Key, Value> {
            public Invalid() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "LoadResult.Invalid";
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 (*\b\b\u0004\u0010\u0001*\u00020\u0002*\b\b\u0005\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001(B=\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00050\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0004\u0012\b\b\u0003\u0010\n\u001a\u00020\u000b\u0012\b\b\u0003\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB+\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00050\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0004\u00a2\u0006\u0004\b\r\u0010\u000fJ\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00050\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00050\u0007H\u00c6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00018\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001f\u001a\u0004\u0018\u00018\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003JV\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00050\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00018\u00042\b\b\u0003\u0010\n\u001a\u00020\u000b2\b\b\u0003\u0010\f\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010'\u001a\u00020\u000bH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\b\u001a\u0004\u0018\u00018\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\t\u001a\u0004\u0018\u00018\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006)"}, d2={"Landroidx/paging/PagingSource$LoadResult$Page;", "Key", "", "Value", "Landroidx/paging/PagingSource$LoadResult;", "", "data", "", "prevKey", "nextKey", "itemsBefore", "", "itemsAfter", "<init>", "(Ljava/util/List;Ljava/lang/Object;Ljava/lang/Object;II)V", "(Ljava/util/List;Ljava/lang/Object;Ljava/lang/Object;)V", "getData", "()Ljava/util/List;", "getPrevKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getNextKey", "getItemsBefore", "()I", "getItemsAfter", "iterator", "", "toString", "", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/util/List;Ljava/lang/Object;Ljava/lang/Object;II)Landroidx/paging/PagingSource$LoadResult$Page;", "equals", "", "other", "hashCode", "Companion", "paging-common"})
        public static final class Page<Key, Value>
        extends LoadResult<Key, Value>
        implements Iterable<Value>,
        KMappedMarker {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final List<Value> data;
            @Nullable
            private final Key prevKey;
            @Nullable
            private final Key nextKey;
            private final int itemsBefore;
            private final int itemsAfter;
            public static final int COUNT_UNDEFINED = Integer.MIN_VALUE;
            @NotNull
            private static final Page EMPTY = new Page(CollectionsKt.emptyList(), null, null, 0, 0);

            public Page(@NotNull List<? extends Value> data, @Nullable Key prevKey, @Nullable Key nextKey, @IntRange(from=-2147483648L) int itemsBefore, @IntRange(from=-2147483648L) int itemsAfter) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                super(null);
                this.data = data;
                this.prevKey = prevKey;
                this.nextKey = nextKey;
                this.itemsBefore = itemsBefore;
                this.itemsAfter = itemsAfter;
                if (!(this.itemsBefore == Integer.MIN_VALUE || this.itemsBefore >= 0)) {
                    boolean $i$a$-require-PagingSource$LoadResult$Page$32 = false;
                    String $i$a$-require-PagingSource$LoadResult$Page$32 = "itemsBefore cannot be negative";
                    throw new IllegalArgumentException($i$a$-require-PagingSource$LoadResult$Page$32.toString());
                }
                if (!(this.itemsAfter == Integer.MIN_VALUE || this.itemsAfter >= 0)) {
                    boolean bl = false;
                    String string = "itemsAfter cannot be negative";
                    throw new IllegalArgumentException(string.toString());
                }
            }

            public /* synthetic */ Page(List list, Object object, Object object2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 8) != 0) {
                    n = Integer.MIN_VALUE;
                }
                if ((n3 & 0x10) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                this(list, object, object2, n, n2);
            }

            @NotNull
            public final List<Value> getData() {
                return this.data;
            }

            @Nullable
            public final Key getPrevKey() {
                return this.prevKey;
            }

            @Nullable
            public final Key getNextKey() {
                return this.nextKey;
            }

            public final int getItemsBefore() {
                return this.itemsBefore;
            }

            public final int getItemsAfter() {
                return this.itemsAfter;
            }

            public Page(@NotNull List<? extends Value> data, @Nullable Key prevKey, @Nullable Key nextKey) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                this(data, prevKey, nextKey, Integer.MIN_VALUE, Integer.MIN_VALUE);
            }

            @Override
            @NotNull
            public Iterator<Value> iterator() {
                return this.data.listIterator();
            }

            @NotNull
            public String toString() {
                return StringsKt.trimMargin$default((String)("LoadResult.Page(\n                    |   data size: " + this.data.size() + "\n                    |   first Item: " + CollectionsKt.firstOrNull(this.data) + "\n                    |   last Item: " + CollectionsKt.lastOrNull(this.data) + "\n                    |   nextKey: " + this.nextKey + "\n                    |   prevKey: " + this.prevKey + "\n                    |   itemsBefore: " + this.itemsBefore + "\n                    |   itemsAfter: " + this.itemsAfter + "\n                    |) "), null, (int)1, null);
            }

            @NotNull
            public final List<Value> component1() {
                return this.data;
            }

            @Nullable
            public final Key component2() {
                return this.prevKey;
            }

            @Nullable
            public final Key component3() {
                return this.nextKey;
            }

            public final int component4() {
                return this.itemsBefore;
            }

            public final int component5() {
                return this.itemsAfter;
            }

            @NotNull
            public final Page<Key, Value> copy(@NotNull List<? extends Value> data, @Nullable Key prevKey, @Nullable Key nextKey, @IntRange(from=-2147483648L) int itemsBefore, @IntRange(from=-2147483648L) int itemsAfter) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                return new Page<Key, Value>(data, prevKey, nextKey, itemsBefore, itemsAfter);
            }

            public static /* synthetic */ Page copy$default(Page page, List list, Object object, Object object2, int n, int n2, int n3, Object object3) {
                if ((n3 & 1) != 0) {
                    list = page.data;
                }
                if ((n3 & 2) != 0) {
                    object = page.prevKey;
                }
                if ((n3 & 4) != 0) {
                    object2 = page.nextKey;
                }
                if ((n3 & 8) != 0) {
                    n = page.itemsBefore;
                }
                if ((n3 & 0x10) != 0) {
                    n2 = page.itemsAfter;
                }
                return page.copy(list, object, object2, n, n2);
            }

            public int hashCode() {
                int result = ((Object)this.data).hashCode();
                result = result * 31 + (this.prevKey == null ? 0 : this.prevKey.hashCode());
                result = result * 31 + (this.nextKey == null ? 0 : this.nextKey.hashCode());
                result = result * 31 + Integer.hashCode(this.itemsBefore);
                result = result * 31 + Integer.hashCode(this.itemsAfter);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Page)) {
                    return false;
                }
                Page page = (Page)other;
                if (!Intrinsics.areEqual(this.data, page.data)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.prevKey, page.prevKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.nextKey, page.nextKey)) {
                    return false;
                }
                if (this.itemsBefore != page.itemsBefore) {
                    return false;
                }
                return this.itemsAfter == page.itemsAfter;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0007\"\b\b\u0006\u0010\r*\u00020\u0001\"\b\b\u0007\u0010\u000e*\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Landroidx/paging/PagingSource$LoadResult$Page$Companion;", "", "<init>", "()V", "COUNT_UNDEFINED", "", "EMPTY", "Landroidx/paging/PagingSource$LoadResult$Page;", "", "getEMPTY$paging_common$annotations", "getEMPTY$paging_common", "()Landroidx/paging/PagingSource$LoadResult$Page;", "empty", "Key", "Value", "empty$paging_common", "paging-common"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Page getEMPTY$paging_common() {
                    return EMPTY;
                }

                public static /* synthetic */ void getEMPTY$paging_common$annotations() {
                }

                @NotNull
                public final <Key, Value> Page<Key, Value> empty$paging_common() {
                    Page page = this.getEMPTY$paging_common();
                    Intrinsics.checkNotNull((Object)page, (String)"null cannot be cast to non-null type androidx.paging.PagingSource.LoadResult.Page<Key of androidx.paging.PagingSource.LoadResult.Page.Companion.empty, Value of androidx.paging.PagingSource.LoadResult.Page.Companion.empty>");
                    return page;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

