/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Interval;
import androidx.compose.ui.graphics.IntervalTree;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/compose/animation/core/PathEasing;", "Landroidx/compose/animation/core/Easing;", "path", "Landroidx/compose/ui/graphics/Path;", "<init>", "(Landroidx/compose/ui/graphics/Path;)V", "intervals", "Landroidx/compose/ui/graphics/IntervalTree;", "Landroidx/compose/ui/graphics/PathSegment;", "transform", "", "fraction", "initializeEasing", "", "animation-core"})
@Immutable
@SourceDebugExtension(value={"SMAP\nPathEasing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathEasing.kt\nandroidx/compose/animation/core/PathEasing\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n*L\n1#1,116:1\n64#2,4:117\n53#2,4:121\n34#2,4:125\n34#2,4:132\n51#3:129\n55#3:131\n22#4:130\n*S KotlinDebug\n*F\n+ 1 PathEasing.kt\nandroidx/compose/animation/core/PathEasing\n*L\n69#1:117,4\n74#1:121,4\n96#1:125,4\n109#1:132,4\n104#1:129\n104#1:131\n104#1:130\n*E\n"})
public final class PathEasing
implements Easing {
    @NotNull
    private final Path path;
    private IntervalTree<PathSegment> intervals;
    public static final int $stable;

    public PathEasing(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.path = path;
    }

    @Override
    public float transform(float fraction) {
        IntervalTree<PathSegment> intervalTree;
        if (fraction <= 0.0f) {
            return 0.0f;
        }
        if (fraction >= 1.0f) {
            return 1.0f;
        }
        if (this.intervals == null) {
            this.initializeEasing();
        }
        if ((intervalTree = this.intervals) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("intervals");
            intervalTree = null;
        }
        Interval result2 = IntervalTree.findFirstOverlap$default(intervalTree, fraction, 0.0f, 2, null);
        Object value$iv = result2.getData();
        boolean $i$f$checkPreconditionNotNull = false;
        if (value$iv == null) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateExceptionForNullCheck("The easing path is invalid. Make sure it is continuous on the x axis.");
            throw new KotlinNothingValueException();
        }
        PathSegment segment = (PathSegment)value$iv;
        float t = BezierKt.findFirstRoot(segment, fraction);
        boolean value$iv2 = !Float.isNaN(t);
        boolean $i$f$checkPrecondition = false;
        if (!value$iv2) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("The easing path is invalid. Make sure it does not contain NaN/Infinity values.");
        }
        return BezierKt.evaluateY(segment, t);
    }

    private final void initializeEasing() {
        IntervalTree<PathSegment> intervalTree;
        float[] roots = new float[5];
        IntervalTree<PathSegment> $this$initializeEasing_u24lambda_u243 = intervalTree = new IntervalTree<PathSegment>();
        boolean bl = false;
        PathIterator iterator2 = this.path.iterator(PathIterator.ConicEvaluation.AsQuadratics, 2.0E-4f);
        while (iterator2.hasNext()) {
            PathSegment segment = iterator2.next();
            boolean value$iv = segment.getType() != PathSegment.Type.Close;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl2 = false;
                PreconditionsKt.throwIllegalArgumentException("The path cannot contain a close() command.");
            }
            if (segment.getType() == PathSegment.Type.Move || segment.getType() == PathSegment.Type.Done) continue;
            long bounds2 = BezierKt.computeHorizontalBounds$default(segment, roots, 0, 4, null);
            boolean bl3 = false;
            int bits$iv$iv = (int)(bounds2 >> 32);
            boolean $i$f$floatFromBits = false;
            float f = Float.intBitsToFloat(bits$iv$iv);
            boolean bl4 = false;
            bits$iv$iv = (int)(bounds2 & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            $this$initializeEasing_u24lambda_u243.addInterval(f, Float.intBitsToFloat(bits$iv$iv), segment);
        }
        IntervalTree<PathSegment> segmentIntervals = intervalTree;
        boolean value$iv = segmentIntervals.contains(0.0f) && segmentIntervals.contains(1.0f);
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl5 = false;
            PreconditionsKt.throwIllegalArgumentException("The easing path must start at 0.0f and end at 1.0f.");
        }
        this.intervals = segmentIntervals;
    }
}

