/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.ext.java7;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import net.sourceforge.argparse4j.ext.java7.Java7ExtensionResourceBundle;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.impl.type.FileVerification;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;

public class PathArgumentType
implements ArgumentType<Path> {
    private final FileSystem fileSystem;
    private boolean acceptSystemIn = false;
    private final FileVerification firstFileVerification;
    private FileVerification currentFileVerification = this.firstFileVerification = new FileVerification();

    public PathArgumentType() {
        this.fileSystem = FileSystems.getDefault();
    }

    public PathArgumentType(FileSystem fileSystem2) {
        this.fileSystem = fileSystem2;
    }

    public PathArgumentType acceptSystemIn() {
        this.acceptSystemIn = true;
        return this;
    }

    public PathArgumentType verifyExists() {
        this.currentFileVerification.verifyExists = true;
        return this;
    }

    public PathArgumentType verifyNotExists() {
        this.currentFileVerification.verifyNotExists = true;
        return this;
    }

    public PathArgumentType verifyIsFile() {
        this.currentFileVerification.verifyIsFile = true;
        return this;
    }

    public PathArgumentType verifyIsDirectory() {
        this.currentFileVerification.verifyIsDirectory = true;
        return this;
    }

    public PathArgumentType verifyCanRead() {
        this.currentFileVerification.verifyCanRead = true;
        return this;
    }

    public PathArgumentType verifyCanWrite() {
        this.currentFileVerification.verifyCanWrite = true;
        return this;
    }

    public PathArgumentType verifyCanWriteParent() {
        this.currentFileVerification.verifyCanWriteParent = true;
        return this;
    }

    public PathArgumentType verifyCanCreate() {
        this.currentFileVerification.verifyCanCreate = true;
        return this;
    }

    public PathArgumentType verifyCanExecute() {
        this.currentFileVerification.verifyCanExecute = true;
        return this;
    }

    public PathArgumentType verifyIsAbsolute() {
        this.currentFileVerification.verifyIsAbsolute = true;
        return this;
    }

    public PathArgumentType or() {
        this.currentFileVerification = this.currentFileVerification.or();
        return this;
    }

    @Override
    public Path convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        Path path;
        try {
            path = this.fileSystem.getPath(value, new String[0]);
        }
        catch (InvalidPathException e) {
            String localizedTypeName = Java7ExtensionResourceBundle.get(parser.getConfig().getLocale()).getString("path");
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), "couldNotConvertToError"), value, localizedTypeName), e.getCause(), parser, arg);
        }
        try {
            File file2 = path.toFile();
            if (!this.isSystemIn(value)) {
                this.firstFileVerification.verify(parser, arg, file2);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return path;
    }

    private boolean isSystemIn(String path) {
        return this.acceptSystemIn && path.equals("-");
    }
}

