/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.token;

import com.ethlo.time.internal.util.ErrorUtil;
import com.ethlo.time.token.DateTimeToken;
import java.text.ParsePosition;

public class SeparatorToken
implements DateTimeToken {
    private final char separator;

    public SeparatorToken(char separator) {
        this.separator = separator;
    }

    @Override
    public int read(String text, ParsePosition parsePosition) {
        int index2 = parsePosition.getIndex();
        if (text.length() > index2 && text.charAt(index2) == this.separator) {
            parsePosition.setIndex(index2 + 1);
        } else if (text.length() <= index2) {
            ErrorUtil.raiseUnexpectedEndOfText(text, text.length());
        } else if (text.charAt(index2) != this.separator) {
            ErrorUtil.raiseUnexpectedCharacter(text, index2, this.separator);
        }
        parsePosition.setIndex(index2 + 1);
        return 1;
    }

    public String toString() {
        return "separator: " + this.separator;
    }
}

