/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.statement.androidkey;

import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import com.webauthn4j.verifier.exception.KeyDescriptionValidationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDescriptionVerifier {
    public static final String ATTESTATION_EXTENSION_OID = "1.3.6.1.4.1.11129.2.1.17";
    public static final int ATTESTATION_CHALLENGE_INDEX = 4;
    public static final int SW_ENFORCED_INDEX = 6;
    public static final int TEE_ENFORCED_INDEX = 7;
    public static final int KM_TAG_PURPOSE = 1;
    public static final int KM_TAG_ALL_APPLICATIONS = 600;
    public static final int KM_TAG_CREATION_DATE_TIME = 701;
    public static final int KM_TAG_ORIGIN = 702;
    public static final int KM_ORIGIN_GENERATED = 0;
    public static final int KM_PURPOSE_SIGN = 2;
    private final Logger logger = LoggerFactory.getLogger(KeyDescriptionVerifier.class);

    public void verify(@NotNull X509Certificate x509Certificate, @NotNull byte[] clientDataHash, boolean teeEnforcedOnly) {
        AssertUtil.notNull(x509Certificate, "x509Certificate must not be null");
        AssertUtil.notNull(clientDataHash, "clientDataHash must not be null");
        try {
            Asn1Container keyDescription = this.extractKeyDescription(x509Certificate);
            this.doVerify(keyDescription, clientDataHash, teeEnforcedOnly);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    Asn1Container extractKeyDescription(@NotNull X509Certificate x509Certificate) throws IOException {
        byte[] attestationExtensionBytes = x509Certificate.getExtensionValue(ATTESTATION_EXTENSION_OID);
        Asn1OctetString envelope = new Asn1OctetString();
        if (attestationExtensionBytes == null) {
            throw new KeyDescriptionValidationException("KeyDescription must not be null");
        }
        envelope.decode(attestationExtensionBytes);
        return (Asn1Container)Asn1Parser.parse(ByteBuffer.wrap((byte[])envelope.getValue()));
    }

    void doVerify(@NotNull Asn1Container keyDescription, @NotNull byte[] clientDataHash, boolean teeEnforcedOnly) throws IOException {
        byte[] attestationChallenge = keyDescription.getChildren().get(4).readBodyBytes();
        if (!Arrays.equals(attestationChallenge, clientDataHash)) {
            throw new KeyDescriptionValidationException("Attestation challenge doesn't match.");
        }
        Asn1Container softwareEnforced = (Asn1Container)keyDescription.getChildren().get(6);
        Asn1Container teeEnforced = (Asn1Container)keyDescription.getChildren().get(7);
        if (this.findAuthorizationListEntry(softwareEnforced, 600) != null || this.findAuthorizationListEntry(teeEnforced, 600) != null) {
            throw new KeyDescriptionValidationException("Key is not scoped properly.");
        }
        this.verifyAuthorizationList(teeEnforcedOnly, softwareEnforced, teeEnforced);
    }

    private void verifyAuthorizationList(boolean teeEnforcedOnly, @NotNull Asn1Container softwareEnforced, @NotNull Asn1Container teeEnforced) throws IOException {
        if (teeEnforcedOnly) {
            if (!this.isKeyGeneratedInKeymaster(this.findAuthorizationListEntry(teeEnforced, 702))) {
                throw new KeyDescriptionValidationException("Key is not generated in keymaster.");
            }
            if (!this.containsValidPurpose(this.findAuthorizationListEntry(teeEnforced, 1))) {
                throw new KeyDescriptionValidationException("Key purpose is invalid.");
            }
        } else {
            if (!this.isKeyGeneratedInKeymaster(this.findAuthorizationListEntry(teeEnforced, 702)) && !this.isKeyGeneratedInKeymaster(this.findAuthorizationListEntry(softwareEnforced, 702))) {
                throw new KeyDescriptionValidationException("Key is not generated in keymaster.");
            }
            if (!this.containsValidPurpose(this.findAuthorizationListEntry(teeEnforced, 1)) && !this.containsValidPurpose(this.findAuthorizationListEntry(softwareEnforced, 1))) {
                throw new KeyDescriptionValidationException("Key purpose is invalid.");
            }
        }
    }

    private boolean isKeyGeneratedInKeymaster(@Nullable Asn1ParseResult origin2) {
        try {
            return Objects.equals(this.getIntegerFromAsn1(origin2), BigInteger.valueOf(0L));
        }
        catch (IOException | RuntimeException e) {
            this.logger.debug("Failed to retrieve origin.", e);
            return false;
        }
    }

    private boolean containsValidPurpose(@Nullable Asn1ParseResult purposes) throws IOException {
        try {
            if (purposes == null) {
                return false;
            }
            Asn1Container set2 = (Asn1Container)purposes;
            for (Asn1ParseResult purpose : set2.getChildren()) {
                if (!Objects.equals(this.getIntegerFromAsn1(purpose), BigInteger.valueOf(2L))) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            this.logger.debug("Failed to retrieve purpose.", e);
            return false;
        }
    }

    @Nullable
    private BigInteger getIntegerFromAsn1(Asn1ParseResult asn1Value) throws IOException {
        if (asn1Value == null) {
            return null;
        }
        if (!asn1Value.isPrimitive()) {
            throw new BadAttestationStatementException(String.format("ASN1Integer is expected. Found %s instead.", asn1Value.getClass().getName()));
        }
        Asn1Integer value = new Asn1Integer();
        value.decode(asn1Value);
        return (BigInteger)value.getValue();
    }

    @Nullable
    private Asn1ParseResult findAuthorizationListEntry(@NotNull Asn1Container authorizationList, int tag) {
        for (Asn1ParseResult entry : authorizationList.getChildren()) {
            if (entry.tagNo() != tag) continue;
            return ((Asn1Container)entry).getChildren().get(0);
        }
        return null;
    }
}

