/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.response;

import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.headers.IHttpHeadersExtKt;
import com.ustadmobile.ihttp.response.IHttpResponse;
import com.ustadmobile.libcache.CompressionType;
import com.ustadmobile.libcache.io.SourceExtKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007*\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/ihttp/response/IHttpResponse;", "", "requireHeadersContentLength", "(Lcom/ustadmobile/ihttp/response/IHttpResponse;)J", "Lkotlinx/io/Source;", "bodyAsUncompressedSourceIfContentEncoded", "(Lcom/ustadmobile/ihttp/response/IHttpResponse;)Lkotlinx/io/Source;", "", "bodyAsString", "(Lcom/ustadmobile/ihttp/response/IHttpResponse;)Ljava/lang/String;", "respect-lib-cache"})
@SourceDebugExtension(value={"SMAP\nHttpResponseExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpResponseExt.kt\ncom/ustadmobile/libcache/response/HttpResponseExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class HttpResponseExtKt {
    public static final long requireHeadersContentLength(@NotNull IHttpResponse $this$requireHeadersContentLength) {
        Intrinsics.checkNotNullParameter((Object)$this$requireHeadersContentLength, (String)"<this>");
        Long l = IHttpHeadersExtKt.contentLength((IHttpHeaders)$this$requireHeadersContentLength.getHeaders());
        if (l == null) {
            throw new IllegalArgumentException("requireHeadersContentLength: response for " + $this$requireHeadersContentLength.getRequest().getUrl() + " has no content-length header");
        }
        return l;
    }

    @Nullable
    public static final Source bodyAsUncompressedSourceIfContentEncoded(@NotNull IHttpResponse $this$bodyAsUncompressedSourceIfContentEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$bodyAsUncompressedSourceIfContentEncoded, (String)"<this>");
        CompressionType compressionType = CompressionType.Companion.byHeaderVal($this$bodyAsUncompressedSourceIfContentEncoded.getHeaders().get("content-encoding"));
        Source source = $this$bodyAsUncompressedSourceIfContentEncoded.bodyAsSource();
        return source != null && (source = CoreKt.buffered((RawSource)((RawSource)source))) != null ? SourceExtKt.uncompress(source, compressionType) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String bodyAsString(@NotNull IHttpResponse $this$bodyAsString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$bodyAsString, (String)"<this>");
        Source source = HttpResponseExtKt.bodyAsUncompressedSourceIfContentEncoded($this$bodyAsString);
        if (source != null) {
            AutoCloseable autoCloseable = (AutoCloseable)source;
            Throwable throwable = null;
            try {
                Source it = (Source)autoCloseable;
                boolean bl = false;
                String string2 = Utf8Kt.readString((Source)it);
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        } else {
            string = null;
        }
        return string;
    }
}

