/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.RestrictTo;
import androidx.navigation.CollectionNavType;
import androidx.navigation.NavArgument;
import androidx.navigation.NavArgumentKt;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavType;
import androidx.navigation.NavUri;
import androidx.navigation.NavUriUtils;
import androidx.navigation.serialization.RouteSerializerKt;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateReader;
import androidx.savedstate.SavedStateWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 p2\u00020\u0001:\u0004mnopB'\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0017\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\tJ*\u0010<\u001a\u00020=2\u0006\u0010\b\u001a\u00020\u00032\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\n\u0010?\u001a\u00060@j\u0002`AH\u0002J\u0015\u0010B\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020CH\u0000\u00a2\u0006\u0002\bDJ\u0015\u0010B\u001a\u00020\u00182\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bDJ\u0012\u0010G\u001a\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010CH\u0002J\u0012\u0010H\u001a\u00020\u00182\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010I\u001a\u00020\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010J\u001a\u00020K2\u0006\u0010\u0005\u001a\u00020\u0003H\u0007J(\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020C2\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010Q0PH\u0007J-\u0010R\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010C2\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010Q0PH\u0000\u00a2\u0006\u0002\bSJ0\u0010T\u001a\u00020=2\b\u0010U\u001a\u0004\u0018\u00010\u00032\u0006\u0010V\u001a\u00020M2\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010Q0PH\u0002J.\u0010W\u001a\u00020\u00182\u0006\u0010X\u001a\u00020Y2\u0006\u0010V\u001a\u00020M2\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010Q0PH\u0002J.\u0010Z\u001a\u00020\u00182\u0006\u0010N\u001a\u00020C2\u0006\u0010V\u001a\u00020M2\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010Q0PH\u0002J<\u0010[\u001a\u00020\u00182\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u0003062\u0006\u0010]\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020M2\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010Q0PH\u0002J\u0017\u0010^\u001a\u00020K2\b\u0010_\u001a\u0004\u0018\u00010CH\u0000\u00a2\u0006\u0002\b`J*\u0010a\u001a\u00020=2\u0006\u0010V\u001a\u00020M2\u0006\u0010b\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\b\u0010c\u001a\u0004\u0018\u00010QH\u0002J,\u0010d\u001a\u00020\u00182\u0006\u0010V\u001a\u00020M2\u0006\u0010b\u001a\u00020\u00032\b\u00108\u001a\u0004\u0018\u00010\u00032\b\u0010c\u001a\u0004\u0018\u00010QH\u0002J\u0013\u0010e\u001a\u00020\u00182\b\u0010f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010g\u001a\u00020KH\u0016J\b\u0010h\u001a\u00020=H\u0002J\u0014\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001c\u0010j\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010#H\u0002J\b\u0010k\u001a\u00020=H\u0002J\f\u0010l\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u0017\u0010\u0019R'\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010!\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\"\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0016\u001a\u0004\b$\u0010%R!\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0016\u001a\u0004\b(\u0010)R\u001d\u0010+\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0016\u001a\u0004\b,\u0010\u000bR\u001d\u0010.\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0016\u001a\u0004\b/\u0010\u0014R\u0010\u00101\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u00102\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0016\u001a\u0004\b3\u0010\u0014R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u0003068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010)R&\u00109\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00188G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0019\"\u0004\b:\u0010;\u00a8\u0006q"}, d2={"Landroidx/navigation/NavDeepLink;", "", "uriPattern", "", "action", "mimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "uri", "(Ljava/lang/String;)V", "getUriPattern", "()Ljava/lang/String;", "getAction", "getMimeType", "pathArgs", "", "pathRegex", "pathPattern", "Lkotlin/text/Regex;", "getPathPattern", "()Lkotlin/text/Regex;", "pathPattern$delegate", "Lkotlin/Lazy;", "isParameterizedQuery", "", "()Z", "isParameterizedQuery$delegate", "queryArgsMap", "", "Landroidx/navigation/NavDeepLink$ParamQuery;", "getQueryArgsMap", "()Ljava/util/Map;", "queryArgsMap$delegate", "isSingleQueryParamValueOnly", "fragArgsAndRegex", "Lkotlin/Pair;", "getFragArgsAndRegex", "()Lkotlin/Pair;", "fragArgsAndRegex$delegate", "fragArgs", "getFragArgs", "()Ljava/util/List;", "fragArgs$delegate", "fragRegex", "getFragRegex", "fragRegex$delegate", "fragPattern", "getFragPattern", "fragPattern$delegate", "mimeTypeRegex", "mimeTypePattern", "getMimeTypePattern", "mimeTypePattern$delegate", "argumentsNames", "", "getArgumentsNames$navigation_common", "value", "isExactDeepLink", "setExactDeepLink$navigation_common", "(Z)V", "buildRegex", "", "args", "uriRegex", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "matches", "Landroidx/navigation/NavUri;", "matches$navigation_common", "deepLinkRequest", "Landroidx/navigation/NavDeepLinkRequest;", "matchUri", "matchAction", "matchMimeType", "getMimeTypeMatchRating", "", "getMatchingArguments", "Landroidx/savedstate/SavedState;", "deepLink", "arguments", "", "Landroidx/navigation/NavArgument;", "getMatchingPathAndQueryArgs", "getMatchingPathAndQueryArgs$navigation_common", "getMatchingUriFragment", "fragment", "savedState", "getMatchingPathArguments", "result", "Lkotlin/text/MatchResult;", "getMatchingQueryArguments", "parseInputParams", "inputParams", "storedParam", "calculateMatchingPathSegments", "requestedLink", "calculateMatchingPathSegments$navigation_common", "parseArgument", "name", "argument", "parseArgumentForRepeatedParam", "equals", "other", "hashCode", "parsePath", "parseQuery", "parseFragment", "parseMime", "saveWildcardInRegex", "ParamQuery", "MimeType", "Builder", "Companion", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n+ 6 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt$savedState$1\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,835:1\n1374#2:836\n1460#2,5:837\n1573#2:856\n1604#2,3:857\n1607#2:861\n1573#2:862\n1604#2,4:863\n1869#2,2:876\n1869#2:878\n1573#2:880\n1604#2,3:881\n1607#2:885\n1870#2:886\n30#3:842\n45#3:843\n34#3,2:844\n30#3:849\n45#3:850\n34#3,2:851\n30#3:869\n45#3:870\n34#3,2:871\n1#4:846\n1#4:853\n1#4:860\n1#4:873\n1#4:879\n106#5:847\n106#5:854\n106#5:874\n90#5:884\n106#5:887\n106#5:888\n90#5:889\n90#5:890\n45#6:848\n45#6:855\n45#6:875\n216#7,2:867\n*S KotlinDebug\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink\n*L\n84#1:836\n84#1:837,5\n229#1:856\n229#1:857,3\n229#1:861\n246#1:862\n246#1:863,4\n307#1:876,2\n316#1:878\n325#1:880\n325#1:881,3\n325#1:885\n316#1:886\n186#1:842\n186#1:843\n186#1:844,2\n210#1:849\n210#1:850\n210#1:851,2\n305#1:869\n305#1:870\n305#1:871,2\n186#1:846\n210#1:853\n305#1:873\n186#1:847\n210#1:854\n305#1:874\n336#1:884\n352#1:887\n381#1:888\n398#1:889\n196#1:890\n186#1:848\n210#1:855\n305#1:875\n268#1:867,2\n*E\n"})
public final class NavDeepLink {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String uriPattern;
    @Nullable
    private final String action;
    @Nullable
    private final String mimeType;
    @NotNull
    private final List<String> pathArgs;
    @Nullable
    private String pathRegex;
    @NotNull
    private final Lazy pathPattern$delegate;
    @NotNull
    private final Lazy isParameterizedQuery$delegate;
    @NotNull
    private final Lazy queryArgsMap$delegate;
    private boolean isSingleQueryParamValueOnly;
    @NotNull
    private final Lazy fragArgsAndRegex$delegate;
    @NotNull
    private final Lazy fragArgs$delegate;
    @NotNull
    private final Lazy fragRegex$delegate;
    @NotNull
    private final Lazy fragPattern$delegate;
    @Nullable
    private String mimeTypeRegex;
    @NotNull
    private final Lazy mimeTypePattern$delegate;
    private boolean isExactDeepLink;
    @NotNull
    private static final Regex SCHEME_PATTERN = new Regex("^[a-zA-Z]+[+\\w\\-.]*:");
    @NotNull
    private static final Regex FILL_IN_PATTERN = new Regex("\\{(.+?)\\}");
    @NotNull
    private static final Regex SCHEME_REGEX = new Regex("http[s]?://");
    @NotNull
    private static final Regex WILDCARD_REGEX = new Regex(".*");
    @NotNull
    private static final Regex PATH_REGEX = new Regex("([^/]*?|)");
    @NotNull
    private static final Regex QUERY_PATTERN = new Regex("^[^?#]+\\?([^#]*).*");
    @NotNull
    private static final String ANY_SYMBOLS_IN_THE_TAIL = "([\\s\\S]+?)?";

    public NavDeepLink(@Nullable String uriPattern, @Nullable String action, @Nullable String mimeType) {
        this.uriPattern = uriPattern;
        this.action = action;
        this.mimeType = mimeType;
        this.pathArgs = new ArrayList();
        this.pathPattern$delegate = LazyKt.lazy(() -> NavDeepLink.pathPattern_delegate$lambda$1(this));
        this.isParameterizedQuery$delegate = LazyKt.lazy(() -> NavDeepLink.isParameterizedQuery_delegate$lambda$2(this));
        this.queryArgsMap$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> NavDeepLink.queryArgsMap_delegate$lambda$3(this));
        this.fragArgsAndRegex$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> NavDeepLink.fragArgsAndRegex_delegate$lambda$4(this));
        this.fragArgs$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> NavDeepLink.fragArgs_delegate$lambda$5(this));
        this.fragRegex$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> NavDeepLink.fragRegex_delegate$lambda$6(this));
        this.fragPattern$delegate = LazyKt.lazy(() -> NavDeepLink.fragPattern_delegate$lambda$8(this));
        this.mimeTypePattern$delegate = LazyKt.lazy(() -> NavDeepLink.mimeTypePattern_delegate$lambda$10(this));
        this.parsePath();
        this.parseMime();
    }

    @Nullable
    public final String getUriPattern() {
        return this.uriPattern;
    }

    @Nullable
    public final String getAction() {
        return this.action;
    }

    @Nullable
    public final String getMimeType() {
        return this.mimeType;
    }

    private final Regex getPathPattern() {
        Lazy lazy = this.pathPattern$delegate;
        return (Regex)lazy.getValue();
    }

    private final boolean isParameterizedQuery() {
        Lazy lazy = this.isParameterizedQuery$delegate;
        return (Boolean)lazy.getValue();
    }

    private final Map<String, ParamQuery> getQueryArgsMap() {
        Lazy lazy = this.queryArgsMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Pair<List<String>, String> getFragArgsAndRegex() {
        Lazy lazy = this.fragArgsAndRegex$delegate;
        return (Pair)lazy.getValue();
    }

    private final List<String> getFragArgs() {
        Lazy lazy = this.fragArgs$delegate;
        return (List)lazy.getValue();
    }

    private final String getFragRegex() {
        Lazy lazy = this.fragRegex$delegate;
        return (String)lazy.getValue();
    }

    private final Regex getFragPattern() {
        Lazy lazy = this.fragPattern$delegate;
        return (Regex)lazy.getValue();
    }

    private final Regex getMimeTypePattern() {
        Lazy lazy = this.mimeTypePattern$delegate;
        return (Regex)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getArgumentsNames$navigation_common() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.getQueryArgsMap().values();
        Collection collection = this.pathArgs;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ParamQuery it = (ParamQuery)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getArguments();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv)), (Iterable)this.getFragArgs());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isExactDeepLink() {
        return this.isExactDeepLink;
    }

    public final void setExactDeepLink$navigation_common(boolean bl) {
        this.isExactDeepLink = bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public NavDeepLink(@NotNull String uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        this(uri, null, null);
    }

    private final void buildRegex(String uri, List<String> args, StringBuilder uriRegex) {
        int appendPos = 0;
        for (MatchResult result2 = Regex.find$default(FILL_IN_PATTERN, uri, 0, 2, null); result2 != null; result2 = result2.next()) {
            MatchGroup matchGroup = result2.getGroups().get(1);
            Intrinsics.checkNotNull(matchGroup);
            String argName = matchGroup.getValue();
            args.add(argName);
            if (result2.getRange().getFirst() > appendPos) {
                String string2 = uri.substring(appendPos, result2.getRange().getFirst());
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                uriRegex.append(Regex.Companion.escape(string2));
            }
            uriRegex.append(PATH_REGEX.getPattern());
            appendPos = result2.getRange().getLast() + 1;
        }
        if (appendPos < uri.length()) {
            String string3 = uri.substring(appendPos);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            uriRegex.append(Regex.Companion.escape(string3));
        }
    }

    public final boolean matches$navigation_common(@NotNull NavUri uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        return this.matches$navigation_common(new NavDeepLinkRequest(uri, null, null));
    }

    public final boolean matches$navigation_common(@NotNull NavDeepLinkRequest deepLinkRequest) {
        Intrinsics.checkNotNullParameter(deepLinkRequest, "deepLinkRequest");
        return this.matchUri(deepLinkRequest.getUri()) && this.matchAction(deepLinkRequest.getAction()) && this.matchMimeType(deepLinkRequest.getMimeType());
    }

    private final boolean matchUri(NavUri uri) {
        boolean bl;
        if (this.getPathPattern() == null) {
            bl = true;
        } else if (uri == null) {
            bl = false;
        } else {
            Regex regex = this.getPathPattern();
            Intrinsics.checkNotNull(regex);
            bl = regex.matches(uri.toString());
        }
        return bl;
    }

    private final boolean matchAction(String action) {
        return this.action == null ? true : (action == null ? false : Intrinsics.areEqual(this.action, action));
    }

    private final boolean matchMimeType(String mimeType) {
        boolean bl;
        if (this.mimeType == null) {
            bl = true;
        } else if (mimeType == null) {
            bl = false;
        } else {
            Regex regex = this.getMimeTypePattern();
            Intrinsics.checkNotNull(regex);
            bl = regex.matches(mimeType);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final int getMimeTypeMatchRating(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter(mimeType, "mimeType");
        if (this.mimeType == null) return -1;
        Regex regex = this.getMimeTypePattern();
        Intrinsics.checkNotNull(regex);
        if (!regex.matches(mimeType)) {
            return -1;
        }
        int n = new MimeType(this.mimeType).compareTo(new MimeType(mimeType));
        return n;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final SavedState getMatchingArguments(@NotNull NavUri deepLink2, @NotNull Map<String, NavArgument> arguments) {
        SavedState savedState2;
        Intrinsics.checkNotNullParameter(deepLink2, "deepLink");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Object object = this.getPathPattern();
        if (object == null || (object = ((Regex)object).matchEntire(deepLink2.toString())) == null) {
            return null;
        }
        Object result2 = object;
        Map initialState$iv = MapsKt.emptyMap();
        boolean $i$f$savedState = false;
        Map<String, Object> copiedState$iv = MapsKt.toMutableMap(initialState$iv);
        SavedState $this$savedState_u24lambda_u240$iv = savedState2 = new SavedState(copiedState$iv);
        boolean bl = false;
        SavedState $this$write$iv$iv = $this$savedState_u24lambda_u240$iv;
        boolean $i$f$write = false;
        SavedState savedState3 = SavedStateWriter.constructor-impl($this$write$iv$iv);
        boolean bl2 = false;
        SavedState savedState4 = savedState3;
        SavedState savedState5 = savedState2;
        if (!this.getMatchingPathArguments((MatchResult)result2, savedState5, arguments)) {
            return null;
        }
        if (this.isParameterizedQuery() && !this.getMatchingQueryArguments(deepLink2, savedState5, arguments)) {
            return null;
        }
        this.getMatchingUriFragment(deepLink2.getFragment(), savedState5, arguments);
        List<String> missingRequiredArguments = NavArgumentKt.missingRequiredArguments(arguments, arg_0 -> NavDeepLink.getMatchingArguments$lambda$13(savedState5, arg_0));
        if (!((Collection)missingRequiredArguments).isEmpty()) {
            return null;
        }
        return savedState5;
    }

    @NotNull
    public final SavedState getMatchingPathAndQueryArgs$navigation_common(@Nullable NavUri deepLink2, @NotNull Map<String, NavArgument> arguments) {
        SavedState savedState2;
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Map initialState$iv = MapsKt.emptyMap();
        boolean $i$f$savedState = false;
        Map<String, Object> copiedState$iv = MapsKt.toMutableMap(initialState$iv);
        SavedState $this$savedState_u24lambda_u240$iv = savedState2 = new SavedState(copiedState$iv);
        boolean bl = false;
        SavedState $this$write$iv$iv = $this$savedState_u24lambda_u240$iv;
        boolean $i$f$write = false;
        SavedState savedState3 = SavedStateWriter.constructor-impl($this$write$iv$iv);
        boolean bl2 = false;
        SavedState savedState4 = savedState3;
        SavedState savedState5 = savedState2;
        if (deepLink2 == null) {
            return savedState5;
        }
        Object object = this.getPathPattern();
        if (object == null || (object = ((Regex)object).matchEntire(deepLink2.toString())) == null) {
            return savedState5;
        }
        Object result2 = object;
        this.getMatchingPathArguments((MatchResult)result2, savedState5, arguments);
        if (this.isParameterizedQuery()) {
            this.getMatchingQueryArguments(deepLink2, savedState5, arguments);
        }
        return savedState5;
    }

    /*
     * WARNING - void declaration
     */
    private final void getMatchingUriFragment(String fragment, SavedState savedState2, Map<String, NavArgument> arguments) {
        void $this$mapIndexedTo$iv$iv;
        Object object = this.getFragPattern();
        if (object == null || (object = ((Regex)object).matchEntire(String.valueOf(fragment))) == null) {
            return;
        }
        Object result2 = object;
        Iterable $this$mapIndexed$iv = this.getFragArgs();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void argumentName;
            String string2;
            String string3;
            void index2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string4 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = result2.getGroups().get((int)(index2 + true));
            if (object2 != null && (object2 = ((MatchGroup)object2).getValue()) != null) {
                Object it = object2;
                boolean bl2 = false;
                string3 = NavUriUtils.INSTANCE.decode((String)it);
            } else {
                string3 = string2 = null;
            }
            if (string3 == null) {
                string2 = "";
            }
            String value = string2;
            NavArgument argument = arguments.get(argumentName);
            try {
                this.parseArgument(savedState2, (String)argumentName, value, argument);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getMatchingPathArguments(MatchResult result2, SavedState savedState2, Map<String, NavArgument> arguments) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.pathArgs;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void argumentName;
            String string2;
            String string3;
            void index2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string4 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = result2.getGroups().get((int)(index2 + true));
            if (object != null && (object = ((MatchGroup)object).getValue()) != null) {
                Object it = object;
                boolean bl2 = false;
                string3 = NavUriUtils.INSTANCE.decode((String)it);
            } else {
                string3 = string2 = null;
            }
            if (string3 == null) {
                string2 = "";
            }
            String value = string2;
            NavArgument argument = arguments.get(argumentName);
            try {
                this.parseArgument(savedState2, (String)argumentName, value, argument);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return true;
    }

    private final boolean getMatchingQueryArguments(NavUri deepLink2, SavedState savedState2, Map<String, NavArgument> arguments) {
        Map<String, ParamQuery> $this$forEach$iv = this.getQueryArgsMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ParamQuery>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean parseSuccess;
            String argValue;
            Map.Entry<String, ParamQuery> element$iv;
            Map.Entry<String, ParamQuery> entry = element$iv = iterator2.next();
            boolean bl = false;
            String paramName = entry.getKey();
            ParamQuery storedParam = entry.getValue();
            List<String> inputParams = deepLink2.getQueryParameters(paramName);
            if (this.isSingleQueryParamValueOnly && (argValue = deepLink2.getQuery()) != null && !Intrinsics.areEqual(argValue, deepLink2.toString())) {
                inputParams = CollectionsKt.listOf(argValue);
            }
            if (parseSuccess = this.parseInputParams(inputParams, storedParam, savedState2, arguments)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parseInputParams(List<String> inputParams, ParamQuery storedParam, SavedState savedState2, Map<String, NavArgument> arguments) {
        SavedState savedState3;
        Map initialState$iv = MapsKt.emptyMap();
        boolean $i$f$savedState = false;
        Map<String, Object> copiedState$iv = MapsKt.toMutableMap(initialState$iv);
        SavedState $this$savedState_u24lambda_u240$iv = savedState3 = new SavedState(copiedState$iv);
        boolean bl = false;
        SavedState $this$write$iv$iv = $this$savedState_u24lambda_u240$iv;
        boolean $i$f$write = false;
        SavedState savedState4 = SavedStateWriter.constructor-impl($this$write$iv$iv);
        boolean bl2 = false;
        SavedState savedState5 = savedState4;
        SavedState tempSavedState = savedState3;
        Iterable $this$forEach$iv = storedParam.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NavArgument argument;
            String argName = (String)element$iv;
            boolean bl3 = false;
            NavArgument navArgument = argument = arguments.get(argName);
            NavType<Object> navType = navArgument != null ? navArgument.getType() : null;
            if (!(navType instanceof CollectionNavType) || argument.isDefaultValuePresent()) continue;
            ((CollectionNavType)navType).put(tempSavedState, argName, ((CollectionNavType)navType).emptyCollection());
        }
        $this$forEach$iv = inputParams;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapIndexedTo$iv$iv;
            MatchResult argMatchResult;
            MatchResult matchResult;
            String inputParam = (String)element$iv;
            boolean bl4 = false;
            if (storedParam.getParamRegex() != null) {
                String it;
                boolean bl5 = false;
                matchResult = new Regex(it).matchEntire(inputParam);
            } else {
                matchResult = argMatchResult = null;
            }
            if (argMatchResult == null) {
                return false;
            }
            Iterable $this$mapIndexed$iv = storedParam.getArguments();
            boolean $i$f$mapIndexed = false;
            Iterable it = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Object object;
                void argName;
                void index2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                MatchGroup matchGroup = argMatchResult.getGroups().get((int)(index2 + true));
                String string3 = matchGroup != null ? matchGroup.getValue() : null;
                if (string3 == null) {
                    string3 = "";
                }
                String value = string3;
                NavArgument argument = arguments.get(argName);
                try {
                    Object object2;
                    SavedState $this$read$iv = tempSavedState;
                    boolean $i$f$read = false;
                    SavedState $this$parseInputParams_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421 = SavedStateReader.constructor-impl($this$read$iv);
                    boolean bl7 = false;
                    if (!SavedStateReader.contains-impl($this$parseInputParams_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421, (String)argName)) {
                        this.parseArgument(tempSavedState, (String)argName, value, argument);
                        object2 = Unit.INSTANCE;
                    } else {
                        object2 = this.parseArgumentForRepeatedParam(tempSavedState, (String)argName, value, argument);
                    }
                    object = object2;
                }
                catch (IllegalArgumentException e) {
                    object = Unit.INSTANCE;
                }
                collection.add(object);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        SavedState $this$write$iv = savedState2;
        boolean $i$f$write2 = false;
        SavedState $this$parseInputParams_u24lambda_u2424 = SavedStateWriter.constructor-impl($this$write$iv);
        boolean bl8 = false;
        SavedStateWriter.putAll-impl($this$parseInputParams_u24lambda_u2424, tempSavedState);
        return true;
    }

    public final int calculateMatchingPathSegments$navigation_common(@Nullable NavUri requestedLink) {
        if (requestedLink == null || this.uriPattern == null) {
            return 0;
        }
        List<String> requestedPathSegments = requestedLink.getPathSegments();
        List<String> uriPathSegments = NavUriUtils.INSTANCE.parse(this.uriPattern).getPathSegments();
        Set matches = CollectionsKt.intersect((Iterable)requestedPathSegments, (Iterable)uriPathSegments);
        return matches.size();
    }

    private final void parseArgument(SavedState savedState2, String name, String value, NavArgument argument) {
        if (argument != null) {
            NavType<Object> type2 = argument.getType();
            type2.parseAndPut(savedState2, name, value);
        } else {
            SavedState $this$write$iv = savedState2;
            boolean $i$f$write = false;
            SavedState $this$parseArgument_u24lambda_u2425 = SavedStateWriter.constructor-impl($this$write$iv);
            boolean bl = false;
            SavedStateWriter.putString-impl($this$parseArgument_u24lambda_u2425, name, value);
        }
    }

    private final boolean parseArgumentForRepeatedParam(SavedState savedState2, String name, String value, NavArgument argument) {
        SavedState $this$read$iv = savedState2;
        boolean $i$f$read = false;
        SavedState $this$parseArgumentForRepeatedParam_u24lambda_u2426 = SavedStateReader.constructor-impl($this$read$iv);
        boolean bl = false;
        if (!SavedStateReader.contains-impl($this$parseArgumentForRepeatedParam_u24lambda_u2426, name)) {
            return true;
        }
        if (argument != null) {
            NavType<Object> type2 = argument.getType();
            Object previousValue = type2.get(savedState2, name);
            type2.parseAndPut(savedState2, name, value, previousValue);
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof NavDeepLink)) {
            return false;
        }
        return Intrinsics.areEqual(this.uriPattern, ((NavDeepLink)other).uriPattern) && Intrinsics.areEqual(this.action, ((NavDeepLink)other).action) && Intrinsics.areEqual(this.mimeType, ((NavDeepLink)other).mimeType);
    }

    public int hashCode() {
        int result2 = 0;
        String string2 = this.uriPattern;
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        String string3 = this.action;
        result2 = 31 * result2 + (string3 != null ? string3.hashCode() : 0);
        String string4 = this.mimeType;
        result2 = 31 * result2 + (string4 != null ? string4.hashCode() : 0);
        return result2;
    }

    private final void parsePath() {
        if (this.uriPattern == null) {
            return;
        }
        StringBuilder uriRegex = new StringBuilder("^");
        if (!SCHEME_PATTERN.containsMatchIn(this.uriPattern)) {
            uriRegex.append(SCHEME_REGEX.getPattern());
        }
        MatchResult matchResult = Regex.find$default(new Regex("(\\?|#|$)"), this.uriPattern, 0, 2, null);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            String string2 = this.uriPattern.substring(0, it.getRange().getFirst());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            this.buildRegex(string2, this.pathArgs, uriRegex);
            this.isExactDeepLink = !WILDCARD_REGEX.containsMatchIn(uriRegex) && !PATH_REGEX.containsMatchIn(uriRegex);
            uriRegex.append("($|(\\?(.)*)|(#(.)*))");
        }
        String string3 = uriRegex.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        this.pathRegex = this.saveWildcardInRegex(string3);
    }

    private final Map<String, ParamQuery> parseQuery() {
        Map paramArgMap = new LinkedHashMap();
        if (!this.isParameterizedQuery()) {
            return paramArgMap;
        }
        String string2 = this.uriPattern;
        Intrinsics.checkNotNull(string2);
        NavUri uri = NavUriUtils.INSTANCE.parse(string2);
        for (String paramName : uri.getQueryParameterNames()) {
            StringBuilder argRegex = new StringBuilder();
            List<String> queryParams = uri.getQueryParameters(paramName);
            if (!(queryParams.size() <= 1)) {
                boolean $i$a$-require-NavDeepLink$parseQuery$22 = false;
                String $i$a$-require-NavDeepLink$parseQuery$22 = "Query parameter " + paramName + " must only be present once in " + this.uriPattern + ". To support repeated query parameters, use an array type for your argument and the pattern provided in your URI will be used to parse each query parameter instance.";
                throw new IllegalArgumentException($i$a$-require-NavDeepLink$parseQuery$22.toString());
            }
            String string3 = CollectionsKt.firstOrNull(queryParams);
            if (string3 == null) {
                String string4;
                String $this$parseQuery_u24lambda_u2429 = string4 = paramName;
                boolean bl = false;
                this.isSingleQueryParamValueOnly = true;
                string3 = string4;
            }
            String queryParam = string3;
            int appendPos = 0;
            ParamQuery param2 = new ParamQuery();
            for (MatchResult result2 = Regex.find$default(FILL_IN_PATTERN, queryParam, 0, 2, null); result2 != null; result2 = result2.next()) {
                MatchGroup matchGroup = result2.getGroups().get(1);
                Intrinsics.checkNotNull(matchGroup);
                param2.addArgumentName(matchGroup.getValue());
                if (result2.getRange().getFirst() > appendPos) {
                    String inputLiteral;
                    Intrinsics.checkNotNullExpressionValue(queryParam.substring(appendPos, result2.getRange().getFirst()), "substring(...)");
                    argRegex.append(Regex.Companion.escape(inputLiteral));
                }
                argRegex.append(ANY_SYMBOLS_IN_THE_TAIL);
                appendPos = result2.getRange().getLast() + 1;
            }
            if (appendPos < queryParam.length()) {
                String string5 = queryParam.substring(appendPos);
                Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                argRegex.append(Regex.Companion.escape(string5));
            }
            argRegex.append("$");
            String string6 = argRegex.toString();
            Intrinsics.checkNotNullExpressionValue(string6, "toString(...)");
            param2.setParamRegex(this.saveWildcardInRegex(string6));
            paramArgMap.put(paramName, param2);
        }
        return paramArgMap;
    }

    private final Pair<List<String>, String> parseFragment() {
        if (this.uriPattern == null || NavUriUtils.INSTANCE.parse(this.uriPattern).getFragment() == null) {
            return null;
        }
        List fragArgs = new ArrayList();
        String fragment = NavUriUtils.INSTANCE.parse(this.uriPattern).getFragment();
        StringBuilder fragRegex = new StringBuilder();
        String string2 = fragment;
        Intrinsics.checkNotNull(string2);
        this.buildRegex(string2, fragArgs, fragRegex);
        return TuplesKt.to(fragArgs, fragRegex.toString());
    }

    private final void parseMime() {
        if (this.mimeType == null) {
            return;
        }
        Regex mimeTypePattern = new Regex("^[\\s\\S]+/[\\s\\S]+$");
        if (!mimeTypePattern.matches(this.mimeType)) {
            boolean $i$a$-require-NavDeepLink$parseMime$22 = false;
            String $i$a$-require-NavDeepLink$parseMime$22 = "The given mimeType " + this.mimeType + " does not match to required \"type/subtype\" format";
            throw new IllegalArgumentException($i$a$-require-NavDeepLink$parseMime$22.toString());
        }
        MimeType splitMimeType = new MimeType(this.mimeType);
        String regex = "^(" + splitMimeType.getType() + "|[*]+)/(" + splitMimeType.getSubType() + "|[*]+)$";
        this.mimeTypeRegex = StringsKt.replace$default(regex, "*|[*]", "[\\s\\S]", false, 4, null);
    }

    private final String saveWildcardInRegex(String $this$saveWildcardInRegex) {
        return StringsKt.contains$default((CharSequence)$this$saveWildcardInRegex, "\\Q", false, 2, null) && StringsKt.contains$default((CharSequence)$this$saveWildcardInRegex, "\\E", false, 2, null) ? StringsKt.replace$default($this$saveWildcardInRegex, ".*", "\\E.*\\Q", false, 4, null) : (StringsKt.contains$default((CharSequence)$this$saveWildcardInRegex, "\\.\\*", false, 2, null) ? StringsKt.replace$default($this$saveWildcardInRegex, "\\.\\*", ".*", false, 4, null) : $this$saveWildcardInRegex);
    }

    private static final Regex pathPattern_delegate$lambda$1(NavDeepLink this$0) {
        Regex regex;
        String string2 = this$0.pathRegex;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            regex = new Regex(it, RegexOption.IGNORE_CASE);
        } else {
            regex = null;
        }
        return regex;
    }

    private static final boolean isParameterizedQuery_delegate$lambda$2(NavDeepLink this$0) {
        return this$0.uriPattern != null && QUERY_PATTERN.matches(this$0.uriPattern);
    }

    private static final Map queryArgsMap_delegate$lambda$3(NavDeepLink this$0) {
        return this$0.parseQuery();
    }

    private static final Pair fragArgsAndRegex_delegate$lambda$4(NavDeepLink this$0) {
        return this$0.parseFragment();
    }

    private static final List fragArgs_delegate$lambda$5(NavDeepLink this$0) {
        Pair<List<String>, String> pair = this$0.getFragArgsAndRegex();
        if (pair == null || (pair = pair.getFirst()) == null) {
            pair = new ArrayList();
        }
        return pair;
    }

    private static final String fragRegex_delegate$lambda$6(NavDeepLink this$0) {
        Pair<List<String>, String> pair = this$0.getFragArgsAndRegex();
        return pair != null ? pair.getSecond() : null;
    }

    private static final Regex fragPattern_delegate$lambda$8(NavDeepLink this$0) {
        Regex regex;
        String string2 = this$0.getFragRegex();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            regex = new Regex(it, RegexOption.IGNORE_CASE);
        } else {
            regex = null;
        }
        return regex;
    }

    private static final Regex mimeTypePattern_delegate$lambda$10(NavDeepLink this$0) {
        Regex regex;
        String string2 = this$0.mimeTypeRegex;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            regex = new Regex(it);
        } else {
            regex = null;
        }
        return regex;
    }

    private static final boolean getMatchingArguments$lambda$13(SavedState $savedState, String argName) {
        Intrinsics.checkNotNullParameter(argName, "argName");
        SavedState $this$read$iv = $savedState;
        boolean $i$f$read = false;
        SavedState $this$getMatchingArguments_u24lambda_u2413_u24lambda_u2412 = SavedStateReader.constructor-impl($this$read$iv);
        boolean bl = false;
        return !SavedStateReader.contains-impl($this$getMatchingArguments_u24lambda_u2413_u24lambda_u2412, argName);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\t\b\u0017\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J<\u0010\b\u001a\u00020\u0000\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00052\u001d\b\u0002\u0010\u000b\u001a\u0017\u0012\u0004\u0012\u00020\r\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0002\b\u000f0\fH\u0086\bJG\u0010\b\u001a\u00020\u0000\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u00112\u0006\u0010\n\u001a\u00020\u00052\u001d\b\u0002\u0010\u000b\u001a\u0017\u0012\u0004\u0012\u00020\r\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0002\b\u000f0\fH\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/navigation/NavDeepLink$Builder;", "", "<init>", "()V", "uriPattern", "", "action", "mimeType", "setUriPattern", "T", "basePath", "typeMap", "", "Lkotlin/reflect/KType;", "Landroidx/navigation/NavType;", "Lkotlin/jvm/JvmSuppressWildcards;", "route", "Lkotlin/reflect/KClass;", "setAction", "setMimeType", "build", "Landroidx/navigation/NavDeepLink;", "Companion", "navigation-common"})
    @SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,835:1\n1#2:836\n*E\n"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String uriPattern;
        @Nullable
        private String action;
        @Nullable
        private String mimeType;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder() {
        }

        @NotNull
        public final Builder setUriPattern(@NotNull String uriPattern) {
            Intrinsics.checkNotNullParameter(uriPattern, "uriPattern");
            this.uriPattern = uriPattern;
            return this;
        }

        public final /* synthetic */ <T> Builder setUriPattern(String basePath, Map<KType, NavType<?>> typeMap) {
            Intrinsics.checkNotNullParameter(basePath, "basePath");
            Intrinsics.checkNotNullParameter(typeMap, "typeMap");
            boolean $i$f$setUriPattern = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            return this.setUriPattern(Reflection.getOrCreateKotlinClass(Object.class), basePath, typeMap);
        }

        public static /* synthetic */ Builder setUriPattern$default(Builder $this, String basePath, Map typeMap, int n, Object object) {
            if ((n & 2) != 0) {
                typeMap = MapsKt.emptyMap();
            }
            Intrinsics.checkNotNullParameter(basePath, "basePath");
            Intrinsics.checkNotNullParameter(typeMap, "typeMap");
            boolean $i$f$setUriPattern = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            return $this.setUriPattern(Reflection.getOrCreateKotlinClass(Object.class), basePath, typeMap);
        }

        @JvmOverloads
        @NotNull
        public final <T> Builder setUriPattern(@NotNull KClass<T> route, @NotNull String basePath, @NotNull Map<KType, NavType<?>> typeMap) {
            Intrinsics.checkNotNullParameter(route, "route");
            Intrinsics.checkNotNullParameter(basePath, "basePath");
            Intrinsics.checkNotNullParameter(typeMap, "typeMap");
            this.uriPattern = RouteSerializerKt.generateRoutePattern(SerializersKt.serializer(route), typeMap, basePath);
            return this;
        }

        public static /* synthetic */ Builder setUriPattern$default(Builder builder, KClass kClass, String string2, Map map2, int n, Object object) {
            if ((n & 4) != 0) {
                map2 = MapsKt.emptyMap();
            }
            return builder.setUriPattern(kClass, string2, map2);
        }

        @NotNull
        public final Builder setAction(@NotNull String action) {
            Intrinsics.checkNotNullParameter(action, "action");
            if (!(((CharSequence)action).length() > 0)) {
                boolean bl = false;
                String string2 = "The NavDeepLink cannot have an empty action.";
                throw new IllegalArgumentException(string2.toString());
            }
            this.action = action;
            return this;
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter(mimeType, "mimeType");
            this.mimeType = mimeType;
            return this;
        }

        @NotNull
        public final NavDeepLink build() {
            return new NavDeepLink(this.uriPattern, this.action, this.mimeType);
        }

        @JvmOverloads
        @NotNull
        public final <T> Builder setUriPattern(@NotNull KClass<T> route, @NotNull String basePath) {
            Intrinsics.checkNotNullParameter(route, "route");
            Intrinsics.checkNotNullParameter(basePath, "basePath");
            return Builder.setUriPattern$default(this, route, basePath, null, 4, null);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromUriPattern(@NotNull String uriPattern) {
            return Companion.fromUriPattern(uriPattern);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromAction(@NotNull String action) {
            return Companion.fromAction(action);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromMimeType(@NotNull String mimeType) {
            return Companion.fromMimeType(mimeType);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J<\u0010\u0004\u001a\u00020\u0005\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\u00072\u001d\b\u0002\u0010\n\u001a\u0017\u0012\u0004\u0012\u00020\f\u0012\r\u0012\u000b\u0012\u0002\b\u00030\r\u00a2\u0006\u0002\b\u000e0\u000bH\u0087\bJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0007H\u0007\u00a8\u0006\u0013"}, d2={"Landroidx/navigation/NavDeepLink$Builder$Companion;", "", "<init>", "()V", "fromUriPattern", "Landroidx/navigation/NavDeepLink$Builder;", "uriPattern", "", "T", "basePath", "typeMap", "", "Lkotlin/reflect/KType;", "Landroidx/navigation/NavType;", "Lkotlin/jvm/JvmSuppressWildcards;", "fromAction", "action", "fromMimeType", "mimeType", "navigation-common"})
        @SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$Builder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,835:1\n1#2:836\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder fromUriPattern(@NotNull String uriPattern) {
                Intrinsics.checkNotNullParameter(uriPattern, "uriPattern");
                Builder builder = new Builder();
                builder.setUriPattern(uriPattern);
                return builder;
            }

            @JvmStatic
            public final /* synthetic */ <T> Builder fromUriPattern(String basePath, Map<KType, NavType<?>> typeMap) {
                Intrinsics.checkNotNullParameter(basePath, "basePath");
                Intrinsics.checkNotNullParameter(typeMap, "typeMap");
                boolean $i$f$fromUriPattern = false;
                Builder builder = new Builder();
                Intrinsics.reifiedOperationMarker(4, "T");
                builder.setUriPattern(Reflection.getOrCreateKotlinClass(Object.class), basePath, typeMap);
                return builder;
            }

            public static /* synthetic */ Builder fromUriPattern$default(Companion $this, String basePath, Map typeMap, int n, Object object) {
                if ((n & 2) != 0) {
                    typeMap = MapsKt.emptyMap();
                }
                Intrinsics.checkNotNullParameter(basePath, "basePath");
                Intrinsics.checkNotNullParameter(typeMap, "typeMap");
                boolean $i$f$fromUriPattern = false;
                Builder builder = new Builder();
                Intrinsics.reifiedOperationMarker(4, "T");
                builder.setUriPattern(Reflection.getOrCreateKotlinClass(Object.class), basePath, typeMap);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromAction(@NotNull String action) {
                Intrinsics.checkNotNullParameter(action, "action");
                if (!(((CharSequence)action).length() > 0)) {
                    boolean bl = false;
                    String string2 = "The NavDeepLink cannot have an empty action.";
                    throw new IllegalArgumentException(string2.toString());
                }
                Builder builder = new Builder();
                builder.setAction(action);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromMimeType(@NotNull String mimeType) {
                Intrinsics.checkNotNullParameter(mimeType, "mimeType");
                Builder builder = new Builder();
                builder.setMimeType(mimeType);
                return builder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/NavDeepLink$Companion;", "", "<init>", "()V", "SCHEME_PATTERN", "Lkotlin/text/Regex;", "FILL_IN_PATTERN", "SCHEME_REGEX", "WILDCARD_REGEX", "PATH_REGEX", "QUERY_PATTERN", "ANY_SYMBOLS_IN_THE_TAIL", "", "navigation-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\u0005\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/NavDeepLink$MimeType;", "", "mimeType", "", "<init>", "(Ljava/lang/String;)V", "type", "getType", "()Ljava/lang/String;", "setType", "subType", "getSubType", "setSubType", "compareTo", "", "other", "navigation-common"})
    @SourceDebugExtension(value={"SMAP\nNavDeepLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$MimeType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,835:1\n739#2,9:836\n*S KotlinDebug\n*F\n+ 1 NavDeepLink.kt\nandroidx/navigation/NavDeepLink$MimeType\n*L\n448#1:836,9\n*E\n"})
    private static final class MimeType
    implements Comparable<MimeType> {
        @NotNull
        private String type;
        @NotNull
        private String subType;

        public MimeType(@NotNull String mimeType) {
            List list2;
            Intrinsics.checkNotNullParameter(mimeType, "mimeType");
            CharSequence charSequence = mimeType;
            Regex regex = new Regex("/");
            int n = 0;
            List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List typeAndSubType = list2;
            this.type = (String)typeAndSubType.get(0);
            this.subType = (String)typeAndSubType.get(1);
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "<set-?>");
            this.type = string2;
        }

        @NotNull
        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "<set-?>");
            this.subType = string2;
        }

        @Override
        public int compareTo(@NotNull MimeType other) {
            Intrinsics.checkNotNullParameter(other, "other");
            int result2 = 0;
            if (Intrinsics.areEqual(this.type, other.type)) {
                result2 += 2;
            }
            if (Intrinsics.areEqual(this.subType, other.subType)) {
                ++result2;
            }
            return result2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Landroidx/navigation/NavDeepLink$ParamQuery;", "", "<init>", "()V", "paramRegex", "", "getParamRegex", "()Ljava/lang/String;", "setParamRegex", "(Ljava/lang/String;)V", "arguments", "", "getArguments", "()Ljava/util/List;", "addArgumentName", "", "name", "getArgumentName", "index", "", "size", "navigation-common"})
    private static final class ParamQuery {
        @Nullable
        private String paramRegex;
        @NotNull
        private final List<String> arguments = new ArrayList();

        @Nullable
        public final String getParamRegex() {
            return this.paramRegex;
        }

        public final void setParamRegex(@Nullable String string2) {
            this.paramRegex = string2;
        }

        @NotNull
        public final List<String> getArguments() {
            return this.arguments;
        }

        public final void addArgumentName(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.arguments.add(name);
        }

        @NotNull
        public final String getArgumentName(int index2) {
            return this.arguments.get(index2);
        }

        public final int size() {
            return this.arguments.size();
        }
    }
}

