/*
 * Decompiled with CFR 0.152.
 */
package com.eygraber.uri;

import com.eygraber.uri.UriSyntaxException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002J&\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\nJ\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\nJ!\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u000f\u001a\u00020\nH\u0082\bJ*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/eygraber/uri/UriCodec;", "", "<init>", "()V", "encodeOrNull", "", "s", "allow", "encode", "isAllowed", "", "c", "", "decodeOrNull", "convertPlus", "throwOnFailure", "decode", "flushDecodingByteAccumulator", "", "Lcom/eygraber/uri/UriCodec$ByteBuffer;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "unexpectedCharacterException", "Lcom/eygraber/uri/UriSyntaxException;", "uri", "name", "unexpected", "index", "", "getNextCharacter", "end", "hexCharToValue", "lowercaseAsciiAlphaRange", "Lkotlin/ranges/CharRange;", "lowercaseHexRange", "uppercaseAsciiAlphaRange", "uppercaseHexRange", "digitAsciiRange", "defaultAllowedSet", "", "hexDigits", "", "INVALID_INPUT_CHARACTER", "ByteBuffer"})
@SourceDebugExtension(value={"SMAP\nUriCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriCodec.kt\ncom/eygraber/uri/UriCodec\n*L\n1#1,357:1\n292#1,14:358\n292#1,14:372\n292#1,14:386\n292#1,14:400\n292#1,14:414\n*S KotlinDebug\n*F\n+ 1 UriCodec.kt\ncom/eygraber/uri/UriCodec\n*L\n209#1:358,14\n226#1:372,14\n240#1:386,14\n251#1:400,14\n257#1:414,14\n*E\n"})
public final class UriCodec {
    @NotNull
    public static final UriCodec INSTANCE = new UriCodec();
    @NotNull
    private static final CharRange lowercaseAsciiAlphaRange = new CharRange('a', 'z');
    @NotNull
    private static final CharRange lowercaseHexRange = new CharRange('a', 'f');
    @NotNull
    private static final CharRange uppercaseAsciiAlphaRange = new CharRange('A', 'Z');
    @NotNull
    private static final CharRange uppercaseHexRange = new CharRange('A', 'F');
    @NotNull
    private static final CharRange digitAsciiRange = new CharRange('0', '9');
    @NotNull
    private static final Set<Character> defaultAllowedSet;
    @NotNull
    private static final char[] hexDigits;
    private static final char INVALID_INPUT_CHARACTER = '\ufffd';

    private UriCodec() {
    }

    @Nullable
    public final String encodeOrNull(@Nullable String s2) {
        String string2 = s2;
        return string2 == null ? null : this.encode(string2, null);
    }

    @Nullable
    public final String encodeOrNull(@Nullable String s2, @Nullable String allow) {
        String string2 = s2;
        return string2 == null ? null : this.encode(string2, allow);
    }

    @NotNull
    public final String encode(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        return this.encode(s2, null);
    }

    @NotNull
    public final String encode(@NotNull String s2, @Nullable String allow) {
        Intrinsics.checkNotNullParameter(s2, "s");
        StringBuilder encoded = null;
        int oldLength = s2.length();
        int current = 0;
        while (current < oldLength) {
            int nextAllowed;
            int nextToEncode;
            for (nextToEncode = current; nextToEncode < oldLength && this.isAllowed(s2.charAt(nextToEncode), allow); ++nextToEncode) {
            }
            if (nextToEncode == oldLength) {
                String string2;
                if (current == 0) {
                    string2 = s2;
                } else {
                    StringBuilder stringBuilder = encoded;
                    if (stringBuilder == null) {
                        String string3 = "Required value was null.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    stringBuilder.append(s2, current, oldLength);
                    String string4 = encoded.toString();
                    Intrinsics.checkNotNull(string4);
                    string2 = string4;
                }
                return string2;
            }
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            if (nextToEncode > current) {
                encoded.append(s2, current, nextToEncode);
            }
            current = nextToEncode;
            for (nextAllowed = current + 1; nextAllowed < oldLength && !this.isAllowed(s2.charAt(nextAllowed), allow); ++nextAllowed) {
            }
            Intrinsics.checkNotNullExpressionValue(s2.substring(current, nextAllowed), "substring(...)");
            try {
                String toEncode;
                byte[] bytes = StringsKt.encodeToByteArray(toEncode);
                int bytesLength = bytes.length;
                for (int i2 = 0; i2 < bytesLength; ++i2) {
                    encoded.append('%');
                    encoded.append(hexDigits[(bytes[i2] & 0xF0) >> 4]);
                    encoded.append(hexDigits[bytes[i2] & 0xF]);
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            current = nextAllowed;
        }
        StringsKt.decodeToString(new byte[0]);
        CharSequence charSequence = encoded;
        if (charSequence == null || (charSequence = charSequence.toString()) == null) {
            charSequence = s2;
        }
        return charSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAllowed(char c, String allow) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        CharRange charRange = lowercaseAsciiAlphaRange;
        char c2 = charRange.getFirst();
        if (c <= charRange.getLast()) {
            if (c2 <= c) {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        charRange = uppercaseAsciiAlphaRange;
        c2 = charRange.getFirst();
        if (c <= charRange.getLast()) {
            if (c2 <= c) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        charRange = digitAsciiRange;
        c2 = charRange.getFirst();
        if (c <= charRange.getLast()) {
            if (c2 <= c) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (defaultAllowedSet.contains(Character.valueOf(c))) return true;
        if (allow == null) return false;
        if (StringsKt.indexOf$default((CharSequence)allow, c, 0, false, 6, null) == -1) return false;
        return true;
    }

    @Nullable
    public final String decodeOrNull(@Nullable String s2, boolean convertPlus, boolean throwOnFailure) {
        String string2 = s2;
        return string2 == null ? null : this.decode(string2, convertPlus, throwOnFailure);
    }

    public static /* synthetic */ String decodeOrNull$default(UriCodec uriCodec, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return uriCodec.decodeOrNull(string2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String decode(@NotNull String s2, boolean convertPlus, boolean throwOnFailure) {
        void $this$flushDecodingByteAccumulator$iv;
        StringBuilder $this$flushDecodingByteAccumulator$iv2;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter(s2, "s");
        StringBuilder builder = new StringBuilder(s2.length());
        ByteBuffer $this$decode_u24lambda_u240 = byteBuffer = new ByteBuffer(s2.length());
        boolean bl = false;
        int i2 = 0;
        while (i2 < s2.length()) {
            char c = s2.charAt(i2++);
            switch (c) {
                case '+': {
                    void builder$iv;
                    UriCodec uriCodec = INSTANCE;
                    ByteBuffer byteBuffer2 = $this$decode_u24lambda_u240;
                    StringBuilder stringBuilder = builder;
                    char throwOnFailure$iv = throwOnFailure;
                    boolean $i$f$flushDecodingByteAccumulator = false;
                    if (((ByteBuffer)((Object)$this$flushDecodingByteAccumulator$iv2)).getWritePosition() != 0) {
                        try {
                            builder$iv.append(((ByteBuffer)((Object)$this$flushDecodingByteAccumulator$iv2)).decodeToStringAndReset());
                        }
                        catch (Exception e$iv) {
                            if (throwOnFailure$iv != '\u0000') {
                                throw new IllegalArgumentException(e$iv);
                            }
                            builder$iv.append('\ufffd');
                        }
                    }
                    Object object = builder.append(convertPlus ? (char)' ' : '+');
                    break;
                }
                case '%': {
                    char throwOnFailure$iv;
                    byte hexValue = 0;
                    for (int j = 0; j < 2; ++j) {
                        StringBuilder $this$flushDecodingByteAccumulator$iv3;
                        try {
                            throwOnFailure$iv = INSTANCE.getNextCharacter(s2, i2, s2.length(), null);
                        }
                        catch (UriSyntaxException e) {
                            if (throwOnFailure != '\u0000') {
                                throw new IllegalArgumentException(e);
                            }
                            UriCodec e$iv = INSTANCE;
                            ByteBuffer byteBuffer3 = $this$decode_u24lambda_u240;
                            StringBuilder stringBuilder = builder;
                            char throwOnFailure$iv2 = throwOnFailure;
                            boolean $i$f$flushDecodingByteAccumulator = false;
                            if (((ByteBuffer)((Object)$this$flushDecodingByteAccumulator$iv3)).getWritePosition() != 0) {
                                void builder$iv;
                                try {
                                    builder$iv.append(((ByteBuffer)((Object)$this$flushDecodingByteAccumulator$iv3)).decodeToStringAndReset());
                                }
                                catch (Exception e$iv2) {
                                    if (throwOnFailure$iv2 != '\u0000') {
                                        throw new IllegalArgumentException(e$iv2);
                                    }
                                    builder$iv.append('\ufffd');
                                }
                            }
                            builder.append('\ufffd');
                            String string2 = builder.toString();
                            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                            return string2;
                        }
                        char nextC = throwOnFailure$iv;
                        ++i2;
                        int newDigit = INSTANCE.hexCharToValue(nextC);
                        if (newDigit < 0) {
                            void $this$flushDecodingByteAccumulator$iv4;
                            if (throwOnFailure != '\u0000') {
                                throw new IllegalArgumentException(INSTANCE.unexpectedCharacterException(s2, null, nextC, i2 - 1));
                            }
                            UriCodec e = INSTANCE;
                            ByteBuffer this_$iv = $this$decode_u24lambda_u240;
                            $this$flushDecodingByteAccumulator$iv3 = builder;
                            char throwOnFailure$iv3 = throwOnFailure;
                            boolean $i$f$flushDecodingByteAccumulator = false;
                            if ($this$flushDecodingByteAccumulator$iv4.getWritePosition() != 0) {
                                void builder$iv;
                                try {
                                    builder$iv.append($this$flushDecodingByteAccumulator$iv4.decodeToStringAndReset());
                                }
                                catch (Exception e$iv) {
                                    if (throwOnFailure$iv3 != '\u0000') {
                                        throw new IllegalArgumentException(e$iv);
                                    }
                                    builder$iv.append('\ufffd');
                                }
                            }
                            builder.append('\ufffd');
                            break;
                        }
                        hexValue = (byte)(hexValue * 16 + newDigit);
                    }
                    $this$decode_u24lambda_u240.writeByte(hexValue);
                    Object object = Unit.INSTANCE;
                    break;
                }
                default: {
                    void builder$iv;
                    UriCodec hexValue = INSTANCE;
                    ByteBuffer j = $this$decode_u24lambda_u240;
                    StringBuilder nextC = builder;
                    char throwOnFailure$iv = throwOnFailure;
                    boolean $i$f$flushDecodingByteAccumulator = false;
                    if (((ByteBuffer)((Object)$this$flushDecodingByteAccumulator$iv2)).getWritePosition() != 0) {
                        try {
                            builder$iv.append(((ByteBuffer)((Object)$this$flushDecodingByteAccumulator$iv2)).decodeToStringAndReset());
                        }
                        catch (Exception e$iv) {
                            if (throwOnFailure$iv != '\u0000') {
                                throw new IllegalArgumentException(e$iv);
                            }
                            builder$iv.append('\ufffd');
                        }
                    }
                    Object object = builder.append(c);
                }
            }
        }
        UriCodec c = INSTANCE;
        ByteBuffer this_$iv = $this$decode_u24lambda_u240;
        $this$flushDecodingByteAccumulator$iv2 = builder;
        char throwOnFailure$iv = throwOnFailure;
        boolean $i$f$flushDecodingByteAccumulator = false;
        if ($this$flushDecodingByteAccumulator$iv.getWritePosition() != 0) {
            void builder$iv;
            try {
                builder$iv.append($this$flushDecodingByteAccumulator$iv.decodeToStringAndReset());
            }
            catch (Exception e$iv) {
                if (throwOnFailure$iv != '\u0000') {
                    throw new IllegalArgumentException(e$iv);
                }
                builder$iv.append('\ufffd');
            }
        }
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    public static /* synthetic */ String decode$default(UriCodec uriCodec, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return uriCodec.decode(string2, bl, bl2);
    }

    private final void flushDecodingByteAccumulator(ByteBuffer $this$flushDecodingByteAccumulator, StringBuilder builder, boolean throwOnFailure) {
        boolean $i$f$flushDecodingByteAccumulator = false;
        if ($this$flushDecodingByteAccumulator.getWritePosition() == 0) {
            return;
        }
        try {
            builder.append($this$flushDecodingByteAccumulator.decodeToStringAndReset());
        }
        catch (Exception e) {
            if (throwOnFailure) {
                throw new IllegalArgumentException(e);
            }
            builder.append('\ufffd');
        }
    }

    private final UriSyntaxException unexpectedCharacterException(String uri, String name, char unexpected, int index2) {
        String string2 = name;
        Object nameString = string2 == null ? "" : " in [" + string2 + "]";
        return new UriSyntaxException(uri, "Unexpected character" + (String)nameString + ": " + unexpected, index2);
    }

    private final char getNextCharacter(String uri, int index2, int end, String name) {
        if (index2 >= end) {
            String string2 = name;
            Object nameString = string2 == null ? "" : " in [" + string2 + "]";
            throw new UriSyntaxException(uri, "Unexpected end of string " + (String)nameString, index2);
        }
        return uri.charAt(index2);
    }

    private final int hexCharToValue(char c) {
        int n;
        char c2 = c;
        CharRange charRange = digitAsciiRange;
        char c3 = charRange.getFirst();
        boolean bl = c2 <= charRange.getLast() ? c3 <= c2 : false;
        if (bl) {
            n = c - 48;
        } else {
            charRange = lowercaseHexRange;
            c3 = charRange.getFirst();
            boolean bl2 = c2 <= charRange.getLast() ? c3 <= c2 : false;
            if (bl2) {
                n = 10 + c - 97;
            } else {
                charRange = uppercaseHexRange;
                c3 = charRange.getFirst();
                n = (c2 <= charRange.getLast() ? c3 <= c2 : false) ? 10 + c - 65 : -1;
            }
        }
        return n;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('_'), Character.valueOf('-'), Character.valueOf('!'), Character.valueOf('.'), Character.valueOf('~'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*')};
        defaultAllowedSet = SetsKt.setOf(objectArray);
        objectArray = new char[16];
        objectArray[0] = (Character)48;
        objectArray[1] = (Character)49;
        objectArray[2] = (Character)50;
        objectArray[3] = (Character)51;
        objectArray[4] = (Character)52;
        objectArray[5] = (Character)53;
        objectArray[6] = (Character)54;
        objectArray[7] = (Character)55;
        objectArray[8] = (Character)56;
        objectArray[9] = (Character)57;
        objectArray[10] = (Character)65;
        objectArray[11] = (Character)66;
        objectArray[12] = (Character)67;
        objectArray[13] = (Character)68;
        objectArray[14] = (Character)69;
        objectArray[15] = (Character)70;
        hexDigits = objectArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/eygraber/uri/UriCodec$ByteBuffer;", "", "size", "", "<init>", "(I)V", "buffer", "", "getBuffer", "()[B", "buffer$delegate", "Lkotlin/Lazy;", "value", "writePosition", "getWritePosition", "()I", "writeByte", "", "byte", "", "decodeToStringAndReset", "", "uri"})
    private static final class ByteBuffer {
        private final int size;
        @NotNull
        private final Lazy buffer$delegate;
        private int writePosition;

        public ByteBuffer(int size2) {
            this.size = size2;
            this.buffer$delegate = LazyKt.lazy(() -> ByteBuffer.buffer_delegate$lambda$0(this));
        }

        private final byte[] getBuffer() {
            Lazy lazy = this.buffer$delegate;
            return (byte[])lazy.getValue();
        }

        public final int getWritePosition() {
            return this.writePosition;
        }

        public final void writeByte(byte by) {
            int n = this.writePosition;
            this.writePosition = n + 1;
            this.getBuffer()[n] = by;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String decodeToStringAndReset() {
            String string2;
            try {
                string2 = StringsKt.decodeToString(this.getBuffer(), 0, this.writePosition, false);
            }
            finally {
                this.writePosition = 0;
            }
            return string2;
        }

        private static final byte[] buffer_delegate$lambda$0(ByteBuffer this$0) {
            int n = 0;
            int n2 = this$0.size;
            byte[] byArray = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                byArray[n3] = 0;
            }
            return byArray;
        }
    }
}

