/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.jws;

import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.data.jws.JWSSignatureUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.SignatureUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWS<T> {
    private final transient Logger logger = LoggerFactory.getLogger(JWS.class);
    private final JWSHeader header;
    private final T payload;
    private final byte[] signature;
    private final String headerString;
    private final String payloadString;

    JWS(@NotNull JWSHeader header2, @NotNull String headerString, @NotNull T payload, @NotNull String payloadString, @NotNull byte[] signature) {
        this.header = header2;
        this.payload = payload;
        this.signature = signature;
        this.headerString = headerString;
        this.payloadString = payloadString;
    }

    @NotNull
    public JWSHeader getHeader() {
        return this.header;
    }

    @NotNull
    public T getPayload() {
        return this.payload;
    }

    @NotNull
    public byte[] getSignature() {
        return ArrayUtil.clone(this.signature);
    }

    public boolean isValidSignature() {
        String signedData = this.headerString + "." + this.payloadString;
        try {
            if (this.header.getAlg() == null || this.header.getX5c() == null || this.header.getX5c().getCertificates().isEmpty()) {
                return false;
            }
            Signature signatureObj = SignatureUtil.createSignature(this.header.getAlg().getJcaName());
            PublicKey publicKey = this.header.getX5c().getCertificates().get(0).getPublicKey();
            signatureObj.initVerify(publicKey);
            signatureObj.update(signedData.getBytes());
            byte[] sig = publicKey instanceof ECPublicKey ? JWSSignatureUtil.convertJwsSignatureToDerSignature(this.signature) : this.signature;
            return signatureObj.verify(sig);
        }
        catch (InvalidKeyException | SignatureException e) {
            this.logger.debug("Signature verification failed", e);
            return false;
        }
    }

    @NotNull
    public byte[] getBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    public String toString() {
        return this.headerString + "." + this.payloadString + "." + Base64UrlUtil.encodeToString(this.signature);
    }
}

