/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.text.ParseException;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.MutableTrigger;

public class CronScheduleBuilder
extends ScheduleBuilder<CronTrigger> {
    private CronExpression cronExpression;
    private int misfireInstruction = 0;

    protected CronScheduleBuilder(CronExpression cronExpression) {
        if (cronExpression == null) {
            throw new NullPointerException("cronExpression cannot be null");
        }
        this.cronExpression = cronExpression;
    }

    @Override
    public MutableTrigger build() {
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        cronTriggerImpl.setCronExpression(this.cronExpression);
        cronTriggerImpl.setTimeZone(this.cronExpression.getTimeZone());
        cronTriggerImpl.setMisfireInstruction(this.misfireInstruction);
        return cronTriggerImpl;
    }

    public static CronScheduleBuilder cronSchedule(String string) {
        try {
            return CronScheduleBuilder.cronSchedule(new CronExpression(string));
        }
        catch (ParseException parseException) {
            throw new RuntimeException("CronExpression '" + string + "' is invalid.", parseException);
        }
    }

    public static CronScheduleBuilder cronScheduleNonvalidatedExpression(String string) {
        return CronScheduleBuilder.cronSchedule(new CronExpression(string));
    }

    private static CronScheduleBuilder cronScheduleNoParseException(String string) {
        try {
            return CronScheduleBuilder.cronSchedule(new CronExpression(string));
        }
        catch (ParseException parseException) {
            throw new RuntimeException("CronExpression '" + string + "' is invalid, which should not be possible, please report bug to Quartz developers.", parseException);
        }
    }

    public static CronScheduleBuilder cronSchedule(CronExpression cronExpression) {
        return new CronScheduleBuilder(cronExpression);
    }

    public static CronScheduleBuilder dailyAtHourAndMinute(int n, int n2) {
        DateBuilder.validateHour(n);
        DateBuilder.validateMinute(n2);
        String string = String.format("0 %d %d ? * *", n2, n);
        return CronScheduleBuilder.cronScheduleNoParseException(string);
    }

    public static CronScheduleBuilder atHourAndMinuteOnGivenDaysOfWeek(int n, int n2, Integer ... integerArray) {
        if (integerArray == null || integerArray.length == 0) {
            throw new IllegalArgumentException("You must specify at least one day of week.");
        }
        Object object = integerArray;
        int n3 = integerArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = object[i];
            DateBuilder.validateDayOfWeek(n4);
        }
        DateBuilder.validateHour(n);
        DateBuilder.validateMinute(n2);
        object = String.format("0 %d %d ? * %d", n2, n, integerArray[0]);
        for (n3 = 1; n3 < integerArray.length; ++n3) {
            object = (String)object + "," + integerArray[n3];
        }
        return CronScheduleBuilder.cronScheduleNoParseException((String)object);
    }

    public static CronScheduleBuilder weeklyOnDayAndHourAndMinute(int n, int n2, int n3) {
        DateBuilder.validateDayOfWeek(n);
        DateBuilder.validateHour(n2);
        DateBuilder.validateMinute(n3);
        String string = String.format("0 %d %d ? * %d", n3, n2, n);
        return CronScheduleBuilder.cronScheduleNoParseException(string);
    }

    public static CronScheduleBuilder monthlyOnDayAndHourAndMinute(int n, int n2, int n3) {
        DateBuilder.validateDayOfMonth(n);
        DateBuilder.validateHour(n2);
        DateBuilder.validateMinute(n3);
        String string = String.format("0 %d %d %d * ?", n3, n2, n);
        return CronScheduleBuilder.cronScheduleNoParseException(string);
    }

    public CronScheduleBuilder inTimeZone(TimeZone timeZone) {
        this.cronExpression.setTimeZone(timeZone);
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }
}

