/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public interface QuartzSchedulerMBean {
    public static final String SCHEDULER_STARTED = "schedulerStarted";
    public static final String SCHEDULER_PAUSED = "schedulerPaused";
    public static final String SCHEDULER_SHUTDOWN = "schedulerShutdown";
    public static final String SCHEDULER_ERROR = "schedulerError";
    public static final String JOB_ADDED = "jobAdded";
    public static final String JOB_DELETED = "jobDeleted";
    public static final String JOB_SCHEDULED = "jobScheduled";
    public static final String JOB_UNSCHEDULED = "jobUnscheduled";
    public static final String JOBS_PAUSED = "jobsPaused";
    public static final String JOBS_RESUMED = "jobsResumed";
    public static final String JOB_EXECUTION_VETOED = "jobExecutionVetoed";
    public static final String JOB_TO_BE_EXECUTED = "jobToBeExecuted";
    public static final String JOB_WAS_EXECUTED = "jobWasExecuted";
    public static final String TRIGGER_FINALIZED = "triggerFinalized";
    public static final String TRIGGERS_PAUSED = "triggersPaused";
    public static final String TRIGGERS_RESUMED = "triggersResumed";
    public static final String SCHEDULING_DATA_CLEARED = "schedulingDataCleared";
    public static final String SAMPLED_STATISTICS_ENABLED = "sampledStatisticsEnabled";
    public static final String SAMPLED_STATISTICS_RESET = "sampledStatisticsReset";

    public String getSchedulerName();

    public String getSchedulerInstanceId();

    public boolean isStandbyMode();

    public boolean isShutdown();

    public String getVersion();

    public String getJobStoreClassName();

    public String getThreadPoolClassName();

    public int getThreadPoolSize();

    public long getJobsScheduledMostRecentSample();

    public long getJobsExecutedMostRecentSample();

    public long getJobsCompletedMostRecentSample();

    public Map<String, Long> getPerformanceMetrics();

    public TabularData getCurrentlyExecutingJobs();

    public TabularData getAllJobDetails();

    public List<CompositeData> getAllTriggers();

    public List<String> getJobGroupNames();

    public List<String> getJobNames(String var1);

    public CompositeData getJobDetail(String var1, String var2);

    public boolean isStarted();

    public void start();

    public void shutdown();

    public void standby();

    public void clear();

    public Date scheduleJob(String var1, String var2, String var3, String var4);

    public void scheduleBasicJob(Map<String, Object> var1, Map<String, Object> var2);

    public void scheduleJob(Map<String, Object> var1, Map<String, Object> var2);

    public void scheduleJob(String var1, String var2, Map<String, Object> var3);

    public boolean unscheduleJob(String var1, String var2);

    public boolean interruptJob(String var1, String var2);

    public boolean interruptJob(String var1);

    public void triggerJob(String var1, String var2, Map<String, String> var3);

    public boolean deleteJob(String var1, String var2);

    public void addJob(CompositeData var1, boolean var2);

    public void addJob(Map<String, Object> var1, boolean var2);

    public void pauseJobGroup(String var1);

    public void pauseJobsStartingWith(String var1);

    public void pauseJobsEndingWith(String var1);

    public void pauseJobsContaining(String var1);

    public void pauseJobsAll();

    public void resumeJobGroup(String var1);

    public void resumeJobsStartingWith(String var1);

    public void resumeJobsEndingWith(String var1);

    public void resumeJobsContaining(String var1);

    public void resumeJobsAll();

    public void pauseJob(String var1, String var2);

    public void resumeJob(String var1, String var2);

    public List<String> getTriggerGroupNames();

    public List<String> getTriggerNames(String var1);

    public CompositeData getTrigger(String var1, String var2);

    public String getTriggerState(String var1, String var2);

    public List<CompositeData> getTriggersOfJob(String var1, String var2);

    public Set<String> getPausedTriggerGroups();

    public void pauseAllTriggers();

    public void resumeAllTriggers();

    public void pauseTriggerGroup(String var1);

    public void pauseTriggersStartingWith(String var1);

    public void pauseTriggersEndingWith(String var1);

    public void pauseTriggersContaining(String var1);

    public void pauseTriggersAll();

    public void resumeTriggerGroup(String var1);

    public void resumeTriggersStartingWith(String var1);

    public void resumeTriggersEndingWith(String var1);

    public void resumeTriggersContaining(String var1);

    public void resumeTriggersAll();

    public void pauseTrigger(String var1, String var2);

    public void resumeTrigger(String var1, String var2);

    public List<String> getCalendarNames();

    public void deleteCalendar(String var1);

    public void setSampledStatisticsEnabled(boolean var1);

    public boolean isSampledStatisticsEnabled();
}

